/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.jxp.xsd;

import com.argo21.common.io.Debug;
import com.argo21.jxp.xsd.XSDDecl;
import com.argo21.jxp.xsd.XSDDocument;
import com.argo21.jxp.xsd.XsdElementDecl;
import com.argo21.jxp.xsd.XsdElementDeclNode;
import java.util.Hashtable;
import java.util.Vector;
import org.w3c.dom.Document;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XsdValidation {
    private final ElementValidator ANY = new ElementValidator();
    private final ElementValidator EMPTY = new EmptyValidator();
    private Hashtable ids;
    private Hashtable validators = new Hashtable();
    ErrorHandler errorHandler = null;
    XSDDecl xsd;
    Document doc;

    public XsdValidation(XSDDecl xsd, Document doc) {
        this(xsd, doc, null);
    }

    public XsdValidation(XSDDecl xsd, Document doc, ErrorHandler errorHandler) {
        this.xsd = xsd;
        this.doc = doc;
        this.ids = new Hashtable();
        this.errorHandler = errorHandler == null ? new DefaultErrorHandler() : errorHandler;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        if (errorHandler != null) {
            this.errorHandler = errorHandler;
        } else {
            errorHandler = new DefaultErrorHandler();
        }
    }

    public void error(String messageId, Object[] parameters) throws SAXException {
        String s = XSDDocument.msgCatalog.getMessage(messageId, parameters);
        SAXParseException x = new SAXParseException(s, null);
        this.errorHandler.warning(x);
    }

    class ChildrenValidator
    extends ElementValidator {
        private XsdElementDecl element;
        private Hashtable savtags;

        ChildrenValidator(XsdElementDecl element) {
            this.savtags = new Hashtable(5);
            this.element = element;
        }

        @Override
        public void consume(String tag) throws SAXException {
            int num = ((XsdElementDeclNode)this.element).getOccurrenceSubElement(tag);
            int num1 = 0;
            Integer Inum = (Integer)this.savtags.get(tag);
            if (Inum != null) {
                num1 = Inum;
            }
            if (num1 == num) {
                XsdValidation.this.error("UNDEF_SBELEMENT", new Object[]{this.element.getNodeName(), tag});
            }
            this.savtags.put(tag, new Integer(++num1));
        }

        @Override
        public void text(String tag) throws SAXException {
            XsdValidation.this.error("UNDEF_TEXT", new Object[]{this.element.getNodeName()});
        }

        @Override
        public void done() throws SAXException {
            this.savtags.clear();
        }
    }

    class MixedValidator
    extends ElementValidator {
        private XsdElementDecl element;

        MixedValidator(XsdElementDecl element) {
            this.element = element;
        }

        @Override
        public void consume(String tag) throws SAXException {
            if (tag.equals("#PCDATA")) {
                return;
            }
            Vector v = this.element.getChildNames();
            if (v == null || !v.contains(tag)) {
                XsdValidation.this.error("UNDEF_ELEMENT", new Object[]{tag});
            }
        }
    }

    class EmptyValidator
    extends ElementValidator {
        EmptyValidator() {
        }

        @Override
        public void consume(String tag) throws SAXException {
            XsdValidation.this.error("UNDEF_ELEMENT", new Object[]{tag});
        }

        @Override
        public void text(String tag) throws SAXException {
            XsdValidation.this.error("UNDEF_TEXT", new Object[]{tag});
        }
    }

    class ElementValidator {
        ElementValidator() {
        }

        public void consume(String tag) throws SAXException {
        }

        public void text(String tag) throws SAXException {
        }

        public void done() throws SAXException {
        }
    }

    static class DefaultErrorHandler
    implements ErrorHandler {
        DefaultErrorHandler() {
        }

        @Override
        public void warning(SAXParseException exception) throws SAXException {
            Debug.println(exception.getMessage());
        }

        @Override
        public void error(SAXParseException exception) throws SAXException {
            Debug.println(exception.getMessage());
        }

        @Override
        public void fatalError(SAXParseException exception) throws SAXException {
            Debug.println(exception.getMessage());
        }
    }
}

