/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.map;

import com.argo21.common.log.AppMessage;
import com.argo21.common.log.BizTranException;
import com.argo21.common.log.WriterMode;
import com.argo21.common.util.MappingInfo;
import java.io.File;
import java.util.ArrayList;

public class ArgumentAnalyzer {
    private MappingInfo mInfo = null;

    public void analyze(String[] args, MappingInfo info) throws BizTranException {
        this.mInfo = info;
        if (args.length < 1) {
            throw new BizTranException(AppMessage.ARG_MAPFILE_NOT_FOUND);
        }
        if (this.isVersionOption(args[0])) {
            this.mInfo.setVersion(true);
            if (args.length > 1) {
                throw new BizTranException(AppMessage.ARG_VERSION);
            }
        } else {
            if (this.isOption(args[0])) {
                throw new BizTranException(AppMessage.ARG_MAPFILE_NOT_FOUND);
            }
            this.mInfo.setMapFilePath(args[0]);
        }
        ArrayList<String> params = new ArrayList<String>();
        for (int i = 1; i < args.length; ++i) {
            if (this.isInputOption(args[i])) {
                this.analyseInput(args, i);
                ++i;
                continue;
            }
            if (this.isOutputOption(args[i])) {
                this.analyseOutput(args, i);
                ++i;
                continue;
            }
            if (this.isFolderOption(args[i])) {
                this.mInfo.setFolder(true);
                continue;
            }
            if (this.isLogOption(args[i])) {
                this.analyseLog(args, i);
                ++i;
                continue;
            }
            if (this.isVersionOption(args[i])) {
                throw new BizTranException(AppMessage.ARG_VERSION);
            }
            if (this.isParam(args[i])) {
                params.add(args[i]);
                continue;
            }
            if (this.isDivideOption(args[i])) {
                this.mInfo.setDoDivide(true);
                this.analyseDiv(args, i);
                ++i;
                continue;
            }
            throw new BizTranException(AppMessage.ARG_UNKNOWN, "\u7570\u5e38\u5024:" + args[i]);
        }
        if (this.mInfo.isVersion()) {
            return;
        }
        if (params.size() > 0) {
            String[] p = new String[params.size()];
            for (int i = 0; i < params.size(); ++i) {
                p[i] = (String)params.get(i);
            }
            this.mInfo.setParameters(p);
        }
        this.analyseInOut();
    }

    private void analyseInput(String[] args, int i) throws BizTranException {
        String inputFile;
        String inputOpt = args[i];
        if (inputOpt.length() > 2) {
            this.mInfo.setInputMsg(inputOpt.substring(2));
        }
        if ((inputFile = this.getOptionFileName(args, i)) == null || this.isOption(inputFile)) {
            throw new BizTranException(AppMessage.ARG_INFILE_NOT_FOUND);
        }
        this.mInfo.setInputFilePath(inputFile);
    }

    private void analyseOutput(String[] args, int i) throws BizTranException {
        String outputFile;
        String outputOpt = args[i];
        if (outputOpt.length() > 2) {
            this.mInfo.setOutputMsg(outputOpt.substring(2));
        }
        if ((outputFile = this.getOptionFileName(args, i)) == null || this.isOption(outputFile)) {
            throw new BizTranException(AppMessage.ARG_OUTFILE_NOT_FOUND);
        }
        this.mInfo.setOutputFilePath(outputFile);
    }

    private void analyseLog(String[] args, int i) throws BizTranException {
        String logFile = this.getOptionFileName(args, i);
        this.mInfo.setLogFilePath(logFile);
        if (logFile == null || this.isOption(logFile)) {
            throw new BizTranException(AppMessage.ARG_LOGFILE_NOT_FOUND);
        }
        if (new File(logFile).isDirectory()) {
            throw new BizTranException(AppMessage.ARG_LOGFILE_IS_FOLDER);
        }
        String logOpt = args[i].toLowerCase();
        if (logOpt.equals("-lp")) {
            this.mInfo.setWriteMode(WriterMode.APPEND);
        } else {
            this.mInfo.setWriteMode(WriterMode.UPDATE);
        }
    }

    private void analyseDiv(String[] args, int i) throws BizTranException {
        String divPropFile = this.getOptionFileName(args, i);
        this.mInfo.setDividePropFilePath(divPropFile);
        if (divPropFile == null || this.isOption(divPropFile)) {
            throw new BizTranException(AppMessage.ARG_UNKNOWN);
        }
        if (new File(divPropFile).isDirectory()) {
            throw new BizTranException(AppMessage.ARG_UNKNOWN);
        }
    }

    private String getOptionFileName(String[] args, int i) {
        if (args.length <= i + 1) {
            return null;
        }
        return args[i + 1];
    }

    private void analyseInOut() throws BizTranException {
        if (this.mInfo.getInputFilePath() == null) {
            throw new BizTranException(AppMessage.ARG_INFILE_NOT_FOUND);
        }
        File input = new File(this.mInfo.getInputFilePath());
        if (this.mInfo.isFolder()) {
            if (!input.exists() || input.isFile()) {
                throw new BizTranException(AppMessage.ARG_INFOLDER_IS_FILE);
            }
        } else if (input.isDirectory()) {
            throw new BizTranException(AppMessage.ARG_INFILE_IS_FOLDER);
        }
        if (this.mInfo.getOutputFilePath() == null) {
            throw new BizTranException(AppMessage.ARG_OUTFILE_NOT_FOUND);
        }
        File output = new File(this.mInfo.getOutputFilePath());
        if (this.mInfo.isFolder()) {
            if (!output.exists() || output.isFile()) {
                throw new BizTranException(AppMessage.ARG_OUTFOLDER_IS_FILE);
            }
        } else if (output.isDirectory()) {
            throw new BizTranException(AppMessage.ARG_OUTFILE_IS_FOLDER);
        }
    }

    private boolean isOption(String arg) {
        return this.isInputOption(arg) || this.isOutputOption(arg) || this.isFolderOption(arg) || this.isLogOption(arg) || this.isVersionOption(arg) || this.isDivideOption(arg);
    }

    private boolean isInputOption(String arg) {
        String s = arg.toLowerCase();
        return s.startsWith("-i");
    }

    private boolean isOutputOption(String arg) {
        String s = arg.toLowerCase();
        return s.startsWith("-o");
    }

    private boolean isFolderOption(String arg) {
        String s = arg.toLowerCase();
        return s.equals("-folder");
    }

    private boolean isLogOption(String arg) {
        String s = arg.toLowerCase();
        return s.equals("-l") || s.equals("-lp") || s.equals("-lo");
    }

    private boolean isVersionOption(String arg) {
        String s = arg.toLowerCase();
        return s.equals("-version");
    }

    private boolean isParam(String arg) {
        String s = arg.toLowerCase();
        return s.indexOf(61) > 0;
    }

    private boolean isDivideOption(String arg) {
        String s = arg.toLowerCase();
        return s.equals("-div");
    }
}

