/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.map;

import com.argo21.common.log.AppMessage;
import com.argo21.common.log.BizTranException;
import com.argo21.common.log.WriterMode;
import com.argo21.common.util.MappingInfo;
import com.argo21.map.MappingProcessor2;
import java.io.File;
import java.util.ArrayList;

public class ArgumentAnalyzer2 {
    private MappingInfo mInfo = null;
    private boolean hasOverwriteValidationFlag = false;

    public void analyze(String[] args, MappingInfo info) throws BizTranException {
        this.mInfo = info;
        if (args.length < 1) {
            throw new BizTranException(AppMessage.ARG_MAPFILE_NOT_FOUND);
        }
        if (this.isVersionOption(args[0])) {
            this.mInfo.setVersion(true);
            if (args.length > 1) {
                throw new BizTranException(AppMessage.ARG_VERSION);
            }
            return;
        }
        ArrayList<String> params = new ArrayList<String>();
        for (int i = 0; i < args.length; ++i) {
            if (this.isMappingFile(args[i])) {
                this.analyseMappingFile(args[i]);
                continue;
            }
            if (this.isInputOption(args[i])) {
                this.analyseInput(args[i]);
                continue;
            }
            if (this.isOutputOption(args[i])) {
                this.analyseOutput(args[i]);
                continue;
            }
            if (this.isFolderOption(args[i])) {
                this.mInfo.setFolder(true);
                continue;
            }
            if (this.isLogOption(args[i])) {
                this.analyseLog(args[i]);
                continue;
            }
            if (this.isTableOption(args[i])) {
                this.analyseTableFile(args[i]);
                continue;
            }
            if (this.isVersionOption(args[i])) {
                throw new BizTranException(AppMessage.ARG_VERSION);
            }
            if (this.isOverwriteValidationFlag(args[i])) {
                this.analyseOverwriteValidationFlag(args[i]);
                continue;
            }
            if (this.isParam(args[i])) {
                params.add(args[i]);
                continue;
            }
            if (this.isDivideOption(args[i])) {
                this.mInfo.setDoDivide(true);
                this.analyseDiv(args[i]);
                continue;
            }
            if (this.isAddDecimalZeroOption(args[i])) {
                MappingProcessor2.setIsAddDecimalZero(true);
                continue;
            }
            throw new BizTranException(AppMessage.ARG_UNKNOWN, "\u7570\u5e38\u5024:" + args[i]);
        }
        if (params.size() > 0) {
            String[] p = new String[params.size()];
            for (int i = 0; i < params.size(); ++i) {
                p[i] = (String)params.get(i);
            }
            this.mInfo.setParameters(p);
        }
        if (this.mInfo.getMapFilePath() == null) {
            throw new BizTranException(AppMessage.ARG_MAPFILE_NOT_FOUND);
        }
        this.analyseInOut();
    }

    private void analyseMappingFile(String argMap) throws BizTranException {
        String mappingFile = this.getOptionFileName(argMap);
        if (mappingFile == null) {
            throw new BizTranException(AppMessage.ARG_MAPFILE_NOT_FOUND);
        }
        if (this.mInfo.getMapFilePath() != null) {
            this.mInfo.setMapFilePath(null);
            throw new BizTranException(AppMessage.ARG_MAPFILE_PLURAL);
        }
        this.mInfo.setMapFilePath(mappingFile);
    }

    private void analyseInput(String argInput) throws BizTranException {
        String inputFile = this.getOptionFileName(argInput);
        if (inputFile == null) {
            throw new BizTranException(AppMessage.ARG_INFILE_NOT_FOUND);
        }
        if (this.mInfo.getInputFilePath() != null) {
            this.mInfo.setInputFilePath(null);
            throw new BizTranException(AppMessage.ARG_INFILE_PLURAL);
        }
        this.mInfo.setInputFilePath(inputFile);
    }

    private void analyseOutput(String argOutput) throws BizTranException {
        String outputFile = this.getOptionFileName(argOutput);
        if (outputFile == null) {
            throw new BizTranException(AppMessage.ARG_OUTFILE_NOT_FOUND);
        }
        if (this.mInfo.getOutputFilePath() != null) {
            this.mInfo.setOutputFilePath(null);
            throw new BizTranException(AppMessage.ARG_OUTFILE_PLURAL);
        }
        this.mInfo.setOutputFilePath(outputFile);
        if (argOutput.toLowerCase().startsWith("/op")) {
            this.mInfo.setPostscriptFlag(true);
        }
    }

    private void analyseLog(String argLog) throws BizTranException {
        if (this.mInfo.getLogFilePath() != null) {
            this.mInfo.setLogFilePath(null);
            throw new BizTranException(AppMessage.ARG_LOGFILE_PLURAL);
        }
        String logFile = this.getOptionFileName(argLog);
        this.mInfo.setLogFilePath(logFile);
        if (logFile == null) {
            throw new BizTranException(AppMessage.ARG_LOGFILE_NOT_FOUND);
        }
        if (new File(logFile).isDirectory()) {
            throw new BizTranException(AppMessage.ARG_LOGFILE_IS_FOLDER);
        }
        String logOpt = argLog.toLowerCase();
        if (logOpt.startsWith("/lp:")) {
            this.mInfo.setWriteMode(WriterMode.APPEND);
        } else {
            this.mInfo.setWriteMode(WriterMode.UPDATE);
        }
    }

    private void analyseTableFile(String argTable) throws BizTranException {
        if (this.mInfo.getTableFilePath() != null) {
            this.mInfo.setTableFilePath(null);
            throw new BizTranException(AppMessage.ARG_TABLEFILE_PLURAL);
        }
        String tablePropFile = this.getOptionFileName(argTable);
        this.mInfo.setTableFilePath(tablePropFile);
        if (tablePropFile == null) {
            throw new BizTranException(AppMessage.ARG_TABLEFILE_NOT_FOUND);
        }
        if (new File(tablePropFile).isDirectory()) {
            throw new BizTranException(AppMessage.ARG_TABLEFILE_IS_FOLDER);
        }
    }

    private void analyseDiv(String argDiv) throws BizTranException {
        if (this.mInfo.getDividePropFilePath() != null) {
            this.mInfo.setDividePropFilePath(null);
            throw new BizTranException(AppMessage.ARG_DIVIDEPROP_PLURAL);
        }
        String divPropFile = this.getOptionFileName(argDiv);
        this.mInfo.setDividePropFilePath(divPropFile);
        if (divPropFile == null) {
            throw new BizTranException(AppMessage.ARG_DIVIDEPROP_NOT_FOUND);
        }
        if (new File(divPropFile).isDirectory()) {
            throw new BizTranException(AppMessage.ARG_DIVIDEPROP_IS_FOLDER);
        }
    }

    private void analyseOverwriteValidationFlag(String argFlag) throws BizTranException {
        if (this.hasOverwriteValidationFlag) {
            throw new BizTranException(AppMessage.ARG_OVERWRITE_VALIDATIONFLAG_PLURAL);
        }
        this.hasOverwriteValidationFlag = true;
        String doValidationFlag = this.getOptionFileName(argFlag);
        this.mInfo.setOverwriteValidationFlag(true);
        if ("YES".equalsIgnoreCase(doValidationFlag)) {
            this.mInfo.setDoValidation(true);
        } else if ("NO".equalsIgnoreCase(doValidationFlag)) {
            this.mInfo.setDoValidation(false);
        } else {
            throw new BizTranException(AppMessage.ARG_OVERWRITE_VALIDATIONFLAG_ERROR);
        }
    }

    private String getOptionFileName(String arg) {
        int index = arg.indexOf(":");
        if (index < 0 || index == arg.length() - 1) {
            return null;
        }
        return arg.substring(index + 1, arg.length());
    }

    private void analyseInOut() throws BizTranException {
        if (this.mInfo.getInputFilePath() == null) {
            throw new BizTranException(AppMessage.ARG_INFILE_NOT_FOUND);
        }
        File input = new File(this.mInfo.getInputFilePath());
        if (this.mInfo.isFolder()) {
            if (!input.exists() || input.isFile()) {
                throw new BizTranException(AppMessage.ARG_INFOLDER_IS_FILE);
            }
        } else if (input.isDirectory()) {
            throw new BizTranException(AppMessage.ARG_INFILE_IS_FOLDER);
        }
        if (this.mInfo.getOutputFilePath() == null) {
            throw new BizTranException(AppMessage.ARG_OUTFILE_NOT_FOUND);
        }
        File output = new File(this.mInfo.getOutputFilePath());
        if (this.mInfo.isFolder()) {
            if (!output.exists() || output.isFile()) {
                throw new BizTranException(AppMessage.ARG_OUTFOLDER_IS_FILE);
            }
        } else if (output.isDirectory()) {
            throw new BizTranException(AppMessage.ARG_OUTFILE_IS_FOLDER);
        }
    }

    private boolean isMappingFile(String arg) {
        String s = arg.toLowerCase();
        return s.startsWith("/m");
    }

    private boolean isInputOption(String arg) {
        String s = arg.toLowerCase();
        return s.startsWith("/i");
    }

    private boolean isOutputOption(String arg) {
        String s = arg.toLowerCase();
        return s.startsWith("/o");
    }

    private boolean isFolderOption(String arg) {
        String s = arg.toLowerCase();
        return s.equals("/f");
    }

    private boolean isLogOption(String arg) {
        String s = arg.toLowerCase();
        return s.startsWith("/l") || s.startsWith("/lp") || s.startsWith("/lo");
    }

    private boolean isVersionOption(String arg) {
        String s = arg.toLowerCase();
        return s.equals("/version");
    }

    private boolean isParam(String arg) {
        String s = arg.toLowerCase();
        return s.indexOf(61) > 0;
    }

    private boolean isDivideOption(String arg) {
        String s = arg.toLowerCase();
        return s.startsWith("/d");
    }

    private boolean isAddDecimalZeroOption(String arg) {
        String s = arg.toLowerCase();
        return s.startsWith("/ad");
    }

    private boolean isTableOption(String arg) {
        String s = arg.toLowerCase();
        return s.startsWith("/t");
    }

    private boolean isOverwriteValidationFlag(String arg) {
        String s = arg.toLowerCase();
        return s.startsWith("/v") && !s.equals("/version");
    }
}

