/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.map;

import com.argo21.common.gui.GuiUtils;
import com.argo21.common.gui.ImageLoader;
import com.argo21.common.util.Properties;
import com.argo21.map.MapDocument;
import com.argo21.map.MappingException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class ConfigDialog
extends JDialog
implements ActionListener {
    boolean isOK = false;
    JTabbedPane tabbedPane;
    JButton okButton;
    JButton cancelButton;
    JTextArea jdbcDriverField;
    JList paramList;
    JButton paramAddButton;
    JButton paramDelButton;
    JTextField paramfield;
    JTextArea descriptionField;

    public ConfigDialog(Frame frame) {
        super(frame, true);
        this.init(frame);
    }

    public ConfigDialog(Dialog dialog) {
        super(dialog, true);
        this.init(dialog);
    }

    private void init(Component frame) {
        this.setTitle(MappingException.getMessage("CMD_VIEW_CONFIG"));
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.addTab(MappingException.getMessage("LB_BASE_INFO"), this.createBaseInfoPanel());
        this.tabbedPane.addTab(MappingException.getMessage("LB_MAP_INFO"), this.createMapInfoPanel());
        contentPane.add((Component)this.tabbedPane, "Center");
        JPanel tp = new JPanel();
        tp.setLayout(new FlowLayout(1, 10, 10));
        this.okButton = new JButton(MappingException.getMessage("BUTTON_OK"));
        this.okButton.addActionListener(this);
        tp.add(this.okButton);
        this.cancelButton = new JButton(MappingException.getMessage("BUTTON_CANCEL"));
        this.cancelButton.addActionListener(this);
        tp.add(this.cancelButton);
        contentPane.add((Component)tp, "South");
        this.setSize(460, 380);
        Point p = frame.getLocation();
        p.translate((frame.getWidth() - this.getWidth()) / 2, (frame.getHeight() - this.getHeight()) / 2);
        this.setLocation(p);
    }

    JPanel createBaseInfoPanel() {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createTitledBorder(""));
        panel.setLayout(new BorderLayout());
        this.jdbcDriverField = new JTextArea("");
        this.jdbcDriverField.setBorder(BorderFactory.createEmptyBorder());
        this.jdbcDriverField.setLineWrap(true);
        JScrollPane scrollPane = new JScrollPane(this.jdbcDriverField);
        scrollPane.setPreferredSize(new Dimension(60, 100));
        GuiUtils.addWindowsEditorHotKey(this.jdbcDriverField);
        String s = MappingException.getMessage("LB_JDBCDRIVER");
        scrollPane.setBorder(BorderFactory.createTitledBorder(s));
        panel.add((Component)scrollPane, "North");
        panel.add((Component)new JLabel(" "), "Center");
        return panel;
    }

    JPanel createMapInfoPanel() {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createTitledBorder(""));
        panel.setLayout(new BorderLayout());
        this.descriptionField = new JTextArea("");
        this.descriptionField.setBorder(BorderFactory.createEtchedBorder());
        JScrollPane scrollPane = new JScrollPane(this.descriptionField);
        String s = MappingException.getMessage("LB_MAP_DECP");
        scrollPane.setBorder(BorderFactory.createTitledBorder(s));
        scrollPane.setPreferredSize(new Dimension(400, 60));
        panel.add((Component)scrollPane, "North");
        JPanel tp = new JPanel();
        s = MappingException.getMessage("LB_MAP_PARAM");
        tp.setBorder(BorderFactory.createTitledBorder(s));
        tp.setLayout(new BorderLayout());
        this.paramList = new JList();
        DefaultListModel dm = new DefaultListModel();
        this.paramList.setModel(dm);
        scrollPane = new JScrollPane(this.paramList);
        scrollPane.setAlignmentX(0.0f);
        scrollPane.setAlignmentY(0.0f);
        tp.add((Component)scrollPane, "Center");
        JPanel tp1 = new JPanel();
        tp1.setLayout(new FlowLayout(1, 0, 0));
        this.paramAddButton = new JButton(ImageLoader.load("toup.gif", "Add"));
        this.paramAddButton.addActionListener(this);
        this.paramAddButton.setBorder(null);
        this.paramAddButton.setMargin(new Insets(0, 0, 0, 0));
        tp1.add(this.paramAddButton);
        this.paramDelButton = new JButton(ImageLoader.load("todown.gif", "Del"));
        this.paramDelButton.addActionListener(this);
        this.paramDelButton.setBorder(null);
        this.paramDelButton.setMargin(new Insets(0, 0, 0, 0));
        tp1.add(this.paramDelButton);
        JPanel tp2 = new JPanel(new BorderLayout());
        tp2.add((Component)tp1, "North");
        this.paramfield = new JTextField("");
        GuiUtils.addWindowsEditorHotKey(this.paramfield);
        this.paramfield.setBorder(BorderFactory.createEtchedBorder());
        tp2.add((Component)this.paramfield, "Center");
        tp.add((Component)tp2, "South");
        panel.add((Component)tp, "Center");
        return panel;
    }

    public String getJdbcDriver() {
        return this.jdbcDriverField.getText();
    }

    public void setJdbcDriver(String value) {
        this.jdbcDriverField.setText(value);
    }

    public void setJdbcDriverEditable(boolean b) {
        this.jdbcDriverField.setEditable(b);
    }

    public String getDescription() {
        return this.descriptionField.getText();
    }

    public void setDescription(String value) {
        this.descriptionField.setText(value);
    }

    public void setDescriptionEditable(boolean b) {
        this.descriptionField.setEditable(b);
    }

    public Properties getParameters() {
        Properties ps = new Properties();
        DefaultListModel dm = (DefaultListModel)this.paramList.getModel();
        int n = dm.getSize();
        for (int i = 0; i < n; ++i) {
            String s = (String)dm.elementAt(i);
            int k = s.indexOf("=");
            if (k <= 0) continue;
            ps.append(s.substring(0, k), s.substring(k + 1));
        }
        return ps;
    }

    public void setParameters(Properties params) {
        DefaultListModel dm = (DefaultListModel)this.paramList.getModel();
        int n = params.getSize();
        for (int i = 0; i < n; ++i) {
            dm.addElement(params.getName(i) + "=" + params.getValue(i));
        }
    }

    public void setParametersEditable(boolean b) {
        this.paramAddButton.setEnabled(b);
        this.paramDelButton.setEnabled(b);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.cancelButton) {
            this.isOK = false;
            this.setVisible(false);
        } else if (source == this.okButton) {
            this.isOK = true;
            this.setVisible(false);
        } else if (source == this.paramAddButton) {
            String s = this.paramfield.getText().trim();
            if (s.equals("")) {
                return;
            }
            int k = s.indexOf("=");
            if (k < 0) {
                String msg = MappingException.msgCatalog.getMessage("INVALID_PARAM", new Object[]{"Name", "Value"});
                JOptionPane.showMessageDialog(this, msg);
                return;
            }
            String name2 = s.substring(0, k).trim();
            String value = s.substring(k + 1).trim();
            if (!MapDocument.isName(name2)) {
                JOptionPane.showMessageDialog(this, MappingException.getMessage("INVALID_NAME", name2));
                return;
            }
            if (this.hasParameter(name2)) {
                JOptionPane.showMessageDialog(this, MappingException.getMessage("DOUBLE_NAME", name2));
                return;
            }
            DefaultListModel dm = (DefaultListModel)this.paramList.getModel();
            dm.addElement(name2 + "=" + value);
            this.paramfield.setText("");
        } else if (source == this.paramDelButton) {
            int index = this.paramList.getSelectedIndex();
            if (index < 0) {
                return;
            }
            this.paramfield.setText((String)this.paramList.getSelectedValue());
            DefaultListModel dm = (DefaultListModel)this.paramList.getModel();
            dm.removeElementAt(index);
        }
    }

    boolean hasParameter(String name2) {
        DefaultListModel dm = (DefaultListModel)this.paramList.getModel();
        int n = dm.getSize();
        for (int i = 0; i < n; ++i) {
            String s = (String)dm.elementAt(i);
            int k = s.indexOf("=");
            if (k <= 0 || !s.substring(0, k).trim().equals(name2)) continue;
            return true;
        }
        return false;
    }
}

