/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.map;

import com.argo21.common.gui.ComboTextFieldEx;
import com.argo21.common.gui.GuiUtils;
import com.argo21.common.lang.Variable;
import com.argo21.common.lang.VariableReference;
import com.argo21.common.lang.XData;
import com.argo21.common.lang.XDataException;
import com.argo21.common.lang.XDataViewer;
import com.argo21.map.MappingEditor;
import com.argo21.map.MappingException;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.border.SoftBevelBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class EvalViewer
extends JDialog {
    static String SPLIT = "                                                                                                            ";
    String ST_CANT_EVAL = MappingException.getMessage("ST_CANT_EVAL");
    MyTree tree;
    JTable table;
    ComboTextFieldEx nameList;
    Variable variable = null;
    VariableReference varref = null;
    JScrollPane sp;
    JPanel viewer;
    int treeWidth = -1;
    int treeHeight = -1;
    private boolean disnableSelected = false;

    public EvalViewer(Frame frame, VariableReference varref, String name2) {
        super(frame, true);
        this.init(varref, name2);
    }

    public EvalViewer(Dialog dialog, VariableReference varref, String name2) {
        super(dialog, true);
        this.init(varref, name2);
    }

    private void init(VariableReference varref, String name2) {
        this.setTitle(MappingException.getMessage("CMD_EVAL"));
        this.varref = varref;
        JPanel tpList = new JPanel();
        tpList.setLayout(new BorderLayout());
        tpList.setBorder(BorderFactory.createTitledBorder(MappingException.getMessage("DLG_VAR_TABLE")));
        this.nameList = new ComboTextFieldEx(varref.names());
        tpList.add((Component)this.nameList, "Center");
        JPanel contentPane = new JPanel(new BorderLayout());
        contentPane.setBorder(MappingEditor.defaultBorder);
        this.setContentPane(contentPane);
        this.setBackground(Color.white);
        this.viewer = new JPanel();
        this.viewer.setLayout(new BorderLayout());
        this.viewer.setBackground(Color.white);
        this.viewer.setOpaque(true);
        this.tree = new MyTree();
        GuiUtils.setLookAndFeel(GuiUtils.lookAndFeelClassName, this.tree);
        try {
            TreeModel treeModel = this.createTreeModel();
            this.tree.setModel(treeModel);
        }
        catch (Exception treeModel) {
            // empty catch block
        }
        DefaultTreeCellRenderer renderer = (DefaultTreeCellRenderer)this.tree.getCellRenderer();
        renderer.setOpenIcon(null);
        renderer.setClosedIcon(null);
        renderer.setLeafIcon(null);
        this.table = new JTable(new MyTableModel()){

            @Override
            public void setBounds(int x, int y, int width, int height) {
                super.setBounds(x, y, width, height);
                super.sizeColumnsToFit(-1);
                EvalViewer.this.adjustContentsPanelSize();
            }
        };
        this.table.setCellSelectionEnabled(false);
        this.table.setRowSelectionAllowed(true);
        this.table.setColumnSelectionAllowed(false);
        this.table.setSelectionMode(0);
        this.table.getTableHeader().setReorderingAllowed(false);
        this.tree.setBackgroundSelectionColor(this.table.getSelectionBackground());
        this.tree.getSelectionModel().setSelectionMode(1);
        if (MappingEditor.isJDK_1_3) {
            this.tree.setRowHeight(this.table.getRowHeight());
        } else {
            this.tree.setRowHeight(this.table.getRowHeight() + 1);
        }
        this.tree.setBorder(BorderFactory.createLineBorder(Color.black, 1));
        this.sp = new JScrollPane(this.table);
        this.sp.getViewport().setBackground(Color.white);
        this.tree.addTreeExpansionListener(new TreeExpansionListener(){

            @Override
            public void treeExpanded(TreeExpansionEvent event) {
                EvalViewer.this.treeChanged();
            }

            @Override
            public void treeCollapsed(TreeExpansionEvent event) {
                EvalViewer.this.treeChanged();
            }
        });
        this.table.add(this.tree);
        this.tree.setLocation(0, -1);
        this.tree.setBorder(null);
        this.viewer.add((Component)this.sp, "Center");
        this.viewer.setPreferredSize(new Dimension(400, 360));
        contentPane.add((Component)this.viewer, "Center");
        contentPane.add((Component)tpList, "North");
        JPanel tp = new JPanel();
        tp.setLayout(new FlowLayout(1, 10, 10));
        JButton okButton = new JButton(MappingException.getMessage("BUTTON_OK"));
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EvalViewer.this.setVisible(false);
            }
        });
        tp.add(okButton);
        contentPane.add((Component)tp, "South");
        this.pack();
        JTableHeader header = this.table.getTableHeader();
        header.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
                EvalViewer.this.adjustTreeWidth();
            }

            @Override
            public void mouseMoved(MouseEvent e) {
            }
        });
        header.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                EvalViewer.this.adjustTreeWidth();
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                EvalViewer.this.setVisible(false);
            }
        });
        this.tree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                EvalViewer.this.treeNodeSelected();
            }
        });
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                EvalViewer.this.tabelRowSelected();
            }
        });
        this.nameList.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EvalViewer.this.nameListChanged();
            }
        });
        if (name2 != null && name2.equals(this.nameList.getSelectedItem())) {
            this.nameListChanged();
        } else {
            this.nameList.setSelectedItem(name2);
        }
    }

    public void nameListChanged() {
        String name2 = (String)this.nameList.getSelectedItem();
        this.variable = name2 == null ? null : this.varref.getVariable(name2);
        try {
            TreeModel treeModel = this.createTreeModel();
            this.tree.setModel(treeModel);
            this.tree.invalidate();
            this.tree.repaint();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void treeNodeSelected() {
        if (this.disnableSelected) {
            return;
        }
        this.disnableSelected = true;
        try {
            int[] sels = this.tree.getSelectionRows();
            if (sels.length > 0) {
                int r = sels[sels.length - 1];
                this.table.clearSelection();
                this.table.setRowSelectionInterval(r, r);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.disnableSelected = false;
    }

    public void tabelRowSelected() {
        if (this.disnableSelected) {
            return;
        }
        this.disnableSelected = true;
        try {
            int[] sels = this.table.getSelectedRows();
            if (sels.length > 0) {
                int r = sels[sels.length - 1];
                this.tree.clearSelection();
                this.tree.setSelectionInterval(r, r);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.disnableSelected = false;
    }

    public void adjustTreeWidth() {
        if (this.table == null || this.tree == null) {
            return;
        }
        int w = this.table.getColumnModel().getColumn(0).getWidth();
        if (MappingEditor.isJDK_1_3) {
            --w;
        }
        int h = this.table.getRowCount() * (this.table.getRowHeight() + 1);
        if (this.treeWidth != w && w > 0 && h > 0) {
            this.treeWidth = w;
            try {
                this.tree.setSize(w, h);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void adjustTreeHeight() {
        if (this.table == null || this.tree == null) {
            return;
        }
        int h = this.table.getRowCount() * (this.table.getRowHeight() + 1);
        int w = this.table.getColumnModel().getColumn(0).getWidth();
        if (MappingEditor.isJDK_1_3) {
            --w;
        }
        if (this.treeHeight != h && w > 0 && h > 0) {
            this.treeHeight = h;
            try {
                this.tree.setSize(w, h);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void adjustContentsPanelSize() {
        if (this.table == null || this.tree == null) {
            return;
        }
        int w = this.table.getColumnModel().getColumn(0).getWidth();
        int h = this.table.getRowCount() * (this.table.getRowHeight() + 1);
        if (MappingEditor.isJDK_1_3) {
            --w;
        }
        if (w <= 0 || h <= 0) {
            return;
        }
        if (this.treeHeight != h || this.treeWidth != w) {
            this.treeWidth = w;
            this.treeHeight = h;
            try {
                this.tree.setSize(w, h);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void treeChanged() {
        this.table.invalidate();
        this.table.repaint();
    }

    TreeModel createTreeModel() throws XDataException {
        XData viewer;
        if (this.variable == null) {
            return new DefaultTreeModel(new EvalValueNode("", "", ""));
        }
        XData data = this.variable.getData();
        XData xData = viewer = data.getEvalType() == null ? null : data;
        DefaultMutableTreeNode root = viewer == null ? new EvalValueNode(this.variable.name, "", this.ST_CANT_EVAL) : (!viewer.hasChildenDataViewer() ? new EvalValueNode(this.variable.name, viewer.getEvalType(), String.valueOf(viewer.getEvalValue())) : new DynamicTreeNode(this.variable.name, viewer));
        return new DefaultTreeModel(root);
    }

    public static JPanel createVerticalPanel(boolean threeD) {
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 1));
        if (threeD) {
            p.setBorder(new SoftBevelBorder(1));
        }
        return p;
    }

    class MyTableModel
    extends AbstractTableModel {
        String[] names = new String[]{MappingException.getMessage("DLG_VAR_NAME"), MappingException.getMessage("DLG_VAR_TYPE"), MappingException.getMessage("DLG_VAR_VALUE")};
        int rows = 0;

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public int getRowCount() {
            int tmp = EvalViewer.this.tree.getRowCount();
            if (tmp > 0 && tmp != this.rows) {
                this.rows = tmp;
            }
            return this.rows;
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (col == 1) {
                TreePath path = EvalViewer.this.tree.getPathForRow(row);
                if (path == null) {
                    return "";
                }
                Object node = path.getLastPathComponent();
                if (node instanceof DynamicTreeNode) {
                    return ((DynamicTreeNode)node).getEvalType();
                }
                if (node instanceof EvalValueNode) {
                    return ((EvalValueNode)node).getEvalType();
                }
            } else if (col == 2) {
                TreePath path = EvalViewer.this.tree.getPathForRow(row);
                if (path == null) {
                    return "";
                }
                Object node = path.getLastPathComponent();
                if (node instanceof DynamicTreeNode) {
                    return ((DynamicTreeNode)node).getEvalValue();
                }
                if (node instanceof EvalValueNode) {
                    return ((EvalValueNode)node).getEvalValue();
                }
            }
            return "";
        }

        @Override
        public String getColumnName(int column) {
            return this.names[column];
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return false;
        }
    }

    static class MyUserData {
        String value;
        int type;
        String name;

        MyUserData(int type, String name2, String value) {
            this.type = type;
            this.name = name2;
            this.value = value;
        }

        public String toString() {
            return this.value == null ? this.name : this.name + " -- " + this.value;
        }
    }

    static class MyTree
    extends JTree {
        int w1 = -1;
        int w2 = -1;

        public MyTree() {
            this.setCellRenderer(new DefaultTreeCellRenderer());
        }

        public void setBackgroundSelectionColor(Color color) {
            DefaultTreeCellRenderer render = (DefaultTreeCellRenderer)this.getCellRenderer();
            render.setBackgroundSelectionColor(color);
        }

        @Override
        public void paint(Graphics g) {
            int rh;
            int h;
            super.paint(g);
            int w = this.getWidth();
            if (w <= 0 || (h = this.getHeight()) <= 0) {
                return;
            }
            Color bakColor = g.getColor();
            g.setColor(Color.black);
            int n = this.getRowCount();
            int k = rh = this.getRowHeight();
            for (int i = 0; i < n && k < h; k += rh, ++i) {
                g.drawLine(0, k, w, k);
            }
            g.drawLine(0, k, w, k);
            g.setColor(bakColor);
        }
    }

    class DynamicTreeNode
    extends DefaultMutableTreeNode {
        protected boolean hasLoaded;
        private String name;

        public DynamicTreeNode(Object obj) {
            this(null, obj);
        }

        public DynamicTreeNode(String name2, Object obj) {
            super(obj);
            this.name = null;
            this.name = name2;
        }

        @Override
        public String toString() {
            XDataViewer viewer = (XDataViewer)this.userObject;
            String name2 = this.name != null ? this.name : viewer.getEvalName();
            return String.valueOf(name2) + SPLIT;
        }

        public String getEvalValue() {
            XDataViewer viewer = (XDataViewer)this.userObject;
            Object value = viewer.getEvalValue();
            return viewer.getEvalType() == null || value == null ? EvalViewer.this.ST_CANT_EVAL : String.valueOf(value);
        }

        public String getEvalType() {
            XDataViewer viewer = (XDataViewer)this.userObject;
            String type = viewer.getEvalType();
            return type == null || "null".equals(type) ? "" : type;
        }

        @Override
        public boolean isLeaf() {
            return false;
        }

        @Override
        public int getChildCount() {
            if (!this.hasLoaded) {
                this.loadChildren();
            }
            return super.getChildCount();
        }

        protected void loadChildren() {
            this.hasLoaded = true;
            XDataViewer viewer = (XDataViewer)this.userObject;
            String typeString = viewer.getEvalType();
            if (typeString.endsWith("[]")) {
                XDataViewer[] views = viewer.getChildren();
                for (int i = 0; i < views.length; ++i) {
                    if (views[i].hasChildenDataViewer()) {
                        this.add(new DynamicTreeNode("[" + i + "]", views[i]));
                        continue;
                    }
                    Object va = views[i].getEvalValue();
                    this.add(new EvalValueNode("[" + i + "]", views[i].getEvalType(), String.valueOf(va)));
                }
            } else {
                XDataViewer[] views = viewer.getChildren();
                for (int i = 0; i < views.length; ++i) {
                    if (views[i].hasChildenDataViewer()) {
                        this.add(new DynamicTreeNode(views[i]));
                        continue;
                    }
                    Object va = views[i].getEvalValue();
                    if (va == null) {
                        this.add(new EvalValueNode(views[i].getEvalName(), views[i].getEvalType(), ""));
                        continue;
                    }
                    if (va instanceof String) {
                        this.add(new EvalValueNode(views[i].getEvalName(), views[i].getEvalType(), (String)va));
                        continue;
                    }
                    if (!(va instanceof XDataViewer)) continue;
                    EvalValueNode node = new EvalValueNode(views[i].getEvalName(), views[i].getEvalType(), "");
                    this.add(node);
                    XDataViewer vv = (XDataViewer)va;
                    node.add(new DynamicTreeNode(vv.getEvalName(), vv));
                }
            }
        }
    }

    class EvalValueNode
    extends DefaultMutableTreeNode {
        String type;
        String value;

        EvalValueNode(String name2, String type, String value) {
            super(name2);
            this.type = type;
            this.value = value;
        }

        @Override
        public String toString() {
            return String.valueOf(this.getUserObject()) + SPLIT;
        }

        public String getEvalValue() {
            return this.type == null || this.value == null ? EvalViewer.this.ST_CANT_EVAL : this.value;
        }

        public String getEvalType() {
            return this.type == null || "null".equals(this.type) ? "" : this.type;
        }
    }
}

