/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.map;

import com.argo21.common.io.XReader;
import com.argo21.common.util.Properties;
import com.argo21.msg.BaseMessage;
import com.argo21.msg.MessageException;
import com.argo21.msg.MessageFactory;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;
import javax.swing.text.Segment;
import org.xml.sax.Locator;

public final class MapDocument {
    static String eol;
    static final String PROPERTY = "[Property]";
    static final String SCHEMA = "[Schema]";
    static final String SCRIPT = "[Script]";
    Vector lisner = new Vector(4);
    String filename = null;
    String description = "";
    Properties params = new Properties();
    DeclSegment[] decls = null;
    ScriptSegment scripts = null;
    long firstModifie;
    long lastModifie;
    public static final String EndOfLineStringProperty = "__EndOfLine__";

    public static MapDocument createDocument() {
        PlainDocument doc = new PlainDocument();
        MapDocument map = new MapDocument(new DeclSegment[0], new ScriptSegment(doc));
        map.scripts.lastModifie = map.lastModifie = (map.firstModifie = System.currentTimeMillis());
        map.scripts.mapDoc = map;
        map.description = "";
        map.params = new Properties();
        return map;
    }

    public static MapDocument openDocument(Reader in) throws MessageException {
        XReader reader = in instanceof XReader ? (XReader)in : XReader.createReader(in);
        DeclSegment[] msgs = new DeclSegment[]{};
        ScriptSegment scripts = null;
        boolean hasScript = false;
        reader.peekWhitespace();
        String description = "";
        Properties params = new Properties();
        while (!reader.isEOF()) {
            String s;
            char c = reader.getc();
            if (c == '#') {
                String s1;
                int k;
                s = reader.readLine();
                if (s == null) continue;
                reader.peekWhitespace();
                s = s.trim();
                if (s.length() > 9 && s.startsWith("@param") && (s.charAt(6) == ' ' || s.charAt(6) == '\b') && (k = (s1 = s.substring(7).trim()).indexOf("=")) > 0) {
                    params.repleace(s1.substring(0, k).trim(), s1.substring(k + 1).trim());
                    continue;
                }
                if (description.length() > 0) {
                    description = description + "\n" + s;
                    continue;
                }
                description = s;
                continue;
            }
            if (c != '[') {
                reader.ungetc();
                MessageException.error("INVAILD_CHAR", reader.lookupWord(), (Locator)reader);
            }
            if ((s = reader.peekName()) == null) {
                MessageException.error("INVAILD_CHAR", reader.lookupWord(), (Locator)reader);
            }
            if (!reader.peekc(']')) {
                MessageException.error("NEED_CHAR", "]", (Locator)reader);
            }
            reader.peekSpace();
            c = reader.getc();
            if (c == '\r') {
                c = reader.getc();
                if (c != '\n') {
                    reader.ungetc();
                }
            } else {
                c = reader.getc();
                if (c != '\n') {
                    reader.ungetc();
                }
            }
            if (s.equals("MSGDECL")) {
                if (hasScript) {
                    MessageException.error("MUST_BEFOR_PARA", new Object[]{"[MSGDECL]", "[SCRIPT]"}, (Locator)reader);
                }
                DeclSegment msg = MapDocument.readMsgDecl1(reader);
                DeclSegment[] tmp = msgs;
                msgs = new DeclSegment[tmp.length + 1];
                System.arraycopy(tmp, 0, msgs, 0, tmp.length);
                msgs[tmp.length] = msg;
                String type = msg.getMsgType();
                if (type == null) {
                    MessageException.error("UNDEFINE_MSG", new String[0], (Locator)reader);
                } else {
                    MessageFactory f = MessageFactory.getInstance();
                    if (!f.contains(type)) {
                        MessageException.error("UNDEFINE_MSG", type, (Locator)reader);
                    }
                }
            } else if (s.equals("SCRIPT")) {
                reader.setPublicId(SCRIPT);
                if (hasScript) {
                    MessageException.error("DOUBLE_PARA", "[SCRIPT]", (Locator)reader);
                }
                hasScript = true;
                scripts = MapDocument.readScript(reader);
            } else {
                MessageException.error("INVAILD_PARA", "[" + s + "]", (Locator)reader);
            }
            reader.peekWhitespace();
        }
        if (scripts == null) {
            scripts = new ScriptSegment(new PlainDocument());
        }
        MapDocument map = new MapDocument(msgs, scripts);
        map.lastModifie = map.firstModifie = System.currentTimeMillis();
        for (int i = 0; i < msgs.length; ++i) {
            String name2 = msgs[i].getMsgName();
            if (name2 == null) {
                msgs[i].ps.append("name", map.getNewMsgName("MSG"));
            }
            msgs[i].lastModifie = map.lastModifie;
            msgs[i].mapDoc = map;
        }
        map.description = description;
        map.params = params;
        map.scripts.lastModifie = map.lastModifie;
        map.scripts.mapDoc = map;
        return map;
    }

    static DeclSegment readMsgDecl(XReader in) throws MessageException {
        in.peekWhitespace();
        if (!in.peek("[MSGDECL]")) {
            MessageException.error("INVAILD_CHAR", in.lookupWord(), (Locator)in);
        }
        in.peekSpace();
        char c = in.getc();
        if (c == '\r') {
            c = in.getc();
            if (c != '\n') {
                in.ungetc();
            }
        } else {
            c = in.getc();
            if (c != '\n') {
                in.ungetc();
            }
        }
        return MapDocument.readMsgDecl1(in);
    }

    private static DeclSegment readMsgDecl1(XReader in) {
        char c;
        int pnum = 1;
        Properties properties = new Properties();
        boolean propertySet = false;
        boolean scemaSet = false;
        in.peekWhitespace();
        while ((c = in.getc()) != '\u0000') {
            if (c == '[') {
                if (in.peek("MSGDECL]")) {
                    in.back(9);
                    break;
                }
                if (in.peek("SCRIPT]")) {
                    in.back(8);
                    break;
                }
            }
            if (c == '<') {
                if (scemaSet) continue;
                in.ungetc();
                in.setPublicId(SCHEMA);
                in.startRemembering();
                scemaSet = true;
                continue;
            }
            if (scemaSet) continue;
            in.ungetc();
            in.setPublicId(PROPERTY);
            String propertyname = in.peekName();
            if (propertyname == null) {
                propertyname = "property" + pnum;
                ++pnum;
            }
            in.peekSpace();
            if (!in.peekc('=')) {
                // empty if block
            }
            in.peekSpace();
            String propertyvalue = null;
            propertyvalue = in.readToEol();
            propertyvalue = propertyvalue.trim();
            if (propertyvalue.equals("")) {
                // empty if block
            }
            if (propertyvalue.equals("null")) {
                propertyvalue = null;
            }
            if (properties.contain(propertyname)) {
                // empty if block
            }
            properties.append(propertyname, propertyvalue, true);
            in.peekWhitespace();
        }
        PlainDocument doc = new PlainDocument();
        StringReader rd = new StringReader(in.rememberText());
        try {
            MapDocument.read(rd, doc, 0);
        }
        catch (BadLocationException badLocationException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return new DeclSegment(properties, doc);
    }

    private static ScriptSegment readScript(XReader in) {
        in.startRemembering();
        while (in.getc() != '\u0000') {
        }
        PlainDocument doc = new PlainDocument();
        StringReader rd = new StringReader(in.rememberText());
        try {
            MapDocument.read(rd, doc, 0);
        }
        catch (BadLocationException badLocationException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return new ScriptSegment(doc);
    }

    private MapDocument(DeclSegment[] decls, ScriptSegment scripts) {
        this.decls = decls;
        this.scripts = scripts;
    }

    public long getLastModifie() {
        return this.lastModifie;
    }

    public String getFileName() {
        return this.filename;
    }

    public void setFileName(String filename) {
        this.filename = filename;
    }

    public boolean isDirty() {
        return this.lastModifie > this.firstModifie;
    }

    public void addMapDocumentListener(MapDocListener l) {
        if (!this.lisner.contains(l)) {
            this.lisner.addElement(l);
        }
    }

    public void removeMapDocumentListener(MapDocListener l) {
        this.lisner.remove(l);
    }

    public void removeAllMapDocumentListener() {
        this.lisner.removeAllElements();
    }

    String getDescription() {
        return this.description;
    }

    void setDescription(String description) {
        this.description = description;
        this.lastModifie = System.currentTimeMillis();
        int n = this.decls == null ? 0 : this.decls.length;
        for (int i = 0; i < n; ++i) {
            this.decls[i].model = null;
            this.decls[i].lastModifie = this.lastModifie;
        }
    }

    Properties getParameters() {
        return this.params;
    }

    void setParameters(Properties params) {
        this.params = params;
        this.lastModifie = System.currentTimeMillis();
    }

    void addParameter(String name2, String value) {
        this.params.repleace(name2, value);
    }

    boolean reName(String oldName, String newName) throws MessageException {
        if (oldName.equals(newName)) {
            return false;
        }
        if (this.hasMsgName(newName)) {
            MessageException.error("DOUBLE_MSGNAME", newName, null);
            return false;
        }
        DeclSegment msg = this.getDeclSegment(oldName);
        if (msg == null) {
            return false;
        }
        Properties ps = msg.getProperties();
        ps.repleace("name", newName);
        msg.name = newName;
        try {
            msg.psdoc.remove(0, msg.psdoc.getLength());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            StringReader rd = new StringReader(ps.toString());
            MapDocument.read(rd, msg.psdoc, 0);
        }
        catch (Exception exception) {
            // empty catch block
        }
        msg.ps = ps;
        this.lastModifie = System.currentTimeMillis();
        this.notifyRenamed(oldName, newName);
        return true;
    }

    void notifyRenamed(String oldName, String newName) {
        int n = this.lisner.size();
        for (int i = 0; i < n; ++i) {
            MapDocListener ad = (MapDocListener)this.lisner.elementAt(i);
            ad.renamed(oldName, newName);
        }
    }

    public void save(Writer out) throws IOException {
        int i;
        if (this.description != null && this.description.trim().length() > 0) {
            StringTokenizer sz = new StringTokenizer(this.description, "\r\n");
            while (sz.hasMoreElements()) {
                String s = (String)sz.nextElement();
                if (s.length() <= 0) continue;
                out.write("#");
                out.write(s);
                out.write(eol);
            }
        }
        int n = this.params.getSize();
        for (i = 0; i < n; ++i) {
            out.write("#@param ");
            out.write(this.params.getName(i));
            out.write("=");
            out.write(this.params.getValue(i));
            out.write(eol);
        }
        for (i = 0; i < this.decls.length; ++i) {
            this.decls[i].writeTo(out);
        }
        out.write("[SCRIPT]");
        out.write(eol);
        try {
            MapDocument.write(out, this.scripts.doc, 0, this.scripts.doc.getLength());
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        out.write(eol);
        this.firstModifie = this.lastModifie;
    }

    public DeclSegment insertDeclSegment(String msgType, String msgName, String refMsgName) throws MessageException {
        if (msgType == null) {
            MessageException.error("UNDEFINE_MSG", new String[0], null);
        }
        if (msgName == null) {
            msgName = this.getNewMsgName("MSG");
        }
        MessageFactory f = MessageFactory.getInstance();
        BaseMessage bs = f.createMessage(msgType);
        bs.setPrameters(this.getParameters());
        Properties ps = bs.getDefaultProperties();
        ps.repleace("name", msgName);
        try {
            for (int i = 0; i < this.decls.length; ++i) {
                Properties ps1 = this.decls[i].getProperties();
                if (!"INPUT".equals(ps1.getValue("direction", "INPUT"))) continue;
                ps.repleace("direction", "OUTPUT");
            }
        }
        catch (Exception i) {
            // empty catch block
        }
        PlainDocument doc = new PlainDocument();
        DeclSegment msg = new DeclSegment(ps, doc);
        msg.type = msgType;
        msg.name = msgName;
        return this.insertDeclSegment(msg, refMsgName);
    }

    DeclSegment insertDeclSegment(DeclSegment msg, String refMsgName) throws MessageException {
        int index;
        if (this.decls == null) {
            this.decls = new DeclSegment[1];
            index = 0;
            this.decls[0] = msg;
        } else {
            DeclSegment[] tmp = this.decls;
            this.decls = new DeclSegment[tmp.length + 1];
            index = this.indexOf(refMsgName);
            if (index >= 0) {
                System.arraycopy(tmp, 0, this.decls, 0, index);
                this.decls[index] = msg;
                System.arraycopy(tmp, index, this.decls, index + 1, tmp.length - index);
            } else {
                index = tmp.length;
                System.arraycopy(tmp, 0, this.decls, 0, tmp.length);
                this.decls[index] = msg;
            }
        }
        msg.lastModifie = this.lastModifie = System.currentTimeMillis();
        msg.mapDoc = this;
        int n = this.lisner.size();
        for (int i = 0; i < n; ++i) {
            MapDocListener ad = (MapDocListener)this.lisner.elementAt(i);
            ad.inserted(msg.name, index);
        }
        return msg;
    }

    public DeclSegment removeDeclSegment(String msgName) {
        int k = this.indexOf(msgName);
        if (k < 0) {
            return null;
        }
        DeclSegment msg = this.decls[k];
        DeclSegment[] tmp = this.decls;
        this.decls = new DeclSegment[tmp.length - 1];
        if (k > 0) {
            System.arraycopy(tmp, 0, this.decls, 0, k);
        }
        if (k + 1 < tmp.length) {
            System.arraycopy(tmp, k + 1, this.decls, k, tmp.length - k - 1);
        }
        this.lastModifie = System.currentTimeMillis();
        int n = this.lisner.size();
        for (int i = 0; i < n; ++i) {
            MapDocListener ad = (MapDocListener)this.lisner.elementAt(i);
            ad.removed(msgName);
        }
        return msg;
    }

    public DeclSegment[] getDeclSegments() {
        return this.decls;
    }

    public DeclSegment getDeclSegment(String msgName) {
        for (int i = 0; i < this.decls.length; ++i) {
            if (!msgName.equals(this.decls[i].name)) continue;
            return this.decls[i];
        }
        return null;
    }

    public ScriptSegment getScriptSegment() {
        return this.scripts;
    }

    public Document getScriptDocument() {
        return this.scripts.doc;
    }

    private int indexOf(String name2) {
        if (name2 == null) {
            return -1;
        }
        for (int i = 0; i < this.decls.length; ++i) {
            if (this.decls[i] == null || !name2.equals(this.decls[i].getMsgName())) continue;
            return i;
        }
        return -1;
    }

    private boolean hasMsgName(String name2) {
        for (int i = 0; i < this.decls.length; ++i) {
            if (this.decls[i] == null || !name2.equals(this.decls[i].getMsgName())) continue;
            return true;
        }
        return false;
    }

    String getNewMsgName(String baseName) {
        if (baseName == null) {
            baseName = "MSG";
        }
        int k = 1;
        while (this.hasMsgName(baseName + k)) {
            ++k;
        }
        return baseName + k;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Segment getDocumentSegment(Document doc) {
        Document document = doc;
        synchronized (document) {
            Segment seg = new Segment();
            try {
                String txt = doc.getText(0, doc.getLength());
                seg.array = txt.toCharArray();
                seg.offset = 0;
                seg.count = seg.array.length;
            }
            catch (BadLocationException e) {
                seg.array = new char[0];
            }
            return seg;
        }
    }

    public static void clearDocument(Document doc) {
        try {
            doc.remove(0, doc.getLength());
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public static void readDocument(Document doc, Reader in) throws IOException {
        try {
            MapDocument.read(in, doc, doc.getLength());
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public static void writeDocument(Document doc, Writer out) throws IOException {
        try {
            MapDocument.write(out, doc, 0, doc.getLength());
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public static void read(Reader in, Document doc, int pos) throws IOException, BadLocationException {
        int nch;
        boolean wasEmpty;
        char[] buff = new char[4096];
        boolean lastWasCR = false;
        boolean isCRLF = false;
        boolean isCR = false;
        boolean bl = wasEmpty = doc.getLength() == 0;
        while ((nch = in.read(buff, 0, buff.length)) != -1) {
            int last2 = 0;
            block5: for (int counter = 0; counter < nch; ++counter) {
                switch (buff[counter]) {
                    case '\r': {
                        if (lastWasCR) {
                            isCR = true;
                            if (counter == 0) {
                                doc.insertString(pos, "\n", null);
                                ++pos;
                                continue block5;
                            }
                            buff[counter - 1] = 10;
                            continue block5;
                        }
                        lastWasCR = true;
                        continue block5;
                    }
                    case '\n': {
                        if (!lastWasCR) continue block5;
                        if (counter > last2 + 1) {
                            doc.insertString(pos, new String(buff, last2, counter - last2 - 1), null);
                            pos += counter - last2 - 1;
                        }
                        lastWasCR = false;
                        last2 = counter;
                        isCRLF = true;
                        continue block5;
                    }
                    default: {
                        if (!lastWasCR) continue block5;
                        isCR = true;
                        if (counter == 0) {
                            doc.insertString(pos, "\n", null);
                            ++pos;
                        } else {
                            buff[counter - 1] = 10;
                        }
                        lastWasCR = false;
                    }
                }
            }
            if (last2 >= nch) continue;
            if (lastWasCR) {
                if (last2 >= nch - 1) continue;
                doc.insertString(pos, new String(buff, last2, nch - last2 - 1), null);
                pos += nch - last2 - 1;
                continue;
            }
            doc.insertString(pos, new String(buff, last2, nch - last2), null);
            pos += nch - last2;
        }
        if (lastWasCR) {
            doc.insertString(pos, "\n", null);
            isCR = true;
        }
        if (wasEmpty) {
            if (isCRLF) {
                doc.putProperty(EndOfLineStringProperty, "\r\n");
            } else if (isCR) {
                doc.putProperty(EndOfLineStringProperty, "\r");
            } else {
                doc.putProperty(EndOfLineStringProperty, "\n");
            }
        }
    }

    public static void write(Writer out, Document doc, int pos, int len) throws IOException, BadLocationException {
        if (pos < 0 || pos + len > doc.getLength()) {
            throw new BadLocationException("DefaultEditorKit.write", pos);
        }
        Segment data = new Segment();
        int nleft = len;
        int offs = pos;
        Object endOfLineProperty = doc.getProperty(EndOfLineStringProperty);
        if (endOfLineProperty == null) {
            try {
                endOfLineProperty = System.getProperty("line.separator");
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        String endOfLine = endOfLineProperty instanceof String ? (String)endOfLineProperty : null;
        if (endOfLineProperty != null && !endOfLine.equals("\n")) {
            String lastChar;
            String string2 = lastChar = endOfLine.length() == 2 ? endOfLine.substring(1) : "";
            while (nleft > 0) {
                int n = Math.min(nleft, 4096);
                doc.getText(offs, n, data);
                int last2 = data.offset;
                char[] array = data.array;
                int maxCounter = last2 + data.count;
                for (int counter = last2; counter < maxCounter; ++counter) {
                    if (array[counter] != '\n') continue;
                    if (counter > last2) {
                        out.write(array, last2, counter - last2);
                    }
                    if (counter > 0 && array[counter - 1] == '\r') {
                        out.write(lastChar);
                    } else {
                        out.write(endOfLine);
                    }
                    last2 = counter + 1;
                }
                if (maxCounter > last2) {
                    out.write(array, last2, maxCounter - last2);
                }
                offs += n;
                nleft -= n;
            }
        } else {
            while (nleft > 0) {
                int n = Math.min(nleft, 4096);
                doc.getText(offs, n, data);
                out.write(data.array, data.offset, data.count);
                offs += n;
                nleft -= n;
            }
        }
        out.flush();
    }

    static boolean isName(String s) {
        if (s == null) {
            return false;
        }
        int n = s.length();
        if (n < 1) {
            return false;
        }
        char c = s.charAt(0);
        if (!Character.isLetter(c)) {
            return false;
        }
        for (int i = 1; i < n; ++i) {
            c = s.charAt(i);
            if (Character.isLetterOrDigit(c) || c == '_') continue;
            return false;
        }
        return true;
    }

    static {
        String temp;
        try {
            temp = System.getProperty("line.separator", "\n");
        }
        catch (SecurityException e) {
            temp = "\n";
        }
        eol = temp;
    }

    public static class MapDocAdapter
    implements MapDocListener {
        @Override
        public void renamed(String oldName, String newName) {
        }

        @Override
        public void inserted(String newName, int index) {
        }

        @Override
        public void removed(String msgName) {
        }
    }

    public static interface MapDocListener {
        public void renamed(String var1, String var2);

        public void inserted(String var1, int var2);

        public void removed(String var1);
    }

    public static class ScriptSegment
    implements DocumentListener {
        int[] bps;
        int bpsCount = 0;
        Document doc;
        long lastModifie;
        MapDocument mapDoc;

        private ScriptSegment(Document doc) {
            this.bps = new int[4];
            this.doc = doc;
            doc.addDocumentListener(this);
            this.bpsCount = 0;
        }

        private ScriptSegment(int[] bps, Document doc) {
            this.bps = bps;
            this.doc = doc;
            this.bpsCount = bps.length;
        }

        public long getLastModifie() {
            return this.lastModifie;
        }

        public Document getDocument() {
            return this.doc;
        }

        public Segment getDocumentSegment() {
            return MapDocument.getDocumentSegment(this.doc);
        }

        private void update() {
            this.mapDoc.lastModifie = this.lastModifie = System.currentTimeMillis();
        }

        public void clearDocument() {
            MapDocument.clearDocument(this.doc);
        }

        public void readDocument(Reader in) throws IOException {
            MapDocument.readDocument(this.doc, in);
        }

        public void writeDocument(Writer out) throws IOException {
            MapDocument.writeDocument(this.doc, out);
        }

        public void setBreakPoint(int line) {
            for (int i = 0; i < this.bps.length; ++i) {
                if (this.bps[i] != line) continue;
                return;
            }
            if (this.bpsCount >= this.bps.length) {
                int[] tmp = this.bps;
                this.bps = new int[this.bpsCount + 4];
                System.arraycopy(tmp, 0, this.bps, 0, this.bpsCount);
            }
            this.bps[this.bpsCount++] = line;
        }

        public void removeBreakPoint(int line) {
            for (int i = 0; i < this.bps.length; ++i) {
                if (this.bps[i] != line) continue;
                if (i + 1 < this.bpsCount) {
                    System.arraycopy(this.bps, i + 1, this.bps, i, this.bpsCount - i - 1);
                }
                --this.bpsCount;
            }
        }

        public boolean isBreakPoint(int line) {
            for (int i = 0; i < this.bps.length; ++i) {
                if (this.bps[i] != line) continue;
                return true;
            }
            return false;
        }

        public void setBreakPointers(int[] bps) {
            this.bps = bps;
        }

        public int[] getBreakPointers() {
            return this.bps;
        }

        public void clearBreakPointers() {
            this.bpsCount = 0;
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.mapDoc.lastModifie = this.lastModifie = System.currentTimeMillis();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.mapDoc.lastModifie = this.lastModifie = System.currentTimeMillis();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
        }
    }

    public static class DeclSegment
    implements DocumentListener {
        Properties ps;
        Document psdoc;
        Document doc;
        Object model = null;
        long lastModifie;
        MapDocument mapDoc;
        String type;
        String name;

        private DeclSegment(Properties ps, Document doc) {
            this.ps = ps;
            this.doc = doc;
            this.psdoc = new PlainDocument();
            try {
                StringReader rd = new StringReader(ps.toString());
                MapDocument.read(rd, this.psdoc, 0);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.model = null;
            this.type = ps.getValue("type");
            this.name = ps.getValue("name");
            doc.addDocumentListener(this);
            this.psdoc.addDocumentListener(this);
        }

        public void reload(Properties ps, Document doc) {
            this.ps = ps;
            this.doc = doc;
            if (this.doc != null) {
                this.doc.removeDocumentListener(this);
            }
            if (this.psdoc != null) {
                this.psdoc.removeDocumentListener(this);
            }
            this.psdoc = new PlainDocument();
            try {
                StringReader rd = new StringReader(ps.toString());
                MapDocument.read(rd, this.psdoc, 0);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.model = null;
            this.update();
            this.doc.addDocumentListener(this);
            this.psdoc.addDocumentListener(this);
        }

        private void update() {
            this.mapDoc.lastModifie = this.lastModifie = System.currentTimeMillis();
        }

        public long getLastModifie() {
            return this.lastModifie;
        }

        public String getMsgName() {
            try {
                return this.name;
            }
            catch (Exception e) {
                return null;
            }
        }

        public void setMsgName(String name2) throws MessageException {
            Properties ps = this.getProperties();
            ps.repleace("name", name2);
            this.name = name2;
        }

        public String getMsgType() {
            return this.type;
        }

        public String getDirection() {
            try {
                return this.getProperties().getValue("direction");
            }
            catch (Exception e) {
                return null;
            }
        }

        public void chackProperty(String propertyname, String propertyvalue, XReader in) throws MessageException {
            if ("name".equals(propertyname)) {
                if (!MapDocument.isName(propertyvalue)) {
                    MessageException.error("INVALID_MSGNAME", propertyname, (Locator)in);
                }
                DeclSegment[] decls = this.mapDoc.getDeclSegments();
                for (int i = 0; i < decls.length; ++i) {
                    if (decls[i] == this || !decls[i].name.equals(propertyvalue)) continue;
                    MessageException.error("DOUBLE_MSGNAME", propertyname, (Locator)in);
                }
            } else if ("direction".equals(propertyname)) {
                String[] directions = new String[]{"INPUT", "OUTPUT", "APPEND"};
                boolean valid = false;
                for (int i = 0; i < directions.length; ++i) {
                    if (!directions[i].equalsIgnoreCase(propertyvalue)) continue;
                    valid = true;
                    break;
                }
                if (!valid) {
                    MessageException.error("INVALID_MSGDIR", propertyvalue, (Locator)in);
                }
            }
        }

        public Properties getProperties() throws MessageException {
            if (this.ps == null) {
                Properties ps = new Properties();
                Segment seg = this.getPropertyDocumentSegment();
                if (seg == null) {
                    MessageException.error("INVALID_PARAM", new String[0], null);
                }
                XReader in = XReader.createReader(seg.array, 0, seg.count, null);
                in.setPublicId(MapDocument.PROPERTY);
                in.peekWhitespace();
                while (!in.isEOF()) {
                    String propertyname = in.peekName();
                    if (propertyname == null) {
                        MessageException.error("INVAILD_CHAR", in.lookupWord(), (Locator)in);
                        break;
                    }
                    in.peekSpace();
                    if (!in.peekc('=')) {
                        MessageException.error("NEED_CHAR", "=", (Locator)in);
                        break;
                    }
                    in.peekSpace();
                    String propertyvalue = null;
                    propertyvalue = in.readToEol();
                    propertyvalue = propertyvalue.trim();
                    if (propertyvalue.equals("null")) {
                        propertyvalue = null;
                    }
                    if (ps.contain(propertyname)) {
                        MessageException.error("DOUBLE_PARAM", propertyname, (Locator)in);
                    }
                    this.chackProperty(propertyname, propertyvalue, in);
                    ps.append(propertyname, propertyvalue, true);
                    in.peekWhitespace();
                }
                ps.repleace("type", this.getMsgType());
                String name2 = ps.getValue("name");
                if (name2 == null) {
                    MessageException.error("NEED_MSGNAME", new String[0], (Locator)in);
                }
                if (!name2.equals(this.name)) {
                    String oldName = this.name;
                    this.name = name2;
                    this.mapDoc.notifyRenamed(oldName, name2);
                }
                MessageFactory f1 = MessageFactory.getInstance();
                BaseMessage bs = f1.createMessage(this.getMsgType());
                bs.setProperties(ps);
                this.ps = ps;
            }
            return this.ps;
        }

        public void setProperties(Properties ps) throws MessageException {
            ps.repleace("type", this.getMsgType());
            String name2 = ps.getValue("name");
            if (name2 == null) {
                MessageException.error("NEED_MSGNAME", new String[0], null);
            }
            if (!name2.equals(this.name)) {
                if (!MapDocument.isName(name2)) {
                    MessageException.error("INVALID_MSGNAME", name2, null);
                }
                DeclSegment[] decls = this.mapDoc.getDeclSegments();
                for (int i = 0; i < decls.length; ++i) {
                    if (decls[i] == this || !name2.equals(decls[i].getMsgName())) continue;
                    MessageException.error("DOUBLE_MSGNAME", name2, null);
                }
                String oldName = this.name;
                this.name = name2;
                this.mapDoc.notifyRenamed(oldName, name2);
            }
            MessageFactory f1 = MessageFactory.getInstance();
            BaseMessage bs = f1.createMessage(this.getMsgType());
            bs.setProperties(ps);
            try {
                this.psdoc.remove(0, this.psdoc.getLength());
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                StringReader rd = new StringReader(ps.toString());
                MapDocument.read(rd, this.psdoc, 0);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.ps = ps;
        }

        public Document getSchemaDocument() {
            return this.doc;
        }

        public Segment getSchemaDocumentSegment() {
            return MapDocument.getDocumentSegment(this.doc);
        }

        public void clearSchemaDocument() {
            MapDocument.clearDocument(this.doc);
        }

        public void readSchemaDocument(Reader in) throws IOException {
            MapDocument.readDocument(this.doc, in);
        }

        public void writeSchemaDocument(Writer out) throws IOException {
            MapDocument.writeDocument(this.doc, out);
        }

        public Document getPropertyDocument() {
            return this.psdoc;
        }

        public Segment getPropertyDocumentSegment() {
            return MapDocument.getDocumentSegment(this.psdoc);
        }

        public void clearPropertyDocument() {
            MapDocument.clearDocument(this.psdoc);
        }

        public void readPropertyDocument(Reader in) throws IOException {
            MapDocument.readDocument(this.psdoc, in);
        }

        public void writePropertyDocument(Writer out) throws IOException {
            MapDocument.writeDocument(this.psdoc, out);
        }

        public Object getSchemaModel() throws MessageException {
            if (this.model == null) {
                this.getProperties();
                if (this.ps == null || this.doc == null) {
                    return null;
                }
                MessageFactory f1 = MessageFactory.getInstance();
                BaseMessage bs = f1.createMessage(this.getMsgType());
                bs.setProperties(this.ps);
                bs.setPrameters(this.mapDoc.getParameters());
                Segment seg = this.getSchemaDocumentSegment();
                String parentPath = null;
                String fileName = this.mapDoc.getFileName();
                if (fileName != null) {
                    try {
                        String filePath = new URL(fileName).getPath();
                        File f = new File(filePath);
                        parentPath = f.getParent();
                    }
                    catch (MalformedURLException filePath) {
                        // empty catch block
                    }
                }
                XReader in = XReader.createReader(seg.array, seg.offset, seg.count, null, parentPath);
                in.setSystemId(this.getMsgName());
                in.setPublicId(MapDocument.SCHEMA);
                bs.readSchema(in);
                in.peekWhitespace();
                if (!in.isEOF()) {
                    MessageException.error("INVAILD_CHAR", in.lookupWord(), (Locator)in);
                }
                this.model = bs.getSchema();
            }
            return this.model;
        }

        public void setSchemaModel(Object schema) throws MessageException {
            MessageFactory f1 = MessageFactory.getInstance();
            BaseMessage bs = f1.createMessage(this.getMsgType());
            bs.setProperties(this.getProperties());
            bs.setSchema(schema);
            StringWriter wr = new StringWriter();
            bs.writeSchema(wr);
            try {
                this.doc.remove(0, this.doc.getLength());
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                StringReader rd = new StringReader(wr.toString());
                MapDocument.read(rd, this.doc, 0);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.model = schema;
        }

        public void check() throws MessageException {
            this.getProperties();
            this.getSchemaModel();
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            if (e.getDocument() == this.doc) {
                this.model = null;
            } else {
                this.ps = null;
            }
            this.mapDoc.lastModifie = this.lastModifie = System.currentTimeMillis();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            if (e.getDocument() == this.doc) {
                this.model = null;
            } else {
                this.ps = null;
            }
            this.mapDoc.lastModifie = this.lastModifie = System.currentTimeMillis();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
        }

        public void writeTo(Writer out) throws IOException {
            out.write("[MSGDECL]");
            out.write(eol);
            try {
                MapDocument.write(out, this.psdoc, 0, this.psdoc.getLength());
                out.write(eol);
                MapDocument.write(out, this.doc, 0, this.doc.getLength());
                out.write(eol);
            }
            catch (BadLocationException e) {
                System.out.println("Warning : " + e.toString());
            }
        }
    }
}

