/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.map;

import com.argo21.common.gui.ComboTextFieldEx;
import com.argo21.common.gui.FileFilterEx;
import com.argo21.common.gui.GuiUtils;
import com.argo21.common.gui.ImageLoader;
import com.argo21.common.gui.StatusChangedListener;
import com.argo21.common.gui.TextEditorPanel;
import com.argo21.common.io.Debug;
import com.argo21.common.io.DocumentWriter;
import com.argo21.common.io.FileEx;
import com.argo21.common.io.XReader;
import com.argo21.common.lang.MessageCatalog;
import com.argo21.common.log.AppMessage;
import com.argo21.common.security.LicenceKeys;
import com.argo21.common.util.PassFileUtil;
import com.argo21.js.ScriptException;
import com.argo21.jxp.parser.XmlParser;
import com.argo21.map.ConfigDialog;
import com.argo21.map.MapDocument;
import com.argo21.map.MappingEditorListener;
import com.argo21.map.MappingException;
import com.argo21.map.MessageLibraryDialog;
import com.argo21.map.MessageLibraryManager;
import com.argo21.map.MessageWindow;
import com.argo21.map.SchemaEditorPanel;
import com.argo21.map.ScriptDebugerPanel;
import com.argo21.map.ScriptEditorPanel;
import com.argo21.map.WorkSpace;
import com.argo21.msg.MessageException;
import com.argo21.msg.MessageFactory;
import com.argo21.msg.rdb.RdbConnector;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.sql.Driver;
import java.sql.SQLException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.JWindow;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.BevelBorder;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.Document;
import jp.co.argo21.nts.commons.passfile.PassFile;
import jp.co.argo21.nts.commons.passfile.PassFileArgumentException;
import jp.co.argo21.nts.commons.passfile.PassFileIOException;
import jp.co.argo21.nts.commons.passfile.PassFileIllegalException;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public final class MappingEditor
extends JFrame
implements MenuListener,
MapDocument.MapDocListener {
    public static int WIDTH;
    public static int HEIGHT;
    public static String TITLE_STRING;
    public static String DEFAULT_JDBC_DRIVER;
    public static String WKS_DEBUGER;
    public static String WKS_SCRIPT;
    public static String WKS_EMPTY;
    public static String WKS_MSGDECL;
    public static final String CMD_NEW_FILE = "NEW";
    public static final String CMD_OPEN_FILE = "OPEN";
    public static final String CMD_SAVE_FILE = "SAVE";
    public static final String CMD_SAVEAS_FILE = "SAVEAS";
    public static final String CMD_EXIT = "EXIT";
    public static final String CMD_MSG_DEL = "CMD_MSG_DEL";
    public static final String CMD_VIEW_MSG = "MSGWINDOW";
    public static final String CMD_VIEW_TOOLBAR = "TOOLBAL";
    public static final String CMD_VIEW_STATUSBAR = "STATUSBAR";
    public static final String CMD_VIEW_CONFIG = "CONFIG";
    public static final String CMD_VIEW_INFORMATION = "INFORMATION";
    public static final String CMD_SAVE_TO_LIB = "CMD_SAVE_TO_LIB";
    public static final String CMD_GET_FROM_LIB = "CMD_GET_FROM_LIB";
    public static final String CMD_DEL_FROM_LIB = "CMD_DEL_FROM_LIB";
    static Border defaultBorder;
    static Border selectBorder;
    static EmptyBorder emptyBorder0;
    static EmptyBorder emptyBorder16;
    static Insets toolBarInsets;
    static Insets toolBarImgButtonInsets;
    static Insets toolBarTextButtonInsets;
    static boolean isJDK_1_3;
    private static int VALIDPERIOD;
    private static String USER_KEY;
    private static String COMPANY;
    private static String USERNAME;
    private static Date LASTMODIFY;
    static int MESSAGE;
    static String USER_DIR;
    static String SAMPLES_DIR;
    static String LIB_DIR;
    static String MapEditorINI;
    static final String HOME_DIR;
    static String[] fileToolBarNames;
    static String[] fileToolBarNames1;
    static String[][] fileMenus;
    static String[][] fileMenus1;
    static String[][] viewMenus;
    static String[][] otherMenus;
    public static MessageCatalog msgCatalog;
    static String NO_NAMING_FILE;
    private JMenuBar menuBar;
    private JPanel toolBar;
    private EmptyPanel emptyPanel = null;
    SchemaEditorPanel schemaEditorPanel = null;
    ScriptEditorPanel scriptEditorPanel = null;
    ScriptDebugerPanel scriptDebugerPanel = null;
    TextEditorPanel scriptEditor = null;
    private WorkSpace workSpaceContents;
    private StatusBar statusBar;
    private JToolBar fileToolBar;
    private JToolBar workSpaceToolBar;
    private JMenu fileMenu;
    private JMenu workSpaceMenu;
    private JMenu messageMenu;
    private JMenu viewMenu;
    private JMenu otherMenu;
    ComboTextFieldEx paraList;
    private int recentFilepos = 0;
    private Hashtable toolButtons;
    private Hashtable menuItems;
    private Hashtable actions;
    private boolean hasStarted = false;
    private boolean isInteralEditor = false;
    private MapDocument mapDocument = null;
    private VersionDialog infoDlg = null;
    String jdbc_driver = null;
    String jdbc_path = null;
    private MessageWindow messageWindow;
    private JSplitPane contentsFondation;
    private JPanel contentsPanel;
    private JPanel scriptPanel;
    private int messageWindowDivider = 0;
    private MappingEditorListener mappingEditorListener = null;
    private File recentFile = null;
    private DropTargetListener mapFileDropListener = null;
    MessageLibraryManager messageLibraryManager = null;

    static ImageIcon loadImage(String name2) {
        return ImageLoader.load(name2 + ".gif", name2);
    }

    public static String getMessage(String msgId) {
        return msgCatalog.getMessage(msgId);
    }

    public static String getMessage(String msgId, String param) {
        return msgCatalog.getMessage(msgId, new Object[]{param});
    }

    private static int getIntegerParameter(Properties properties, String key, int def) {
        String s = properties.getProperty(key, null);
        if (s == null) {
            return def;
        }
        try {
            int k = Integer.parseInt(s);
            if (k > 0) {
                return k;
            }
            return def;
        }
        catch (Exception exception) {
            return def;
        }
    }

    private MappingEditor(boolean isInteralEditor) {
        this.isInteralEditor = isInteralEditor;
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
    }

    public void setMappingEditorListener(MappingEditorListener mappingEditorListener) {
        this.mappingEditorListener = mappingEditorListener;
    }

    void start() {
        if (this.hasStarted) {
            return;
        }
        this.viewWaitCursor(null);
        ImageIcon img = ImageLoader.load("mapIcon.gif", "mapIcon");
        if (img != null) {
            this.setIconImage(img.getImage());
        }
        this.toolButtons = new Hashtable(41);
        this.menuItems = new Hashtable(61);
        this.actions = new Hashtable(61);
        this.registActions();
        JPanel cp = new JPanel();
        cp.setBorder(defaultBorder);
        cp.setLayout(new BorderLayout());
        this.setContentPane(cp);
        this.menuBar = this.createMenuBar();
        this.setJMenuBar(this.menuBar);
        if (isJDK_1_3) {
            this.menuBar.setInputMap(2, null);
        } else {
            KeyStroke[] keys = this.menuBar.getRegisteredKeyStrokes();
            for (int i = 0; i < keys.length; ++i) {
                KeyStroke ks = keys[i];
                if (ks.getKeyCode() != 121 || ks.getModifiers() != 0) continue;
                this.menuBar.unregisterKeyboardAction(ks);
            }
        }
        this.toolBar = new JPanel(new FlowLayout(0));
        this.toolBar.add(new JLabel(MappingEditor.getMessage("LB_WORKSPACE")));
        this.paraList = new ComboTextFieldEx(false){

            @Override
            public boolean valueChanged(Object source, String value) {
                MappingEditor.this.selectWorkSpace(value);
                return true;
            }
        };
        this.paraList.setRenderer(new ListEntryRenderer());
        this.toolBar.add(this.paraList);
        this.fileToolBar = this.isInteralEditor ? this.createToolbar(fileToolBarNames1) : this.createToolbar(fileToolBarNames);
        this.toolBar.add(this.fileToolBar);
        this.workSpaceToolBar = this.createToolbar(new String[0]);
        this.toolBar.add(this.workSpaceToolBar);
        cp.add((Component)this.toolBar, "North");
        this.messageWindow = new MessageWindow(this);
        Document doc = this.messageWindow.getDocument();
        Debug.setPrintWriter(new PrintWriter((Writer)new BufferedWriter(new DocumentWriter(doc)), true));
        Debug.enDebug = true;
        this.loadInitParamenter();
        this.contentsFondation = new JSplitPane(0, false){
            private boolean dividerInitialed;
            {
                this.dividerInitialed = false;
            }

            @Override
            public void setBounds(int x, int y, int w, int h) {
                super.setBounds(x, y, w, h);
                if (!this.dividerInitialed && w > 100 && h > 100) {
                    this.dividerInitialed = true;
                    this.setDividerLocation(0.9);
                }
            }
        };
        this.contentsFondation.setDividerSize(2);
        this.contentsPanel = new JPanel();
        this.contentsPanel.setLayout(new CardLayout());
        this.emptyPanel = new EmptyPanel();
        this.contentsPanel.add((Component)this.emptyPanel, WKS_EMPTY);
        this.workSpaceContents = this.emptyPanel;
        this.contentsFondation.setTopComponent(this.contentsPanel);
        this.messageWindow.setVisible(true);
        this.contentsFondation.setBottomComponent(this.messageWindow);
        cp.add((Component)this.contentsFondation, "Center");
        this.statusBar = new StatusBar();
        this.statusBar.setMinimumSize(new Dimension(100, 20));
        cp.add((Component)this.statusBar, "South");
        this.statusChanged();
        this.scriptEditor = new TextEditorPanel();
        this.setTitle();
        this.viewDefaultCursor(MappingEditor.getMessage("ST_READY"));
        this.hasStarted = true;
        if (this.mappingEditorListener != null) {
            this.mappingEditorListener.started();
        }
        this.mapFileDropListener = new MapFileDropListener();
        DropTarget target1 = new DropTarget(this.emptyPanel, this.mapFileDropListener);
        DropTarget target2 = new DropTarget(this.scriptEditor.getDragComponent(), this.mapFileDropListener);
    }

    @Override
    public void setVisible(boolean b) {
        if (b && !this.hasStarted) {
            this.start();
        }
        super.setVisible(b);
    }

    JComponent getWorkSpaceFondation() {
        return (JComponent)this.getContentPane();
    }

    public void addParameter(String name2, String value) {
        if (this.mapDocument == null) {
            return;
        }
        this.mapDocument.addParameter(name2, value);
    }

    void addNewMessage(String command) {
        String s;
        int k;
        if (this.mapDocument == null) {
            return;
        }
        if (command.startsWith("MENU_ADD_")) {
            command = command.substring(9);
        }
        if ((k = (s = this.paraList.getSelectedItem().toString()).indexOf(" ")) > 0) {
            s = s.substring(0, k);
        }
        try {
            if (MESSAGE == 0 && this.mapDocument.decls.length == 2) {
                MessageException.error("CANT_CONVERT_MSG", new String[0], null);
            }
            this.mapDocument.insertDeclSegment(command, null, s);
        }
        catch (Exception e) {
            Debug.println(e.getMessage());
        }
    }

    void removeMessageFromLibrary() {
        if (this.messageLibraryManager == null) {
            this.messageLibraryManager = new MessageLibraryManager();
        }
        MessageLibraryDialog dlg = new MessageLibraryDialog((Frame)this, "Remove the message from library", this.messageLibraryManager, 2);
        Point p = this.getLocation();
        p.translate((this.getWidth() - dlg.getWidth()) / 2, (this.getHeight() - dlg.getHeight()) / 2);
        dlg.setLocation(p);
        dlg.setVisible(true);
    }

    void addMessageFromLibrary() {
        if (this.mapDocument == null) {
            return;
        }
        if (this.messageLibraryManager == null) {
            this.messageLibraryManager = new MessageLibraryManager();
        }
        MessageLibraryDialog dlg = new MessageLibraryDialog((Frame)this, "Load the message from library", this.messageLibraryManager, 0);
        Point p = this.getLocation();
        p.translate((this.getWidth() - dlg.getWidth()) / 2, (this.getHeight() - dlg.getHeight()) / 2);
        dlg.setLocation(p);
        dlg.setVisible(true);
        if (!dlg.isOk()) {
            return;
        }
        String folder = dlg.getFolder();
        String name2 = dlg.getName();
        try {
            MapDocument.DeclSegment msg = this.messageLibraryManager.getMsgFromLibrary(folder, name2);
            String msgname = this.mapDocument.getNewMsgName(name2);
            msg.setMsgName(msgname);
            String s = this.paraList.getSelectedItem().toString();
            int k = s.indexOf(" ");
            if (k > 0) {
                s = s.substring(0, k);
            }
            if (MESSAGE == 0 && this.mapDocument.decls.length == 2) {
                MessageException.error("CANT_CONVERT_MSG", new String[0], null);
            }
            MessageFactory mf = MessageFactory.getInstance();
            String msgtype = msg.getMsgType();
            if (msgtype == null) {
                MessageException.error("INVALID_MSGTYPE", new String[]{"null"}, null);
            }
            if (!mf.isEnabled(msgtype)) {
                MessageException.error("INVALID_MSGTYPE", new String[]{msgtype}, null);
            }
            this.mapDocument.insertDeclSegment(msg, s);
        }
        catch (Exception e) {
            Debug.println(e.getMessage());
        }
    }

    void saveMessageToLibrary() {
        String name2;
        MapDocument.DeclSegment decl;
        if (this.mapDocument == null) {
            return;
        }
        if (!this.saveWorkSpaceBack()) {
            return;
        }
        String msgnm = this.paraList.getSelectedItem().toString();
        int k = msgnm.indexOf(" ");
        if (k > 0) {
            msgnm = msgnm.substring(0, k);
        }
        if ((decl = this.mapDocument.getDeclSegment(msgnm)) == null) {
            Debug.println("no message!");
            return;
        }
        if (this.messageLibraryManager == null) {
            this.messageLibraryManager = new MessageLibraryManager();
        }
        MessageLibraryDialog dlg = new MessageLibraryDialog((Frame)this, "Save the message to library", this.messageLibraryManager, 1);
        Point p = this.getLocation();
        p.translate((this.getWidth() - dlg.getWidth()) / 2, (this.getHeight() - dlg.getHeight()) / 2);
        dlg.setLocation(p);
        dlg.setVisible(true);
        if (!dlg.isOk()) {
            return;
        }
        String folder = dlg.getFolder();
        MessageLibraryManager.MsgEntry et = this.messageLibraryManager.getMsgEntry(folder, name2 = dlg.getName());
        if (et != null) {
            if (et.isWritable()) {
                String s = MappingEditor.getMessage("QST_LIB_SAVEOVER", folder + "/" + name2);
                int rs = JOptionPane.showConfirmDialog(this, s, MappingEditor.getMessage("DLG_CONFIRM"), 2);
                if (rs != 0) {
                    return;
                }
            } else {
                JOptionPane.showMessageDialog(this, MappingEditor.getMessage("WAR_SLIB_SAVEOVER", folder + "/" + name2));
                return;
            }
        }
        try {
            this.messageLibraryManager.setMsgToLibrary(decl, folder, name2, dlg.getComment());
        }
        catch (IOException e) {
            Debug.println(e.getMessage());
        }
    }

    void removeCurrentMessage() {
        String s = this.paraList.getSelectedItem().toString();
        int k = s.indexOf(" ");
        if (k > 0) {
            s = s.substring(0, k);
        }
        if (this.mapDocument.getDeclSegment(s) == null) {
            return;
        }
        int rs = JOptionPane.showConfirmDialog(this, MappingEditor.getMessage("QST_DEL_MSG", s), MappingEditor.getMessage("DLG_CONFIRM"), 0);
        if (rs != 0) {
            return;
        }
        this.mapDocument.removeDeclSegment(s);
        this.paraList.setEnabledEvent(false);
        int index = this.getSelectWorkSpace(s);
        if (index >= 0) {
            this.paraList.removeItemAt(index);
        }
        if (this.schemaEditorPanel != null) {
            this.contentsPanel.remove(this.schemaEditorPanel);
        }
        this.schemaEditorPanel = new SchemaEditorPanel(this.mapFileDropListener){

            @Override
            void clearMessage() {
                MappingEditor.this.messageWindow.clear();
            }

            @Override
            void printMessage(String msg) {
                MappingEditor.this.messageWindow.println(msg);
            }
        };
        this.schemaEditorPanel.addStatusChangedListener(new StatusChangedListener(){

            @Override
            public void statusChanged(int id2, EventObject e) {
                MappingEditor.this.workSpaceStateChanged();
            }
        });
        try {
            this.schemaEditorPanel.load(this.mapDocument);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.contentsPanel.add((Component)this.schemaEditorPanel, WKS_MSGDECL);
        this.selectWorkSpace(WKS_SCRIPT);
    }

    JMenuBar createMenuBar() {
        JMenuItem menuItem;
        JMenuBar menuBar = new JMenuBar();
        Font font1 = menuBar.getFont();
        Font font = new Font(font1.getName(), 0, 12);
        menuBar.setAlignmentX(0.0f);
        menuBar.setAlignmentY(0.0f);
        String s = MappingEditor.getMessage("MENU_FILE");
        if (s.indexOf("F") < 0) {
            s = s + "(F)";
        }
        this.fileMenu = this.isInteralEditor ? this.createMenu(s, fileMenus1) : this.createMenu(s, fileMenus);
        this.fileMenu.setMnemonic('F');
        this.fileMenu.setRequestFocusEnabled(false);
        menuBar.add(this.fileMenu);
        this.recentFilepos = this.fileMenu.getItemCount() - 2;
        this.fileMenu.addMenuListener(this);
        s = MappingEditor.getMessage("MENU_EDIT");
        if (s.indexOf("E") < 0) {
            s = s + "(E)";
        }
        this.workSpaceMenu = new JMenu(s);
        this.workSpaceMenu.setMnemonic('E');
        this.workSpaceMenu.setFont(font);
        s = MappingEditor.getMessage("MENU_MESSAGE");
        if (s.indexOf("M") < 0) {
            s = s + "(M)";
        }
        this.messageMenu = new JMenu(s);
        this.messageMenu.setMnemonic('M');
        this.messageMenu.setFont(font);
        menuBar.add(this.messageMenu);
        MessageFactory f = MessageFactory.getInstance();
        Object[] ss = f.getEnabledMessageTypes();
        Arrays.sort(ss);
        ActionListener addListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Component c = (Component)e.getSource();
                MappingEditor.this.addNewMessage(c.getName());
            }
        };
        for (int i = 0; i < ss.length; ++i) {
            String name2 = "MENU_ADD_" + (String)ss[i];
            String des = MappingEditor.getMessage(name2);
            if (des == name2) {
                des = (String)ss[i] + MappingEditor.getMessage("MENU_ADD");
            }
            menuItem = new JMenuItem(des);
            this.messageMenu.add(menuItem);
            menuItem.setFont(font);
            menuItem.setName(name2);
            menuItem.addActionListener(addListener);
        }
        this.messageMenu.addSeparator();
        String name3 = CMD_MSG_DEL;
        s = MappingEditor.getMessage(name3);
        if (s.indexOf("D") < 0) {
            s = s + "(D)";
        }
        menuItem = new JMenuItem(s);
        menuItem.setMnemonic('D');
        this.messageMenu.add(menuItem);
        menuItem.setFont(font);
        menuItem.setName(name3);
        ImageIcon icon = ImageLoader.load("delete.gif", "delete");
        if (icon != null) {
            menuItem.setIcon(icon);
            menuItem.setHorizontalTextPosition(4);
        }
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MappingEditor.this.removeCurrentMessage();
            }
        });
        this.messageMenu.addMenuListener(this);
        s = MappingEditor.getMessage("MENU_VIEW");
        if (s.indexOf("V") < 0) {
            s = s + "(V)";
        }
        this.viewMenu = this.createMenu(s, viewMenus);
        this.viewMenu.setMnemonic('V');
        menuBar.add(this.viewMenu);
        this.viewMenu.addMenuListener(this);
        s = MappingEditor.getMessage("MENU_OTHER");
        if (s.indexOf("O") < 0) {
            s = s + "(O)";
        }
        this.otherMenu = this.createMenu(s, otherMenus);
        this.otherMenu.setMnemonic('O');
        menuBar.add(this.otherMenu);
        menuBar.setRequestFocusEnabled(false);
        return menuBar;
    }

    @Override
    public void menuSelected(MenuEvent e) {
        Object obj = e.getSource();
        boolean b = this.hasContents();
        if (obj == this.fileMenu) {
            this.setMenuItemEnabled(CMD_SAVE_FILE, b);
            this.setMenuItemEnabled(CMD_SAVEAS_FILE, b);
        } else if (obj == this.messageMenu) {
            int n = this.messageMenu.getMenuComponentCount();
            for (int i = 0; i < n; ++i) {
                Component c = this.messageMenu.getMenuComponent(i);
                String name2 = c.getName();
                if (CMD_MSG_DEL.equals(name2) || CMD_SAVE_TO_LIB.equals(name2)) {
                    c.setEnabled(this.workSpaceContents == this.schemaEditorPanel);
                    continue;
                }
                c.setEnabled(b);
            }
        }
    }

    @Override
    public void menuDeselected(MenuEvent e) {
    }

    @Override
    public void menuCanceled(MenuEvent e) {
    }

    void statusChanged() {
        boolean b = this.hasContents();
        this.setToolButtonEnabled(CMD_SAVE_FILE, b);
    }

    void setStatusText(String text) {
        this.statusBar.setStatusText(text);
    }

    void changeWorkSpaceMenu() {
        JMenu menu = this.workSpaceContents.getMenu();
        if (menu != null && this.workSpaceMenu != menu) {
            if (this.workSpaceMenu != null) {
                this.menuBar.remove(this.workSpaceMenu);
            }
            this.workSpaceMenu = menu;
            this.menuBar.add((Component)this.workSpaceMenu, 1);
            this.menuBar.invalidate();
            this.menuBar.repaint();
        }
    }

    void changeWorkSpaceToolBar() {
        JToolBar tb = this.workSpaceContents.getToolBar();
        if (tb != null && this.workSpaceToolBar != tb) {
            if (this.workSpaceToolBar != null) {
                this.workSpaceToolBar.setVisible(false);
                this.toolBar.remove(this.workSpaceToolBar);
            }
            this.workSpaceToolBar = null;
            this.workSpaceToolBar = tb;
            this.workSpaceToolBar.setVisible(true);
            this.toolBar.add(this.workSpaceToolBar);
            this.toolBar.invalidate();
            this.toolBar.repaint();
        }
    }

    private void setToolButtonEnabled(String name2, boolean b) {
        JButton bt = (JButton)this.toolButtons.get(name2);
        if (bt != null && bt.isEnabled() != b) {
            bt.setEnabled(b);
        }
    }

    private void setMenuItemEnabled(String name2, boolean b) {
        JMenuItem item = (JMenuItem)this.menuItems.get(name2);
        if (item != null && item.isEnabled() != b) {
            item.setEnabled(b);
        }
    }

    private void switchWorkSpace(WorkSpace ws) {
        if (this.workSpaceContents != ws) {
            this.workSpaceContents = ws;
            LayoutManager layout = this.contentsPanel.getLayout();
            if (layout instanceof CardLayout) {
                CardLayout cardLayout = (CardLayout)layout;
                if (ws == this.emptyPanel) {
                    cardLayout.show(this.contentsPanel, WKS_EMPTY);
                } else if (ws == this.schemaEditorPanel) {
                    cardLayout.show(this.contentsPanel, WKS_MSGDECL);
                } else if (ws == this.scriptEditorPanel || ws == this.scriptDebugerPanel) {
                    LayoutManager layout2;
                    cardLayout.show(this.contentsPanel, WKS_SCRIPT);
                    if (this.scriptPanel != null && (layout2 = this.scriptPanel.getLayout()) instanceof CardLayout) {
                        CardLayout cardLayout2 = (CardLayout)layout2;
                        if (ws == this.scriptEditorPanel) {
                            cardLayout2.show(this.scriptPanel, WKS_SCRIPT);
                        } else if (ws == this.scriptDebugerPanel) {
                            cardLayout2.show(this.scriptPanel, WKS_DEBUGER);
                        }
                    }
                }
            }
        }
        this.workSpaceStateChanged();
        this.repaint();
        this.show();
    }

    private void workSpaceStateChanged() {
        this.changeWorkSpaceMenu();
        this.changeWorkSpaceToolBar();
    }

    public void newFile() {
        if (!this.closeFile()) {
            return;
        }
        this.closedFile();
        MapDocument map = MapDocument.createDocument();
        map.setFileName(NO_NAMING_FILE);
        try {
            this.loadMapDocument(map);
            this.loadMapFileSucceed(null);
        }
        catch (SAXException e) {
            this.switchWorkSpace(this.emptyPanel);
            this.viewDefaultCursor(e.getMessage());
        }
        if (this.mappingEditorListener != null) {
            this.mappingEditorListener.fileCreated();
        }
    }

    void openFile() {
        File file;
        if (!this.closeFile()) {
            return;
        }
        FileFilterEx filter = new FileFilterEx(new String[]{"map"}, "Mapping Files");
        String filename = null;
        if (this.mapDocument != null) {
            filename = this.mapDocument.getFileName();
        }
        if ((file = this.getOpenFileNameJ(filter, filename)) != null) {
            if (!file.isFile() || !file.exists()) {
                JOptionPane.showMessageDialog(this, MappingEditor.getMessage("INVALID_FILE"));
                return;
            }
            try {
                this.closedFile();
                URL url = file.toURL();
                this.loadMapFile(url);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public boolean saveFile(File file) {
        FileWriter wr = null;
        try {
            wr = new FileWriter(file);
            this.mapDocument.save(wr);
            wr.close();
            this.mapDocument.setFileName(file.toURL().toString());
            this.setTitle();
            if (this.mappingEditorListener != null) {
                this.mappingEditorListener.fileSaved(file.getAbsolutePath());
            }
            return true;
        }
        catch (IOException e) {
            if (wr != null) {
                try {
                    wr.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return false;
        }
    }

    boolean saveWorkSpaceBack() {
        WorkSpace ws = this.workSpaceContents;
        try {
            ws.saveBack();
        }
        catch (SAXParseException e) {
            String s = e.getSystemId() + "<" + e.getLineNumber() + "," + e.getColumnNumber() + "> " + e.getMessage() + "\n" + MappingEditor.getMessage("QST_NOSAVE");
            int rs = JOptionPane.showConfirmDialog(this, s, MappingEditor.getMessage("DLG_CONFIRM"), 1);
            if (rs != 0) {
                return false;
            }
            ws.clearChanged();
        }
        catch (SAXException e) {
            String s = e.getMessage() + "\n" + MappingEditor.getMessage("QST_NOSAVE");
            int rs = JOptionPane.showConfirmDialog(this, s, MappingEditor.getMessage("DLG_CONFIRM"), 1);
            if (rs != 0) {
                return false;
            }
            ws.clearChanged();
        }
        return true;
    }

    boolean saveFile() {
        if (this.mapDocument == null) {
            return false;
        }
        String filename = this.mapDocument.getFileName();
        FileEx file = null;
        if (filename.equals(NO_NAMING_FILE)) {
            return this.saveFileAs();
        }
        try {
            file = new FileEx(filename);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (file != null && file.isFile()) {
            if (!this.saveWorkSpaceBack()) {
                return false;
            }
            return this.saveFile(file);
        }
        return this.saveFileAs();
    }

    boolean saveFileAs() {
        int rs;
        if (this.mapDocument == null) {
            return false;
        }
        if (!this.saveWorkSpaceBack()) {
            return false;
        }
        FileFilterEx filter = new FileFilterEx(new String[]{"map"}, "Mapping Files");
        File file = this.getSaveFileNameJ(filter, this.mapDocument.getFileName());
        if (file == null) {
            return false;
        }
        String s = file.getPath();
        if (s.indexOf(".") < 0) {
            file = new File(s + ".map");
        }
        if (file.isDirectory()) {
            JOptionPane.showMessageDialog(this, MappingEditor.getMessage("INVALID_FILE", file.getPath()));
            return false;
        }
        if (file.exists() && (rs = JOptionPane.showConfirmDialog(this, s = MappingEditor.getMessage("QST_SAVEOVER", file.getPath()), MappingEditor.getMessage("DLG_CONFIRM"), 0)) == 1) {
            return false;
        }
        if (this.saveFile(file)) {
            String filename = this.mapDocument.getFileName();
            if (!this.isInteralEditor) {
                this.addRecentFile(filename, true);
            }
            this.viewDefaultCursor(MappingEditor.getMessage("ST_EDITING", filename));
            return true;
        }
        return false;
    }

    boolean closeFile() {
        if (this.mapDocument == null) {
            return true;
        }
        if (!this.saveWorkSpaceBack()) {
            return false;
        }
        if (this.mapDocument.isDirty()) {
            int rs = JOptionPane.showConfirmDialog(this, MappingEditor.getMessage("QST_SAVE", this.mapDocument.getFileName()), MappingEditor.getMessage("DLG_CONFIRM"), 1);
            if (rs == 2) {
                return false;
            }
            if (rs == 0 && !this.saveFile()) {
                return false;
            }
        }
        return true;
    }

    private void closedFile() {
        if (this.scriptDebugerPanel != null) {
            this.scriptDebugerPanel.close();
        }
        if (this.scriptEditorPanel != null) {
            this.scriptEditorPanel.close();
        }
        if (this.mappingEditorListener != null && this.mapDocument != null) {
            String filename = this.mapDocument.getFileName();
            this.mappingEditorListener.fileClosed(filename);
        }
    }

    public void loadMapFile(String address) {
        URL url;
        block4: {
            url = null;
            try {
                url = new URL(address);
            }
            catch (MalformedURLException e) {
                File file = new File(address);
                if (!file.exists()) break block4;
                try {
                    url = file.toURL();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        this.loadMapFile(url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadMapFile(URL url) {
        String dialogMsg;
        XReader reader;
        block17: {
            this.messageWindow.clear();
            reader = null;
            dialogMsg = null;
            if (url != null) {
                try {
                    InputStream is = url.openStream();
                    reader = XReader.createReader(new InputStreamReader(is, "JISAutoDetect"));
                    reader.setSystemId(url.toString());
                }
                catch (IOException e1) {
                    reader = null;
                    dialogMsg = MappingEditor.getMessage("INVALID_URL", url.toString());
                    String errMsg = e1.getMessage();
                    if (errMsg == null) break block17;
                    dialogMsg = dialogMsg + "\n" + errMsg;
                }
            }
        }
        if (reader == null) {
            this.mapDocument = null;
            String dialogMsg1 = dialogMsg;
            this.loadMapFileFailed(url, dialogMsg1, null);
            return;
        }
        reader.setEnableAbandon(false);
        try {
            MapDocument map = MapDocument.openDocument(reader);
            map.setFileName(url.toString());
            this.certificateMapDocument(map);
            this.loadMapDocument(map);
            this.loadMapFileSucceed(url);
            if (this.mappingEditorListener != null) {
                this.mappingEditorListener.fileOpen(url.toString());
            }
        }
        catch (SAXException e) {
            this.loadMapFileFailed(url, null, e);
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    private void loadMapFileFailed(URL url, String dialogMsg, SAXException e) {
        this.getToolkit().beep();
        this.mapDocument = null;
        this.paraList.setEnabledEvent(false);
        this.paraList.removeAllItems();
        this.paraList.setEnabledEvent(true);
        if (dialogMsg != null) {
            JOptionPane.showMessageDialog(this, dialogMsg, MappingEditor.getMessage("DLG_ERR"), 0);
        }
        this.switchWorkSpace(this.emptyPanel);
        this.setTitle();
        this.show();
        if (e != null) {
            int lineNum = 0;
            int colNum = 0;
            if (e instanceof SAXParseException) {
                SAXParseException spe = (SAXParseException)e;
                lineNum = spe.getLineNumber();
                colNum = spe.getColumnNumber();
            }
            StringBuffer sb = new StringBuffer();
            sb.append(url.toString());
            sb.append(' ');
            if (lineNum > 0 || colNum > 0) {
                sb.append('<');
                sb.append(lineNum);
                sb.append(',');
                sb.append(colNum);
                sb.append('>');
            }
            sb.append(e.getMessage());
            this.messageWindow.println(sb.toString());
        }
        this.viewDefaultCursor(MappingEditor.getMessage("ST_CANT_LODE", url.toString()));
        this.statusChanged();
    }

    private void loadMapFileSucceed(URL url) {
        MapDocument.DeclSegment[] decls = this.mapDocument.getDeclSegments();
        Document scriptDocument = this.mapDocument.getScriptDocument();
        this.paraList.setEnabledEvent(false);
        this.paraList.removeAllItems();
        this.paraList.addItem(WKS_MSGDECL);
        for (int i = 0; i < decls.length; ++i) {
            MapDocument.DeclSegment msg = decls[i];
            String msgName = msg.getMsgName() + "  -- " + msg.getMsgType();
            this.paraList.addItem(msgName);
        }
        this.scriptEditor.clearAllMark();
        this.scriptEditor.setDocument(scriptDocument);
        this.contentsPanel.removeAll();
        this.contentsPanel.add((Component)this.emptyPanel, WKS_EMPTY);
        this.contentsPanel.add((Component)this.schemaEditorPanel, WKS_MSGDECL);
        JSplitPane split = new JSplitPane(0, false){
            private boolean dividerInitialed;
            {
                this.dividerInitialed = false;
            }

            @Override
            public void setBounds(int x, int y, int w, int h) {
                super.setBounds(x, y, w, h);
                if (!this.dividerInitialed && w > 100 && h > 100) {
                    this.dividerInitialed = true;
                    this.setDividerLocation(0.5);
                }
            }
        };
        split.setDividerSize(2);
        this.scriptPanel = new JPanel();
        this.scriptPanel.setLayout(new CardLayout());
        this.scriptPanel.add((Component)this.scriptEditorPanel, WKS_SCRIPT);
        this.scriptPanel.add((Component)this.scriptDebugerPanel, WKS_DEBUGER);
        split.setTopComponent(this.scriptPanel);
        split.setBottomComponent(this.scriptEditor);
        this.contentsPanel.add((Component)split, WKS_SCRIPT);
        this.scriptEditor.requestFocus();
        this.paraList.addItem(WKS_SCRIPT);
        this.paraList.addItem(WKS_DEBUGER);
        this.paraList.setEnabledEvent(true);
        int num = this.paraList.getItemCount();
        int selectItem = num - 2;
        if (selectItem == this.paraList.getSelectedIndex()) {
            this.selectWorkSpace((String)this.paraList.getSelectedItem());
        } else {
            this.paraList.setSelectedIndex(selectItem);
        }
        this.setTitle();
        if (url != null) {
            this.viewDefaultCursor(MappingEditor.getMessage("ST_EDITING", url.toString()));
        } else {
            this.viewDefaultCursor("");
        }
        this.statusChanged();
        if (!this.isInteralEditor) {
            this.addRecentFile(url, true);
        }
    }

    synchronized void loadMapDocument(MapDocument mapDocument) throws SAXException {
        if (this.mapDocument != null) {
            this.mapDocument.removeAllMapDocumentListener();
        }
        this.mapDocument = mapDocument;
        mapDocument.addMapDocumentListener(this);
        if (this.scriptDebugerPanel != null) {
            this.scriptDebugerPanel.close();
        }
        if (this.scriptEditorPanel != null) {
            this.scriptEditorPanel.close();
        }
        this.schemaEditorPanel = new SchemaEditorPanel(this.mapFileDropListener){

            @Override
            void clearMessage() {
                MappingEditor.this.messageWindow.clear();
            }

            @Override
            void printMessage(String msg) {
                MappingEditor.this.messageWindow.println(msg);
            }
        };
        this.schemaEditorPanel.addStatusChangedListener(new StatusChangedListener(){

            @Override
            public void statusChanged(int id2, EventObject e) {
                MappingEditor.this.workSpaceStateChanged();
            }
        });
        this.schemaEditorPanel.load(this.mapDocument);
        this.scriptEditorPanel = new ScriptEditorPanel(this.scriptEditor, this.mapFileDropListener){

            @Override
            void cmd_compile() {
                try {
                    MappingEditor.this.scriptDebugerPanel.closeDebugEngine();
                    MappingEditor.this.scriptDebugerPanel.review();
                }
                catch (ScriptException e) {
                    this.getToolkit().beep();
                    MappingEditor.this.messageWindow.println("<" + e.getLineNumber() + "," + e.getColumnNumber() + ">" + e.getMessage());
                    MappingEditor.this.messageWindow.println(MappingException.getMessage("CP_FAULT"));
                }
                catch (SAXParseException e) {
                    this.getToolkit().beep();
                    MappingEditor.this.messageWindow.println(e.getPublicId() + "<" + e.getLineNumber() + "," + e.getColumnNumber() + ">" + e.getMessage());
                    MappingEditor.this.messageWindow.println(MappingException.getMessage("CP_FAULT"));
                }
                catch (SAXException e2) {
                    this.getToolkit().beep();
                    MappingEditor.this.messageWindow.println(e2.getMessage());
                }
                MappingEditor.this.scriptDebugerPanel.closeDebugEngine();
            }

            @Override
            void cmd_run() {
                if (MappingEditor.this.selectWorkSpace(WKS_DEBUGER)) {
                    MappingEditor.this.scriptDebugerPanel.cmd_run();
                }
            }
        };
        this.scriptEditorPanel.load(this.mapDocument);
        this.scriptEditorPanel.resetDivider(this.emptyPanel.getSize());
        this.scriptDebugerPanel = new ScriptDebugerPanel(this.scriptEditor, this.mapFileDropListener){

            @Override
            void cmd_exit() {
                super.cmd_exit();
                MappingEditor.this.selectWorkSpace(WKS_SCRIPT);
            }

            @Override
            void setStatusText(String text) {
                MappingEditor.this.setStatusText(text);
            }

            @Override
            void clearMessage() {
                MappingEditor.this.messageWindow.clear();
            }

            @Override
            void printMessage(String msg) {
                MappingEditor.this.messageWindow.println(msg);
            }
        };
        this.scriptDebugerPanel.load(this.mapDocument);
    }

    int setSelectWorkSpace(String wsname) {
        int n = this.paraList.getItemCount();
        for (int i = 0; i < n; ++i) {
            String s = this.paraList.getItemAt(i).toString();
            int k = s.indexOf(" ");
            if (k > 0) {
                s = s.substring(0, k);
            }
            if (!s.equals(wsname)) continue;
            if (this.paraList.getSelectedIndex() != i) {
                this.paraList.setEnabledEvent(false);
                this.paraList.setSelectedIndex(i);
                this.paraList.setEnabledEvent(true);
            }
            return i;
        }
        return -1;
    }

    int getSelectWorkSpace(String wsname) {
        int n = this.paraList.getItemCount();
        for (int i = 0; i < n; ++i) {
            String s = this.paraList.getItemAt(i).toString();
            int k = s.indexOf(" ");
            if (k > 0) {
                s = s.substring(0, k);
            }
            if (!s.equals(wsname)) continue;
            return i;
        }
        return -1;
    }

    WorkSpace getWorkSpace() {
        return this.workSpaceContents;
    }

    boolean selectWorkSpace(String wsname) {
        WorkSpace oldws = this.workSpaceContents;
        String oldname = oldws.getWorkSpaceName();
        if (wsname.equals(WKS_MSGDECL)) {
            this.setSelectWorkSpace(oldname);
            return false;
        }
        try {
            oldws.saveBack();
        }
        catch (ScriptException e) {
            this.getToolkit().beep();
            Debug.println(e.getMessage());
            int k = this.getSelectWorkSpace(WKS_SCRIPT);
            this.paraList.setSelectedIndex(k);
            this.scriptEditor.requestFocus();
            this.scriptEditor.selectLine(e.getLineNumber());
            return false;
        }
        catch (MessageException e1) {
            this.getToolkit().beep();
            wsname = e1.getSystemId();
            Debug.println(e1.getPublicId() + "<" + e1.getLineNumber() + "," + e1.getColumnNumber() + ">" + e1.getMessage());
            int k = this.getSelectWorkSpace(wsname);
            if (k < 0) {
                k = 0;
            }
            this.paraList.setSelectedIndex(k);
            return false;
        }
        catch (SAXException e) {
            this.getToolkit().beep();
            Debug.println(e.getMessage());
            this.setSelectWorkSpace(oldname);
            return false;
        }
        if (wsname.equals(WKS_SCRIPT)) {
            if (this.scriptDebugerPanel != null) {
                this.scriptDebugerPanel.removeScriptEditor();
            }
            this.scriptEditorPanel.pleaceScriptEditor();
            this.switchWorkSpace(this.scriptEditorPanel);
            this.scriptEditor.setTabSize(4);
            try {
                this.scriptEditorPanel.review();
            }
            catch (MessageException e) {
                wsname = e.getSystemId();
                Debug.println("<" + e.getLineNumber() + "," + e.getColumnNumber() + ">" + e.getMessage());
                int k = this.getSelectWorkSpace(wsname);
                if (k < 0) {
                    k = 0;
                }
                this.paraList.setSelectedIndex(k);
                return false;
            }
        }
        if (wsname.equals(WKS_DEBUGER)) {
            if (this.scriptEditorPanel != null) {
                this.scriptEditorPanel.removeScriptEditor();
            }
            this.scriptDebugerPanel.pleaceScriptEditor();
            this.switchWorkSpace(this.scriptDebugerPanel);
            try {
                this.scriptDebugerPanel.review();
            }
            catch (ScriptException e) {
                this.getToolkit().beep();
                Debug.println("<" + e.getLineNumber() + "," + e.getColumnNumber() + ">" + e.getMessage());
                int k = this.getSelectWorkSpace(WKS_SCRIPT);
                if (k != this.paraList.getSelectedIndex()) {
                    this.paraList.setSelectedIndex(k);
                } else {
                    this.selectWorkSpace(WKS_SCRIPT);
                }
                this.messageWindow.println(MappingException.getMessage("CP_FAULT"));
                return false;
            }
            catch (MessageException e1) {
                this.getToolkit().beep();
                wsname = e1.getSystemId();
                Debug.println(e1.getPublicId() + "<" + e1.getLineNumber() + "," + e1.getColumnNumber() + ">" + e1.getMessage());
                if (this.mapDocument.getDeclSegment(wsname) != null) {
                    int k = this.getSelectWorkSpace(wsname);
                    if (k < 0) {
                        k = 0;
                    }
                    if (k != this.paraList.getSelectedIndex()) {
                        this.paraList.setSelectedIndex(k);
                    } else {
                        this.selectWorkSpace(wsname);
                    }
                } else {
                    int k = this.getSelectWorkSpace(WKS_SCRIPT);
                    if (k < 0) {
                        k = 0;
                    }
                    if (k != this.paraList.getSelectedIndex()) {
                        this.paraList.setSelectedIndex(k);
                    } else {
                        this.selectWorkSpace(WKS_SCRIPT);
                    }
                }
                return false;
            }
            catch (SAXException e2) {
                this.getToolkit().beep();
                Debug.println(e2.getMessage());
                int k = this.getSelectWorkSpace(WKS_SCRIPT);
                this.paraList.setSelectedIndex(k);
                return false;
            }
        }
        int k = wsname.indexOf(" ");
        if (k > 0) {
            wsname = wsname.substring(0, k);
        }
        if (this.mapDocument.getDeclSegment(wsname) == null) {
            return false;
        }
        if (wsname.equals(this.schemaEditorPanel.getMsgName())) {
            this.switchWorkSpace(this.schemaEditorPanel);
            return true;
        }
        this.schemaEditorPanel.msgName = wsname;
        this.messageWindow.clear();
        try {
            this.schemaEditorPanel.review();
        }
        catch (MessageException e1) {
            this.getToolkit().beep();
            Debug.println(e1.getPublicId() + "<" + e1.getLineNumber() + "," + e1.getColumnNumber() + ">" + e1.getMessage());
        }
        this.switchWorkSpace(this.schemaEditorPanel);
        this.setSelectWorkSpace(wsname);
        return true;
    }

    private void viewMessageWindow() {
        JMenuItem viewMessageWindow = (JMenuItem)this.menuItems.get(CMD_VIEW_MSG);
        if (viewMessageWindow.isSelected()) {
            this.messageWindow.setVisible(true);
            this.contentsFondation.setBottomComponent(this.messageWindow);
            if (this.messageWindowDivider < 20) {
                this.messageWindowDivider = 20;
            }
            this.contentsFondation.setDividerLocation(this.messageWindowDivider);
        } else {
            this.messageWindow.setVisible(false);
            this.messageWindowDivider = this.contentsFondation.getDividerLocation();
            this.contentsFondation.remove(this.messageWindow);
        }
        this.statusChanged();
    }

    private void viewToolBar() {
        JMenuItem viewToolBarItem = (JMenuItem)this.menuItems.get(CMD_VIEW_TOOLBAR);
        if (viewToolBarItem.isSelected()) {
            this.getContentPane().add((Component)this.toolBar, "North");
        } else {
            this.getContentPane().remove(this.toolBar);
        }
        this.getContentPane().invalidate();
        this.getContentPane().repaint();
        this.statusChanged();
        this.show();
    }

    private void viewStatusBar() {
        JMenuItem viewStatusBarItem = (JMenuItem)this.menuItems.get(CMD_VIEW_STATUSBAR);
        if (viewStatusBarItem.isSelected()) {
            this.getContentPane().add((Component)this.statusBar, "South");
        } else {
            this.getContentPane().remove(this.statusBar);
        }
        this.getContentPane().invalidate();
        this.getContentPane().repaint();
        this.statusChanged();
        this.show();
    }

    private void viewSetDailog() {
        ConfigDialog win = new ConfigDialog(this);
        win.setJdbcDriver(this.jdbc_driver);
        if (this.mapDocument != null) {
            win.setDescription(this.mapDocument.getDescription());
            win.setParameters(this.mapDocument.getParameters());
        } else {
            win.setDescriptionEditable(false);
            win.setParametersEditable(false);
        }
        win.setVisible(true);
        if (win.isOK) {
            String s = win.getJdbcDriver();
            if (!this.jdbc_driver.equals(s)) {
                this.jdbc_driver = s;
                this.installJdbcDriver();
            }
            if (this.mapDocument != null) {
                this.mapDocument.setDescription(win.getDescription());
                this.mapDocument.setParameters(win.getParameters());
            }
        }
    }

    void viewInformation() {
        int y;
        int x;
        if (this.infoDlg == null) {
            this.infoDlg = new VersionDialog(this, true);
        }
        Dimension dlgsize = this.infoDlg.getSize();
        if (this.contentsPanel != null) {
            Point p = this.contentsPanel.getLocationOnScreen();
            x = p.x + (this.contentsPanel.getWidth() - dlgsize.width) / 2;
            y = p.y + (this.contentsPanel.getHeight() - dlgsize.height) / 2;
        } else {
            Rectangle rect = this.getBounds();
            x = rect.x + (rect.width - dlgsize.width) / 2;
            y = rect.y + (rect.height - dlgsize.height) / 2;
        }
        this.infoDlg.setLocation(x, y);
        this.infoDlg.setVisible(true);
    }

    private void openRecentFile(ActionEvent e) {
        JMenuItem item = (JMenuItem)e.getSource();
        String text = item.getText();
        if (text == null) {
            return;
        }
        if (this.mapDocument != null && text.equalsIgnoreCase(this.mapDocument.getFileName())) {
            return;
        }
        URL url = null;
        try {
            url = new URL(text);
        }
        catch (MalformedURLException e1) {
            try {
                File file = new File(text);
                url = file.toURL();
            }
            catch (Exception file) {
                // empty catch block
            }
        }
        if (!this.closeFile()) {
            return;
        }
        try {
            this.closedFile();
            this.loadMapFile(url);
        }
        catch (Exception e1) {
            String message = e1.getMessage();
            if (message != null) {
                JOptionPane.showMessageDialog(this, MappingEditor.getMessage("INVALID_URL", text) + "\n" + message);
            } else {
                JOptionPane.showMessageDialog(this, MappingEditor.getMessage("INVALID_URL", text));
            }
            this.fileMenu.remove(item);
        }
    }

    File getOpenFileNameJ(FileFilter filter, String filename) {
        File file3;
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setMultiSelectionEnabled(false);
        fileChooser.setDialogTitle(MappingEditor.getMessage("DLG_OPEN"));
        fileChooser.addChoosableFileFilter(filter);
        fileChooser.setFileFilter(filter);
        fileChooser.setPreferredSize(new Dimension(500, 260));
        if (filename != null && !NO_NAMING_FILE.equals(filename)) {
            try {
                file3 = new FileEx(filename);
                fileChooser.setCurrentDirectory(file3);
                if (file3.isFile()) {
                    fileChooser.setSelectedFile(file3);
                }
            }
            catch (Exception file2) {}
        } else {
            try {
                file3 = new File(SAMPLES_DIR);
                fileChooser.setCurrentDirectory(file3);
            }
            catch (Exception file3) {
                // empty catch block
            }
        }
        int result = fileChooser.showOpenDialog(this);
        if (result != 0) {
            return null;
        }
        File file4 = fileChooser.getSelectedFile();
        if (!file4.exists()) {
            return null;
        }
        return file4;
    }

    File getSaveFileNameJ(FileFilter filter, String filename) {
        File file2;
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setMultiSelectionEnabled(false);
        fileChooser.setDialogTitle(MappingEditor.getMessage("DLG_SAVE"));
        fileChooser.addChoosableFileFilter(filter);
        fileChooser.setFileFilter(filter);
        fileChooser.setPreferredSize(new Dimension(500, 260));
        if (filename != null && !NO_NAMING_FILE.equals(filename)) {
            try {
                file2 = new FileEx(filename);
                fileChooser.setCurrentDirectory(file2);
                fileChooser.setSelectedFile(file2);
            }
            catch (Exception file2) {}
        } else if (NO_NAMING_FILE.equals(filename) && this.recentFile != null) {
            fileChooser.setSelectedFile(this.recentFile);
        } else {
            try {
                file2 = new File(SAMPLES_DIR);
                fileChooser.setCurrentDirectory(file2);
            }
            catch (Exception file3) {
                // empty catch block
            }
        }
        int result = fileChooser.showSaveDialog(this);
        if (result != 0) {
            return null;
        }
        File file4 = fileChooser.getSelectedFile();
        if (file4 != null) {
            this.recentFile = file4;
        }
        return file4;
    }

    void addRecentFile(String name2, boolean removeSame) {
        URL url = null;
        try {
            url = new URL(name2);
        }
        catch (MalformedURLException e) {
            try {
                File file = new File(name2);
                url = file.toURL();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.addRecentFile(url, removeSame);
    }

    void addRecentFile(URL url, boolean removeSame) {
        if (url == null) {
            return;
        }
        if (removeSame) {
            this.removeRecentFile(url);
        }
        JMenuItem item = new JMenuItem(url.toString());
        this.fileMenu.insert(item, this.recentFilepos);
        Font font = new Font(this.fileMenu.getFont().getName(), 0, 12);
        item.setFont(font);
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MappingEditor.this.openRecentFile(e);
            }
        });
    }

    private void removeRecentFile(URL url) {
        File f1 = null;
        String fileName = FileEx.urlToFile(url);
        if (fileName != null) {
            f1 = new File(fileName);
        }
        int n = this.fileMenu.getMenuComponentCount();
        for (int i = this.recentFilepos; i < n; ++i) {
            String s;
            Component c = this.fileMenu.getMenuComponent(i);
            if (!(c instanceof JMenuItem) || (s = ((JMenuItem)c).getText()) == null) continue;
            if (f1 != null) {
                FileEx f2 = null;
                try {
                    f2 = new FileEx(s);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (!f1.equals(f2)) continue;
                this.fileMenu.remove(c);
                break;
            }
            if (!s.equals(url.toString())) continue;
            this.fileMenu.remove(c);
            break;
        }
    }

    private void setTitle() {
        if (this.mapDocument == null) {
            this.setTitle(TITLE_STRING);
        } else {
            this.setTitle(TITLE_STRING + " -- " + this.mapDocument.getFileName());
        }
    }

    private void clearChanged() {
        this.workSpaceContents.clearChanged();
    }

    JMenu createMenu(String menuName, String[][] items) {
        JMenu menu = new JMenu(menuName);
        Font font1 = menu.getFont();
        Font font = new Font(font1.getName(), 0, 12);
        menu.setFont(font);
        for (int i = 0; i < items.length; ++i) {
            String itemname = items[i][0];
            if (itemname.equals("-")) {
                menu.addSeparator();
                continue;
            }
            Action act = (Action)this.actions.get(itemname);
            String dec = (String)act.getValue("ShortDescription");
            if (items[i][1] != null && dec.indexOf(items[i][1]) < 0) {
                dec = dec + "(" + items[i][1] + ")";
            }
            JMenuItem menuItem = items[i][2] == null ? new JMenuItem(dec) : new JCheckBoxMenuItem(dec);
            menu.add(menuItem);
            menu.setName(itemname);
            ImageIcon icon = (ImageIcon)act.getValue("SmallIcon");
            if (icon != null) {
                menuItem.setIcon(icon);
                menuItem.setHorizontalTextPosition(4);
            }
            menuItem.addActionListener(act);
            if (items[i][1] != null) {
                menuItem.setMnemonic(items[i][1].charAt(0));
            }
            if (items[i][2] != null) {
                menuItem.setSelected(items[i][2].equals("Y"));
            }
            if (items[i][3] != null) {
                try {
                    String s = items[i][3];
                    int k = s.indexOf(":");
                    if (k >= 0) {
                        int mask = Integer.parseInt(s.substring(0, k));
                        int keyid = Integer.parseInt(s.substring(k + 1));
                        menuItem.setAccelerator(KeyStroke.getKeyStroke(keyid, mask));
                    } else {
                        int keyid = Integer.parseInt(s);
                        menuItem.setAccelerator(KeyStroke.getKeyStroke(keyid, 0));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            menuItem.setFont(font);
            this.menuItems.put(itemname, menuItem);
        }
        return menu;
    }

    private JToolBar createToolbar(String[] names) {
        JToolBar toolbar = new JToolBar();
        toolbar.setMargin(toolBarInsets);
        toolbar.setFloatable(false);
        int n = names.length;
        for (int i = 0; i < n; ++i) {
            if (names[i].equals("-")) {
                toolbar.addSeparator();
                continue;
            }
            Action act = (Action)this.actions.get(names[i]);
            if (act == null) continue;
            ImageIcon icon = (ImageIcon)act.getValue("SmallIcon");
            JButton bt = new JButton((Icon)icon){

                @Override
                public float getAlignmentY() {
                    return 0.5f;
                }
            };
            bt.setRequestFocusEnabled(false);
            bt.setMargin(toolBarImgButtonInsets);
            bt.setName(names[i]);
            bt.setToolTipText((String)act.getValue("ShortDescription"));
            bt.addActionListener(act);
            toolbar.add(bt);
            this.toolButtons.put(names[i], bt);
        }
        return toolbar;
    }

    private void loadInitParamenter() {
        Properties properties = new Properties();
        try {
            properties.load(new FileInputStream(MapEditorINI));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        int x = MappingEditor.getIntegerParameter(properties, "window.left", 0);
        int y = MappingEditor.getIntegerParameter(properties, "window.top", 0);
        int w = MappingEditor.getIntegerParameter(properties, "window.width", 0);
        int h = MappingEditor.getIntegerParameter(properties, "window.height", 0);
        if (w > 0 && h > 0) {
            this.setBounds(x, y, w, h);
        } else {
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            this.setBounds(screenSize.width / 2 - WIDTH / 2, screenSize.height / 2 - HEIGHT / 2, WIDTH, HEIGHT);
        }
        if (!this.isInteralEditor) {
            for (int i = 9; i >= 0; --i) {
                String s = properties.getProperty("recent." + String.valueOf(i), null);
                if (s == null) continue;
                this.addRecentFile(s, false);
            }
        }
        this.jdbc_path = properties.getProperty("jdbc.path");
        this.jdbc_driver = properties.getProperty("jdbc.driver", DEFAULT_JDBC_DRIVER);
        this.installJdbcDriver();
    }

    private void installJdbcDriver() {
        if (this.jdbc_driver != null) {
            URL[] urls;
            int count2;
            StringTokenizer st;
            URLClassLoader loader = null;
            if (this.jdbc_path != null) {
                st = new StringTokenizer(this.jdbc_path, ";");
                count2 = st.countTokens();
                if (count2 > 0) {
                    urls = new URL[count2];
                    int k = 0;
                    for (int i = 0; i < count2; ++i) {
                        try {
                            File file2 = new File(st.nextToken());
                            urls[k++] = file2.toURL();
                            continue;
                        }
                        catch (Exception file2) {
                            // empty catch block
                        }
                    }
                    if (k < count2) {
                        URL[] newUrls = new URL[k];
                        System.arraycopy(urls, 0, newUrls, 0, k);
                        urls = newUrls;
                    }
                    loader = new URLClassLoader(urls);
                }
            } else {
                File file = null;
                file = LIB_DIR != null ? new File(LIB_DIR) : new File(USER_DIR, "lib");
                File[] fileList = file.listFiles();
                if (fileList != null) {
                    count2 = fileList.length;
                    urls = new URL[count2 + 1];
                    int k = 0;
                    try {
                        urls[k++] = file.toURL();
                    }
                    catch (Exception file2) {
                        // empty catch block
                    }
                    for (int i = 0; i < count2; ++i) {
                        try {
                            if (!fileList[i].isFile()) continue;
                            urls[k++] = fileList[i].toURL();
                            continue;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (k < count2 + 1) {
                        URL[] newUrls = new URL[k];
                        System.arraycopy(urls, 0, newUrls, 0, k);
                        urls = newUrls;
                    }
                    loader = new URLClassLoader(urls);
                }
            }
            st = new StringTokenizer(this.jdbc_driver, ";");
            while (st.hasMoreTokens()) {
                String driver = (String)st.nextElement();
                if ((driver = driver.trim()).length() == 0) continue;
                try {
                    if (loader != null) {
                        RdbConnector.registerDriver((Driver)loader.loadClass(driver).newInstance());
                        continue;
                    }
                    RdbConnector.registerDriver((Driver)Class.forName(driver).newInstance());
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
                catch (InstantiationException instantiationException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    private void saveInitParamenter() {
        Properties properties = new Properties();
        Rectangle rect = this.getBounds();
        properties.put("window.left", String.valueOf(rect.x));
        properties.put("window.top", String.valueOf(rect.y));
        properties.put("window.width", String.valueOf(rect.width));
        properties.put("window.height", String.valueOf(rect.height));
        int n = this.fileMenu.getItemCount() - 2;
        if (this.recentFilepos + 10 < n) {
            n = this.recentFilepos + 10;
        }
        int k = 0;
        for (int i = this.recentFilepos; i < n; ++i) {
            String s = this.fileMenu.getItem(i).getText();
            properties.put("recent." + String.valueOf(k), s);
            ++k;
        }
        if (this.jdbc_path != null) {
            properties.put("jdbc.path", this.jdbc_path);
        }
        if (this.jdbc_driver != null) {
            properties.put("jdbc.driver", this.jdbc_driver);
        }
        try {
            FileOutputStream out = new FileOutputStream(MapEditorINI);
            properties.store(out, "MappingEditor initialize file");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    protected void processWindowEvent(WindowEvent e) {
        if (e.getID() == 201) {
            if (!this.closedWindow()) {
                return;
            }
            this.closedFile();
        }
        super.processWindowEvent(e);
    }

    public boolean hasContents() {
        return this.mapDocument != null;
    }

    boolean closedWindow() {
        if (this.scriptDebugerPanel != null && this.scriptDebugerPanel.isDocumentProcessing()) {
            this.getToolkit().beep();
            return false;
        }
        if (!this.isInteralEditor) {
            this.saveInitParamenter();
            return this.closeFile();
        }
        if (this.closeFile() && this.mappingEditorListener != null) {
            this.mappingEditorListener.windowClosing();
        }
        return false;
    }

    void viewWaitCursor(String msg) {
        GuiUtils.setCursorToComponent(this, Cursor.getPredefinedCursor(3));
        if (this.statusBar != null) {
            if (msg != null && msg.length() > 0) {
                this.statusBar.setStatusText(msg);
            } else {
                this.statusBar.setStatusText("   ");
            }
            this.statusBar.repaint();
        }
    }

    void viewDefaultCursor(String msg) {
        GuiUtils.setCursorToComponent(this, Cursor.getPredefinedCursor(0));
        if (this.statusBar != null) {
            if (msg != null && msg.length() > 0) {
                this.statusBar.setStatusText(msg);
            } else {
                this.statusBar.setStatusText("   ");
            }
            this.statusBar.repaint();
        }
    }

    @Override
    public void renamed(String oldName, String newName) {
        this.paraList.setEnabledEvent(false);
        int index = this.getSelectWorkSpace(oldName);
        if (index < 0) {
            return;
        }
        MapDocument.DeclSegment msg = this.mapDocument.getDeclSegment(newName);
        String s = newName + " -- " + msg.getMsgType();
        if (this.schemaEditorPanel != null && oldName.equals(this.schemaEditorPanel.getMsgName())) {
            this.schemaEditorPanel.msgName = newName;
        }
        this.paraList.removeItemAt(index);
        this.paraList.insertItemAt(s, index);
        this.paraList.setSelectedItem(s);
        this.paraList.setEnabledEvent(true);
    }

    @Override
    public void inserted(String newName, int index) {
        int MSGOFFSET = 1;
        this.paraList.setEnabledEvent(false);
        MapDocument.DeclSegment msg = this.mapDocument.getDeclSegment(newName);
        this.paraList.insertItemAt(newName + " -- " + msg.getMsgType(), index + MSGOFFSET);
        this.paraList.setEnabledEvent(true);
        this.paraList.setSelectedIndex(index + MSGOFFSET);
    }

    @Override
    public void removed(String msgName) {
    }

    private void certificateMapDocument(MapDocument map) throws MessageException {
        MapDocument.DeclSegment[] decls = map.getDeclSegments();
        int len = decls.length;
        if (MESSAGE == 0) {
            String dir2;
            String dir1;
            if (len > 2) {
                MessageException.error("CANT_CONVERT_MSG", new String[0], null);
            }
            if (len == 2 && (dir1 = decls[0].getDirection()).equalsIgnoreCase(dir2 = decls[1].getDirection())) {
                MessageException.error("CANT_CONVERT_MSG", new String[0], null);
            }
        }
        MessageFactory mf = MessageFactory.getInstance();
        for (int i = 0; i < len; ++i) {
            if (mf.isEnabled(decls[i].getMsgType())) continue;
            MessageException.error("INVALID_MSGTYPE", new String[]{decls[i].getMsgType()}, null);
        }
    }

    private boolean certificate() {
        MessageFactory mf;
        Properties ps = LicenceKeys.ps;
        if (ps == null) {
            String fileName = "license.key";
            File file = new File(USER_DIR, fileName);
            if (!file.isFile() && !(file = LIB_DIR != null ? new File(LIB_DIR, fileName) : new File(new File(USER_DIR, "lib"), fileName)).isFile()) {
                File userdir = new File(System.getProperty("user.dir", "."));
                File parent = userdir.getParentFile();
                if (parent != null) {
                    file = new File(parent, fileName);
                    if (!file.isFile()) {
                        file = new File(userdir, fileName);
                    }
                } else {
                    file = new File(userdir, fileName);
                }
            }
            ps = LicenceKeys.loadKeys(file);
        }
        if (ps == null) {
            MESSAGE = 1;
            MessageFactory mf2 = MessageFactory.getInstance();
            mf2.setEnabled(this, "FIX", true);
            return true;
        }
        USER_KEY = ps.getProperty("USER_KEY");
        COMPANY = ps.getProperty("COMPANY");
        USERNAME = ps.getProperty("USERNAME");
        String s = ps.getProperty("LASTMODIFY");
        if (s != null) {
            try {
                SimpleDateFormat format = new SimpleDateFormat("yyyy/MM/dd");
                LASTMODIFY = format.parse(s, new ParsePosition(0));
            }
            catch (Exception e) {
                LASTMODIFY = null;
            }
        }
        if ((s = ps.getProperty("MAPPINGEDITOR")) == null) {
            VALIDPERIOD = -1;
        } else {
            try {
                VALIDPERIOD = Integer.parseInt(s);
            }
            catch (Exception e) {
                VALIDPERIOD = -1;
            }
        }
        if (USER_KEY == null || COMPANY == null || COMPANY == null || USERNAME == null || LASTMODIFY == null || VALIDPERIOD < 0) {
            MESSAGE = 1;
            mf = MessageFactory.getInstance();
            mf.setEnabled(this, "FIX", true);
            return true;
        }
        s = ps.getProperty("MAPPINGOPTIONS");
        if (s != null) {
            String s1 = s.substring(0, 1);
            MESSAGE = s1 == null ? 0 : (s1.equalsIgnoreCase("N") ? 1 : 0);
        }
        mf = MessageFactory.getInstance();
        s = ps.getProperty("MSGTYPES");
        if (s != null) {
            StringTokenizer sz = new StringTokenizer(s, ";");
            while (sz.hasMoreElements()) {
                mf.setEnabled(this, (String)sz.nextElement(), true);
            }
        }
        return true;
    }

    public static MappingEditor getInstance() {
        String vers = System.getProperty("java.version");
        if (vers.compareTo("1.2.2") < 0) {
            System.out.println(MappingEditor.getMessage("WAR_NEED_JDK"));
            return null;
        }
        isJDK_1_3 = vers.compareTo("1.3") >= 0;
        MappingEditor frame = new MappingEditor(true);
        if (!frame.certificate()) {
            return null;
        }
        frame.start();
        return frame;
    }

    public static void main(String[] args) {
        long diff;
        AppMessage appMsg;
        String vers = System.getProperty("java.version");
        if (vers.compareTo("1.2.2") < 0) {
            JOptionPane.showMessageDialog(new Frame(), MappingEditor.getMessage("WAR_NEED_JDK"), MappingEditor.getMessage("DLG_ERR"), 0);
            System.exit(0);
        }
        isJDK_1_3 = vers.compareTo("1.3") >= 0;
        MappingEditor frame = new MappingEditor(false);
        if (!frame.certificate()) {
            JOptionPane.showMessageDialog(frame, MappingEditor.getMessage("WAR_NEED_KEY"), MappingEditor.getMessage("DLG_ERR"), 0);
            System.exit(0);
        }
        if (XmlParser.getXmlParser() == null) {
            JOptionPane.showMessageDialog(frame, MappingEditor.getMessage("WAR_NEED_JAR"), MappingEditor.getMessage("DLG_ERR"), 0);
            System.exit(0);
        }
        if ((appMsg = PassFileUtil.readCheck()) != null) {
            System.err.println(appMsg.getMessage());
            System.exit(appMsg.getCode());
        }
        ImageIcon img = MappingEditor.loadImage("BizTran");
        VersionDialog dlg = new VersionDialog(frame, false, img);
        dlg.pack();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dlgsize = dlg.getSize();
        dlg.setLocation(screenSize.width / 2 - dlgsize.width / 2, screenSize.height / 2 - dlgsize.width / 2);
        dlg.show();
        if (VALIDPERIOD > 0 && (diff = System.currentTimeMillis() - LASTMODIFY.getTime()) > (long)VALIDPERIOD * 24L * 3600000L) {
            JOptionPane.showMessageDialog(frame, MappingEditor.getMessage("WAR_OVER_TEST"), MappingEditor.getMessage("DLG_ERR"), 0);
            dlg.dispose();
            System.exit(0);
        }
        frame.start();
        frame.setVisible(true);
        dlg.modal = true;
        dlg.endDialog();
        if (args.length > 0) {
            URL url;
            block12: {
                String arg = args[0];
                url = null;
                try {
                    url = new URL(arg);
                }
                catch (MalformedURLException e) {
                    File file = new File(arg);
                    if (!file.isAbsolute()) {
                        file = new File(USER_DIR, arg);
                    }
                    if (!file.isFile() || !file.exists()) break block12;
                    try {
                        url = file.toURL();
                    }
                    catch (MalformedURLException malformedURLException) {
                        // empty catch block
                    }
                }
            }
            if (url == null) {
                return;
            }
            frame.setCursor(Cursor.getPredefinedCursor(3));
            frame.loadMapFile(url);
            frame.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    private void registActions() {
        MyAction a = new MyAction(CMD_NEW_FILE, MappingEditor.getMessage("CMD_NEW_FILE"), (Icon)MappingEditor.loadImage("new")){

            @Override
            public void actionPerformed(ActionEvent e) {
                MappingEditor.this.newFile();
            }
        };
        this.actions.put(CMD_NEW_FILE, a);
        a = new MyAction(CMD_OPEN_FILE, MappingEditor.getMessage("CMD_OPEN_FILE"), (Icon)MappingEditor.loadImage("open")){

            @Override
            public void actionPerformed(ActionEvent e) {
                MappingEditor.this.openFile();
            }
        };
        this.actions.put(CMD_OPEN_FILE, a);
        a = new MyAction(CMD_SAVE_FILE, MappingEditor.getMessage("CMD_SAVE_FILE"), (Icon)MappingEditor.loadImage("save")){

            @Override
            public void actionPerformed(ActionEvent e) {
                MappingEditor.this.saveFile();
            }
        };
        this.actions.put(CMD_SAVE_FILE, a);
        a = new MyAction(CMD_SAVEAS_FILE, MappingEditor.getMessage("CMD_SAVEAS_FILE")){

            @Override
            public void actionPerformed(ActionEvent e) {
                MappingEditor.this.saveFileAs();
            }
        };
        this.actions.put(CMD_SAVEAS_FILE, a);
        a = new MyAction(CMD_EXIT, MappingEditor.getMessage("CMD_EXIT")){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (MappingEditor.this.closedWindow()) {
                    System.exit(0);
                }
            }
        };
        this.actions.put(CMD_EXIT, a);
        a = new MyAction(CMD_VIEW_MSG, MappingEditor.getMessage("CMD_VIEW_MSG")){

            @Override
            public void actionPerformed(ActionEvent e) {
                MappingEditor.this.viewMessageWindow();
            }
        };
        this.actions.put(CMD_VIEW_MSG, a);
        a = new MyAction(CMD_VIEW_TOOLBAR, MappingEditor.getMessage("CMD_VIEW_TOOLBAR")){

            @Override
            public void actionPerformed(ActionEvent e) {
                MappingEditor.this.viewToolBar();
            }
        };
        this.actions.put(CMD_VIEW_TOOLBAR, a);
        a = new MyAction(CMD_VIEW_STATUSBAR, MappingEditor.getMessage("CMD_VIEW_STATUSBAR")){

            @Override
            public void actionPerformed(ActionEvent e) {
                MappingEditor.this.viewStatusBar();
            }
        };
        this.actions.put(CMD_VIEW_STATUSBAR, a);
        a = new MyAction(CMD_VIEW_CONFIG, MappingEditor.getMessage("CMD_VIEW_CONFIG")){

            @Override
            public void actionPerformed(ActionEvent e) {
                MappingEditor.this.viewSetDailog();
            }
        };
        this.actions.put(CMD_VIEW_CONFIG, a);
        a = new MyAction(CMD_VIEW_INFORMATION, MappingEditor.getMessage("CMD_VIEW_INFORMATION")){

            @Override
            public void actionPerformed(ActionEvent e) {
                MappingEditor.this.viewInformation();
            }
        };
        this.actions.put(CMD_VIEW_INFORMATION, a);
        a = new MyAction(CMD_SAVE_TO_LIB, MappingEditor.getMessage(CMD_SAVE_TO_LIB)){

            @Override
            public void actionPerformed(ActionEvent e) {
                MappingEditor.this.saveMessageToLibrary();
            }
        };
        this.actions.put(CMD_SAVE_TO_LIB, a);
        a = new MyAction(CMD_GET_FROM_LIB, MappingEditor.getMessage(CMD_GET_FROM_LIB)){

            @Override
            public void actionPerformed(ActionEvent e) {
                MappingEditor.this.addMessageFromLibrary();
            }
        };
        this.actions.put(CMD_GET_FROM_LIB, a);
        a = new MyAction(CMD_DEL_FROM_LIB, MappingEditor.getMessage(CMD_DEL_FROM_LIB)){

            @Override
            public void actionPerformed(ActionEvent e) {
                MappingEditor.this.removeMessageFromLibrary();
            }
        };
        this.actions.put(CMD_DEL_FROM_LIB, a);
    }

    static {
        File f;
        String name2;
        File parent;
        File file;
        WIDTH = 800;
        HEIGHT = 560;
        TITLE_STRING = "Biz Tran";
        DEFAULT_JDBC_DRIVER = "sun.jdbc.odbc.JdbcOdbcDriver";
        WKS_DEBUGER = "[DEBUGER]";
        WKS_SCRIPT = "[SCRIPT]";
        WKS_EMPTY = "[EMPTY]";
        WKS_MSGDECL = "[MSGDECL]";
        defaultBorder = BorderFactory.createEtchedBorder();
        selectBorder = BorderFactory.createEtchedBorder(Color.blue, Color.blue);
        emptyBorder0 = new EmptyBorder(0, 0, 0, 0);
        emptyBorder16 = new EmptyBorder(0, 16, 0, 0);
        toolBarInsets = new Insets(0, 0, 0, 0);
        toolBarImgButtonInsets = new Insets(1, 1, 1, 1);
        toolBarTextButtonInsets = new Insets(4, 1, 4, 1);
        isJDK_1_3 = false;
        VALIDPERIOD = -1;
        USER_KEY = null;
        COMPANY = null;
        USERNAME = null;
        LASTMODIFY = null;
        MESSAGE = 0;
        URL resource = ClassLoader.getSystemResource("com/argo21/map/MappingEditor.class");
        if (resource != null) {
            if ("file".equals(resource.getProtocol())) {
                try {
                    USER_DIR = FileEx.urlToFile(new URL(resource, "../../../"));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (USER_DIR != null) {
                    file = new File(USER_DIR);
                    parent = file.getParentFile();
                    name2 = file.getName();
                    if ("out".equals(name2) && parent != null) {
                        USER_DIR = parent.getAbsolutePath();
                    }
                }
            } else if ("jar".equals(resource.getProtocol())) {
                try {
                    JarURLConnection connect = (JarURLConnection)resource.openConnection();
                    LIB_DIR = FileEx.urlToFile(new URL(connect.getJarFileURL(), "./"));
                }
                catch (Exception connect) {
                    // empty catch block
                }
                if (LIB_DIR != null) {
                    USER_DIR = new File(LIB_DIR).getParent();
                }
            }
        }
        if (USER_DIR == null || !new File(USER_DIR).isDirectory()) {
            file = new File(System.getProperty("user.dir", "."));
            parent = file.getParentFile();
            name2 = file.getName();
            USER_DIR = (name2.startsWith("bin") || "src".equals(name2)) && parent != null ? parent.getAbsolutePath() : file.getAbsolutePath();
        }
        if (USER_DIR != null) {
            SAMPLES_DIR = new File(new File(USER_DIR, "samples"), "map").getPath();
        }
        if (!(f = new File(HOME_DIR = System.getProperty("user.home", "."), ".esooner")).exists()) {
            try {
                f.mkdirs();
            }
            catch (Exception e) {
                System.err.println(e);
            }
        }
        File MapEditorINIfile = new File(f, "MappingEditor.ini");
        MapEditorINI = MapEditorINIfile.getPath();
        fileToolBarNames = new String[]{CMD_NEW_FILE, CMD_OPEN_FILE, CMD_SAVE_FILE};
        fileToolBarNames1 = new String[]{CMD_SAVE_FILE};
        fileMenus = new String[][]{{CMD_NEW_FILE, "N", null, "2:78"}, {CMD_OPEN_FILE, "O", null, "2:79"}, {"-", null, null, null}, {CMD_SAVE_FILE, "S", null, "2:83"}, {CMD_SAVEAS_FILE, "A", null, null}, {"-", null, null, null}, {"-", null, null, null}, {CMD_EXIT, "X", null, null}};
        fileMenus1 = new String[][]{{CMD_SAVE_FILE, "S", null, null, "2:83"}, {"-", null, null, null}, {CMD_EXIT, "X", null, null}};
        viewMenus = new String[][]{{CMD_VIEW_MSG, "M", "Y", null}, {CMD_VIEW_TOOLBAR, "T", "Y", null}, {CMD_VIEW_STATUSBAR, "U", "Y", null}, {"-", null, null, null}, {CMD_VIEW_CONFIG, "S", null, null}};
        otherMenus = new String[][]{{CMD_VIEW_INFORMATION, "V", null, null}};
        String lang = System.getProperty("user.msg.lang", null);
        if (lang == null) {
            lang = Locale.getDefault().getLanguage();
        }
        String classbase = MappingEditor.class.getName();
        int k = classbase.lastIndexOf(".");
        classbase = classbase.substring(0, k + 1) + "MessageCatalog_";
        try {
            msgCatalog = (MessageCatalog)Class.forName(classbase + lang).newInstance();
        }
        catch (Exception e) {
            try {
                msgCatalog = (MessageCatalog)Class.forName(classbase + "en").newInstance();
            }
            catch (Exception e1) {
                System.err.println(e1);
                System.exit(1);
            }
        }
        NO_NAMING_FILE = msgCatalog.getMessage("NO_NAMING_FILE");
    }

    class MapFileDropListener
    implements DropTargetListener {
        MapFileDropListener() {
        }

        @Override
        public void drop(DropTargetDropEvent dtde) {
            dtde.acceptDrop(dtde.getDropAction());
            try {
                Transferable trans = dtde.getTransferable();
                DataFlavor[] flavors = trans.getTransferDataFlavors();
                for (int i = 0; i < flavors.length; ++i) {
                    List list;
                    if (!flavors[i].isFlavorJavaFileListType() || (list = (List)trans.getTransferData(flavors[i])).size() <= 0) continue;
                    if (!MappingEditor.this.closeFile()) {
                        return;
                    }
                    MappingEditor.this.closedFile();
                    File file = (File)list.get(0);
                    URL url = file.toURL();
                    MappingEditor.this.loadMapFile(url);
                }
            }
            catch (IOException iOException) {
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
                // empty catch block
            }
            dtde.dropComplete(true);
        }

        @Override
        public void dragEnter(DropTargetDragEvent dtde) {
        }

        @Override
        public void dragOver(DropTargetDragEvent dtde) {
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent dtde) {
        }

        @Override
        public void dragExit(DropTargetEvent dte) {
        }
    }

    static class ListEntryRenderer
    extends JLabel
    implements ListCellRenderer {
        public ListEntryRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList listbox, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value != null) {
                String s = value.toString();
                this.setText(s);
                EmptyBorder border = index != -1 && !s.startsWith("[") ? emptyBorder16 : emptyBorder0;
                if (UIManager.getLookAndFeel().getName().equals("CDE/Motif")) {
                    if (index == -1) {
                        this.setOpaque(false);
                    } else {
                        this.setOpaque(true);
                    }
                } else {
                    this.setOpaque(true);
                }
                this.setBorder(border);
                if (isSelected) {
                    this.setBackground(UIManager.getColor("ComboBox.selectionBackground"));
                    this.setForeground(UIManager.getColor("ComboBox.selectionForeground"));
                } else {
                    this.setBackground(Color.white);
                    this.setForeground(UIManager.getColor("ComboBox.foreground"));
                }
            } else {
                this.setText("");
            }
            return this;
        }
    }

    static class EmptyPanel
    extends JPanel
    implements WorkSpace {
        EmptyPanel() {
            this.setBorder(BorderFactory.createBevelBorder(1));
            this.setBackground(Color.gray);
        }

        @Override
        public void load(MapDocument mapDoc) throws MessageException {
        }

        @Override
        public void saveBack() throws MessageException {
        }

        @Override
        public void review() throws MessageException {
        }

        @Override
        public JMenu getMenu() {
            JMenu m = new JMenu("");
            m.setVisible(false);
            return m;
        }

        @Override
        public JToolBar getToolBar() {
            return new JToolBar();
        }

        @Override
        public String getWorkSpaceName() {
            return WKS_EMPTY;
        }

        @Override
        public void addStatusChangedListener(StatusChangedListener l) {
        }

        @Override
        public void removeStatusChangedListener(StatusChangedListener l) {
        }

        @Override
        public void clearChanged() {
        }

        @Override
        public boolean isChanged() {
            return false;
        }

        @Override
        public void messageItemSelected(String id2, int line) {
        }
    }

    static class VersionDialog
    extends JWindow {
        JLabel label;
        boolean modal;

        VersionDialog(Frame owner, boolean modal) {
            this(owner, modal, null);
        }

        VersionDialog(Frame owner, boolean modal, ImageIcon img) {
            super(owner);
            JLabel label1;
            String s;
            int k;
            this.modal = modal;
            this.setBackground(Color.white);
            this.getContentPane().setLayout(new BorderLayout());
            if (img == null) {
                img = MappingEditor.loadImage("BizTran");
            }
            int w = img.getIconWidth();
            int h = img.getIconHeight();
            this.label = new JLabel(img);
            this.label.setOpaque(false);
            this.label.setBorder(BorderFactory.createEtchedBorder());
            this.getContentPane().add((Component)this.label, "Center");
            this.pack();
            Dimension size = this.label.getSize();
            Font defaultFont = this.getFont();
            int charH = 16;
            int sp = 6;
            try {
                defaultFont = new Font("Dialog", 0, 12);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.label.setLayout(null);
            if (VALIDPERIOD > 0) {
                k = 5;
                s = USERNAME == null || USERNAME.length() == 0 ? System.getProperty("user.name", "None") : USERNAME;
                label1 = new JLabel(MappingEditor.getMessage("WAR_USER") + " : " + s, 4);
                label1.setForeground(Color.black);
                label1.setFont(defaultFont);
                this.label.add(label1);
                label1.setBounds(w / 2 - sp, k, w / 2, charH);
                label1.setBackground(Color.white);
                label1.setOpaque(true);
                k += charH;
                label1 = new JLabel(MappingEditor.getMessage("WAR_LIMIT"), 4);
                label1.setForeground(Color.black);
                label1.setFont(defaultFont);
                this.label.add(label1);
                label1.setBounds(w / 2 - sp, k, w / 2, charH);
                label1.setBackground(Color.white);
                label1.setOpaque(true);
                k += charH;
                long diff = System.currentTimeMillis() - LASTMODIFY.getTime();
                diff = diff < 0L ? 0L : (diff /= 86400000L);
                s = MappingEditor.getMessage("WAR_CAN_USE", String.valueOf((long)VALIDPERIOD - diff));
                label1 = new JLabel(s, 4);
                label1.setForeground(Color.black);
                label1.setFont(defaultFont);
                this.label.add(label1);
                label1.setBounds(w / 2 - sp, k, w / 2, charH);
                label1.setBackground(Color.white);
                label1.setOpaque(true);
                k += charH;
            } else {
                k = 5;
                s = USERNAME == null || USERNAME.length() == 0 ? System.getProperty("user.name", "None") : USERNAME;
                label1 = new JLabel(MappingEditor.getMessage("WAR_USER") + " : " + s, 4);
                label1.setForeground(Color.black);
                label1.setFont(defaultFont);
                this.label.add(label1);
                label1.setBounds(w / 2 - sp, k, w / 2, charH);
                label1.setBackground(Color.white);
                label1.setOpaque(true);
                k += charH;
                label1 = new JLabel(COMPANY, 4);
                label1.setForeground(Color.black);
                label1.setFont(defaultFont);
                this.label.add(label1);
                label1.setBounds(w / 2 - sp, k, w / 2, charH);
                label1.setBackground(Color.white);
                label1.setOpaque(true);
                k += charH;
                label1 = new JLabel(USER_KEY, 4);
                label1.setForeground(Color.black);
                label1.setFont(defaultFont);
                this.label.add(label1);
                label1.setBounds(w / 2 - sp, k, w / 2, charH);
                label1.setBackground(Color.white);
                label1.setOpaque(true);
            }
            this.label.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (modal) {
                        this.endDialog();
                    }
                }
            });
            PassFile passFile = null;
            String version = null;
            String serialNo = null;
            try {
                passFile = PassFile.getInstance();
                version = passFile.getValueByString(PassFileUtil.VERSION_NO.getBeginIndex(), PassFileUtil.VERSION_NO.getEndIndex());
                serialNo = passFile.getSerialNo(PassFileUtil.DECODE_KEY);
            }
            catch (PassFileIOException e1) {
                System.err.println(AppMessage.PASSFILE_NOT_FOUND.getMessage() + e1.getLocalizedMessage());
            }
            catch (PassFileIllegalException e1) {
                System.err.println(AppMessage.PASSFILE_CONTENT_ILLEGAL.getMessage() + e1.getLocalizedMessage());
            }
            catch (PassFileArgumentException e) {
                System.err.println(e.getLocalizedMessage());
            }
            JLabel label3 = null;
            label3 = new JLabel("Version     " + version);
            label3.setForeground(Color.black);
            label3.setFont(defaultFont);
            this.label.add(label3);
            label3.setSize(w / 2, charH);
            label3.setLocation(sp + 2, h - 55);
            label3.setBackground(Color.white);
            label3.setOpaque(true);
            this.label.add(label3);
            JLabel label4 = null;
            label4 = new JLabel("Serial No  " + serialNo);
            label4.setForeground(Color.black);
            label4.setFont(defaultFont);
            this.label.add(label4);
            label4.setSize(w / 2, charH);
            label4.setLocation(sp + 2, h - 40);
            label4.setBackground(Color.white);
            label4.setOpaque(true);
            this.label.add(label4);
        }

        @Override
        public void setVisible(boolean b) {
            super.setVisible(b);
            if (!b) {
                return;
            }
            this.toFront();
            this.requestFocus();
        }

        void endDialog() {
            super.setVisible(false);
        }
    }

    static class MyAction
    extends AbstractAction {
        MyAction(String name2, String description) {
            super(name2);
            this.putValue("ShortDescription", description);
            this.setEnabled(false);
        }

        MyAction(String name2, String description, Icon icon) {
            super(name2, icon);
            this.putValue("ShortDescription", description);
            this.setEnabled(false);
        }

        MyAction(String name2, String shortdes, String longdes, Icon icon) {
            super(name2, icon);
            this.putValue("ShortDescription", shortdes);
            this.putValue("LongDescription", longdes);
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
        }
    }

    static class StatusBar
    extends JPanel {
        protected JLabel text;

        public StatusBar() {
            this.setLayout(new BorderLayout());
            this.text = new JLabel();
            this.add("Center", this.text);
            this.text.setBorder(new BevelBorder(1));
        }

        public void setStatusText(String s) {
            System.out.println(s);
            if (s != null && s.length() > 0) {
                this.text.setText(s);
            } else {
                this.text.setText(" ");
            }
        }

        public String getStatusText() {
            return this.text.getText();
        }
    }
}

