/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.map;

import com.argo21.common.io.Debug;
import com.argo21.common.io.FileEx;
import com.argo21.common.io.XReader;
import com.argo21.common.lang.Variable;
import com.argo21.common.lang.VariableReference;
import com.argo21.common.lang.XObject;
import com.argo21.common.lang.XString;
import com.argo21.common.log.AppMessage;
import com.argo21.common.log.BizTranException;
import com.argo21.common.log.Logger;
import com.argo21.common.log.LoggerFactory;
import com.argo21.common.log.XMLSchemaErrorMessageHandler;
import com.argo21.common.security.LicenceKeys;
import com.argo21.common.util.MappingInfo;
import com.argo21.common.util.PassFileUtil;
import com.argo21.js.ScriptEngine;
import com.argo21.js.ScriptErrorHandler;
import com.argo21.map.ArgumentAnalyzer;
import com.argo21.map.Mapping;
import com.argo21.map.MappingException;
import com.argo21.map.MappingProcessor2;
import com.argo21.msg.BaseMessage;
import com.argo21.msg.MessageErrorHandler;
import com.argo21.msg.MessageException;
import com.argo21.msg.MessageFactory;
import com.argo21.msg.rdb.RdbConnector;
import com.argo21.msg.rdb.RdbMsg;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.sql.Driver;
import java.sql.SQLException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Properties;
import java.util.StringTokenizer;
import jp.co.argo21.nts.commons.passfile.PassFile;
import jp.co.argo21.nts.commons.passfile.PassFileArgumentException;
import jp.co.argo21.nts.commons.passfile.PassFileIOException;
import jp.co.argo21.nts.commons.passfile.PassFileIllegalException;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public final class MappingProcessor
implements Mapping {
    static String MapEditorINI;
    static String USER_DIR;
    static String LIB_DIR;
    static boolean folder;
    static boolean version;
    static final String HOME_DIR;
    private BaseMessage[] msglist = new BaseMessage[2];
    private int msgcount = 0;
    private ScriptEngine scriptEngine;

    public static void main(String[] args) {
        int returnCode = AppMessage.NORMAL_EXIT.getCode();
        Logger logger = LoggerFactory.getLogger();
        MappingInfo mapInfo = logger.getMappingInfo();
        try {
            PassFile passFile = PassFile.getInstance();
            if (!PassFileUtil.isBizTran()) {
                throw new PassFileIllegalException("\u5546\u54c1\u8b58\u5225\u5b50\u304c\u4e0d\u6b63\u3067\u3059\u3002");
            }
            new ArgumentAnalyzer().analyze(args, mapInfo);
            folder = mapInfo.isFolder();
            if (mapInfo.isVersion()) {
                logger.normal();
                logger.renameByResult();
                System.out.println("(C)2003-2018 Canon IT Solutions Inc. All Right Reserved.");
                System.out.println("Version    " + passFile.getValueByString(PassFileUtil.VERSION_NO.getBeginIndex(), PassFileUtil.VERSION_NO.getEndIndex()));
                System.out.println("Serial No  " + passFile.getSerialNo(PassFileUtil.DECODE_KEY));
                System.exit(AppMessage.NORMAL_EXIT.getCode());
            }
            MappingProcessor2 mapping = new MappingProcessor2();
            returnCode = mapping.execMapping(logger, mapInfo);
            System.exit(returnCode);
        }
        catch (PassFileIOException e) {
            logger.error(AppMessage.PASSFILE_NOT_FOUND);
            logger.renameByResult();
            System.err.println(AppMessage.PASSFILE_NOT_FOUND.getMessage());
            System.exit(AppMessage.PASSFILE_NOT_FOUND.getCode());
        }
        catch (PassFileIllegalException e) {
            logger.error(AppMessage.PASSFILE_CONTENT_ILLEGAL);
            logger.renameByResult();
            System.err.println(AppMessage.PASSFILE_CONTENT_ILLEGAL.getMessage());
            System.exit(AppMessage.PASSFILE_CONTENT_ILLEGAL.getCode());
        }
        catch (PassFileArgumentException e) {
            logger.error(AppMessage.PASSFILE_CONTENT_ILLEGAL);
            logger.renameByResult();
            System.err.println(AppMessage.PASSFILE_CONTENT_ILLEGAL.getMessage());
            System.exit(AppMessage.PASSFILE_CONTENT_ILLEGAL.getCode());
        }
        catch (BizTranException e) {
            logger.error(e);
            logger.renameByResult();
            System.exit(e.getStsCode());
        }
        catch (OutOfMemoryError e) {
            MappingProcessor.logWriterForOutOfMemory(logger, e);
            System.exit(AppMessage.JAVA_OUTOFMOMERY_EXCEPTION.getCode());
        }
        catch (Throwable e) {
            logger.error(AppMessage.JAVA_EXCEPTION, e);
            logger.renameByResult();
            System.exit(AppMessage.JAVA_EXCEPTION.getCode());
        }
    }

    private static void useage(File logFile, String errorMesage) {
        System.out.println(errorMesage);
        System.out.println("Useage:MappingProcessor mapdefile -I[MessageName] inputfile -O[MessageName] outputfile [-L logfile] [parameter=value]");
        System.out.println("    or MappingProcessor mapdefile -folder -I[MessageName] inputfolder -O[MessageName] outputfolder [-L logfile] [parameter=value]");
        try {
            if (logFile != null) {
                FileWriter logFileWriter = new FileWriter(logFile, true);
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
                String log = "3\t" + dateFormat.format(new Date()) + "\t\t" + errorMesage + "\n";
                logFileWriter.write(log);
                logFileWriter.close();
            }
        }
        catch (IOException e) {
            System.err.println(e.getMessage());
            System.exit(1);
        }
    }

    public static Mapping createMappingProcessor() {
        return new MappingProcessor();
    }

    private MappingProcessor() {
        this.init();
    }

    private void certificate() {
        long diff;
        Properties ps = LicenceKeys.ps;
        if (ps == null) {
            String fileName = "license.key";
            File file = new File(USER_DIR, fileName);
            if (!file.isFile() && !(file = LIB_DIR != null ? new File(LIB_DIR, fileName) : new File(new File(USER_DIR, "lib"), fileName)).isFile()) {
                File userdir = new File(System.getProperty("user.dir", "."));
                File parent = userdir.getParentFile();
                if (parent != null) {
                    file = new File(parent, fileName);
                    if (!file.isFile()) {
                        file = new File(userdir, fileName);
                    }
                } else {
                    file = new File(userdir, fileName);
                }
            }
            ps = LicenceKeys.loadKeys(file);
        }
        if (ps == null) {
            throw new SecurityException(MappingException.getMessage("WAR_NEED_KEY"));
        }
        String userKey = ps.getProperty("USER_KEY");
        String company = ps.getProperty("COMPANY");
        String userName = ps.getProperty("USERNAME");
        String s = ps.getProperty("LASTMODIFY");
        Date lastModify = null;
        if (s != null) {
            try {
                SimpleDateFormat format = new SimpleDateFormat("yyyy/MM/dd");
                lastModify = format.parse(s, new ParsePosition(0));
            }
            catch (Exception format) {
                // empty catch block
            }
        }
        int vaildPeriod = -1;
        s = ps.getProperty("MAPPINGEDITOR");
        if (s != null) {
            try {
                vaildPeriod = Integer.parseInt(s);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (userKey == null || company == null || userName == null || lastModify == null || vaildPeriod < 0) {
            throw new SecurityException(MappingException.getMessage("WAR_NEED_KEY"));
        }
        if (vaildPeriod > 0 && (diff = System.currentTimeMillis() - lastModify.getTime()) > (long)vaildPeriod * 24L * 3600000L) {
            throw new SecurityException(MappingException.getMessage("WAR_OVER_TEST"));
        }
    }

    private void init() {
        String jdbc_path;
        File f;
        String s = System.getProperty("jdbc.driver", null);
        if (s == null && (f = new File(MapEditorINI)).isFile() && f.exists()) {
            try {
                FileInputStream in = new FileInputStream(f);
                Properties ps = new Properties();
                ps.load(in);
                s = ps.getProperty("jdbc.driver", null);
                jdbc_path = ps.getProperty("jdbc.path");
                if (jdbc_path != null) {
                    System.setProperty("jdbc.path", jdbc_path);
                }
            }
            catch (Exception in) {
                // empty catch block
            }
        }
        if (s != null) {
            URL[] urls;
            StringTokenizer st;
            URLClassLoader loader = null;
            jdbc_path = System.getProperty("jdbc.path");
            if (jdbc_path != null) {
                st = new StringTokenizer(jdbc_path, ";");
                int count2 = st.countTokens();
                if (count2 > 0) {
                    urls = new URL[count2];
                    int k = 0;
                    for (int i = 0; i < count2; ++i) {
                        try {
                            File file2 = new File(st.nextToken());
                            urls[k++] = file2.toURL();
                            continue;
                        }
                        catch (Exception file2) {
                            // empty catch block
                        }
                    }
                    if (k < count2) {
                        URL[] newUrls = new URL[k];
                        System.arraycopy(urls, 0, newUrls, 0, k);
                        urls = newUrls;
                    }
                    loader = new URLClassLoader(urls);
                }
            } else {
                File file = null;
                file = LIB_DIR != null ? new File(LIB_DIR) : new File(USER_DIR, "lib");
                File[] fileList = file.listFiles();
                if (fileList != null) {
                    int count3 = fileList.length;
                    urls = new URL[count3 + 1];
                    int k = 0;
                    try {
                        urls[k++] = file.toURL();
                    }
                    catch (Exception file2) {
                        // empty catch block
                    }
                    for (int i = 0; i < count3; ++i) {
                        try {
                            if (!fileList[i].isFile()) continue;
                            urls[k++] = fileList[i].toURL();
                            continue;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (k < count3 + 1) {
                        URL[] newUrls = new URL[k];
                        System.arraycopy(urls, 0, newUrls, 0, k);
                        urls = newUrls;
                    }
                    loader = new URLClassLoader(urls);
                }
            }
            st = new StringTokenizer(s, ";");
            while (st.hasMoreTokens()) {
                String driver = (String)st.nextElement();
                try {
                    if (loader != null) {
                        RdbConnector.registerDriver((Driver)loader.loadClass(driver).newInstance());
                        continue;
                    }
                    RdbConnector.registerDriver((Driver)Class.forName(driver).newInstance());
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
                catch (InstantiationException instantiationException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    @Override
    public void execMapping(String address, InputStream in, OutputStream out, String[] args) throws MappingException {
        Logger logger = LoggerFactory.getLogger();
        MappingInfo mapInfo = logger.getMappingInfo();
        mapInfo.setMapFilePath(address);
        mapInfo.setParameters(args);
        XReader reader = null;
        try {
            PassFile.getInstance();
            if (!PassFileUtil.isBizTran()) {
                throw new PassFileIllegalException("\u5546\u54c1\u8b58\u5225\u5b50\u304c\u4e0d\u6b63\u3067\u3059\u3002");
            }
            URL url = null;
            String parentPath = null;
            try {
                url = new URL(address);
            }
            catch (MalformedURLException e) {
                File file = new File(address);
                if (!file.exists()) {
                    throw new BizTranException(AppMessage.MAPFILE_NOT_FOUND);
                }
                try {
                    url = file.toURL();
                    parentPath = file.getParent();
                }
                catch (Exception e1) {
                    throw new BizTranException(AppMessage.MAPFILE_NOT_FOUND);
                }
            }
            try {
                InputStream is = url.openStream();
                reader = XReader.createReader(new InputStreamReader(is), parentPath);
                reader.setSystemId(url.toString());
            }
            catch (IOException e1) {
                throw new BizTranException(AppMessage.MAPFILE_NOT_FOUND);
            }
        }
        catch (BizTranException e2) {
            logger.error(e2);
            logger.renameByResult();
            this.error(e2);
        }
        catch (PassFileIOException e2) {
            logger.error(AppMessage.PASSFILE_NOT_FOUND);
            logger.renameByResult();
            this.error(new BizTranException(AppMessage.PASSFILE_NOT_FOUND, (Throwable)e2));
        }
        catch (PassFileIllegalException e2) {
            logger.error(AppMessage.PASSFILE_CONTENT_ILLEGAL);
            logger.renameByResult();
            this.error(new BizTranException(AppMessage.PASSFILE_CONTENT_ILLEGAL, (Throwable)e2));
        }
        catch (OutOfMemoryError e2) {
            this.throwErrorForOutOfMemory(logger, e2);
        }
        catch (Throwable e2) {
            logger.error(AppMessage.JAVA_EXCEPTION, e2);
            logger.renameByResult();
            this.error(new BizTranException(AppMessage.JAVA_EXCEPTION, e2));
        }
        this.execMapping(reader, in, out, args);
    }

    @Override
    public void execMapping(String address, Reader in, Writer out, String[] args) throws MappingException {
        Logger logger = LoggerFactory.getLogger();
        MappingInfo mapInfo = logger.getMappingInfo();
        mapInfo.setMapFilePath(address);
        mapInfo.setParameters(args);
        XReader reader = null;
        try {
            PassFile.getInstance();
            if (!PassFileUtil.isBizTran()) {
                throw new PassFileIllegalException("\u5546\u54c1\u8b58\u5225\u5b50\u304c\u4e0d\u6b63\u3067\u3059\u3002");
            }
            URL url = null;
            String parentPath = null;
            try {
                url = new URL(address);
            }
            catch (MalformedURLException e) {
                File file = new File(address);
                if (!file.exists()) {
                    throw new BizTranException(AppMessage.MAPFILE_NOT_FOUND);
                }
                try {
                    url = file.toURL();
                    parentPath = file.getParent();
                }
                catch (Exception e1) {
                    throw new BizTranException(AppMessage.MAPFILE_NOT_FOUND);
                }
            }
            try {
                InputStream is = url.openStream();
                reader = XReader.createReader(new InputStreamReader(is), parentPath);
                reader.setSystemId(url.toString());
            }
            catch (IOException e1) {
                throw new BizTranException(AppMessage.MAPFILE_NOT_FOUND);
            }
        }
        catch (BizTranException e2) {
            logger.error(e2);
            logger.renameByResult();
            this.error(e2);
        }
        catch (PassFileIOException e2) {
            logger.error(AppMessage.PASSFILE_NOT_FOUND);
            logger.renameByResult();
            this.error(new BizTranException(AppMessage.PASSFILE_NOT_FOUND, (Throwable)e2));
        }
        catch (PassFileIllegalException e2) {
            logger.error(AppMessage.PASSFILE_CONTENT_ILLEGAL);
            logger.renameByResult();
            this.error(new BizTranException(AppMessage.PASSFILE_CONTENT_ILLEGAL, (Throwable)e2));
        }
        catch (OutOfMemoryError e2) {
            this.throwErrorForOutOfMemory(logger, e2);
        }
        catch (Throwable e2) {
            logger.error(AppMessage.JAVA_EXCEPTION, e2);
            logger.renameByResult();
            this.error(new BizTranException(AppMessage.JAVA_EXCEPTION, e2));
        }
        this.execMapping(reader, in, out, args);
    }

    @Override
    public void execMapping(Reader mapdef, InputStream in, OutputStream out, String[] args) throws MappingException {
        BizTranException exception;
        Logger logger = LoggerFactory.getLogger();
        MappingInfo mapInfo = logger.getMappingInfo();
        mapInfo.setParameters(args);
        XReader rd = null;
        String parentPath = null;
        try {
            PassFile.getInstance();
            if (!PassFileUtil.isBizTran()) {
                throw new PassFileIllegalException("\u5546\u54c1\u8b58\u5225\u5b50\u304c\u4e0d\u6b63\u3067\u3059\u3002");
            }
            if (mapdef instanceof XReader) {
                rd = (XReader)mapdef;
                parentPath = rd.getParentPath();
            } else {
                rd = XReader.createReader(mapdef);
            }
            this.scriptEngine = ScriptEngine.getScriptEngine();
            VariableReference vref = this.scriptEngine.getVariableReference();
            com.argo21.common.util.Properties params = new com.argo21.common.util.Properties();
            if (args != null) {
                for (int i = 0; i < args.length; ++i) {
                    String s = args[i];
                    int k = s.indexOf("=");
                    if (k <= 0) continue;
                    String key = s.substring(0, k).trim();
                    String value = s.substring(k + 1).trim();
                    if (value.startsWith("\"") && value.endsWith("\"")) {
                        value = value.substring(1, value.length() - 1);
                    }
                    vref.putData(key, new XString(value));
                    params.repleace(key, value);
                }
            }
            this.parse(rd, params);
        }
        catch (PassFileIOException e2) {
            logger.error(AppMessage.PASSFILE_NOT_FOUND);
            logger.renameByResult();
            this.error(new BizTranException(AppMessage.PASSFILE_NOT_FOUND, (Throwable)e2));
        }
        catch (PassFileIllegalException e2) {
            logger.error(AppMessage.PASSFILE_CONTENT_ILLEGAL);
            logger.renameByResult();
            this.error(new BizTranException(AppMessage.PASSFILE_CONTENT_ILLEGAL, (Throwable)e2));
        }
        catch (SAXParseException e) {
            exception = XMLSchemaErrorMessageHandler.createBizTranExcepton(AppMessage.MAPFILE_CONTENT_ILLEGAL, e);
            logger.error(exception);
            logger.renameByResult();
            this.error(exception);
        }
        catch (OutOfMemoryError e2) {
            this.throwErrorForOutOfMemory(logger, e2);
        }
        catch (Throwable e2) {
            logger.error(AppMessage.JAVA_EXCEPTION, e2);
            logger.renameByResult();
            this.error(new BizTranException(AppMessage.JAVA_EXCEPTION, e2));
        }
        try {
            this.execMapping(in, out, parentPath);
            logger.normal();
            logger.renameByResult();
        }
        catch (SAXParseException e) {
            exception = XMLSchemaErrorMessageHandler.createBizTranExcepton(AppMessage.IO_INFILE_ABNORMAL, e);
            logger.error(exception);
            logger.renameByResult();
            this.error(exception);
        }
        catch (BizTranException e) {
            logger.error(e);
            logger.renameByResult();
            this.error(e);
        }
        catch (OutOfMemoryError e2) {
            this.throwErrorForOutOfMemory(logger, e2);
        }
        catch (Throwable e2) {
            logger.error(AppMessage.JAVA_EXCEPTION, e2);
            logger.renameByResult();
            this.error(new BizTranException(AppMessage.JAVA_EXCEPTION, e2));
        }
    }

    public void loadMapping(String mapFile) throws MappingException {
        URL url = null;
        try {
            url = new URL(mapFile);
        }
        catch (MalformedURLException e) {
            File file = new File(mapFile);
            if (!file.exists()) {
                MappingException.error("INVALID_FILENAME", file.getAbsolutePath(), null);
            }
            try {
                url = file.toURL();
            }
            catch (Exception e1) {
                this.error(e1);
            }
        }
        XReader reader = null;
        try {
            InputStream is = url.openStream();
            reader = XReader.createReader(new InputStreamReader(is));
            reader.setSystemId(url.toString());
        }
        catch (IOException e1) {
            this.error(e1);
        }
        this.loadMapping(reader);
    }

    public void loadMapping(Reader in) throws MappingException {
        this.loadMapping(in, new com.argo21.common.util.Properties());
    }

    public void loadMapping(Reader in, com.argo21.common.util.Properties p) throws MappingException {
        XReader rd = in instanceof XReader ? (XReader)in : XReader.createReader(in);
        this.scriptEngine = ScriptEngine.getScriptEngine();
        try {
            this.parse(rd, p);
        }
        catch (Exception e) {
            this.error(e);
        }
    }

    @Override
    public void execMapping(Reader mapdef, Reader in, Writer out, String[] args) throws MappingException {
        BizTranException exception;
        Logger logger = LoggerFactory.getLogger();
        MappingInfo mapInfo = logger.getMappingInfo();
        mapInfo.setParameters(args);
        XReader rd = null;
        String parentPath = null;
        try {
            PassFile.getInstance();
            if (!PassFileUtil.isBizTran()) {
                throw new PassFileIllegalException("\u5546\u54c1\u8b58\u5225\u5b50\u304c\u4e0d\u6b63\u3067\u3059\u3002");
            }
            if (mapdef instanceof XReader) {
                rd = (XReader)mapdef;
                parentPath = rd.getParentPath();
            } else {
                rd = XReader.createReader(mapdef);
            }
            this.scriptEngine = ScriptEngine.getScriptEngine();
            VariableReference vref = this.scriptEngine.getVariableReference();
            com.argo21.common.util.Properties params = new com.argo21.common.util.Properties();
            if (args != null) {
                for (int i = 0; i < args.length; ++i) {
                    String s = args[i];
                    int k = s.indexOf("=");
                    if (k <= 0) continue;
                    String key = s.substring(0, k).trim();
                    String value = s.substring(k + 1).trim();
                    if (value.startsWith("\"") && value.endsWith("\"")) {
                        value = value.substring(1, value.length() - 1);
                    }
                    vref.putData(key, new XString(value));
                    params.repleace(key, value);
                }
            }
            this.parse(rd, params);
        }
        catch (PassFileIOException e2) {
            logger.error(AppMessage.PASSFILE_NOT_FOUND);
            logger.renameByResult();
            this.error(new BizTranException(AppMessage.PASSFILE_NOT_FOUND, (Throwable)e2));
        }
        catch (PassFileIllegalException e2) {
            logger.error(AppMessage.PASSFILE_CONTENT_ILLEGAL);
            logger.renameByResult();
            this.error(new BizTranException(AppMessage.PASSFILE_CONTENT_ILLEGAL, (Throwable)e2));
        }
        catch (SAXParseException e) {
            exception = XMLSchemaErrorMessageHandler.createBizTranExcepton(AppMessage.MAPFILE_CONTENT_ILLEGAL, e);
            logger.error(exception);
            logger.renameByResult();
            this.error(exception);
        }
        catch (OutOfMemoryError e2) {
            this.throwErrorForOutOfMemory(logger, e2);
        }
        catch (Throwable e2) {
            logger.error(AppMessage.JAVA_EXCEPTION, e2);
            logger.renameByResult();
            this.error(new BizTranException(AppMessage.JAVA_EXCEPTION, e2));
        }
        try {
            this.execMapping(in, out, parentPath);
            logger.normal();
            logger.renameByResult();
        }
        catch (BizTranException e) {
            logger.error(e);
            logger.renameByResult();
            this.error(e);
        }
        catch (SAXParseException e) {
            exception = XMLSchemaErrorMessageHandler.createBizTranExcepton(AppMessage.IO_INFILE_ABNORMAL, e);
            logger.error(exception);
            logger.renameByResult();
            this.error(exception);
        }
        catch (OutOfMemoryError e2) {
            this.throwErrorForOutOfMemory(logger, e2);
        }
        catch (Throwable e2) {
            logger.error(AppMessage.JAVA_EXCEPTION, e2);
            logger.renameByResult();
            this.error(new BizTranException(AppMessage.JAVA_EXCEPTION, e2));
        }
    }

    public void execMapping() throws MappingException, BizTranException {
        ScriptErrorHandler handler = new ScriptErrorHandler();
        this.scriptEngine.setErrorHandler(handler);
        Debug.println(MappingException.getMessage("ST_SCRIPT_RUNNING"));
        try {
            this.scriptEngine.execute();
        }
        catch (SAXException e) {
            throw new BizTranException(AppMessage.IO_INFILE_ABNORMAL, (Throwable)e);
        }
        Debug.println(MappingException.getMessage("ST_SCRIPT_TERMINATE"));
        handler.reset();
    }

    private void execMapping(InputStream in, OutputStream out, String mapPath) throws MappingException, BizTranException {
        try {
            for (int i = 0; i < this.msgcount; ++i) {
                BaseMessage msg = this.msglist[i];
                if (msg.getDirection() != "INPUT" || !msg.isStreamIO() || in == null) continue;
                Debug.println(MappingException.getMessage("ST_DOC_LOADING", msg.getMsgName()));
                msg.read(in);
                Debug.println(MappingException.getMessage("ST_DOC_LOADED"));
                boolean validateResult = msg.validateMessage(mapPath);
                if (validateResult) break;
                throw XMLSchemaErrorMessageHandler.createBizTranExcepton(AppMessage.XMLSCHEMA_INFILE_PARSE_FAIL, msg.getExceptions());
            }
            this.execMapping();
            boolean hasStremOut = false;
            for (int i = 0; i < this.msgcount; ++i) {
                BaseMessage msg = this.msglist[i];
                if (msg.getDirection() != "INPUT" && out != null && msg.isStreamIO() && !hasStremOut) {
                    boolean validateResult = msg.validateMessage(mapPath);
                    if (!validateResult) {
                        throw XMLSchemaErrorMessageHandler.createBizTranExcepton(AppMessage.XMLSCHEMA_OUTFILE_PARSE_FAIL, msg.getExceptions());
                    }
                    Debug.println(MappingException.getMessage("ST_DOC_SAVING", msg.getMsgName()));
                    msg.write(out);
                    Debug.println(MappingException.getMessage("ST_DOC_SAVED"));
                    msg.close();
                    hasStremOut = true;
                    continue;
                }
                msg.submit();
                msg.close();
            }
        }
        catch (BizTranException e) {
            throw e;
        }
        catch (MessageException e) {
            Exception e1 = e.getException();
            if (e1 instanceof IOException) {
                MappingException.error("IO_ERR", new String[]{e.getMessage()}, null);
            }
            this.error(e);
        }
        catch (Exception e) {
            this.error(e);
        }
    }

    private void execMapping(Reader in, Writer out, String mapPath) throws MappingException, BizTranException {
        try {
            for (int i = 0; i < this.msgcount; ++i) {
                BaseMessage msg = this.msglist[i];
                if (msg.getDirection() != "INPUT" || !msg.isStreamIO() || in == null) continue;
                Debug.println(MappingException.getMessage("ST_DOC_LOADING", msg.getMsgName()));
                msg.read(in);
                Debug.println(MappingException.getMessage("ST_DOC_LOADED"));
                boolean validateResult = msg.validateMessage(mapPath);
                if (validateResult) break;
                throw XMLSchemaErrorMessageHandler.createBizTranExcepton(AppMessage.XMLSCHEMA_INFILE_PARSE_FAIL, msg.getExceptions());
            }
            this.execMapping();
            boolean hasStremOut = false;
            for (int i = 0; i < this.msgcount; ++i) {
                BaseMessage msg = this.msglist[i];
                if (msg.getDirection() != "INPUT" && out != null && msg.isStreamIO() && !hasStremOut) {
                    boolean validateResult = msg.validateMessage(mapPath);
                    if (!validateResult) {
                        throw XMLSchemaErrorMessageHandler.createBizTranExcepton(AppMessage.XMLSCHEMA_OUTFILE_PARSE_FAIL, msg.getExceptions());
                    }
                    Debug.println(MappingException.getMessage("ST_DOC_SAVING", msg.getMsgName()));
                    msg.write(out);
                    Debug.println(MappingException.getMessage("ST_DOC_SAVED"));
                    msg.close();
                    hasStremOut = true;
                    continue;
                }
                msg.submit();
                msg.close();
            }
        }
        catch (BizTranException e) {
            throw e;
        }
        catch (MessageException e) {
            Exception e1 = e.getException();
            if (e1 instanceof IOException) {
                MappingException.error("IO_ERR", new String[]{e.getMessage()}, null);
            }
            this.error(e);
        }
        catch (Exception e) {
            this.error(e);
        }
    }

    private void loadInputFile(BaseMessage msg, String address, String mapPath) throws IOException, SAXException, BizTranException {
        URL url = null;
        try {
            url = new URL(address);
        }
        catch (MalformedURLException e) {
            url = new File(address).toURL();
        }
        Debug.println(MappingException.getMessage("ST_DOC_LOADING", msg.getMsgName()));
        MessageErrorHandler handler = new MessageErrorHandler();
        msg.setErrorHandler(handler);
        msg.read(url);
        Debug.println(MappingException.getMessage("ST_DOC_LOADED"));
        msg.setErrorHandler(null);
        boolean validateResult = msg.validateMessage(mapPath);
        if (!validateResult) {
            throw XMLSchemaErrorMessageHandler.createBizTranExcepton(AppMessage.XMLSCHEMA_INFILE_PARSE_FAIL, msg.getExceptions());
        }
    }

    private void writeToFile(BaseMessage msg, String address, String mapPath) throws IOException, SAXException, BizTranException {
        boolean validateResult = msg.validateMessage(mapPath);
        if (!validateResult) {
            throw XMLSchemaErrorMessageHandler.createBizTranExcepton(AppMessage.XMLSCHEMA_OUTFILE_PARSE_FAIL, msg.getExceptions());
        }
        if (folder) {
            address = address.concat(".").concat(msg.getExtension());
        }
        URL url = null;
        try {
            url = new URL(address);
        }
        catch (MalformedURLException e) {
            url = new File(address).toURL();
        }
        Debug.println(MappingException.getMessage("ST_DOC_SAVING", msg.getMsgName()));
        MessageErrorHandler handler = new MessageErrorHandler();
        msg.setErrorHandler(handler);
        if (url != null) {
            msg.write(url, false);
        }
        Debug.println(MappingException.getMessage("ST_DOC_SAVED"));
        msg.setErrorHandler(null);
    }

    private void execMapping(String mapFile, IOFile[] ioFiles, String[] args) throws MappingException, BizTranException {
        int i;
        InputStream is;
        URL url = null;
        String parentPath = null;
        try {
            url = new URL(mapFile);
        }
        catch (MalformedURLException e) {
            File file = new File(mapFile);
            if (!file.exists()) {
                throw new BizTranException(AppMessage.MAPFILE_NOT_FOUND);
            }
            try {
                url = file.toURL();
                parentPath = file.getParent();
            }
            catch (Exception e1) {
                throw new BizTranException(AppMessage.MAPFILE_NOT_FOUND);
            }
        }
        try {
            is = url.openStream();
        }
        catch (IOException e1) {
            throw new BizTranException(AppMessage.MAPFILE_NOT_FOUND);
        }
        XReader reader = XReader.createReader(new InputStreamReader(is), parentPath);
        reader.setSystemId(url.toString());
        this.scriptEngine = ScriptEngine.getScriptEngine();
        VariableReference vref = this.scriptEngine.getVariableReference();
        com.argo21.common.util.Properties params = new com.argo21.common.util.Properties();
        if (args != null) {
            for (int i2 = 0; i2 < args.length; ++i2) {
                String s = args[i2];
                int k = s.indexOf("=");
                if (k <= 0) continue;
                String key = s.substring(0, k).trim();
                String value = s.substring(k + 1).trim();
                if (value.startsWith("\"") && value.endsWith("\"") && value.length() > 1) {
                    value = value.substring(1, value.length() - 1);
                }
                vref.putData(key, new XString(value));
                params.repleace(key, value);
            }
        }
        try {
            this.parse(reader, params);
        }
        catch (SAXParseException e1) {
            BizTranException exception = XMLSchemaErrorMessageHandler.createBizTranExcepton(AppMessage.MAPFILE_CONTENT_ILLEGAL, e1);
            throw exception;
        }
        int inNo = 0;
        BaseMessage[] inMsgs = this.getInputMessages();
        for (int i3 = 0; i3 < ioFiles.length; ++i3) {
            BaseMessage msg;
            if (ioFiles[i3].io != 0) continue;
            String msgname = ioFiles[i3].name;
            if (msgname != null) {
                msg = this.getMessage(msgname);
                if (msg == null) {
                    MappingException.error("NODEF_MSG", msgname, null);
                }
                if (msg.getDirection() != "INPUT") {
                    MappingException.error("MSG_IODEF_ERR", msgname, null);
                }
                if (ioFiles[i3].file != null) {
                    try {
                        this.loadInputFile(msg, ioFiles[i3].file, parentPath);
                    }
                    catch (SAXParseException e) {
                        throw new BizTranException(AppMessage.IO_INFILE_ABNORMAL);
                    }
                    catch (SAXException e) {
                        throw new BizTranException(AppMessage.IO_INFILE_NOT_FOUND);
                    }
                    catch (IOException e) {
                        throw new BizTranException(AppMessage.IO_INFILE_NOT_FOUND);
                    }
                }
            } else if (inMsgs != null && inNo < inMsgs.length) {
                msg = inMsgs[inNo];
                if (ioFiles[i3].file != null) {
                    try {
                        this.loadInputFile(msg, ioFiles[i3].file, parentPath);
                    }
                    catch (SAXParseException e) {
                        throw new BizTranException(AppMessage.IO_INFILE_ABNORMAL);
                    }
                    catch (SAXException e) {
                        throw new BizTranException(AppMessage.IO_INFILE_NOT_FOUND);
                    }
                    catch (IOException e) {
                        throw new BizTranException(AppMessage.IO_INFILE_NOT_FOUND);
                    }
                }
            } else {
                MappingException.error("NODEF_MSG", String.valueOf(i3 + 1), null);
            }
            ++inNo;
        }
        this.execMapping();
        int outNo = 0;
        BaseMessage[] outMsgs = this.getOutputMessages();
        for (i = 0; i < ioFiles.length; ++i) {
            BaseMessage msg;
            if (ioFiles[i].io != 1) continue;
            String msgname = ioFiles[i].name;
            if (msgname != null) {
                msg = this.getMessage(msgname);
                if (msg == null) {
                    MappingException.error("NODEF_MSG", msgname, null);
                }
                if (msg.getDirection() == "INPUT") {
                    MappingException.error("MSG_IODEF_ERR", msgname, null);
                }
                if (ioFiles[i].file != null) {
                    try {
                        this.writeToFile(msg, ioFiles[i].file, parentPath);
                    }
                    catch (SAXException e) {
                        throw new BizTranException(AppMessage.IO_OUTFILE_WRITE_FAIL);
                    }
                    catch (IOException e) {
                        throw new BizTranException(AppMessage.IO_OUTFILE_WRITE_FAIL);
                    }
                }
            } else if (outMsgs != null && outNo < outMsgs.length) {
                msg = outMsgs[outNo];
                if (ioFiles[i].file != null) {
                    try {
                        this.writeToFile(msg, ioFiles[i].file, parentPath);
                    }
                    catch (SAXException e) {
                        throw new BizTranException(AppMessage.IO_OUTFILE_WRITE_FAIL);
                    }
                    catch (IOException e) {
                        throw new BizTranException(AppMessage.IO_OUTFILE_WRITE_FAIL);
                    }
                } else {
                    throw new BizTranException(AppMessage.IO_OUTFILE_WRITE_FAIL);
                }
            }
            ++outNo;
        }
        for (i = 0; i < this.msgcount; ++i) {
            BaseMessage msg = this.msglist[i];
            MessageErrorHandler handler = new MessageErrorHandler();
            msg.setErrorHandler(handler);
            try {
                msg.submit();
                msg.close();
            }
            catch (SAXException e) {
                this.error(e);
            }
            msg.setErrorHandler(null);
        }
    }

    public VariableReference getVariableReference() {
        return this.scriptEngine == null ? null : this.scriptEngine.getVariableReference();
    }

    @Override
    public BaseMessage[] getMessages() {
        if (this.msgcount == this.msglist.length) {
            return this.msglist;
        }
        BaseMessage[] msglist1 = new BaseMessage[this.msgcount];
        System.arraycopy(this.msglist, 0, msglist1, 0, this.msgcount);
        return msglist1;
    }

    @Override
    public BaseMessage[] getInputMessages() {
        int count2 = 0;
        for (int i = 0; i < this.msgcount; ++i) {
            if (this.msglist[i].getDirection() != "INPUT") continue;
            ++count2;
        }
        BaseMessage[] res = new BaseMessage[count2];
        count2 = 0;
        for (int i = 0; i < this.msgcount; ++i) {
            if (this.msglist[i].getDirection() != "INPUT") continue;
            res[count2++] = this.msglist[i];
        }
        return res;
    }

    @Override
    public BaseMessage[] getInputStreamMessages() {
        int count2 = 0;
        for (int i = 0; i < this.msgcount; ++i) {
            if (this.msglist[i].getDirection() != "INPUT" || !this.msglist[i].isStreamIO()) continue;
            ++count2;
        }
        BaseMessage[] res = new BaseMessage[count2];
        count2 = 0;
        for (int i = 0; i < this.msgcount; ++i) {
            if (this.msglist[i].getDirection() != "INPUT" || !this.msglist[i].isStreamIO()) continue;
            res[count2++] = this.msglist[i];
        }
        return res;
    }

    @Override
    public BaseMessage[] getOutputMessages() {
        int count2 = 0;
        for (int i = 0; i < this.msgcount; ++i) {
            if (this.msglist[i].getDirection() == "INPUT") continue;
            ++count2;
        }
        BaseMessage[] res = new BaseMessage[count2];
        count2 = 0;
        for (int i = 0; i < this.msgcount; ++i) {
            if (this.msglist[i].getDirection() == "INPUT") continue;
            res[count2++] = this.msglist[i];
        }
        return res;
    }

    @Override
    public BaseMessage[] getOutputStreamMessages() {
        int count2 = 0;
        for (int i = 0; i < this.msgcount; ++i) {
            if (this.msglist[i].getDirection() == "INPUT" || !this.msglist[i].isStreamIO()) continue;
            ++count2;
        }
        BaseMessage[] res = new BaseMessage[count2];
        count2 = 0;
        for (int i = 0; i < this.msgcount; ++i) {
            if (this.msglist[i].getDirection() == "INPUT" || !this.msglist[i].isStreamIO()) continue;
            res[count2++] = this.msglist[i];
        }
        return res;
    }

    @Override
    public BaseMessage getMessage(String msgName) {
        for (int i = 0; i < this.msgcount; ++i) {
            BaseMessage msg = this.msglist[i];
            if (!msgName.equals(msg.getMsgName())) continue;
            return msg;
        }
        return null;
    }

    @Override
    public BaseMessage getMessage(int order) {
        for (int i = 0; i < this.msgcount; ++i) {
            BaseMessage msg = this.msglist[i];
            if (msg.getOrder() != order) continue;
            return msg;
        }
        return null;
    }

    @Override
    public int[] getErrorRecords(String msgName, String tableName) {
        BaseMessage msg = this.getMessage(msgName);
        if (msg instanceof RdbMsg) {
            RdbMsg rdbMsg = (RdbMsg)msg;
            return rdbMsg.getErrorRecords(tableName);
        }
        return new int[0];
    }

    private void parse(XReader in, com.argo21.common.util.Properties params) throws SAXParseException {
        int msgNo = 0;
        boolean hasScript = false;
        in.peekWhitespace();
        while (!in.isEOF()) {
            String s;
            char c = in.getc();
            if (c == '#') {
                in.readLine();
                in.peekWhitespace();
                continue;
            }
            if (c != '[') {
                MappingException.error("INVAILD_CHAR", String.valueOf(c), (Locator)in);
            }
            if ((s = in.peekName()) == null) {
                c = in.getc();
                MappingException.error("INVAILD_CHAR", String.valueOf(c), (Locator)in);
            }
            if (!in.peekc(']')) {
                MappingException.error("NEED_CHAR", "]", (Locator)in);
            }
            in.peekSpace();
            c = in.getc();
            if (c == '\r') {
                c = in.getc();
                if (c != '\n') {
                    in.ungetc();
                }
            } else {
                c = in.getc();
                if (c != '\n') {
                    in.ungetc();
                }
            }
            if (s.equals("MSGDECL")) {
                if (hasScript) {
                    MappingException.error("MUST_BEFOR_PARA", new Object[]{"[MSGDECL]", "[SCRIPT]"}, (Locator)in);
                }
                int firstLine = in.getLineNumber();
                BaseMessage msg = this.parseMessage(in, params);
                int totalLines = in.getLineNumber() - firstLine;
                if (msg != null) {
                    msg.setOrder(msgNo);
                    msg.setFirstLine(firstLine);
                    msg.setTotalLines(totalLines);
                    ++msgNo;
                    if (this.msgcount == this.msglist.length) {
                        BaseMessage[] tmp = new BaseMessage[this.msglist.length + 1];
                        System.arraycopy(this.msglist, 0, tmp, 0, this.msglist.length);
                        this.msglist = tmp;
                    }
                    this.msglist[this.msgcount++] = msg;
                }
            } else if (s.equals("SCRIPT")) {
                if (hasScript) {
                    MappingException.error("DOUBLE_PARA", "[SCRIPT]", (Locator)in);
                } else if (msgNo == 0) {
                    MappingException.error("MUST_BEFOR_PARA", new Object[]{"[MSGDECL]", "[SCRIPT]"}, (Locator)in);
                }
                VariableReference ref = this.scriptEngine.getVariableReference();
                for (int i = 0; i < this.msgcount; ++i) {
                    Variable v = new Variable(this.msglist[i].getMsgName(), new XObject(this.msglist[i]));
                    ref.putFixVariable(v);
                }
                this.scriptEngine.loadScripts(in);
            } else {
                MappingException.error("INVAILD_PARA", "[" + s + "]", (Locator)in);
            }
            in.peekWhitespace();
        }
    }

    private BaseMessage parseMessage(XReader in, com.argo21.common.util.Properties params) throws SAXParseException {
        char c;
        com.argo21.common.util.Properties properties = new com.argo21.common.util.Properties();
        BaseMessage msg = null;
        in.peekWhitespace();
        while ((c = in.getc()) != '\u0000') {
            if (c == '#') {
                in.readLine();
                in.peekWhitespace();
                continue;
            }
            in.ungetc();
            if (c == '[') break;
            if (c == '<') {
                if (msg == null) {
                    msg = this.createMessage(properties, params, in);
                }
                msg.readSchema(in);
                in.peekWhitespace();
                break;
            }
            String propertyname = in.peekName();
            if (propertyname == null) {
                MessageException.error("INVAILD_CHAR", String.valueOf(c), (Locator)in);
            }
            in.peekSpace();
            if (!in.peekc('=')) {
                MessageException.error("NEED_CHAR", "=", (Locator)in);
            }
            in.peekSpace();
            String propertyvalue = null;
            propertyvalue = in.readToEol();
            propertyvalue = propertyvalue.trim();
            if (propertyvalue.equals("")) {
                MessageException.error("INVALID_PARAM", new Object[]{propertyname, propertyvalue}, (Locator)in);
            }
            if ((propertyvalue = MappingProcessor.parseSpecialChar(propertyvalue)).equals("null")) {
                propertyvalue = null;
            }
            if (properties.contain(propertyname)) {
                MessageException.error("DOUBLE_PARAM", propertyname, (Locator)in);
            }
            properties.append(propertyname, propertyvalue);
            in.peekWhitespace();
        }
        if (msg == null) {
            msg = this.createMessage(properties, params, in);
        }
        return msg;
    }

    private BaseMessage createMessage(com.argo21.common.util.Properties properties, com.argo21.common.util.Properties params, XReader in) throws MappingException, MessageException {
        String msgname;
        String msgtype = properties.getValue("type", null);
        if (msgtype == null) {
            MappingException.error("NEED_MSGTYPE", new Object[0], (Locator)in);
        }
        if ((msgname = properties.getValue("name", null)) == null) {
            MappingException.error("NEED_MSGNAME", new Object[0], (Locator)in);
        }
        if (this.getMessage(msgname) != null) {
            MappingException.error("DOUBLE_MSGNAME", msgname, (Locator)in);
        }
        BaseMessage msg = MessageFactory.getInstance().createMessage(msgtype);
        msg.setProperties(properties);
        msg.setPrameters(params);
        return msg;
    }

    private void error(Exception exception) throws MappingException {
        if (exception instanceof MappingException) {
            throw (MappingException)exception;
        }
        if (exception instanceof SAXParseException) {
            SAXParseException spe = (SAXParseException)exception;
            throw new MappingException(spe.getMessage(), spe.getPublicId(), spe.getSystemId(), spe.getLineNumber(), spe.getColumnNumber(), spe.getException());
        }
        if (exception instanceof SAXException) {
            SAXException se = (SAXException)exception;
            throw new MappingException(se.getMessage(), "", "", 0, 0, se.getException());
        }
        throw new MappingException(exception.getMessage(), "", "", 0, 0, exception);
    }

    public static String parseSpecialChar(String str) {
        int k;
        if (str == null) {
            return null;
        }
        int n = str.length();
        for (k = 0; k < n && str.charAt(k) != '&'; ++k) {
        }
        if (k == n) {
            return str;
        }
        StringBuffer sb = new StringBuffer();
        if (k > 0) {
            sb.append(str.substring(0, k));
        }
        while (k < n) {
            char c = str.charAt(k);
            if (c == '&') {
                int k1 = k + 1;
                if (k1 < n && str.charAt(k1) == '#') {
                    int k2;
                    int base = 10;
                    if (++k1 < n && (str.charAt(k1) == 'x' || str.charAt(k1) == 'x')) {
                        base = 16;
                    }
                    for (k2 = ++k1; k2 < n && str.charAt(k2) != ';'; ++k2) {
                    }
                    if (k2 <= n && k2 > k1) {
                        String strnum = str.substring(k1, k2);
                        try {
                            int num = Integer.parseInt(strnum, base);
                            sb.append((char)num);
                            k = k2 + 1;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (k >= k2) continue;
                    sb.append(str.substring(k, k2));
                    k = k2;
                    continue;
                }
                sb.append(c);
                ++k;
                continue;
            }
            sb.append(c);
            ++k;
        }
        return sb.toString();
    }

    public static String makeSpecialChar(String str) {
        int k;
        if (str == null) {
            return null;
        }
        int n = str.length();
        char c = '\u0000';
        for (k = 0; k < n && (c = str.charAt(k)) != '\r' && c != '\b' && c != '\n' && c != '%' && c != '*' && c != '[' && c != ']' && c != '<' && c != '>' && c != '&'; ++k) {
        }
        if (k == n) {
            return str;
        }
        StringBuffer sb = new StringBuffer();
        if (k > 0) {
            sb.append(str.substring(0, k));
        }
        sb.append("&#");
        sb.append((int)c);
        sb.append(';');
        if (++k < n) {
            c = str.charAt(k);
            if (c == '\r' || c == '\b' || c == '\n' || c == '%' || c == '*' || c == '[' || c == ']' || c == '<' || c == '>' || c == '&') {
                sb.append("&#");
                sb.append((int)c);
                sb.append(';');
            } else {
                sb.append(c);
            }
        }
        return sb.toString();
    }

    private void throwErrorForOutOfMemory(Logger logger, OutOfMemoryError e) throws MappingException {
        MappingProcessor.logWriterForOutOfMemory(logger, e);
        while (true) {
            try {
                this.error(new BizTranException(AppMessage.JAVA_OUTOFMOMERY_EXCEPTION, (Throwable)e));
            }
            catch (OutOfMemoryError e3) {
                System.gc();
                continue;
            }
            break;
        }
    }

    private static void logWriterForOutOfMemory(Logger logger, OutOfMemoryError e) {
        System.gc();
        while (true) {
            try {
                logger.error(AppMessage.JAVA_OUTOFMOMERY_EXCEPTION, e);
            }
            catch (OutOfMemoryError e3) {
                System.gc();
                continue;
            }
            break;
        }
        while (true) {
            try {
                logger.renameByResult();
            }
            catch (OutOfMemoryError e3) {
                System.gc();
                continue;
            }
            break;
        }
    }

    static {
        String name2;
        File parent;
        File file;
        folder = false;
        version = false;
        HOME_DIR = System.getProperty("user.home", ".");
        File f = new File(HOME_DIR, ".esooner");
        if (!f.exists()) {
            try {
                f.mkdirs();
            }
            catch (Exception e) {
                System.err.println(e);
            }
        }
        File MapEditorINIfile = new File(f, "MappingEditor.ini");
        MapEditorINI = MapEditorINIfile.getPath();
        URL resource = ClassLoader.getSystemResource("com/argo21/map/MappingProcessor.class");
        if (resource != null) {
            if ("file".equals(resource.getProtocol())) {
                try {
                    USER_DIR = FileEx.urlToFile(new URL(resource, "../../../"));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (USER_DIR != null) {
                    file = new File(USER_DIR);
                    parent = file.getParentFile();
                    name2 = file.getName();
                    if ("out".equals(name2) && parent != null) {
                        USER_DIR = parent.getAbsolutePath();
                    }
                }
            } else if ("jar".equals(resource.getProtocol())) {
                try {
                    JarURLConnection connect = (JarURLConnection)resource.openConnection();
                    LIB_DIR = FileEx.urlToFile(new URL(connect.getJarFileURL(), "./"));
                }
                catch (Exception connect) {
                    // empty catch block
                }
                if (LIB_DIR != null) {
                    USER_DIR = new File(LIB_DIR).getParent();
                }
            }
        }
        if (USER_DIR == null || !new File(USER_DIR).isDirectory()) {
            file = new File(System.getProperty("user.dir", "."));
            parent = file.getParentFile();
            name2 = file.getName();
            USER_DIR = (name2.startsWith("bin") || "src".equals(name2)) && parent != null ? parent.getAbsolutePath() : file.getAbsolutePath();
        }
    }

    static class RDBChecker {
        static int NOUSE = 0;
        static int INPUT = 1;
        static int OUTPUT = 2;
        static int INPUT_AND_OUTPUT = 3;

        RDBChecker() {
        }

        static int isUsingRDB(String mapFileName, File logFile) {
            File mapFile = new File(mapFileName);
            if (!mapFile.exists()) {
                MappingProcessor.useage(logFile, "MAP\u30d5\u30a1\u30a4\u30eb\u304c\u5b58\u5728\u3057\u307e\u305b\u3093");
                System.exit(3);
            }
            if (!mapFile.isFile()) {
                MappingProcessor.useage(logFile, "MAP\u30d5\u30a1\u30a4\u30eb\u304c\u30d5\u30a1\u30a4\u30eb\u3067\u3042\u308a\u307e\u305b\u3093");
                System.exit(3);
            }
            int result = NOUSE;
            boolean isInput = false;
            boolean isOutput = false;
            try {
                FileReader mapReader = new FileReader(mapFile);
                BufferedReader mapBufferedReader = new BufferedReader(mapReader);
                ArrayList<String> RDBList = new ArrayList<String>();
                String line = mapBufferedReader.readLine();
                while (line != null) {
                    block21: {
                        block20: {
                            if (!line.equals("[MSGDECL]")) break block20;
                            String name2 = null;
                            boolean isRDB = false;
                            while (!(line = mapBufferedReader.readLine()).startsWith("[")) {
                                if (line.startsWith("name=")) {
                                    name2 = line.substring(5).trim();
                                }
                                if (!line.equals("type=RDB")) continue;
                                isRDB = true;
                            }
                            if (!isRDB) break block21;
                            RDBList.add(name2);
                            break block21;
                        }
                        if (line.equals("[SCRIPT]")) {
                            while (RDBList.size() != 0 && (line = mapBufferedReader.readLine()) != null) {
                                int equal = line.indexOf("=");
                                if (equal > 0) {
                                    int i;
                                    ArrayList removeList = new ArrayList();
                                    for (i = 0; i < RDBList.size(); ++i) {
                                        int msg = line.indexOf((String)RDBList.get(i));
                                        if (msg < 0) continue;
                                        if (msg < equal) {
                                            isOutput = true;
                                            removeList.add(RDBList.get(i));
                                            continue;
                                        }
                                        if (msg <= equal) continue;
                                        isInput = true;
                                        removeList.add(RDBList.get(i));
                                    }
                                    if (removeList.size() > 0) {
                                        for (i = 0; i < removeList.size(); ++i) {
                                            RDBList.remove(removeList.get(i));
                                        }
                                    }
                                }
                                if (!isInput || !isOutput) continue;
                                break;
                            }
                        }
                    }
                    line = mapBufferedReader.readLine();
                }
                mapBufferedReader.close();
                mapReader.close();
            }
            catch (FileNotFoundException e) {
                MappingProcessor.useage(logFile, "");
                System.exit(3);
            }
            catch (IOException e) {
                MappingProcessor.useage(logFile, "");
                System.exit(3);
            }
            if (isInput && isOutput) {
                result = INPUT_AND_OUTPUT;
            } else if (isInput) {
                result = INPUT;
            } else if (isOutput) {
                result = OUTPUT;
            }
            return result;
        }
    }

    static class IOFile {
        public String name;
        public String file;
        public int io;

        public IOFile(String name2, String file, int io) {
            this.name = name2;
            this.io = io;
            this.file = file;
        }
    }
}

