/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.map;

import com.argo21.common.io.Debug;
import com.argo21.common.io.FileEx;
import com.argo21.common.io.XReader;
import com.argo21.common.lang.Variable;
import com.argo21.common.lang.VariableReference;
import com.argo21.common.lang.XObject;
import com.argo21.common.lang.XString;
import com.argo21.common.log.AppMessage;
import com.argo21.common.log.BizTranException;
import com.argo21.common.log.Logger;
import com.argo21.common.log.LoggerFactory;
import com.argo21.common.log.WriterMode;
import com.argo21.common.log.XMLSchemaErrorMessageHandler;
import com.argo21.common.util.BizTranUtil;
import com.argo21.common.util.MappingInfo;
import com.argo21.common.util.MultiProcessUtil;
import com.argo21.common.util.PassFileUtil;
import com.argo21.common.util.ProcessIdGetter;
import com.argo21.js.ScriptEngine;
import com.argo21.js.ScriptErrorHandler;
import com.argo21.map.ArgumentAnalyzer2;
import com.argo21.map.IOFile;
import com.argo21.map.Mapping2;
import com.argo21.map.MappingException;
import com.argo21.map.table.BizTranTableFileException;
import com.argo21.map.table.TableFileAnalyzer;
import com.argo21.msg.BaseMessage;
import com.argo21.msg.MessageErrorHandler;
import com.argo21.msg.MessageException;
import com.argo21.msg.MessageFactory;
import com.argo21.msg.division.DivisionProperties;
import com.argo21.msg.division.input.InputMessageDivisioner;
import com.argo21.msg.division.output.OutputMessageUnioner;
import com.argo21.msg.rdb.RdbConnector;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.sql.Driver;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Properties;
import java.util.StringTokenizer;
import jp.co.argo21.nts.commons.passfile.PassFile;
import jp.co.argo21.nts.commons.passfile.PassFileArgumentException;
import jp.co.argo21.nts.commons.passfile.PassFileIOException;
import jp.co.argo21.nts.commons.passfile.PassFileIllegalException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public final class MappingProcessor2
implements Mapping2 {
    static String MapEditorINI;
    static String USER_DIR;
    static String LIB_DIR;
    static boolean folder;
    static String exst;
    static final String HOME_DIR;
    private static boolean isAddDecimalZero;
    private boolean testFlag = false;
    private BaseMessage[] msglist = new BaseMessage[2];
    private int msgcount = 0;
    private ScriptEngine scriptEngine;

    public static void setIsAddDecimalZero(boolean _isAddDecimalZero) {
        isAddDecimalZero = _isAddDecimalZero;
    }

    public static boolean getIsAddDecimalZero() {
        return isAddDecimalZero;
    }

    public void setTestFlag(boolean testFlag) {
        this.testFlag = testFlag;
    }

    public static void main(String[] args) {
        int returnCode = AppMessage.NORMAL_EXIT.getCode();
        Logger logger = LoggerFactory.getLogger();
        MappingInfo mapInfo = logger.getMappingInfo();
        try {
            PassFile passFile = PassFile.getInstance();
            if (!PassFileUtil.isBizTran()) {
                throw new PassFileIllegalException("\u5546\u54c1\u8b58\u5225\u5b50\u304c\u4e0d\u6b63\u3067\u3059\u3002");
            }
            new ArgumentAnalyzer2().analyze(args, mapInfo);
            folder = mapInfo.isFolder();
            if (mapInfo.isVersion()) {
                logger.deleteLogFile();
                System.out.println("BizTran");
                System.out.println("(C)2003-2018 Canon IT Solutions Inc. All Right Reserved.");
                System.out.println("Version    " + passFile.getValueByString(PassFileUtil.VERSION_NO.getBeginIndex(), PassFileUtil.VERSION_NO.getEndIndex()));
                System.out.println("Serial No  " + passFile.getSerialNo(PassFileUtil.DECODE_KEY));
                System.exit(AppMessage.NORMAL_EXIT.getCode());
            }
            MappingProcessor2 mapping = new MappingProcessor2();
            returnCode = mapping.execMapping(logger, mapInfo);
            System.exit(returnCode);
        }
        catch (PassFileIOException e) {
            logger.error(AppMessage.PASSFILE_NOT_FOUND);
            logger.renameByResult();
            System.err.println(AppMessage.PASSFILE_NOT_FOUND.getMessage());
            System.exit(AppMessage.PASSFILE_NOT_FOUND.getCode());
        }
        catch (PassFileIllegalException e) {
            logger.error(AppMessage.PASSFILE_CONTENT_ILLEGAL);
            logger.renameByResult();
            System.err.println(AppMessage.PASSFILE_CONTENT_ILLEGAL.getMessage());
            System.exit(AppMessage.PASSFILE_CONTENT_ILLEGAL.getCode());
        }
        catch (PassFileArgumentException e) {
            logger.error(AppMessage.PASSFILE_CONTENT_ILLEGAL);
            logger.renameByResult();
            System.err.println(AppMessage.PASSFILE_CONTENT_ILLEGAL.getMessage());
            System.exit(AppMessage.PASSFILE_CONTENT_ILLEGAL.getCode());
        }
        catch (BizTranException e) {
            logger.error(e);
            logger.renameByResult();
            System.exit(e.getStsCode());
        }
        catch (BizTranTableFileException e) {
            logger.error(AppMessage.IO_TABLE_INFILE_ABNORMAL, e);
            logger.renameByResult();
            System.exit(AppMessage.IO_TABLE_INFILE_ABNORMAL.getCode());
        }
        catch (OutOfMemoryError e) {
            MappingProcessor2.logWriterForOutOfMemory(logger, e);
            System.exit(AppMessage.JAVA_OUTOFMOMERY_EXCEPTION.getCode());
        }
        catch (Throwable e) {
            logger.error(AppMessage.JAVA_EXCEPTION, e);
            logger.renameByResult();
            System.exit(AppMessage.JAVA_EXCEPTION.getCode());
        }
    }

    @Override
    public int execMapping(String mapFilePath, String inputFilePath, String tableFilePath, String outputFilePath, String logFilePath, boolean doOverWriteLog, String[] params, boolean doValidation, boolean postscriptFlag) {
        return this.execMapping(mapFilePath, inputFilePath, tableFilePath, outputFilePath, logFilePath, doOverWriteLog, params, true, doValidation, null, postscriptFlag);
    }

    @Override
    public int execMapping(String mapFilePath, String inputFilePath, String tableFilePath, String outputFilePath, String logFilePath, boolean doOverWriteLog, String[] params, boolean postscriptFlag) {
        return this.execMapping(mapFilePath, inputFilePath, tableFilePath, outputFilePath, logFilePath, doOverWriteLog, params, false, false, null, postscriptFlag);
    }

    @Override
    public int execMapping(String mapFilePath, String inputFilePath, String tableFilePath, String divisionPropFilePath, String outputFilePath, String logFilePath, boolean doOverWriteLog, String[] params, boolean doValidation, boolean postscriptFlag) {
        return this.execMapping(mapFilePath, inputFilePath, tableFilePath, outputFilePath, logFilePath, doOverWriteLog, params, true, doValidation, divisionPropFilePath, postscriptFlag);
    }

    @Override
    public int execMapping(String mapFilePath, String inputFilePath, String tableFilePath, String divisionPropFilePath, String outputFilePath, String logFilePath, boolean doOverWriteLog, String[] params, boolean postscriptFlag) {
        return this.execMapping(mapFilePath, inputFilePath, tableFilePath, outputFilePath, logFilePath, doOverWriteLog, params, false, false, divisionPropFilePath, postscriptFlag);
    }

    private synchronized int execMapping(String mapFilePath, String inputFilePath, String tableFilePath, String outputFilePath, String logFilePath, boolean doOverWriteLog, String[] params, boolean overwriteValidationFlag, boolean doValidation, String divisionPropFilePath, boolean postscriptFlag) {
        int returnCode = AppMessage.NORMAL_EXIT.getCode();
        Logger logger = LoggerFactory.getAPILogger();
        MappingInfo mapInfo = logger.getMappingInfo();
        try {
            mapInfo.setMapFilePath(mapFilePath);
            mapInfo.setInputFilePath(inputFilePath);
            mapInfo.setTableFilePath(tableFilePath);
            mapInfo.setOutputFilePath(outputFilePath);
            mapInfo.setLogFilePath(logFilePath);
            if (doOverWriteLog) {
                mapInfo.setWriteMode(WriterMode.UPDATE);
            } else {
                mapInfo.setWriteMode(WriterMode.APPEND);
            }
            mapInfo.setParameters(params);
            mapInfo.setOverwriteValidationFlag(overwriteValidationFlag);
            mapInfo.setDoValidation(doValidation);
            if (divisionPropFilePath != null) {
                mapInfo.setDoDivide(true);
                mapInfo.setDividePropFilePath(divisionPropFilePath);
            }
            mapInfo.setPostscriptFlag(postscriptFlag);
            returnCode = this.execMapping(logger, mapInfo);
        }
        catch (BizTranException e) {
            logger.error(e);
            logger.renameByResult();
            returnCode = e.getStsCode();
        }
        catch (BizTranTableFileException e) {
            logger.error(AppMessage.IO_TABLE_INFILE_ABNORMAL, e);
            logger.renameByResult();
            returnCode = AppMessage.IO_TABLE_INFILE_ABNORMAL.getCode();
        }
        catch (OutOfMemoryError e) {
            MappingProcessor2.logWriterForOutOfMemory(logger, e);
            returnCode = AppMessage.JAVA_OUTOFMOMERY_EXCEPTION.getCode();
        }
        catch (Throwable e) {
            e.printStackTrace();
            logger.error(AppMessage.JAVA_EXCEPTION, e);
            logger.renameByResult();
            returnCode = AppMessage.JAVA_EXCEPTION.getCode();
        }
        LoggerFactory.deleteLogger();
        return returnCode;
    }

    protected int execMapping(Logger logger, MappingInfo mapInfo) throws BizTranTableFileException, BizTranException, MappingException {
        int returnCode = AppMessage.NORMAL_EXIT.getCode();
        if (isAddDecimalZero) {
            String[] mapIO = BizTranUtil.getMapIOMessageType(mapInfo.getMapFilePath());
            if (!"FIX".equals(mapIO[0])) {
                throw new BizTranException(AppMessage.ARG_ADDDECIMAL_NOT_FIXTOXML);
            }
            if (!"XSD".equals(mapIO[1])) {
                throw new BizTranException(AppMessage.ARG_ADDDECIMAL_NOT_FIXTOXML);
            }
        }
        folder = mapInfo.isFolder();
        if (mapInfo.getLogFilePath() != null) {
            logger.addLog(mapInfo.getLogFilePath(), mapInfo.getWriteMode());
        }
        TableFileAnalyzer tableFile = new TableFileAnalyzer();
        if (mapInfo.getTableFilePath() != null) {
            tableFile.analyzeTableFile(mapInfo.getTableFilePath());
        }
        DivisionProperties divProp = null;
        if (mapInfo.isDoDivide()) {
            divProp = new DivisionProperties(mapInfo);
            if (mapInfo.isPostscriptFlag() && "XML".equals(divProp.getOutputMsgType())) {
                throw new BizTranException(AppMessage.ARG_POSTSCRIPT_XML);
            }
        }
        ArrayList<IOFile[]> ioList = new ArrayList<IOFile[]>();
        if (mapInfo.isFolder()) {
            File iFolder = new File(mapInfo.getInputFilePath());
            String[] inputFiles = iFolder.list();
            if (inputFiles == null || inputFiles.length == 0) {
                throw new BizTranException(AppMessage.IO_INFILE_NOT_FOUND);
            }
            for (int j = 0; j < inputFiles.length; ++j) {
                String inputPath = FilenameUtils.concat((String)mapInfo.getInputFilePath(), (String)inputFiles[j]);
                if (!new File(inputPath).isFile()) continue;
                int lastIndex = inputFiles[j].lastIndexOf(".");
                if (lastIndex < 0) {
                    lastIndex = inputFiles[j].length();
                }
                String outputFile = inputFiles[j].substring(0, lastIndex);
                String outputPath = FilenameUtils.concat((String)mapInfo.getOutputFilePath(), (String)outputFile);
                IOFile[] iofilesNow = new IOFile[2 + tableFile.getTableMsgNum()];
                iofilesNow[0] = new IOFile(tableFile.getMainMsg(), inputPath, IOFile.INPUT);
                iofilesNow[1] = new IOFile(mapInfo.getOutputMsg(), outputPath, IOFile.OUTPUT);
                tableFile.getTableFiles(iofilesNow);
                ioList.add(iofilesNow);
            }
        } else {
            IOFile[] iofilesNow = new IOFile[2 + tableFile.getTableMsgNum()];
            iofilesNow[0] = new IOFile(tableFile.getMainMsg(), mapInfo.getInputFilePath(), IOFile.INPUT);
            iofilesNow[1] = new IOFile(mapInfo.getOutputMsg(), mapInfo.getOutputFilePath(), IOFile.OUTPUT);
            tableFile.getTableFiles(iofilesNow);
            ioList.add(iofilesNow);
        }
        BizTranException tempe = null;
        for (IOFile[] iofilesNow : ioList) {
            this.msglist = new BaseMessage[2];
            this.msgcount = 0;
            this.scriptEngine = null;
            Debug.setPrintWriter(new PrintWriter(System.out, true));
            Debug.enDebug = true;
            String inputFile = null;
            String outputFile = null;
            if (iofilesNow[0].io == IOFile.INPUT) {
                inputFile = iofilesNow[0].file;
                outputFile = iofilesNow[1].file;
            } else {
                inputFile = iofilesNow[1].file;
                outputFile = iofilesNow[0].file;
            }
            boolean isToXML = MultiProcessUtil.isOutputTypeXML(mapInfo.getMapFilePath());
            if (isToXML) {
                try {
                    MultiProcessUtil.lockOutputFile(outputFile);
                }
                catch (BizTranException e) {
                    logger.error(e);
                    returnCode = e.getStsCode();
                    logger.renameByResult();
                    return returnCode;
                }
            }
            if (mapInfo.isDoDivide()) {
                try {
                    this.divideAndExecute(inputFile, outputFile, divProp, mapInfo, iofilesNow, logger, true);
                }
                catch (BizTranException e) {
                    if (returnCode == AppMessage.NORMAL_EXIT.getCode()) {
                        returnCode = e.getStsCode();
                    }
                    logger.error(e);
                }
            } else {
                block27: {
                    mapInfo.setInputFilePath(inputFile);
                    mapInfo.setOutputFilePath(outputFile);
                    try {
                        this.execMapping(mapInfo.getMapFilePath(), iofilesNow, mapInfo.getParameters(), mapInfo.isOverwriteValidationFlag(), mapInfo.isDoValidation(), mapInfo.isPostscriptFlag());
                    }
                    catch (BizTranException e) {
                        tempe = e;
                        if (returnCode != AppMessage.NORMAL_EXIT.getCode()) break block27;
                        returnCode = e.getStsCode();
                    }
                }
                if (tempe == null) {
                    logger.normal();
                } else {
                    logger.error(tempe);
                    tempe = null;
                }
            }
            if (!isToXML) continue;
            MultiProcessUtil.releaseOutputFile();
        }
        logger.renameByResult();
        return returnCode;
    }

    private void checkMsg(IOFile[] iofilesNow) throws BizTranTableFileException {
        for (int i = 0; i < this.msgcount; ++i) {
            if (this.msglist[i].getDirection() != "INPUT") continue;
            boolean existFlag = false;
            String msgName = this.msglist[i].getMsgName();
            for (int j = 0; j < iofilesNow.length; ++j) {
                if (!msgName.equals(iofilesNow[j].name)) continue;
                existFlag = true;
                break;
            }
            if (existFlag) continue;
            throw new BizTranTableFileException("\u5909\u63db\u88dc\u52a9\u30d5\u30a1\u30a4\u30eb\u3067\u3001\u30e1\u30c3\u30bb\u30fc\u30b8" + msgName + "\u306b\u5bfe\u5fdc\u3059\u308b\u30d5\u30a1\u30a4\u30eb\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
        }
    }

    public static Mapping2 createMappingProcessor2() {
        return new MappingProcessor2();
    }

    protected MappingProcessor2() {
        this.init();
    }

    private void init() {
        String jdbc_path;
        File f;
        String s = System.getProperty("jdbc.driver", null);
        if (s == null && (f = new File(MapEditorINI)).isFile() && f.exists()) {
            try {
                FileInputStream in = new FileInputStream(f);
                Properties ps = new Properties();
                ps.load(in);
                s = ps.getProperty("jdbc.driver", null);
                jdbc_path = ps.getProperty("jdbc.path");
                if (jdbc_path != null) {
                    System.setProperty("jdbc.path", jdbc_path);
                }
            }
            catch (Exception in) {
                // empty catch block
            }
        }
        if (s != null) {
            URL[] urls;
            StringTokenizer st;
            URLClassLoader loader = null;
            jdbc_path = System.getProperty("jdbc.path");
            if (jdbc_path != null) {
                st = new StringTokenizer(jdbc_path, ";");
                int count2 = st.countTokens();
                if (count2 > 0) {
                    urls = new URL[count2];
                    int k = 0;
                    for (int i = 0; i < count2; ++i) {
                        try {
                            File file2 = new File(st.nextToken());
                            urls[k++] = file2.toURL();
                            continue;
                        }
                        catch (Exception file2) {
                            // empty catch block
                        }
                    }
                    if (k < count2) {
                        URL[] newUrls = new URL[k];
                        System.arraycopy(urls, 0, newUrls, 0, k);
                        urls = newUrls;
                    }
                    loader = new URLClassLoader(urls);
                }
            } else {
                File file = null;
                file = LIB_DIR != null ? new File(LIB_DIR) : new File(USER_DIR, "lib");
                File[] fileList = file.listFiles();
                if (fileList != null) {
                    int count3 = fileList.length;
                    urls = new URL[count3 + 1];
                    int k = 0;
                    try {
                        urls[k++] = file.toURL();
                    }
                    catch (Exception file2) {
                        // empty catch block
                    }
                    for (int i = 0; i < count3; ++i) {
                        try {
                            if (!fileList[i].isFile()) continue;
                            urls[k++] = fileList[i].toURL();
                            continue;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (k < count3 + 1) {
                        URL[] newUrls = new URL[k];
                        System.arraycopy(urls, 0, newUrls, 0, k);
                        urls = newUrls;
                    }
                    loader = new URLClassLoader(urls);
                }
            }
            st = new StringTokenizer(s, ";");
            while (st.hasMoreTokens()) {
                String driver = (String)st.nextElement();
                try {
                    if (loader != null) {
                        RdbConnector.registerDriver((Driver)loader.loadClass(driver).newInstance());
                        continue;
                    }
                    RdbConnector.registerDriver((Driver)Class.forName(driver).newInstance());
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
                catch (InstantiationException instantiationException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    private void execMapping() throws MappingException, BizTranException {
        ScriptErrorHandler handler = new ScriptErrorHandler();
        this.scriptEngine.setErrorHandler(handler);
        try {
            this.scriptEngine.execute();
        }
        catch (SAXException e) {
            throw new BizTranException(AppMessage.IO_INFILE_ABNORMAL, (Throwable)e);
        }
        handler.reset();
    }

    private void loadInputFile(BaseMessage msg, String address, String mapPath) throws IOException, SAXException, BizTranException {
        URL url = null;
        try {
            url = new URL(address);
        }
        catch (MalformedURLException e) {
            url = new File(address).toURL();
        }
        MessageErrorHandler handler = new MessageErrorHandler();
        msg.setErrorHandler(handler);
        msg.read(url);
        msg.setErrorHandler(null);
        boolean validateResult = msg.validateMessage(mapPath);
        if (!validateResult) {
            throw XMLSchemaErrorMessageHandler.createBizTranExcepton(AppMessage.XMLSCHEMA_INFILE_PARSE_FAIL, msg.getExceptions());
        }
    }

    private void writeToFile(BaseMessage msg, String address, String mapPath, boolean postscriptFlag) throws IOException, SAXException, BizTranException {
        if (folder) {
            address = address.concat(".").concat(msg.getExtension());
            exst = msg.getExtension();
        }
        URL url = null;
        try {
            url = new URL(address);
        }
        catch (MalformedURLException e) {
            url = new File(address).toURL();
        }
        if (msg.doValidate()) {
            this.validateOutputMessage(msg, mapPath, new File(url.getFile()).getName());
        }
        MessageErrorHandler handler = new MessageErrorHandler();
        msg.setErrorHandler(handler);
        if (url != null) {
            msg.write(url, postscriptFlag);
        }
        msg.setErrorHandler(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateOutputMessage(BaseMessage msg, String mapPath, String outputFileName) throws IOException, SAXException, BizTranException {
        String tmpFolderName = null;
        String ngFolderName = null;
        tmpFolderName = BizTranUtil.getMappingFolderPath();
        ngFolderName = tmpFolderName.concat(File.separator).concat("ValidateNG");
        File tmpFolder = new File(tmpFolderName = tmpFolderName.concat(File.separator).concat(ProcessIdGetter.getProcessIdWithDateWithCounter()));
        if (!tmpFolder.mkdirs()) {
            throw new BizTranException(AppMessage.IO_MAKE_TMP_FOLDER_FAIL, tmpFolderName);
        }
        tmpFolderName = tmpFolder.getCanonicalPath();
        try {
            File valdateFile = new File(tmpFolderName + "/validate.xml");
            URL url = valdateFile.toURL();
            msg.write(url, false);
            BaseMessage vmsg = this.getMessage(msg.getMsgName());
            vmsg.read(url);
            boolean validateResult = vmsg.validateMessage(mapPath);
            if (!validateResult) {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmssSSS");
                String timestamp = sdf.format(new Date());
                long pid = ProcessIdGetter.getProcessId();
                new File(ngFolderName).mkdirs();
                File ngFile = new File(ngFolderName.concat(File.separator).concat(timestamp).concat("_").concat(String.valueOf(pid)).concat("_").concat(outputFileName));
                try {
                    FileUtils.copyFile((File)valdateFile, (File)ngFile);
                    throw XMLSchemaErrorMessageHandler.createBizTranExcepton(AppMessage.XMLSCHEMA_OUTFILE_PARSE_FAIL, vmsg.getExceptions(), ngFile.getCanonicalPath());
                }
                catch (IOException e) {
                    throw XMLSchemaErrorMessageHandler.createBizTranExcepton(AppMessage.XMLSCHEMA_OUTFILE_PARSE_FAIL_NG, vmsg.getExceptions(), e.getMessage());
                }
            }
        }
        finally {
            if (!this.testFlag) {
                FileUtils.deleteDirectory((File)tmpFolder);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void execMapping(String mapFile, IOFile[] ioFiles, String[] args, boolean overwriteValidationFlag, boolean doValidation, boolean postscriptFlag) throws MappingException, BizTranException, BizTranTableFileException {
        int i;
        XReader reader;
        InputStream is;
        URL url = null;
        String parentPath = null;
        try {
            url = new URL(mapFile);
        }
        catch (MalformedURLException e) {
            File file = new File(mapFile);
            if (!file.exists()) {
                throw new BizTranException(AppMessage.MAPFILE_NOT_FOUND, (Throwable)e);
            }
            try {
                url = file.toURL();
                parentPath = file.getParent();
            }
            catch (Exception e1) {
                throw new BizTranException(AppMessage.MAPFILE_NOT_FOUND, (Throwable)e1);
            }
        }
        try {
            is = url.openStream();
        }
        catch (IOException e1) {
            throw new BizTranException(AppMessage.MAPFILE_NOT_FOUND, (Throwable)e1);
        }
        try {
            reader = XReader.createReader(new InputStreamReader(is, "JISAutoDetect"), parentPath);
            reader.setSystemId(url.toString());
        }
        catch (UnsupportedEncodingException e2) {
            throw new BizTranException(AppMessage.MAPFILE_NOT_FOUND, (Throwable)e2);
        }
        this.scriptEngine = ScriptEngine.getScriptEngine();
        VariableReference vref = this.scriptEngine.getVariableReference();
        com.argo21.common.util.Properties params = new com.argo21.common.util.Properties();
        if (args != null) {
            for (int i2 = 0; i2 < args.length; ++i2) {
                String s = args[i2];
                int k = s.indexOf("=");
                if (k <= 0) continue;
                String string2 = s.substring(0, k).trim();
                String value = s.substring(k + 1).trim();
                if (value.startsWith("\"") && value.endsWith("\"") && value.length() > 1) {
                    value = value.substring(1, value.length() - 1);
                }
                vref.putData(string2, new XString(value));
                params.repleace(string2, value);
            }
        }
        try {
            this.parse(reader, params, overwriteValidationFlag, doValidation);
        }
        catch (SAXParseException e1) {
            BizTranException exception = XMLSchemaErrorMessageHandler.createBizTranExcepton(AppMessage.MAPFILE_CONTENT_ILLEGAL, e1);
            throw exception;
        }
        int inNo = 0;
        BaseMessage[] inMsgs = this.getInputMessages();
        if (ioFiles.length > 2) {
            this.checkMsg(ioFiles);
        }
        for (int i3 = 0; i3 < ioFiles.length; ++i3) {
            BaseMessage msg;
            if (ioFiles[i3].io != IOFile.INPUT) continue;
            String string3 = ioFiles[i3].name;
            if (string3 != null) {
                msg = this.getMessage(string3);
                if (msg == null) {
                    throw new BizTranException(AppMessage.IO_TABLE_INFILE_ABNORMAL, "\u30e1\u30c3\u30bb\u30fc\u30b8 " + string3 + " \u306f\u5b9a\u7fa9\u3057\u3066\u3044\u307e\u305b\u3093\u3002");
                }
                if (msg.getDirection() != "INPUT") {
                    MappingException.error("MSG_IODEF_ERR", string3, null);
                }
                if (ioFiles[i3].file != null) {
                    try {
                        this.loadInputFile(msg, ioFiles[i3].file, parentPath);
                    }
                    catch (SAXParseException e) {
                        if (i3 > 1) {
                            throw new BizTranException(AppMessage.IO_TABLE_INFILE_ABNORMAL, ioFiles[i3].file, e);
                        }
                        throw new BizTranException(AppMessage.IO_INFILE_ABNORMAL, (Throwable)e);
                    }
                    catch (SAXException e) {
                        if (i3 > 1) {
                            throw new BizTranException(AppMessage.IO_TABLE_INFILE_NOT_FOUND, ioFiles[i3].file, e);
                        }
                        throw new BizTranException(AppMessage.IO_INFILE_NOT_FOUND, (Throwable)e);
                    }
                    catch (IOException e) {
                        if (i3 > 1) {
                            throw new BizTranException(AppMessage.IO_TABLE_INFILE_NOT_FOUND, ioFiles[i3].file, e);
                        }
                        throw new BizTranException(AppMessage.IO_INFILE_NOT_FOUND, (Throwable)e);
                    }
                }
            } else if (inMsgs != null && inNo < inMsgs.length) {
                msg = inMsgs[inNo];
                if (ioFiles[i3].file != null) {
                    try {
                        this.loadInputFile(msg, ioFiles[i3].file, parentPath);
                    }
                    catch (SAXParseException e) {
                        throw new BizTranException(AppMessage.IO_INFILE_ABNORMAL, (Throwable)e);
                    }
                    catch (SAXException e) {
                        throw new BizTranException(AppMessage.IO_INFILE_NOT_FOUND, (Throwable)e);
                    }
                    catch (IOException e) {
                        throw new BizTranException(AppMessage.IO_INFILE_NOT_FOUND, (Throwable)e);
                    }
                }
            } else {
                MappingException.error("NODEF_MSG", String.valueOf(i3 + 1), null);
            }
            ++inNo;
        }
        BaseMessage[] outMsgs = this.getOutputMessages();
        if (postscriptFlag) {
            for (BaseMessage out : outMsgs) {
                if ("XSD".equals(out.getMsgType())) {
                    throw new BizTranException(AppMessage.ARG_POSTSCRIPT_XML);
                }
                if (!"XML".equals(out.getMsgType())) continue;
                throw new BizTranException(AppMessage.ARG_POSTSCRIPT_XML);
            }
        }
        this.execMapping();
        boolean bl = false;
        for (i = 0; i < ioFiles.length; ++i) {
            void var16_28;
            BaseMessage msg;
            if (ioFiles[i].io != IOFile.OUTPUT) continue;
            String msgname = ioFiles[i].name;
            if (msgname != null) {
                msg = this.getMessage(msgname);
                if (msg == null) {
                    MappingException.error("NODEF_MSG", msgname, null);
                }
                if (msg.getDirection() == "INPUT") {
                    MappingException.error("MSG_IODEF_ERR", msgname, null);
                }
                if (ioFiles[i].file != null) {
                    try {
                        this.writeToFile(msg, ioFiles[i].file, parentPath, postscriptFlag);
                    }
                    catch (SAXException e) {
                        throw new BizTranException(AppMessage.IO_OUTFILE_WRITE_FAIL, (Throwable)e);
                    }
                    catch (IOException e) {
                        throw new BizTranException(AppMessage.IO_OUTFILE_WRITE_FAIL, (Throwable)e);
                    }
                }
            } else if (outMsgs != null && var16_28 < outMsgs.length) {
                msg = outMsgs[var16_28];
                if (ioFiles[i].file != null) {
                    try {
                        this.writeToFile(msg, ioFiles[i].file, parentPath, postscriptFlag);
                    }
                    catch (SAXException e) {
                        throw new BizTranException(AppMessage.IO_OUTFILE_WRITE_FAIL, (Throwable)e);
                    }
                    catch (IOException e) {
                        throw new BizTranException(AppMessage.IO_OUTFILE_WRITE_FAIL, (Throwable)e);
                    }
                } else {
                    throw new BizTranException(AppMessage.IO_OUTFILE_WRITE_FAIL);
                }
            }
            ++var16_28;
        }
        for (i = 0; i < this.msgcount; ++i) {
            BaseMessage msg = this.msglist[i];
            MessageErrorHandler handler = new MessageErrorHandler();
            msg.setErrorHandler(handler);
            try {
                msg.submit();
                msg.close();
            }
            catch (SAXException e) {
                this.error(e);
            }
            msg.setErrorHandler(null);
        }
    }

    private BaseMessage[] getInputMessages() {
        int count2 = 0;
        for (int i = 0; i < this.msgcount; ++i) {
            if (this.msglist[i].getDirection() != "INPUT") continue;
            ++count2;
        }
        BaseMessage[] res = new BaseMessage[count2];
        count2 = 0;
        for (int i = 0; i < this.msgcount; ++i) {
            if (this.msglist[i].getDirection() != "INPUT") continue;
            res[count2++] = this.msglist[i];
        }
        return res;
    }

    private BaseMessage[] getOutputMessages() {
        int count2 = 0;
        for (int i = 0; i < this.msgcount; ++i) {
            if (this.msglist[i].getDirection() == "INPUT") continue;
            ++count2;
        }
        BaseMessage[] res = new BaseMessage[count2];
        count2 = 0;
        for (int i = 0; i < this.msgcount; ++i) {
            if (this.msglist[i].getDirection() == "INPUT") continue;
            res[count2++] = this.msglist[i];
        }
        return res;
    }

    private BaseMessage getMessage(String msgName) {
        for (int i = 0; i < this.msgcount; ++i) {
            BaseMessage msg = this.msglist[i];
            if (!msgName.equals(msg.getMsgName())) continue;
            return msg;
        }
        return null;
    }

    private void parse(XReader in, com.argo21.common.util.Properties params, boolean overwriteValidationFlag, boolean doValidation) throws SAXParseException {
        int msgNo = 0;
        boolean hasScript = false;
        in.peekWhitespace();
        while (!in.isEOF()) {
            String s;
            char c = in.getc();
            if (c == '#') {
                in.readLine();
                in.peekWhitespace();
                continue;
            }
            if (c != '[') {
                MappingException.error("INVAILD_CHAR", String.valueOf(c), (Locator)in);
            }
            if ((s = in.peekName()) == null) {
                c = in.getc();
                MappingException.error("INVAILD_CHAR", String.valueOf(c), (Locator)in);
            }
            if (!in.peekc(']')) {
                MappingException.error("NEED_CHAR", "]", (Locator)in);
            }
            in.peekSpace();
            c = in.getc();
            if (c == '\r') {
                c = in.getc();
                if (c != '\n') {
                    in.ungetc();
                }
            } else {
                c = in.getc();
                if (c != '\n') {
                    in.ungetc();
                }
            }
            if (s.equals("MSGDECL")) {
                if (hasScript) {
                    MappingException.error("MUST_BEFOR_PARA", new Object[]{"[MSGDECL]", "[SCRIPT]"}, (Locator)in);
                }
                int firstLine = in.getLineNumber();
                BaseMessage msg = this.parseMessage(in, params, overwriteValidationFlag, doValidation);
                int totalLines = in.getLineNumber() - firstLine;
                if (msg != null) {
                    msg.setOrder(msgNo);
                    msg.setFirstLine(firstLine);
                    msg.setTotalLines(totalLines);
                    ++msgNo;
                    if (this.msgcount == this.msglist.length) {
                        BaseMessage[] tmp = new BaseMessage[this.msglist.length + 1];
                        System.arraycopy(this.msglist, 0, tmp, 0, this.msglist.length);
                        this.msglist = tmp;
                    }
                    this.msglist[this.msgcount++] = msg;
                }
            } else if (s.equals("SCRIPT")) {
                if (hasScript) {
                    MappingException.error("DOUBLE_PARA", "[SCRIPT]", (Locator)in);
                } else if (msgNo == 0) {
                    MappingException.error("MUST_BEFOR_PARA", new Object[]{"[MSGDECL]", "[SCRIPT]"}, (Locator)in);
                }
                VariableReference ref = this.scriptEngine.getVariableReference();
                for (int i = 0; i < this.msgcount; ++i) {
                    Variable v = new Variable(this.msglist[i].getMsgName(), new XObject(this.msglist[i]));
                    ref.putFixVariable(v);
                }
                this.scriptEngine.loadScripts(in);
            } else {
                MappingException.error("INVAILD_PARA", "[" + s + "]", (Locator)in);
            }
            in.peekWhitespace();
        }
    }

    private BaseMessage parseMessage(XReader in, com.argo21.common.util.Properties params, boolean overwriteValidationFlag, boolean doValidation) throws SAXParseException {
        char c;
        com.argo21.common.util.Properties properties = new com.argo21.common.util.Properties();
        BaseMessage msg = null;
        in.peekWhitespace();
        while ((c = in.getc()) != '\u0000') {
            if (c == '#') {
                in.readLine();
                in.peekWhitespace();
                continue;
            }
            in.ungetc();
            if (c == '[') break;
            if (c == '<') {
                if (msg == null) {
                    msg = this.createMessage(properties, params, in, overwriteValidationFlag, doValidation);
                }
                msg.readSchema(in);
                in.peekWhitespace();
                break;
            }
            String propertyname = in.peekName();
            if (propertyname == null) {
                MessageException.error("INVAILD_CHAR", String.valueOf(c), (Locator)in);
            }
            in.peekSpace();
            if (!in.peekc('=')) {
                MessageException.error("NEED_CHAR", "=", (Locator)in);
            }
            in.peekSpace();
            String propertyvalue = null;
            propertyvalue = in.readToEol();
            propertyvalue = propertyvalue.trim();
            propertyvalue = this.parseSpecialChar(propertyvalue);
            if (propertyvalue.equals("null")) {
                propertyvalue = null;
            }
            if (properties.contain(propertyname)) {
                MessageException.error("DOUBLE_PARAM", propertyname, (Locator)in);
            }
            properties.append(propertyname, propertyvalue);
            in.peekWhitespace();
        }
        if (msg == null) {
            msg = this.createMessage(properties, params, in, overwriteValidationFlag, doValidation);
        }
        return msg;
    }

    private BaseMessage createMessage(com.argo21.common.util.Properties properties, com.argo21.common.util.Properties params, XReader in, boolean overwriteValidationFlag, boolean doValidation) throws MappingException, MessageException {
        String msgname;
        String msgtype = properties.getValue("type", null);
        if (msgtype == null) {
            MappingException.error("NEED_MSGTYPE", new Object[0], (Locator)in);
        }
        if ((msgname = properties.getValue("name", null)) == null) {
            MappingException.error("NEED_MSGNAME", new Object[0], (Locator)in);
        }
        if (this.getMessage(msgname) != null) {
            MappingException.error("DOUBLE_MSGNAME", msgname, (Locator)in);
        }
        if (msgtype.equals("XSD") && overwriteValidationFlag) {
            String flag = doValidation ? "YES" : "NO";
            properties.repleace("validate", flag);
        }
        BaseMessage msg = MessageFactory.getInstance().createMessage(msgtype);
        msg.setProperties(properties);
        msg.setPrameters(params);
        msg.setEol();
        return msg;
    }

    private void error(Exception exception) throws MappingException {
        if (exception instanceof MappingException) {
            throw (MappingException)exception;
        }
        if (exception instanceof SAXParseException) {
            SAXParseException spe = (SAXParseException)exception;
            throw new MappingException(spe.getMessage(), spe.getPublicId(), spe.getSystemId(), spe.getLineNumber(), spe.getColumnNumber(), spe.getException());
        }
        if (exception instanceof SAXException) {
            SAXException se = (SAXException)exception;
            throw new MappingException(se.getMessage(), "", "", 0, 0, se.getException());
        }
        throw new MappingException(exception.getMessage(), "", "", 0, 0, exception);
    }

    private String parseSpecialChar(String str) {
        int k;
        if (str == null) {
            return null;
        }
        int n = str.length();
        for (k = 0; k < n && str.charAt(k) != '&'; ++k) {
        }
        if (k == n) {
            return str;
        }
        StringBuffer sb = new StringBuffer();
        if (k > 0) {
            sb.append(str.substring(0, k));
        }
        while (k < n) {
            char c = str.charAt(k);
            if (c == '&') {
                int k1 = k + 1;
                if (k1 < n && str.charAt(k1) == '#') {
                    int k2;
                    int base = 10;
                    if (++k1 < n && (str.charAt(k1) == 'x' || str.charAt(k1) == 'x')) {
                        base = 16;
                    }
                    for (k2 = ++k1; k2 < n && str.charAt(k2) != ';'; ++k2) {
                    }
                    if (k2 <= n && k2 > k1) {
                        String strnum = str.substring(k1, k2);
                        try {
                            int num = Integer.parseInt(strnum, base);
                            sb.append((char)num);
                            k = k2 + 1;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (k >= k2) continue;
                    sb.append(str.substring(k, k2));
                    k = k2;
                    continue;
                }
                sb.append(c);
                ++k;
                continue;
            }
            sb.append(c);
            ++k;
        }
        return sb.toString();
    }

    private static void logWriterForOutOfMemory(Logger logger, OutOfMemoryError e) {
        System.gc();
        while (true) {
            try {
                logger.error(AppMessage.JAVA_OUTOFMOMERY_EXCEPTION, e);
            }
            catch (OutOfMemoryError e3) {
                System.gc();
                continue;
            }
            break;
        }
        while (true) {
            try {
                logger.renameByResult();
            }
            catch (OutOfMemoryError e3) {
                System.gc();
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void divideAndExecute(String inputFileName, String outputFileName, DivisionProperties divProp, MappingInfo mapInfo, IOFile[] iofiles, Logger logger, boolean topFlag) throws MappingException, BizTranException, BizTranTableFileException {
        String ifName;
        String[] ifNames;
        File inputFile = new File(inputFileName);
        Object divKeys = topFlag ? new String[]{"top"} : ((ifNames = (ifName = inputFile.getName()).split("_")).length != 2 ? null : divProp.getChildKeys(ifNames[1]));
        long infSize = inputFile.length();
        if (infSize >= divProp.getFileSize() && divKeys != null && ((String[])divKeys).length > 0) {
            String tmpFolderName = null;
            try {
                tmpFolderName = BizTranUtil.getMappingFolderPath();
            }
            catch (IOException e) {
                throw new BizTranException(AppMessage.IO_DIVIDEPROP_DIVIDE_FAIL, e.getMessage());
            }
            tmpFolderName = tmpFolderName.concat(File.separator).concat(ProcessIdGetter.getProcessIdWithDateWithCounter());
            File tmpFolder = new File(tmpFolderName);
            if (!tmpFolder.mkdirs()) {
                throw new BizTranException(AppMessage.IO_MAKE_TMP_FOLDER_FAIL, tmpFolderName);
            }
            try {
                tmpFolderName = tmpFolder.getCanonicalPath();
            }
            catch (Exception e) {
                throw new BizTranException(AppMessage.IO_DIVIDEPROP_DIVIDE_FAIL, e.getMessage());
            }
            try {
                String[] inputFileNames;
                String divInputFolderName = tmpFolderName.concat(File.separator).concat("input");
                String divOutputFolderName = tmpFolderName.concat(File.separator).concat("output");
                File divInputFolder = new File(divInputFolderName);
                File divOutputFolder = new File(divOutputFolderName);
                divOutputFolder.mkdirs();
                InputMessageDivisioner imDiv = new InputMessageDivisioner(divProp, (String[])divKeys);
                imDiv.divide(inputFileName, divInputFolderName);
                for (String name2 : inputFileNames = divInputFolder.list()) {
                    this.divideAndExecute(divInputFolderName + File.separator + name2, divOutputFolderName + File.separator + name2, divProp, mapInfo, iofiles, logger, false);
                }
                if (folder && "top".equals(divKeys[0]) && exst != null) {
                    outputFileName = outputFileName.concat(".").concat(exst);
                }
                OutputMessageUnioner osUni = new OutputMessageUnioner(divProp, (String[])divKeys);
                osUni.union(outputFileName, divOutputFolder, this.getOutputMessages()[0].isSettingIndent(), mapInfo.isPostscriptFlag());
            }
            finally {
                if (!this.testFlag) {
                    try {
                        FileUtils.deleteDirectory((File)tmpFolder);
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        this.msglist = new BaseMessage[2];
        this.msgcount = 0;
        this.scriptEngine = null;
        IOFile[] iofilesNow = new IOFile[iofiles.length];
        if (iofiles[0].io == IOFile.INPUT) {
            iofilesNow[0] = new IOFile(iofiles[0].name, inputFileName, IOFile.INPUT);
            iofilesNow[1] = new IOFile(iofiles[1].name, outputFileName, IOFile.OUTPUT);
        } else {
            iofilesNow[0] = new IOFile(iofiles[1].name, inputFileName, IOFile.INPUT);
            iofilesNow[1] = new IOFile(iofiles[0].name, outputFileName, IOFile.OUTPUT);
        }
        for (int j = 2; j < iofiles.length; ++j) {
            iofilesNow[j] = iofiles[j];
        }
        mapInfo.setDivInputFilePath(inputFileName);
        mapInfo.setDivOutputFilePath(outputFileName);
        this.execMapping(mapInfo.getMapFilePath(), iofilesNow, mapInfo.getParameters(), mapInfo.isOverwriteValidationFlag(), mapInfo.isDoValidation(), mapInfo.isPostscriptFlag());
        logger.normal();
    }

    static {
        String name2;
        File parent;
        File file;
        folder = false;
        exst = null;
        HOME_DIR = System.getProperty("user.home", ".");
        File f = new File(HOME_DIR, ".esooner");
        if (!f.exists()) {
            try {
                f.mkdirs();
            }
            catch (Exception e) {
                System.err.println(e);
            }
        }
        File MapEditorINIfile = new File(f, "MappingEditor.ini");
        MapEditorINI = MapEditorINIfile.getPath();
        URL resource = ClassLoader.getSystemResource("com/argo21/map/MappingProcessor2.class");
        if (resource != null) {
            if ("file".equals(resource.getProtocol())) {
                try {
                    USER_DIR = FileEx.urlToFile(new URL(resource, "../../../"));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (USER_DIR != null) {
                    file = new File(USER_DIR);
                    parent = file.getParentFile();
                    name2 = file.getName();
                    if ("out".equals(name2) && parent != null) {
                        USER_DIR = parent.getAbsolutePath();
                    }
                }
            } else if ("jar".equals(resource.getProtocol())) {
                try {
                    JarURLConnection connect = (JarURLConnection)resource.openConnection();
                    LIB_DIR = FileEx.urlToFile(new URL(connect.getJarFileURL(), "./"));
                }
                catch (Exception connect) {
                    // empty catch block
                }
                if (LIB_DIR != null) {
                    USER_DIR = new File(LIB_DIR).getParent();
                }
            }
        }
        if (USER_DIR == null || !new File(USER_DIR).isDirectory()) {
            file = new File(System.getProperty("user.dir", "."));
            parent = file.getParentFile();
            name2 = file.getName();
            USER_DIR = (name2.startsWith("bin") || "src".equals(name2)) && parent != null ? parent.getAbsolutePath() : file.getAbsolutePath();
        }
        isAddDecimalZero = false;
    }
}

