/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.map;

import com.argo21.map.Mapping;
import com.argo21.map.MappingException;
import com.argo21.map.MappingProcessor;
import com.argo21.map.MappingProcessorTestFrame;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;

public class MappingProcessorTest {
    private static final int MAP_FILE = 0;
    private static final int INPUT_FILE = 1;
    private static final int OUTPUT_FILE = 2;

    public static void main(String[] args) {
        if (args.length < 1) {
            MappingProcessorTest.guiTest();
        } else {
            MappingProcessorTest.commandTest(args);
        }
    }

    private static void guiTest() {
        MappingProcessorTestFrame f = new MappingProcessorTestFrame();
        f.show();
    }

    private static void commandTest(String[] args) {
        if (args.length < 1) {
            MappingProcessorTest.useage();
            System.exit(3);
        }
        String mapFileName = args[0];
        String inputFileName = args[1];
        String outputFileName = args[2];
        String[] properties = null;
        MappingProcessorTest.mapping(mapFileName, inputFileName, outputFileName, properties);
    }

    public static void mapping(String mapFileName, String inputFileName, String outputFileName, String[] args) {
        Mapping mapping = MappingProcessor.createMappingProcessor();
        FileInputStream in = null;
        FileOutputStream out = null;
        try {
            in = new FileInputStream(inputFileName);
            out = new FileOutputStream(outputFileName);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            System.exit(3);
        }
        try {
            mapping.execMapping(mapFileName, (InputStream)in, (OutputStream)out, args);
        }
        catch (MappingException exp) {
            exp.printStackTrace();
        }
    }

    private static void useage() {
        System.err.println("Useage:MappingProcessor mapdefine inputfile outputfile [parameter=value]");
    }
}

