/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.map;

import com.argo21.map.Mapping;
import com.argo21.map.MappingException;
import com.argo21.map.MappingProcessor;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

class MappingProcessorTestFrame
extends JFrame {
    private JTextField mapFileText = null;
    private JTextField inputFileText = null;
    private JTextField outputFileText = null;

    public MappingProcessorTestFrame() {
        super("MappingProcessorTest");
        this.setSize(300, 200);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        Container container = this.getContentPane();
        container.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.insets = new Insets(2, 2, 2, 2);
        JPanel filePanel = new JPanel();
        filePanel.setLayout(new GridBagLayout());
        filePanel.setBackground(new Color(224, 64, 224));
        gbc.weightx = 1.0;
        filePanel.add((Component)new JLabel("MAP"), gbc);
        gbc.weightx = 5.0;
        gbc.gridwidth = 0;
        this.mapFileText = new JTextField();
        filePanel.add((Component)this.mapFileText, gbc);
        gbc.weightx = 1.0;
        gbc.gridwidth = -1;
        filePanel.add((Component)new JLabel("INPUT"), gbc);
        gbc.weightx = 5.0;
        gbc.gridwidth = 0;
        this.inputFileText = new JTextField();
        filePanel.add((Component)this.inputFileText, gbc);
        gbc.weightx = 1.0;
        gbc.gridwidth = -1;
        filePanel.add((Component)new JLabel("OUTPUT"), gbc);
        gbc.weightx = 5.0;
        gbc.gridwidth = 0;
        this.outputFileText = new JTextField();
        filePanel.add((Component)this.outputFileText, gbc);
        JPanel p = new JPanel();
        p.setLayout(new GridLayout(1, 3));
        p.add(new Label());
        JButton okBtn = new JButton("\u5b9f\u884c");
        okBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MappingProcessorTestFrame.this.exec();
            }
        });
        p.add(okBtn);
        p.add(new Label());
        gbc.fill = 1;
        container.add((Component)filePanel, gbc);
        container.add((Component)p, gbc);
    }

    private void exec() {
        String mapFile = this.getFileName(this.mapFileText, "\u30de\u30c3\u30d7\u30d5\u30a1\u30a4\u30eb");
        String inputFile = this.getFileName(this.inputFileText, "\u8aad\u8fbc\u30d5\u30a1\u30a4\u30eb");
        String outputFile = this.getFileName(this.outputFileText, "\u51fa\u529b\u30d5\u30a1\u30a4\u30eb");
        if (mapFile == null || inputFile == null || outputFile == null) {
            return;
        }
        try {
            MappingProcessorTestFrame.mapping(mapFile, inputFile, outputFile, null);
        }
        catch (MappingException exp) {
            exp.printStackTrace();
            JOptionPane.showMessageDialog(this, "\u4f8b\u5916\u767a\u751f", "error", 0);
            System.exit(3);
        }
        JOptionPane.showMessageDialog(this, "\u30de\u30c3\u30d4\u30f3\u30b0\u5b8c\u4e86", "", 0);
    }

    private String getFileName(JTextField text, String desc) {
        String fileName = text.getText();
        if (fileName == null || fileName.equals("")) {
            JOptionPane.showMessageDialog(this, desc + "\u3092\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044", "error", 0);
            return null;
        }
        return fileName;
    }

    public static void mapping(String mapFileName, String inputFileName, String outputFileName, String[] args) throws MappingException {
        Mapping mapping = MappingProcessor.createMappingProcessor();
        FileInputStream in = null;
        FileOutputStream out = null;
        try {
            in = new FileInputStream(inputFileName);
            out = new FileOutputStream(outputFileName);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            System.exit(3);
        }
        mapping.execMapping(mapFileName, (InputStream)in, (OutputStream)out, args);
    }
}

