/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.map;

import com.argo21.map.MappingException;
import com.argo21.map.MessageLibraryManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.DateFormat;
import java.util.Date;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;

public class MessageLibraryDialog
extends JDialog
implements ActionListener,
ChangeListener,
ListSelectionListener {
    public static final short OPT_INSERT = 1;
    public static final short OPT_REMOVE = 2;
    boolean is_OK = false;
    static String[] tabNames = new String[]{MappingException.getMessage("WD_NAME"), MappingException.getMessage("WD_TYPE"), MappingException.getMessage("WD_DATE"), MappingException.getMessage("WD_COMMENT")};
    MessageLibraryManager messageLibraryManager;
    JTabbedPane folderTab;
    JScrollPane library_sp;
    JTable libraryViewer;
    JButton okButton;
    JButton delButton;
    JButton cancelButton;
    JTextField folderField;
    JTextField nameField;
    JTextField commentField;
    JPanel extendPanel;

    MessageLibraryDialog(Frame frame, String title, MessageLibraryManager messageLibraryManager, int opt) {
        super(frame, title, true);
        this.messageLibraryManager = messageLibraryManager;
        this.libraryViewer = new JTable();
        this.libraryViewer.getSelectionModel().addListSelectionListener(this);
        this.libraryViewer.setBorder(null);
        this.libraryViewer.setCellSelectionEnabled(false);
        this.libraryViewer.setRowSelectionAllowed(true);
        this.libraryViewer.setColumnSelectionAllowed(false);
        this.libraryViewer.setSelectionMode(0);
        this.libraryViewer.getTableHeader().setReorderingAllowed(false);
        this.libraryViewer.setShowGrid(false);
        this.library_sp = new JScrollPane(this.libraryViewer);
        this.library_sp.setBorder(BorderFactory.createEtchedBorder());
        this.library_sp.getViewport().setBackground(Color.white);
        JPanel tp = new JPanel(new BorderLayout());
        this.setContentPane(tp);
        tp.add((Component)this.createContentPanel(opt), "Center");
        JPanel tp2 = new JPanel();
        if ((opt & 2) != 0) {
            this.delButton = new JButton(MappingException.getMessage("CMD_DELETE"));
            tp2.add(this.delButton);
            this.delButton.setEnabled(false);
            this.delButton.addActionListener(this);
        } else {
            tp2.setLayout(new FlowLayout(1));
            this.okButton = new JButton(MappingException.getMessage("BUTTON_OK"));
            tp2.add(this.okButton);
            this.okButton.addActionListener(this);
        }
        this.cancelButton = new JButton(MappingException.getMessage("BUTTON_CANCEL"));
        tp2.add(this.cancelButton);
        this.cancelButton.addActionListener(this);
        tp.add((Component)tp2, "South");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                MessageLibraryDialog.this.is_OK = false;
                MessageLibraryDialog.this.setVisible(false);
            }
        });
        this.setSize(480, 440);
        if (this.folderTab.getTabCount() > 0) {
            if (this.folderTab.getSelectedIndex() != 0) {
                this.folderTab.setSelectedIndex(0);
            } else {
                this.selectFolder(0);
            }
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        int sel = this.libraryViewer.getSelectedRow();
        if (sel < 0) {
            if (this.delButton != null) {
                this.delButton.setEnabled(false);
            }
            return;
        }
        MyTableModel mode = (MyTableModel)this.libraryViewer.getModel();
        MessageLibraryManager.MsgEntry et = (MessageLibraryManager.MsgEntry)mode.entries.elementAt(sel);
        this.nameField.setText(et.name);
        this.libraryViewer.setToolTipText(et.comment);
        this.commentField.setText(et.comment);
        if (this.delButton != null) {
            this.delButton.setEnabled(et.isWritable());
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.selectFolder(this.folderTab.getSelectedIndex());
    }

    void selectFolder(int index) {
        if (index < 0) {
            return;
        }
        String folder = this.folderTab.getTitleAt(index);
        this.folderField.setText(folder);
        this.libraryViewer.setModel(new MyTableModel(folder));
        JPanel jp = (JPanel)this.folderTab.getComponentAt(index);
        jp.add((Component)this.library_sp, "Center");
        jp.revalidate();
        jp.repaint();
    }

    private JPanel createContentPanel(int opt) {
        JPanel tp = new JPanel();
        Font font = this.getFont();
        Font deffont = new Font(font.getName(), 0, 12);
        tp.setFont(deffont);
        tp.setBorder(BorderFactory.createEtchedBorder());
        this.folderTab = new JTabbedPane();
        Vector fds = this.messageLibraryManager.getFoldersByOrder();
        int n = fds.size();
        for (int i = 0; i < n; ++i) {
            JPanel jp = new JPanel(new BorderLayout());
            jp.setBorder(BorderFactory.createTitledBorder(""));
            this.folderTab.addTab((String)fds.elementAt(i), jp);
        }
        this.folderTab.addChangeListener(this);
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(1, 1, 1, 1);
        c.fill = 1;
        tp.setLayout(new GridBagLayout());
        c.gridy = 0;
        c.gridx = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridwidth = 1;
        c.gridheight = 1;
        tp.add((Component)this.folderTab, c);
        ++c.gridy;
        c.weightx = 1.0;
        c.weighty = 0.0;
        this.extendPanel = new JPanel();
        if ((opt & 1) != 0) {
            tp.add((Component)this.extendPanel, c);
        }
        this.extendPanel.setFont(deffont);
        String s = MappingException.getMessage("LB_LIB_INFO");
        this.extendPanel.setBorder(BorderFactory.createTitledBorder(s));
        this.extendPanel.setLayout(new GridBagLayout());
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        s = MappingException.getMessage("WD_FOLDER");
        JLabel lab = new JLabel(s + " : ");
        this.extendPanel.add((Component)lab, c);
        lab.setFont(deffont);
        ++c.gridx;
        c.weightx = 1.0;
        this.folderField = new JTextField("");
        this.extendPanel.add((Component)this.folderField, c);
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        c.weighty = 0.0;
        lab = new JLabel(tabNames[0] + " : ");
        this.extendPanel.add((Component)lab, c);
        lab.setFont(deffont);
        ++c.gridx;
        c.weightx = 1.0;
        this.nameField = new JTextField("");
        this.extendPanel.add((Component)this.nameField, c);
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        c.weighty = 0.0;
        lab = new JLabel(tabNames[3] + " : ");
        this.extendPanel.add((Component)lab, c);
        lab.setFont(deffont);
        ++c.gridx;
        c.weightx = 1.0;
        this.commentField = new JTextField("");
        this.extendPanel.add((Component)this.commentField, c);
        return tp;
    }

    public boolean isOk() {
        return this.is_OK;
    }

    public String getFolder() {
        return this.folderField.getText();
    }

    @Override
    public String getName() {
        return this.nameField.getText();
    }

    public String getComment() {
        return this.commentField.getText();
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        Object obj = evt.getSource();
        if (obj == this.okButton) {
            this.is_OK = true;
            this.setVisible(false);
        } else if (obj == this.cancelButton) {
            this.is_OK = false;
            this.setVisible(false);
        } else if (obj == this.delButton) {
            int k = this.folderTab.getSelectedIndex();
            if (k < 0) {
                return;
            }
            String folder = this.folderTab.getTitleAt(k);
            k = this.libraryViewer.getSelectedRow();
            if (k < 0) {
                return;
            }
            String name2 = (String)this.libraryViewer.getModel().getValueAt(k, 0);
            this.messageLibraryManager.remove(folder, name2);
            this.selectFolder(this.folderTab.getSelectedIndex());
        }
    }

    class MyTableModel
    extends AbstractTableModel {
        Vector entries;

        public MyTableModel(String folder) {
            this.entries = MessageLibraryDialog.this.messageLibraryManager.getMsgEntriesByOrder(folder);
        }

        @Override
        public int getColumnCount() {
            return tabNames.length;
        }

        @Override
        public int getRowCount() {
            return this.entries.size();
        }

        @Override
        public Object getValueAt(int row, int col) {
            MessageLibraryManager.MsgEntry et = (MessageLibraryManager.MsgEntry)this.entries.elementAt(row);
            switch (col) {
                case 0: {
                    return et.name;
                }
                case 1: {
                    return et.type;
                }
                case 2: {
                    Date date = new Date(et.time);
                    return DateFormat.getDateTimeInstance().format(date);
                }
                case 3: {
                    return et.comment;
                }
            }
            return "";
        }

        @Override
        public String getColumnName(int column) {
            return tabNames[column];
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return false;
        }
    }
}

