/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.map;

import com.argo21.common.io.XReader;
import com.argo21.map.MapDocument;
import com.argo21.map.MappingEditor;
import com.argo21.msg.MessageException;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

final class MessageLibraryManager {
    static File userTemplateFile = null;
    Hashtable folderTab = new Hashtable(11);
    byte[] buf;

    public MessageLibraryManager() {
        int i;
        File[] fs;
        File f = new File(MappingEditor.MapEditorINI);
        userTemplateFile = new File(f.getParentFile(), "UserMessage.mlb");
        f = new File(MappingEditor.USER_DIR);
        if (userTemplateFile.isFile() && userTemplateFile.exists()) {
            try {
                this.loadTemplates(userTemplateFile);
            }
            catch (Exception e) {
                System.out.println(e);
            }
        }
        if ((fs = f.listFiles()) != null) {
            for (i = 0; i < fs.length; ++i) {
                if (!fs[i].isFile() || !fs[i].exists() || !fs[i].getAbsolutePath().endsWith(".mlb")) continue;
                try {
                    this.loadTemplates(fs[i]);
                    continue;
                }
                catch (Exception e) {
                    System.out.println(e);
                }
            }
        }
        if ((fs = (f = new File(MappingEditor.USER_DIR, "lib")).listFiles()) != null) {
            for (i = 0; i < fs.length; ++i) {
                if (!fs[i].isFile() || !fs[i].exists() || !fs[i].getAbsolutePath().endsWith(".mlb")) continue;
                try {
                    this.loadTemplates(fs[i]);
                    continue;
                }
                catch (Exception e) {
                    System.out.println(e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MapDocument.DeclSegment getMsgFromLibrary(String folder, String name2) throws MessageException, IOException {
        MapDocument.DeclSegment decl;
        MsgEntry me = this.getMsgEntry(folder, name2);
        if (me == null) {
            return null;
        }
        ZipFile zf = null;
        zf = new ZipFile(me.file);
        ZipEntry ze = zf.getEntry(me.folder + "/" + me.name);
        if (ze == null) {
            MapDocument.DeclSegment declSegment = null;
            return declSegment;
        }
        InputStream is = zf.getInputStream(ze);
        XReader rd = XReader.createReader(is, "UTF8");
        MapDocument.DeclSegment declSegment = decl = MapDocument.readMsgDecl(rd);
        return declSegment;
        finally {
            if (zf != null) {
                try {
                    zf.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public void setMsgToLibrary(MapDocument.DeclSegment msg, String folder, String name2, String comment) throws IOException {
        Vector<MsgEntry> vec = new Vector<MsgEntry>();
        if (userTemplateFile.exists()) {
            ZipFile zf = null;
            try {
                zf = new ZipFile(userTemplateFile);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (zf != null) {
                Enumeration<? extends ZipEntry> en = zf.entries();
                while (en.hasMoreElements()) {
                    ZipEntry entry = en.nextElement();
                    MsgEntry me = new MsgEntry(entry, userTemplateFile);
                    try {
                        InputStream in = zf.getInputStream(entry);
                        ByteArrayOutputStream out = new ByteArrayOutputStream();
                        this.copy(in, out);
                        in.close();
                        me.content = out;
                        vec.addElement(me);
                    }
                    catch (Exception in) {}
                }
                try {
                    zf.close();
                }
                catch (Exception entry) {
                    // empty catch block
                }
            }
        }
        MsgEntry newme = new MsgEntry(folder, name2, msg.getMsgType(), comment, userTemplateFile);
        ByteArrayOutputStream bufout = new ByteArrayOutputStream();
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)bufout, "UTF8");
        msg.writeTo(writer);
        ((Writer)writer).flush();
        newme.content = bufout;
        int n = vec.size();
        boolean replaced = false;
        for (int i = 0; i < n; ++i) {
            MsgEntry me = (MsgEntry)vec.elementAt(i);
            if (!folder.equals(me.folder) || !name2.equals(me.name)) continue;
            vec.setElementAt(newme, i);
            replaced = true;
            break;
        }
        if (!replaced) {
            vec.addElement(newme);
        }
        ZipOutputStream zo = null;
        zo = new ZipOutputStream(new FileOutputStream(userTemplateFile));
        n = vec.size();
        for (int i = 0; i < n; ++i) {
            try {
                MsgEntry me = (MsgEntry)vec.elementAt(i);
                if (me.content == null) continue;
                zo.putNextEntry(me.getZipEntry());
                me.content.writeTo(zo);
                zo.closeEntry();
                me.content = null;
                continue;
            }
            catch (Exception e) {
                System.out.println(e);
            }
        }
        try {
            zo.finish();
        }
        catch (Exception e) {
            System.out.println(e);
        }
        try {
            zo.close();
        }
        catch (Exception e) {
            System.out.println(e);
        }
        Hashtable<String, MsgEntry> msgTab = (Hashtable<String, MsgEntry>)this.folderTab.get(folder);
        if (msgTab == null) {
            msgTab = new Hashtable<String, MsgEntry>(31);
            this.folderTab.put(folder, msgTab);
        }
        msgTab.put(name2, newme);
    }

    public void remove(String folder, String name2) {
        if (!userTemplateFile.exists()) {
            return;
        }
        MsgEntry msg = this.getMsgEntry(folder, name2);
        if (msg == null) {
            return;
        }
        Vector<MsgEntry> vec = new Vector<MsgEntry>();
        ZipFile zf = null;
        try {
            zf = new ZipFile(userTemplateFile);
        }
        catch (Exception e) {
            System.out.println(e);
        }
        if (zf == null) {
            return;
        }
        Enumeration<? extends ZipEntry> en = zf.entries();
        String path = folder + "/" + name2;
        while (en.hasMoreElements()) {
            ZipEntry entry = en.nextElement();
            if (path.equals(entry.getName())) continue;
            MsgEntry me = new MsgEntry(entry, userTemplateFile);
            try {
                InputStream in = zf.getInputStream(entry);
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                this.copy(in, out);
                in.close();
                me.content = out;
                vec.addElement(me);
            }
            catch (Exception in) {}
        }
        try {
            zf.close();
        }
        catch (Exception entry) {
            // empty catch block
        }
        ZipOutputStream zo = null;
        try {
            zo = new ZipOutputStream(new FileOutputStream(userTemplateFile));
        }
        catch (Exception e) {
            System.out.println(e);
            return;
        }
        int n = vec.size();
        for (int i = 0; i < n; ++i) {
            try {
                MsgEntry me = (MsgEntry)vec.elementAt(i);
                if (me.content == null) continue;
                zo.putNextEntry(me.getZipEntry());
                me.content.writeTo(zo);
                zo.closeEntry();
                me.content = null;
                continue;
            }
            catch (Exception e) {
                System.out.println(e);
            }
        }
        try {
            if (n > 0) {
                zo.finish();
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
        try {
            zo.close();
        }
        catch (Exception e) {
            System.out.println(e);
        }
        Hashtable msgTab = (Hashtable)this.folderTab.get(folder);
        if (msgTab != null) {
            msgTab.remove(name2);
        }
    }

    public MsgEntry getMsgEntry(String folder, String name2) {
        Hashtable msgTab = (Hashtable)this.folderTab.get(folder);
        if (msgTab == null) {
            return null;
        }
        return (MsgEntry)msgTab.get(name2);
    }

    public boolean contains(String folder, String name2) {
        Hashtable msgTab = (Hashtable)this.folderTab.get(folder);
        if (msgTab == null) {
            return false;
        }
        return msgTab.get(name2) != null;
    }

    public Vector getFoldersByOrder() {
        Vector vet = new Vector();
        Enumeration en = this.folderTab.keys();
        while (en.hasMoreElements()) {
            String key = (String)en.nextElement();
            this.insertByOrder(key, vet);
        }
        return vet;
    }

    public Vector getNamesByOrder(String folder) {
        Vector vet = new Vector();
        Hashtable msgTab = (Hashtable)this.folderTab.get(folder);
        if (msgTab == null) {
            return vet;
        }
        Enumeration en = msgTab.keys();
        while (en.hasMoreElements()) {
            String key = (String)en.nextElement();
            this.insertByOrder(key, vet);
        }
        return vet;
    }

    public Vector getMsgEntriesByOrder(String folder) {
        Vector vet = new Vector();
        Hashtable msgTab = (Hashtable)this.folderTab.get(folder);
        if (msgTab == null) {
            return vet;
        }
        Enumeration en = msgTab.elements();
        while (en.hasMoreElements()) {
            MsgEntry et = (MsgEntry)en.nextElement();
            this.insertByOrder(et, vet);
        }
        return vet;
    }

    private void insertByOrder(MsgEntry et, Vector vec) {
        int n = vec.size();
        for (int i = 0; i < n; ++i) {
            MsgEntry et1 = (MsgEntry)vec.elementAt(i);
            if (et.name.compareTo(et1.name) >= 0) continue;
            vec.insertElementAt(et, i);
            return;
        }
        vec.addElement(et);
    }

    private void insertByOrder(String elem, Vector vec) {
        int n = vec.size();
        for (int i = 0; i < n; ++i) {
            String s = (String)vec.elementAt(i);
            if (elem.compareTo(s) >= 0) continue;
            vec.insertElementAt(elem, i);
            return;
        }
        vec.addElement(elem);
    }

    private void loadTemplates(File file) throws IOException, ZipException {
        ZipFile zf = new ZipFile(file);
        Enumeration<? extends ZipEntry> en = zf.entries();
        while (en.hasMoreElements()) {
            ZipEntry entry = en.nextElement();
            MsgEntry me = new MsgEntry(entry, file);
            Hashtable<String, MsgEntry> msgTab = (Hashtable<String, MsgEntry>)this.folderTab.get(me.folder);
            if (msgTab == null) {
                msgTab = new Hashtable<String, MsgEntry>();
                this.folderTab.put(me.folder, msgTab);
            }
            msgTab.put(me.name, me);
        }
    }

    private void copy(InputStream in, OutputStream out) throws IOException {
        int n;
        if (this.buf == null) {
            this.buf = new byte[1024];
        }
        while ((n = in.read(this.buf)) >= 0) {
            out.write(this.buf, 0, n);
        }
    }

    static class MsgEntry {
        String folder;
        String name;
        String type;
        long time;
        String comment;
        File file;
        ByteArrayOutputStream content;

        MsgEntry(String folder, String name2, String type, String comment, File file) {
            this.folder = folder;
            this.name = name2;
            this.type = type;
            this.comment = comment;
            this.time = System.currentTimeMillis();
            this.file = file;
        }

        MsgEntry(ZipEntry entry, File file) {
            String id2 = entry.getName();
            int k = id2.indexOf(47);
            if (k < 0) {
                k = id2.indexOf(92);
            }
            if (k > 0) {
                this.folder = id2.substring(0, k);
                this.name = id2.substring(k + 1);
            } else {
                this.folder = id2;
                this.name = id2;
            }
            this.time = entry.getTime();
            this.file = file;
            String s = null;
            byte[] cdata = entry.getExtra();
            if (cdata != null) {
                try {
                    s = new String(cdata, "UTF8");
                }
                catch (Exception exception) {}
            } else {
                s = entry.getComment();
            }
            if (s != null) {
                k = s.indexOf(47);
                if (k > 0) {
                    this.type = s.substring(0, k);
                    this.comment = s.substring(k + 1);
                } else {
                    this.type = s;
                    this.comment = "";
                }
            }
        }

        ZipEntry getZipEntry() {
            ZipEntry entry = new ZipEntry(this.folder + "/" + this.name);
            entry.setTime(this.time);
            String s = this.type + "/" + this.comment;
            try {
                byte[] cdata = s.getBytes("UTF8");
                entry.setExtra(cdata);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return entry;
        }

        boolean isWritable() {
            return userTemplateFile == this.file;
        }
    }
}

