/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.map;

import com.argo21.common.gui.GuiUtils;
import com.argo21.map.MappingEditor;
import com.argo21.map.WorkSpace;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.border.MatteBorder;
import javax.swing.text.Document;

public class MessageWindow
extends JScrollPane
implements MouseListener {
    MappingEditor map;
    JPopupMenu menu;
    Action[] actions1 = new Action[10];
    private DropTargetListener mapFileDropListener = null;
    JTextArea textArea = new JTextArea();

    MessageWindow(MappingEditor map) {
        this.map = map;
        this.textArea.setEditable(true);
        this.textArea.setMargin(new Insets(0, 6, 0, 0));
        this.textArea.setRequestFocusEnabled(true);
        this.textArea.setLineWrap(true);
        this.setBorder(new MessageWindowBorder("Message"));
        this.setViewportView(this.textArea);
        this.setHorizontalScrollBarPolicy(31);
        this.textArea.addMouseListener(this);
        Action[] actions = this.textArea.getActions();
        this.menu = new JPopupMenu();
        JMenuItem item = this.menu.add(new JMenuItem(GuiUtils.getMessage("CMD_CUT"), GuiUtils.loadImageIcon("cut.gif", "CUT")));
        this.actions1[0] = GuiUtils.findAction("cut-to-clipboard", actions);
        item.addActionListener(this.actions1[0]);
        KeyStroke key = KeyStroke.getKeyStroke(88, 2);
        item.setAccelerator(key);
        this.textArea.registerKeyboardAction(this.actions1[0], key, 0);
        item = this.menu.add(new JMenuItem(GuiUtils.getMessage("CMD_COPY"), GuiUtils.loadImageIcon("copy.gif", "COPY")));
        this.actions1[1] = GuiUtils.findAction("copy-to-clipboard", actions);
        item.addActionListener(this.actions1[1]);
        key = KeyStroke.getKeyStroke(155, 2);
        item.setAccelerator(key);
        this.textArea.registerKeyboardAction(this.actions1[1], key, 0);
        item = this.menu.add(new JMenuItem(GuiUtils.getMessage("CMD_PASTE"), GuiUtils.loadImageIcon("paste.gif", "PASTE")));
        this.actions1[2] = GuiUtils.findAction("paste-from-clipboard", actions);
        item.addActionListener(this.actions1[2]);
        key = KeyStroke.getKeyStroke(155, 1);
        item.setAccelerator(key);
        this.textArea.registerKeyboardAction(this.actions1[2], key, 0);
        this.menu.addSeparator();
        item = this.menu.add(new JMenuItem(GuiUtils.getMessage("CMD_SELECTALL")));
        this.actions1[4] = GuiUtils.findAction("select-all", actions);
        item.addActionListener(this.actions1[4]);
        key = KeyStroke.getKeyStroke(65, 2);
        item.setAccelerator(key);
        this.textArea.registerKeyboardAction(this.actions1[4], key, 0);
        this.menu.addSeparator();
        item = this.menu.add(new JMenuItem(GuiUtils.getMessage("CMD_DELETE"), GuiUtils.loadImageIcon("delete.gif", "DELETE")));
        this.actions1[6] = GuiUtils.findAction("delete-next", actions);
        item.addActionListener(this.actions1[6]);
        this.textArea.registerKeyboardAction(this.actions1[6], key, 0);
        if (this.mapFileDropListener != null) {
            DropTarget dropTarget = new DropTarget(this.textArea, this.mapFileDropListener);
        }
    }

    public void clear() {
        this.textArea.setText("");
    }

    public void println(String text) {
        Document doc = this.textArea.getDocument();
        try {
            int n = doc.getLength();
            doc.insertString(n, text, null);
            n = doc.getLength();
            doc.insertString(n, "\n", null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.textArea.invalidate();
        this.textArea.repaint();
    }

    public Document getDocument() {
        return this.textArea.getDocument();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        int mod = e.getModifiers();
        if (mod == 8 || mod == 4) {
            this.setMenuItemEnabled();
            this.menu.show(e.getComponent(), e.getX(), e.getY());
        } else if (e.getModifiers() == 16) {
            if (e.getClickCount() < 2) {
                try {
                    int pos = this.textArea.getSelectionStart();
                    if (pos < 0) {
                        return;
                    }
                    int line = this.textArea.getLineOfOffset(pos);
                    if (line < 0) {
                        return;
                    }
                    pos = this.textArea.getLineStartOffset(line);
                    this.textArea.setCaretPosition(this.textArea.getLineEndOffset(line));
                    this.textArea.moveCaretPosition(pos);
                }
                catch (Exception pos) {
                    // empty catch block
                }
                return;
            }
            try {
                int k;
                String wkname;
                String id2;
                int pos = this.textArea.viewToModel(new Point(e.getX(), e.getY()));
                int line = this.textArea.getLineOfOffset(pos);
                int pos1 = this.textArea.getLineStartOffset(line);
                int pos2 = this.textArea.getLineEndOffset(line);
                this.textArea.setSelectionStart(pos1);
                this.textArea.setSelectionEnd(pos2);
                String s = this.textArea.getSelectedText();
                pos1 = s.indexOf("<");
                pos2 = s.indexOf(">");
                if (pos1 < 0 || pos2 < pos1) {
                    return;
                }
                String s1 = s.substring(pos1 + 1, pos2);
                s = s.substring(0, pos1);
                pos2 = s1.indexOf(",");
                if (pos2 > 0) {
                    s1 = s1.substring(0, pos2);
                }
                line = 0;
                try {
                    line = Integer.parseInt(s1);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                pos2 = s.lastIndexOf(":");
                if (pos2 > 0) {
                    id2 = s.substring(pos2);
                    wkname = s.substring(0, pos2);
                } else {
                    id2 = s;
                    wkname = s;
                }
                WorkSpace ws = this.map.getWorkSpace();
                if (!wkname.equals(ws.getWorkSpaceName()) && (k = this.map.getSelectWorkSpace(wkname)) >= 0) {
                    this.map.paraList.setSelectedIndex(k);
                }
                ws = this.map.getWorkSpace();
                ws.messageItemSelected(id2, line);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void setMenuItemEnabled() {
        boolean b = this.textArea.getSelectionEnd() != this.textArea.getSelectionStart();
        this.actions1[0].setEnabled(b);
        this.actions1[1].setEnabled(b);
        this.actions1[2].setEnabled(true);
        this.actions1[4].setEnabled(true);
        this.actions1[6].setEnabled(b);
        int n = this.menu.getComponentCount();
        for (int i = 0; i < n; ++i) {
            if (this.actions1[i] == null) continue;
            Component c = this.menu.getComponent(i);
            c.setEnabled(this.actions1[i].isEnabled());
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    class MessageWindowBorder
    extends MatteBorder {
        String title;

        MessageWindowBorder(String title) {
            super(2, 16, 2, 2, Color.lightGray);
            this.title = title;
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            Insets insets = this.getBorderInsets(c);
            Color oldColor = g.getColor();
            g.translate(x, y);
            g.setColor(this.color);
            g.fillRect(0, 0, width - insets.right, insets.top);
            g.fillRect(0, insets.top, insets.left, height - insets.top);
            g.fillRect(insets.left, height - insets.bottom, width - insets.left, insets.bottom);
            g.fillRect(width - insets.right, 0, insets.right, height - insets.bottom);
            g.setColor(Color.darkGray);
            g.fillRect(2, insets.top, insets.left - 2, height - insets.top);
            g.translate(-x, -y);
            if (this.title != null) {
                Font f = g.getFont();
                g.setFont(new Font(f.getName(), 0, 10));
                int h = g.getFontMetrics().getHeight() - 5;
                g.setColor(Color.white);
                int n = this.title.length();
                int hh = insets.top + h;
                for (int i = 0; i < n; ++i) {
                    String s = this.title.substring(i, i + 1);
                    g.drawString(s, 6, hh);
                    hh += h;
                }
                g.setFont(f);
            }
            g.setColor(oldColor);
        }
    }
}

