/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.map;

import com.argo21.common.gui.StatusChangedListener;
import com.argo21.common.gui.TextEditorPanel;
import com.argo21.common.io.Debug;
import com.argo21.common.io.FileEx;
import com.argo21.common.util.Properties;
import com.argo21.map.MapDocument;
import com.argo21.map.MappingEditor;
import com.argo21.map.MappingException;
import com.argo21.map.WorkSpace;
import com.argo21.msg.MessageException;
import com.argo21.msg.SchemaEditor;
import com.argo21.msg.VisualMessageFactory;
import java.awt.Component;
import java.awt.Font;
import java.awt.Window;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.EventObject;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.xml.sax.SAXParseException;

public class SchemaEditorPanel
extends JTabbedPane
implements PopupMenuListener,
MouseListener,
ChangeListener,
FocusListener,
WorkSpace,
SchemaEditor.NameChangedListener,
SchemaEditor.ExceptionListener {
    static String[] toolBarNames = new String[]{"UNDO", "REDO", "CUT", "COPY", "PASTE", "DELETE", "FINDTEXT"};
    static String[][] editMenus = new String[][]{{"UNDO", "U", null, "2:90"}, {"REDO", "R", null, "2:89"}, {"-", null, null, null}, {"CUT", "T", null, "2:88"}, {"COPY", "C", null, "2:155"}, {"PASTE", "P", null, "1:155"}, {"-", null, null, null}, {"FINDTEXT", "F", null, "2:70"}, {"REFINDTEXT", "A", null, String.valueOf(114)}, {"-", null, null, null}, {"SELECTALL", "S", null, "2:65"}, {"-", null, null, null}, {"DELETE", "D", null, String.valueOf(127)}};
    private TextEditorPanel propertyEditor = null;
    private JMenu menu1 = null;
    private JToolBar toolBar1 = null;
    private TextEditorPanel schemaTextEditor = null;
    private JMenu menu2 = null;
    private JToolBar toolBar2 = null;
    private JSplitPane textEditorPanel = null;
    private Component visualEditorPanel = null;
    private SchemaEditor schema = null;
    private DropTargetListener mapFileDropListener = null;
    private Vector myStatusChangedListener = new Vector(1);
    MapDocument mapDocument = null;
    String msgName;
    private int focusPanel = 0;
    private boolean disEnabledTabSelectHandel = false;

    public SchemaEditorPanel(DropTargetListener mapFileDropListener) {
        DropTarget dropTarget;
        this.mapFileDropListener = mapFileDropListener;
        this.setTabPlacement(3);
        this.visualEditorPanel = new JPanel();
        this.add("Visual Editor", this.visualEditorPanel);
        this.textEditorPanel = new JSplitPane(0, false){
            private boolean dividerInitialed;
            {
                this.dividerInitialed = false;
            }

            @Override
            public void setBounds(int x, int y, int w, int h) {
                super.setBounds(x, y, w, h);
                if (!this.dividerInitialed && w > 100 && h > 100) {
                    this.dividerInitialed = true;
                    this.setDividerLocation(0.1);
                }
            }
        };
        this.textEditorPanel.setDividerLocation(0.5);
        this.textEditorPanel.setDividerSize(2);
        this.propertyEditor = new TextEditorPanel();
        this.textEditorPanel.setTopComponent(this.propertyEditor);
        this.propertyEditor.setBorder(MappingEditor.defaultBorder);
        Component c = this.propertyEditor.getDragComponent();
        c.addFocusListener(this);
        c.addMouseListener(this);
        this.propertyEditor.addStatusChangedListener(new StatusChangedListener(){

            @Override
            public void statusChanged(int id2, EventObject e) {
                SchemaEditorPanel.this.editorStatusChanged(id2, e);
            }
        });
        if (mapFileDropListener != null) {
            dropTarget = new DropTarget(c, mapFileDropListener);
        }
        this.toolBar1 = this.createToolbar(toolBarNames, this.propertyEditor);
        this.menu1 = this.createMenu(editMenus, this.propertyEditor);
        MenuListener ml = new MenuListener(){

            @Override
            public void menuSelected(MenuEvent e) {
                SchemaEditorPanel.this.setMenuStatus();
            }

            @Override
            public void menuDeselected(MenuEvent e) {
            }

            @Override
            public void menuCanceled(MenuEvent e) {
            }
        };
        this.menu1.addMenuListener(ml);
        this.schemaTextEditor = new TextEditorPanel();
        this.textEditorPanel.setBottomComponent(this.schemaTextEditor);
        this.schemaTextEditor.setBorder(MappingEditor.defaultBorder);
        c = this.schemaTextEditor.getDragComponent();
        c.addFocusListener(this);
        c.addMouseListener(this);
        this.schemaTextEditor.addStatusChangedListener(new StatusChangedListener(){

            @Override
            public void statusChanged(int id2, EventObject e) {
                SchemaEditorPanel.this.editorStatusChanged(id2, e);
            }
        });
        if (mapFileDropListener != null) {
            dropTarget = new DropTarget(c, mapFileDropListener);
        }
        this.add("Text Editor", this.textEditorPanel);
        this.addChangeListener(this);
        if (mapFileDropListener != null) {
            dropTarget = new DropTarget(this, mapFileDropListener);
        }
        this.toolBar2 = this.createToolbar(toolBarNames, this.schemaTextEditor);
        this.menu2 = this.createMenu(editMenus, this.schemaTextEditor);
        this.menu2.addMenuListener(ml);
    }

    @Override
    public void focusGained(FocusEvent e) {
        for (Component c = e.getComponent(); c != null; c = c.getParent()) {
            if (c == this.propertyEditor) {
                this.focusPanel = 1;
                this.schemaTextEditor.setBorder(MappingEditor.defaultBorder);
                this.propertyEditor.setBorder(MappingEditor.selectBorder);
                break;
            }
            if (c != this.schemaTextEditor) continue;
            this.focusPanel = 2;
            this.schemaTextEditor.setBorder(MappingEditor.selectBorder);
            this.propertyEditor.setBorder(MappingEditor.defaultBorder);
            break;
        }
        if (this.focusPanel == 1 || this.focusPanel == 2) {
            this.editorStatusChanged(2, new EventObject(this));
        }
        this.setToolbarStatus();
    }

    @Override
    public void focusLost(FocusEvent e) {
    }

    void setMenuStatus() {
        block3: {
            block2: {
                if (this.focusPanel != 1) break block2;
                int n = this.menu1.getMenuComponentCount();
                for (int i = 0; i < n; ++i) {
                    Component c = this.menu1.getMenuComponent(i);
                    Action at = this.propertyEditor.getAction(c.getName());
                    if (at == null) continue;
                    c.setEnabled(at.isEnabled());
                }
                break block3;
            }
            if (this.focusPanel != 2) break block3;
            int n = this.menu2.getMenuComponentCount();
            for (int i = 0; i < n; ++i) {
                Component c = this.menu2.getMenuComponent(i);
                Action at = this.schemaTextEditor.getAction(c.getName());
                if (at == null) continue;
                c.setEnabled(at.isEnabled());
            }
        }
    }

    void setToolbarStatus() {
        block3: {
            block2: {
                if (this.focusPanel != 1) break block2;
                int n = this.toolBar1.getComponentCount();
                for (int i = 0; i < n; ++i) {
                    Component c = this.toolBar1.getComponent(i);
                    Action at = this.propertyEditor.getAction(c.getName());
                    if (at == null) continue;
                    c.setEnabled(at.isEnabled());
                }
                break block3;
            }
            if (this.focusPanel != 2) break block3;
            int n = this.toolBar2.getComponentCount();
            for (int i = 0; i < n; ++i) {
                Component c = this.toolBar2.getComponent(i);
                Action at = this.schemaTextEditor.getAction(c.getName());
                if (at == null) continue;
                c.setEnabled(at.isEnabled());
            }
        }
    }

    private void editorStatusChanged(int id2, EventObject e) {
        this.setToolbarStatus();
        int n = this.myStatusChangedListener.size();
        for (int i = 0; i < n; ++i) {
            StatusChangedListener l = (StatusChangedListener)this.myStatusChangedListener.elementAt(i);
            l.statusChanged(id2, e);
        }
    }

    @Override
    public boolean nameChanged(String oldName, String newName) {
        try {
            return this.mapDocument.reName(oldName, newName);
        }
        catch (MessageException e) {
            this.getToolkit().beep();
            Window window = SwingUtilities.windowForComponent(this);
            if (window != null) {
                JOptionPane.showMessageDialog(window, e.getMessage());
            } else {
                JOptionPane.showMessageDialog(new JFrame(), e.getMessage());
            }
            return false;
        }
    }

    @Override
    public void exceptionHappened(Exception e) {
        SAXParseException e1;
        String s;
        if (e instanceof SAXParseException && (s = (e1 = (SAXParseException)e).getSystemId()) != null && s.length() > 0) {
            s = s + "<" + e1.getLineNumber() + "," + e1.getColumnNumber() + ">: " + e1.getMessage();
            Debug.println(s);
            return;
        }
        Debug.println(e.getMessage());
    }

    boolean isTextEditor() {
        return this.getSelectedComponent() == this.textEditorPanel;
    }

    boolean isVisualEditor() {
        return this.getSelectedComponent() == this.visualEditorPanel;
    }

    @Override
    public void addStatusChangedListener(StatusChangedListener l) {
        this.myStatusChangedListener.addElement(l);
    }

    @Override
    public void removeStatusChangedListener(StatusChangedListener l) {
        this.myStatusChangedListener.removeElement(l);
    }

    @Override
    public boolean isChanged() {
        if (this.schema != null && this.schema.isChanged()) {
            return true;
        }
        return this.schemaTextEditor.isChanged();
    }

    @Override
    public void clearChanged() {
        this.schemaTextEditor.clearChanged();
        if (this.schema != null) {
            this.schema.clearChanged();
        }
    }

    @Override
    public String getWorkSpaceName() {
        return this.msgName;
    }

    @Override
    public void load(MapDocument mapDoc) throws MessageException {
        this.mapDocument = mapDoc;
    }

    @Override
    public void saveBack() throws MessageException {
        String name2;
        MapDocument.DeclSegment msg;
        if (this.isTextEditor()) {
            String name3 = this.getMsgName();
            MapDocument.DeclSegment msg2 = this.mapDocument.getDeclSegment(name3);
            if (msg2 != null) {
                this.msgName = msg2.getMsgName();
            }
        } else if (this.schema != null && this.schema.isChanged() && (msg = this.mapDocument.getDeclSegment(name2 = this.getMsgName())) != null) {
            msg.setProperties(this.schema.getProperties());
            msg.setSchemaModel(this.schema.getSchema());
            this.msgName = msg.getMsgName();
            this.schema.clearChanged();
        }
    }

    @Override
    public void review() throws MessageException {
        Component c;
        String name2 = this.getMsgName();
        MapDocument.DeclSegment msg = this.mapDocument.getDeclSegment(name2);
        this.schemaTextEditor.setDocument(msg.getSchemaDocument());
        this.propertyEditor.setDocument(msg.getPropertyDocument());
        boolean canVisual = false;
        int errLine = -1;
        int errMode = 0;
        VisualMessageFactory f = VisualMessageFactory.getInstance();
        if (this.schema != null) {
            c = this.schema.getPopMenuComponent();
            c.removeMouseListener(this);
            this.schema.close();
            this.schema = null;
        }
        try {
            this.schema = f.createSchemaEditor(msg.getMsgType());
            String filename = this.mapDocument.getFileName();
            if (filename == null || filename.equals(MappingEditor.NO_NAMING_FILE)) {
                filename = MappingEditor.USER_DIR;
            } else {
                try {
                    FileEx file = new FileEx(filename);
                    String parent = file.getParent();
                    filename = parent != null ? parent : MappingEditor.USER_DIR;
                }
                catch (Exception ex) {
                    filename = MappingEditor.USER_DIR;
                }
            }
            this.schema.setDefaultFilePath(filename);
        }
        catch (Exception filename) {
            // empty catch block
        }
        if (this.visualEditorPanel != null) {
            this.remove(this.visualEditorPanel);
        }
        if (this.schema != null && this.schema.getEditorPanel() != null) {
            this.schema.setNameChangedListener(this);
            this.schema.setExceptionListener(this);
            this.visualEditorPanel = this.schema.getEditorPanel();
            c = this.schema.getPopMenuComponent();
            c.addMouseListener(this);
            if (this.mapFileDropListener != null) {
                DropTarget ex = new DropTarget(c, this.mapFileDropListener);
            }
            this.insertTab("Visual Editor", null, this.visualEditorPanel, "Visual Editor", 0);
            this.validate();
            try {
                this.schema.load(this.mapDocument.getParameters(), msg.getProperties(), msg.getSchemaModel());
                canVisual = true;
            }
            catch (SAXParseException e1) {
                String pid = e1.getPublicId();
                errMode = "[Schema]".equals(pid) ? 2 : 1;
                Debug.println(pid + "<" + e1.getLineNumber() + "," + e1.getColumnNumber() + ">" + e1.getMessage());
                canVisual = false;
                errLine = e1.getLineNumber();
            }
            catch (Exception e2) {
                errLine = 0;
                Debug.println(e2.getMessage());
                canVisual = false;
            }
        }
        if (canVisual) {
            this.setSelectedComponent(this.visualEditorPanel);
        } else {
            this.disEnabledTabSelectHandel = true;
            this.setSelectedComponent(this.textEditorPanel);
            this.disEnabledTabSelectHandel = false;
            if (errLine > 0) {
                if (errMode == 1) {
                    this.propertyEditor.selectLine(errLine);
                } else {
                    this.schemaTextEditor.selectLine(errLine);
                }
            }
        }
    }

    public String getMsgName() {
        return this.msgName;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        JMenu menu;
        e.getComponent().requestFocus();
        if ((e.getModifiers() & 0x10) == 0 && (menu = this.getMenu()) != null) {
            JPopupMenu popmenu = menu.getPopupMenu();
            popmenu.addPopupMenuListener(this);
            this.setMenuStatus();
            popmenu.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
        JPopupMenu popmenu = (JPopupMenu)e.getSource();
        JMenu menu = this.getMenu();
        if (menu != null) {
            popmenu.setInvoker(menu);
        }
        popmenu.removePopupMenuListener(this);
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent e) {
    }

    @Override
    public void messageItemSelected(String id2, int line) {
        if (line > 0) {
            if (id2.equals("[Schema]")) {
                this.schemaTextEditor.selectLine(line);
            } else {
                this.propertyEditor.selectLine(line);
            }
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (this.disEnabledTabSelectHandel) {
            return;
        }
        boolean sc = true;
        this.clearMessage();
        if (this.getSelectedIndex() == 0) {
            this.focusPanel = 3;
            sc = this.reloadVisual();
        } else {
            if (this.schema != null && this.schema.isChanged()) {
                String name2 = this.getMsgName();
                MapDocument.DeclSegment msg = this.mapDocument.getDeclSegment(name2);
                if (msg != null) {
                    try {
                        msg.setProperties(this.schema.getProperties());
                        this.msgName = msg.getMsgName();
                    }
                    catch (SAXParseException e1) {
                        Debug.println("[Property]<" + e1.getLineNumber() + "," + e1.getColumnNumber() + ">" + e1.getMessage());
                        sc = false;
                    }
                    catch (Exception e2) {
                        Debug.println("[Property]" + e2.getMessage());
                        sc = false;
                    }
                } else {
                    sc = false;
                }
                if (sc) {
                    try {
                        msg.setSchemaModel(this.schema.getSchema());
                        this.schema.clearChanged();
                    }
                    catch (SAXParseException e1) {
                        Debug.println("[Schema]<" + e1.getLineNumber() + "," + e1.getColumnNumber() + ">" + e1.getMessage());
                        sc = false;
                    }
                    catch (Exception e2) {
                        Debug.println("[Schema]" + e2.getMessage());
                        sc = false;
                    }
                }
            }
            this.propertyEditor.invalidate();
            this.propertyEditor.repaint();
            this.schemaTextEditor.invalidate();
            this.propertyEditor.repaint();
            this.schemaTextEditor.requestFocus();
            this.propertyEditor.requestFocus();
        }
        if (!sc) {
            this.disEnabledTabSelectHandel = true;
            if (this.getSelectedIndex() == 0) {
                if (this.getTabCount() > 1) {
                    this.setSelectedIndex(1);
                }
            } else {
                this.setSelectedIndex(0);
            }
            this.disEnabledTabSelectHandel = false;
        }
        this.editorStatusChanged(2, new EventObject(this));
    }

    boolean reloadVisual() {
        if (!this.schemaTextEditor.isChanged() && !this.propertyEditor.isChanged()) {
            return true;
        }
        MapDocument.DeclSegment msg = this.mapDocument.getDeclSegment(this.getMsgName());
        if (msg == null) {
            msg = this.mapDocument.getDeclSegment(this.getMsgName());
        }
        if (msg != null && this.schema != null) {
            Properties ps = null;
            Object smode = null;
            try {
                ps = msg.getProperties();
                this.msgName = msg.getMsgName();
            }
            catch (SAXParseException e1) {
                Debug.println("[Property]<" + e1.getLineNumber() + "," + e1.getColumnNumber() + ">" + e1.getMessage());
                this.propertyEditor.selectLine(e1.getLineNumber());
                return false;
            }
            catch (Exception e2) {
                Debug.println("[Property]" + e2.getMessage());
                return false;
            }
            try {
                smode = msg.getSchemaModel();
            }
            catch (SAXParseException e1) {
                Debug.println("[Schema]<" + e1.getLineNumber() + "," + e1.getColumnNumber() + ">" + e1.getMessage());
                this.schemaTextEditor.selectLine(e1.getLineNumber());
                return false;
            }
            catch (Exception e2) {
                Debug.println("[Schema]" + e2.getMessage());
                return false;
            }
            try {
                this.schema.load(this.mapDocument.getParameters(), ps, smode);
            }
            catch (SAXParseException e1) {
                Debug.println("[Schema]<" + e1.getLineNumber() + "," + e1.getColumnNumber() + ">" + e1.getMessage());
                return false;
            }
            catch (Exception e2) {
                Debug.println("[Schema]" + e2.getMessage());
                return false;
            }
            this.schemaTextEditor.clearChanged();
            this.propertyEditor.clearChanged();
        }
        return true;
    }

    @Override
    public JToolBar getToolBar() {
        if (this.isTextEditor()) {
            return this.focusPanel == 1 ? this.toolBar1 : this.toolBar2;
        }
        if (this.schema != null) {
            return this.schema.getToolBar();
        }
        return null;
    }

    @Override
    public JMenu getMenu() {
        if (this.isTextEditor()) {
            return this.focusPanel == 1 ? this.menu1 : this.menu2;
        }
        if (this.schema != null) {
            return this.schema.getMenu();
        }
        return null;
    }

    private JToolBar createToolbar(String[] names, TextEditorPanel schemaTextEditor) {
        JToolBar toolbar = new JToolBar();
        toolbar.setMargin(MappingEditor.toolBarInsets);
        toolbar.setFloatable(false);
        int n = names.length;
        for (int i = 0; i < n; ++i) {
            if (names[i].equals("-")) {
                toolbar.addSeparator();
                continue;
            }
            Action act = schemaTextEditor.getAction(names[i]);
            if (act == null) continue;
            ImageIcon icon = (ImageIcon)act.getValue("SmallIcon");
            JButton bt = new JButton((Icon)icon){

                @Override
                public float getAlignmentY() {
                    return 0.5f;
                }
            };
            bt.setRequestFocusEnabled(false);
            bt.setMargin(MappingEditor.toolBarImgButtonInsets);
            bt.setName(names[i]);
            bt.setToolTipText((String)act.getValue("ShortDescription"));
            bt.addActionListener(act);
            toolbar.add(bt);
            bt.setName(names[i]);
        }
        return toolbar;
    }

    private JMenu createMenu(String[][] items, TextEditorPanel schemaTextEditor) {
        String s = MappingException.getMessage("MENU_EDIT");
        if (s.indexOf("E") < 0) {
            s = s + "(E)";
        }
        JMenu menu = new JMenu(s);
        menu.setMnemonic('E');
        Font font1 = menu.getFont();
        Font font = new Font(font1.getName(), 0, 12);
        menu.setFont(font);
        for (int i = 0; i < items.length; ++i) {
            String itemname = items[i][0];
            if (itemname.equals("-")) {
                menu.addSeparator();
                continue;
            }
            Action act = schemaTextEditor.getAction(itemname);
            String dec = (String)act.getValue("ShortDescription");
            if (items[i][1] != null && dec.indexOf(items[i][1]) < 0) {
                dec = dec + "(" + items[i][1] + ")";
            }
            JMenuItem menuItem = items[i][2] == null ? new JMenuItem(dec) : new JCheckBoxMenuItem(dec);
            menuItem.setName(itemname);
            menu.add(menuItem);
            ImageIcon icon = (ImageIcon)act.getValue("SmallIcon");
            if (icon != null) {
                menuItem.setIcon(icon);
                menuItem.setHorizontalTextPosition(4);
            }
            menuItem.addActionListener(act);
            if (items[i][1] != null) {
                menuItem.setMnemonic(items[i][1].charAt(0));
            }
            if (items[i][2] != null) {
                menuItem.setSelected(items[i][2].equals("Y"));
            }
            if (items[i][3] != null) {
                try {
                    s = items[i][3];
                    int k = s.indexOf(":");
                    if (k >= 0) {
                        int mask = Integer.parseInt(s.substring(0, k));
                        int keyid = Integer.parseInt(s.substring(k + 1));
                        menuItem.setAccelerator(KeyStroke.getKeyStroke(keyid, mask));
                    } else {
                        int keyid = Integer.parseInt(s);
                        menuItem.setAccelerator(KeyStroke.getKeyStroke(keyid, 0));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            menuItem.setFont(font);
        }
        return menu;
    }

    void clearMessage() {
    }

    void printMessage(String msg) {
    }

    public void clearMessageArea() {
        this.clearMessage();
    }

    public void printlnMessage(String msg) {
        this.printMessage(msg);
    }
}

