/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.map;

import com.argo21.common.gui.ComboTextFieldEx;
import com.argo21.common.gui.FileOrUrlOpenDialog;
import com.argo21.common.gui.GuiUtils;
import com.argo21.common.gui.ImageLoader;
import com.argo21.common.gui.StatusChangedListener;
import com.argo21.common.gui.TextEditorPanel;
import com.argo21.common.io.Debug;
import com.argo21.common.io.FileEx;
import com.argo21.common.io.XReader;
import com.argo21.common.lang.Variable;
import com.argo21.common.lang.VariableReference;
import com.argo21.common.lang.XData;
import com.argo21.common.lang.XObject;
import com.argo21.common.lang.XString;
import com.argo21.common.util.BizTranCache;
import com.argo21.common.util.Properties;
import com.argo21.js.CompileExceptionListener;
import com.argo21.js.DebugStatusListener;
import com.argo21.js.Debuger;
import com.argo21.js.ScriptEngine;
import com.argo21.js.ScriptErrorHandler;
import com.argo21.js.ScriptException;
import com.argo21.map.EvalViewer;
import com.argo21.map.MapDocument;
import com.argo21.map.MappingEditor;
import com.argo21.map.MappingException;
import com.argo21.map.WorkSpace;
import com.argo21.msg.BaseMessage;
import com.argo21.msg.DocumentViewer;
import com.argo21.msg.MessageErrorHandler;
import com.argo21.msg.MessageException;
import com.argo21.msg.MessageFactory;
import com.argo21.msg.VisualMessageFactory;
import com.argo21.msg.xml.XmlMsg;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Window;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.BufferedWriter;
import java.io.CharArrayReader;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.PlainDocument;
import javax.swing.text.Segment;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class ScriptDebugerPanel
extends JSplitPane
implements PopupMenuListener,
MouseListener,
FocusListener,
MapDocument.MapDocListener,
WorkSpace,
CompileExceptionListener {
    public static final String CMD_RUN = "run";
    public static final String CMD_STOP = "stop";
    public static final String CMD_TERMINATE = "terminate";
    public static final String CMD_STEP = "step";
    public static final String CMD_STEPOVER = "stepover";
    public static final String CMD_BREAK = "break";
    public static final String CMD_EVAL = "eval";
    public static final String CMD_LOADDOC = "loaddoc";
    public static final String CMD_SAVEDOC = "savedoc";
    public static final String CMD_SUBMITDOC = "submitdoc";
    public static final String CMD_EXITDEBUG = "exit";
    public static final int STATE_RUN = 1;
    public static final int STATE_STOP = 2;
    public static final int STATE_TERMINATE = 4;
    public static final int STATE_STEP = 8;
    public static final int STATE_STEPOVER = 16;
    public static final int STATE_BREAK = 32;
    public static final int STATE_EVAL = 64;
    public static final int STATE_LOADDOC = 128;
    public static final int STATE_SAVEDOC = 256;
    public static final int STATE_SUBMITDOC = 512;
    public static final int STATE_EXITDEBUG = 1024;
    public static final int STATE_FIND = 2048;
    public static final int STATE_FINDNEXT = 4096;
    public static final int UNLOAD = 7328;
    public static final int DOCREADING = 0;
    public static final int RUNNING = 1030;
    public static final int STOPPING = 8189;
    public static final int READY = 8121;
    public static final int TERMINATE = 8185;
    static String[] toolBarNames = new String[]{"run", "stop", "terminate", "-", "step", "stepover", "-", "break", "eval", "-", "FINDTEXT", "exit"};
    static String[][] debugMenus = new String[][]{{"run", "R", null, String.valueOf(116)}, {"stop", "S", null, null}, {"terminate", "T", null, null}, {"-", null, null, null}, {"step", "I", null, String.valueOf(121)}, {"stepover", "O", null, String.valueOf(122)}, {"-", null, null, null}, {"break", "B", null, String.valueOf(120)}, {"eval", "V", null, String.valueOf(117)}, {"-", null, null, null}, {"FINDTEXT", "F", null, "2:70"}, {"REFINDTEXT", "A", null, String.valueOf(114)}, {"-", null, null, null}, {"loaddoc", "L", null, null}, {"savedoc", "A", null, null}, {"submitdoc", "M", null, null}, {"-", null, null, null}, {"exit", "X", null, null}};
    private JToolBar toolBar = null;
    private JMenu menu = null;
    Reference ref = null;
    private MessagePanel inputMsgPanel = null;
    private MessagePanel outputMsgPanel = null;
    private TextEditorPanel scriptEditor = null;
    private boolean resized = false;
    private DropTargetListener mapFileDropListener = null;
    private Vector myStatusChangedListener = new Vector(1);
    private ToolTipWindow tipwindow = null;
    MapDocument mapDocument = null;
    Debuger debugEngine = null;
    ScriptErrorHandler scriptErrorHandler = null;
    Hashtable msgTable = new Hashtable(3);
    DebugStatusListener debugStatusListener = null;
    int documentStatus = 0;
    private Hashtable actions = new Hashtable(11);
    private int focusPanel = 0;
    private long lastModifie = 0L;
    private boolean msgStructChanged = false;
    private File recentFile = null;
    private ScriptException lastCompileException = null;

    public ScriptDebugerPanel(TextEditorPanel scriptEditor, DropTargetListener mapFileDropListener) {
        super(1, false);
        this.setDividerSize(2);
        this.setBorder(MappingEditor.defaultBorder);
        this.mapFileDropListener = mapFileDropListener;
        this.inputMsgPanel = new MessagePanel();
        this.setLeftComponent(this.inputMsgPanel);
        this.outputMsgPanel = new MessagePanel();
        this.setRightComponent(this.outputMsgPanel);
        if (mapFileDropListener != null) {
            DropTarget target1 = new DropTarget(this.inputMsgPanel, mapFileDropListener);
            DropTarget dropTarget = new DropTarget(this.outputMsgPanel, mapFileDropListener);
        }
        this.scriptEditor = scriptEditor;
        this.registActions();
        this.debugStatusListener = new DebugStatusListener(){

            @Override
            public void statusChanged(int oldStatus, int newStatus) {
                ScriptDebugerPanel.this.debugStatusChanged(oldStatus, newStatus);
            }
        };
    }

    void pleaceScriptEditor() {
        this.scriptEditor.requestDefaultFocus();
        this.scriptEditor.addStatusChangedListener(new StatusChangedListener(){

            @Override
            public void statusChanged(int id2, EventObject e) {
                ScriptDebugerPanel.this.editorStatusChanged(id2, e);
            }
        });
        Component c = this.scriptEditor.getDragComponent();
        c.addMouseListener(this);
        c.addFocusListener(this);
        this.scriptEditor.setEditable(false);
    }

    void removeScriptEditor() {
        this.scriptEditor.clearStatusChangedListener();
        Component c = this.scriptEditor.getDragComponent();
        c.removeMouseListener(this);
        c.removeFocusListener(this);
    }

    @Override
    public void focusGained(FocusEvent e) {
        Component c = e.getComponent();
        this.setFocusTo(c);
    }

    private void setFocusTo(Component c) {
        while (c != null) {
            if (c == this.scriptEditor) {
                if (this.focusPanel == 3) {
                    return;
                }
                this.focusPanel = 3;
                this.inputMsgPanel.setBorder(MappingEditor.defaultBorder);
                this.outputMsgPanel.setBorder(MappingEditor.defaultBorder);
                this.scriptEditor.setBorder(MappingEditor.selectBorder);
                break;
            }
            if (c == this.inputMsgPanel) {
                if (this.focusPanel == 1) {
                    return;
                }
                this.focusPanel = 1;
                this.inputMsgPanel.setBorder(MappingEditor.selectBorder);
                this.outputMsgPanel.setBorder(MappingEditor.defaultBorder);
                this.scriptEditor.setBorder(MappingEditor.defaultBorder);
                break;
            }
            if (c == this.outputMsgPanel) {
                if (this.focusPanel == 2) {
                    return;
                }
                this.focusPanel = 2;
                this.inputMsgPanel.setBorder(MappingEditor.defaultBorder);
                this.outputMsgPanel.setBorder(MappingEditor.selectBorder);
                this.scriptEditor.setBorder(MappingEditor.defaultBorder);
                break;
            }
            c = c.getParent();
        }
        if (this.toolBar != null) {
            this.setToobarStatus();
        }
        if (this.menu != null) {
            this.setMenuStatus();
        }
    }

    @Override
    public void focusLost(FocusEvent e) {
    }

    public void resetDivider() {
        this.setDividerLocation(0.5);
        this.validate();
    }

    void setActionEnable(String cmd, boolean b) {
        Action act = (Action)this.actions.get(cmd);
        if (act == null) {
            return;
        }
        act.setEnabled(b);
        if (this.toolBar != null) {
            this.setToobarStatus();
        }
        if (this.menu != null) {
            this.setMenuStatus();
        }
    }

    void setActionEnable(int status) {
        Enumeration em = this.actions.elements();
        while (em.hasMoreElements()) {
            Action a = (Action)em.nextElement();
            Integer intv = (Integer)a.getValue("LongDescription");
            if (intv == null) continue;
            a.setEnabled((intv & status) != 0);
        }
        if (this.toolBar != null) {
            this.setToobarStatus();
        }
        if (this.menu != null) {
            this.setMenuStatus();
        }
    }

    void debugStatusChanged(int oldStatus, int newStatus) {
        final int status = newStatus;
        final String statusMessage = this.debugEngine.getStatusMessage();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ScriptDebugerPanel.this.setStatusText(statusMessage);
                if (status == 1 || status == 0) {
                    ScriptDebugerPanel.this.setActionEnable(7328);
                } else if (status == 2) {
                    ScriptDebugerPanel.this.setActionEnable(8121);
                } else if (status == 3) {
                    ScriptDebugerPanel.this.setActionEnable(1030);
                } else if (status == 5) {
                    ScriptDebugerPanel.this.setActionEnable(8189);
                    ScriptDebugerPanel.this.markCurrentLine();
                    ScriptDebugerPanel.this.outputMsgPanel.viewResult();
                } else if (status == 4) {
                    String msg;
                    ScriptDebugerPanel.this.setActionEnable(8185);
                    try {
                        Exception e = ScriptDebugerPanel.this.debugEngine.getLastException();
                        if (e != null) {
                            throw e;
                        }
                        msg = ScriptDebugerPanel.this.debugEngine.getStatusMessage();
                    }
                    catch (SAXParseException e) {
                        ScriptDebugerPanel.this.scriptEditor.selectLine(e.getLineNumber());
                        msg = "<" + e.getLineNumber() + "," + e.getColumnNumber() + "> " + e.getMessage();
                    }
                    catch (Exception e1) {
                        msg = e1.toString();
                    }
                    ScriptDebugerPanel.this.printMessage(msg);
                    ScriptDebugerPanel.this.markCurrentLine();
                    ScriptDebugerPanel.this.outputMsgPanel.viewResult();
                }
            }
        });
        if (status == 4 && this.scriptErrorHandler != null) {
            this.scriptErrorHandler.reset();
        }
    }

    void setStatusText(String text) {
    }

    public boolean isDocumentProcessing() {
        return this.documentStatus > 0;
    }

    void setMenuStatus() {
        block11: {
            int n;
            block12: {
                block10: {
                    n = this.menu.getMenuComponentCount();
                    if (this.focusPanel != 1) break block10;
                    for (int i = 0; i < n; ++i) {
                        Action at;
                        Component c = this.menu.getMenuComponent(i);
                        String name2 = c.getName();
                        if (name2 == null) continue;
                        if (CMD_LOADDOC.equals(name2)) {
                            at = (Action)this.actions.get(name2);
                            c.setEnabled(at != null && at.isEnabled() && this.documentStatus == 0);
                            continue;
                        }
                        if (CMD_BREAK.equals(name2) || CMD_SAVEDOC.equals(name2) || CMD_SUBMITDOC.equals(name2) || "FINDTEXT".equals(name2)) {
                            c.setEnabled(false);
                            continue;
                        }
                        at = (Action)this.actions.get(name2);
                        c.setEnabled(at != null && at.isEnabled() && this.documentStatus == 0);
                    }
                    break block11;
                }
                if (this.focusPanel != 2) break block12;
                for (int i = 0; i < n; ++i) {
                    Component c = this.menu.getMenuComponent(i);
                    String name3 = c.getName();
                    if (name3 == null) continue;
                    if (CMD_SAVEDOC.equals(name3)) {
                        Action at = (Action)this.actions.get(name3);
                        c.setEnabled(at != null && at.isEnabled() && this.documentStatus == 0);
                        continue;
                    }
                    if (CMD_SUBMITDOC.equals(name3)) {
                        Action at;
                        boolean submit = false;
                        BaseMessage msg = this.outputMsgPanel.getSelectedMessage();
                        if (msg != null) {
                            String connect = msg.getProperties().getValue("connect");
                            submit = connect != null;
                        }
                        c.setEnabled((at = (Action)this.actions.get(name3)) != null && at.isEnabled() && submit && this.documentStatus == 0);
                        continue;
                    }
                    if (CMD_BREAK.equals(name3) || CMD_LOADDOC.equals(name3) || "FINDTEXT".equals(name3)) {
                        c.setEnabled(false);
                        continue;
                    }
                    Action at = (Action)this.actions.get(name3);
                    c.setEnabled(at != null && at.isEnabled() && this.documentStatus == 0);
                }
                break block11;
            }
            if (this.focusPanel != 3) break block11;
            for (int i = 0; i < n; ++i) {
                Component c = this.menu.getMenuComponent(i);
                String name4 = c.getName();
                if (name4 == null) continue;
                if (CMD_LOADDOC.equals(name4) || CMD_SAVEDOC.equals(name4) || CMD_SUBMITDOC.equals(name4)) {
                    c.setEnabled(false);
                    continue;
                }
                Action at = (Action)this.actions.get(c.getName());
                c.setEnabled(at != null && at.isEnabled() && this.documentStatus == 0);
            }
        }
    }

    void setToobarStatus() {
        block4: {
            int n;
            block3: {
                n = this.toolBar.getComponentCount();
                if (this.focusPanel != 1 && this.focusPanel != 2) break block3;
                for (int i = 0; i < n; ++i) {
                    Component c = this.toolBar.getComponent(i);
                    String name2 = c.getName();
                    if (name2 == null) continue;
                    if (CMD_BREAK.equals(name2) || "FINDTEXT".equals(name2)) {
                        c.setEnabled(false);
                        continue;
                    }
                    Action at = (Action)this.actions.get(name2);
                    c.setEnabled(at != null && at.isEnabled() && this.documentStatus == 0);
                }
                break block4;
            }
            if (this.focusPanel != 3) break block4;
            for (int i = 0; i < n; ++i) {
                Component c = this.toolBar.getComponent(i);
                String name3 = c.getName();
                if (name3 == null) continue;
                Action at = (Action)this.actions.get(name3);
                c.setEnabled(at != null && at.isEnabled() && this.documentStatus == 0);
            }
        }
    }

    private void editorStatusChanged(int id2, EventObject e) {
        if (this.myStatusChangedListener != null) {
            int n = this.myStatusChangedListener.size();
            for (int i = 0; i < n; ++i) {
                StatusChangedListener l = (StatusChangedListener)this.myStatusChangedListener.elementAt(i);
                l.statusChanged(id2, e);
            }
        }
    }

    @Override
    public void addStatusChangedListener(StatusChangedListener l) {
        this.myStatusChangedListener.addElement(l);
    }

    @Override
    public void removeStatusChangedListener(StatusChangedListener l) {
        this.myStatusChangedListener.removeElement(l);
    }

    @Override
    public boolean isChanged() {
        return this.scriptEditor.isChanged();
    }

    @Override
    public void clearChanged() {
        this.scriptEditor.clearChanged();
    }

    @Override
    public String getWorkSpaceName() {
        return MappingEditor.WKS_DEBUGER;
    }

    @Override
    public void load(MapDocument mapDoc) throws SAXException {
        if (this.mapDocument != null) {
            this.mapDocument.removeMapDocumentListener(this);
        }
        this.mapDocument = mapDoc;
        this.mapDocument.addMapDocumentListener(this);
    }

    void closeDebugEngine() {
        try {
            if (this.debugEngine != null) {
                int status = this.debugEngine.getStatus();
                if (status == 5 || status == 3) {
                    this.debugEngine.debugexit();
                }
                if (this.debugStatusListener != null) {
                    this.debugEngine.removeDebugStatusListener(this.debugStatusListener);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.debugEngine = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close() {
        if (this.mapDocument != null) {
            this.mapDocument.removeMapDocumentListener(this);
        }
        this.closeDebugEngine();
        Enumeration en = this.msgTable.elements();
        while (en.hasMoreElements()) {
            BaseMessage msg = (BaseMessage)en.nextElement();
            try {
                BaseMessage baseMessage = msg;
                synchronized (baseMessage) {
                    msg.close();
                }
            }
            catch (Exception e) {
                System.err.println(e);
            }
        }
        this.msgTable.clear();
        this.removeScriptEditor();
        if (this.tipwindow != null) {
            this.tipwindow.dispose();
            this.tipwindow = null;
        }
    }

    public void reload() throws SAXException {
        MessageFactory f = MessageFactory.getInstance();
        MapDocument.DeclSegment[] msgdecls = this.mapDocument.getDeclSegments();
        int n = msgdecls.length;
        Vector<BaseMessage> inputMsgs = new Vector<BaseMessage>();
        Vector<BaseMessage> outputMsgs = new Vector<BaseMessage>();
        for (int i = 0; i < n; ++i) {
            String dir = msgdecls[i].getDirection();
            String msgname = msgdecls[i].getMsgName();
            String msgtype = msgdecls[i].getMsgType();
            try {
                BaseMessage msgmod = (BaseMessage)this.msgTable.get(msgname);
                if (msgmod == null) {
                    msgmod = f.createMessage(msgtype);
                    msgmod.setPrameters(this.mapDocument.getParameters());
                    this.msgTable.put(msgname, msgmod);
                }
                msgmod.setProperties(msgdecls[i].getProperties());
                msgmod.setSchema(msgdecls[i].getSchemaModel());
                msgmod.init();
                if (dir.equals("INPUT")) {
                    inputMsgs.addElement(msgmod);
                    continue;
                }
                outputMsgs.addElement(msgmod);
                continue;
            }
            catch (SAXParseException e) {
                throw new MessageException(e.getMessage(), e.getPublicId(), msgname, e.getLineNumber(), e.getColumnNumber(), e.getException());
            }
            catch (SAXException e) {
                throw new MessageException(e.getMessage(), "", msgname, 0, 0, e.getException());
            }
            catch (Exception e) {
                throw new MessageException(e.getMessage(), "", msgname, 0, 0, e);
            }
        }
        this.inputMsgPanel.load(inputMsgs);
        this.outputMsgPanel.load(outputMsgs);
        this.lastModifie = this.mapDocument.getLastModifie();
        this.msgStructChanged = false;
    }

    public void addAllBreakers() {
        try {
            this.debugEngine.clearAllBreaker();
        }
        catch (Exception e) {
            Debug.println(e.getMessage());
        }
        int[] bks = this.scriptEditor.getMarks();
        for (int i = 0; i < bks.length; ++i) {
            try {
                this.debugEngine.addBreaker(bks[i]);
                continue;
            }
            catch (Exception e) {
                Debug.println(e.getMessage());
            }
        }
    }

    @Override
    public void saveBack() throws SAXException {
        if (this.debugEngine != null) {
            this.cmd_terminate();
        }
    }

    @Override
    public void exceptionHappened(ScriptException e) {
        if (this.lastCompileException != null) {
            String s = "<" + this.lastCompileException.getLineNumber() + "," + this.lastCompileException.getColumnNumber() + "> " + this.lastCompileException.getMessage();
            this.printMessage(s);
        }
        this.lastCompileException = e;
    }

    @Override
    public void review() throws SAXException {
        this.clearMessage();
        boolean scriptchanged = this.lastModifie < this.mapDocument.getScriptSegment().getLastModifie();
        boolean changed = this.msgStructChanged;
        if (!changed) {
            MapDocument.DeclSegment[] msglist = this.mapDocument.getDeclSegments();
            for (int i = 0; i < msglist.length; ++i) {
                if (msglist[i].getLastModifie() <= this.lastModifie) continue;
                changed = true;
                break;
            }
        }
        if (!this.resized && this.getHeight() > 20 && this.getWidth() > 20) {
            this.resized = true;
            this.resetDivider();
        }
        if (changed) {
            this.reload();
        }
        if (changed || this.debugEngine == null) {
            this.debugEngine = ScriptEngine.getDebugEngine();
            this.debugEngine.setCompileExceptionListener(this);
            this.debugEngine.addDebugStatusListener(this.debugStatusListener);
            this.scriptErrorHandler = new ScriptErrorHandler();
            this.debugEngine.setErrorHandler(this.scriptErrorHandler);
        }
        VariableReference vars = this.debugEngine.getVariableReference();
        Properties params = this.mapDocument.getParameters();
        int n = params.getSize();
        for (int i = 0; i < n; ++i) {
            String pn = params.getName(i);
            String pv = params.getValue(i);
            vars.putFixVariable(new Variable(pn, new XString(pv)));
        }
        Enumeration em = this.msgTable.elements();
        while (em.hasMoreElements()) {
            BaseMessage msg = (BaseMessage)em.nextElement();
            vars.putFixVariable(new Variable(msg.getMsgName(), new XObject(msg)));
        }
        MapDocument.ScriptSegment doc = this.mapDocument.getScriptSegment();
        Segment se = doc.getDocumentSegment();
        XReader in = XReader.createReader(se.array, se.offset, se.count, null);
        this.lastCompileException = null;
        this.debugEngine.loadScripts(in);
        if (this.lastCompileException != null) {
            ScriptException tmp = this.lastCompileException;
            this.lastCompileException = null;
            throw tmp;
        }
        this.printMessage(MappingException.getMessage("CP_SUCCESS"));
        this.lastModifie = this.mapDocument.getScriptSegment().getLastModifie();
        this.addAllBreakers();
        this.debugEngine.reset();
        this.scriptEditor.requestFocus();
    }

    private Frame getFrame() {
        Container parent;
        for (parent = this; parent != null && !(parent instanceof Frame); parent = parent.getParent()) {
        }
        if (parent != null) {
            return (Frame)parent;
        }
        return null;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.setFocusTo(e.getComponent());
        if ((e.getModifiers() & 0x10) == 0) {
            if (e.getSource() == this.scriptEditor.getDragComponent()) {
                this.scriptEditor.requestFocus();
                JPopupMenu popmenu = this.getMenu().getPopupMenu();
                popmenu.addPopupMenuListener(this);
                this.setMenuStatus();
                popmenu.show(e.getComponent(), e.getX(), e.getY());
            } else {
                JPopupMenu popmenu = this.getMenu().getPopupMenu();
                popmenu.addPopupMenuListener(this);
                this.setMenuStatus();
                popmenu.show(e.getComponent(), e.getX(), e.getY());
            }
        } else if (this.debugEngine != null && e.getSource() == this.scriptEditor.getDragComponent() && e.isControlDown()) {
            String s = this.scriptEditor.getSelectWord();
            if (s == null) {
                this.hideToolTipWindow();
            } else {
                Variable var1 = this.debugEngine.getVariableReference().getVariable(s);
                if (var1 == null) {
                    return;
                }
                XData data = var1.getData();
                if (data == null || data.isNull()) {
                    return;
                }
                StringWriter sw = new StringWriter();
                try {
                    data.dump(sw);
                }
                catch (Exception e1) {
                    return;
                }
                this.showToolTipWindow(e.getComponent(), e.getX(), e.getY(), sw.toString());
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.hideToolTipWindow();
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
        JPopupMenu popmenu = (JPopupMenu)e.getSource();
        popmenu.setInvoker(this.menu);
        popmenu.removePopupMenuListener(this);
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent e) {
    }

    @Override
    public JToolBar getToolBar() {
        if (this.toolBar == null) {
            this.toolBar = this.createToolbar(toolBarNames);
        }
        return this.toolBar;
    }

    @Override
    public JMenu getMenu() {
        if (this.menu == null) {
            this.menu = this.creatMenu(debugMenus);
        }
        return this.menu;
    }

    @Override
    public void messageItemSelected(String id2, int line) {
        if (line > 0) {
            this.scriptEditor.selectLine(line);
        }
    }

    private JToolBar createToolbar(String[] names) {
        JToolBar toolbar = new JToolBar();
        toolbar.setMargin(MappingEditor.toolBarInsets);
        toolbar.setFloatable(false);
        int n = names.length;
        for (int i = 0; i < n; ++i) {
            if (names[i].equals("-")) {
                toolbar.addSeparator();
                continue;
            }
            Action act = (Action)this.actions.get(names[i]);
            if (act == null) continue;
            ImageIcon icon = (ImageIcon)act.getValue("SmallIcon");
            String lab = null;
            if (icon == null) {
                lab = (String)act.getValue("ShortDescription");
            }
            JButton bt = new JButton(lab, icon){

                @Override
                public float getAlignmentY() {
                    return 0.5f;
                }
            };
            bt.setRequestFocusEnabled(false);
            bt.setMargin(icon == null ? MappingEditor.toolBarTextButtonInsets : MappingEditor.toolBarImgButtonInsets);
            bt.setName(names[i]);
            bt.setToolTipText((String)act.getValue("ShortDescription"));
            bt.addActionListener(act);
            toolbar.add(bt);
            bt.setName(names[i]);
        }
        return toolbar;
    }

    private JMenu creatMenu(String[][] items) {
        String s = MappingException.getMessage("MENU_DEBUG");
        if (s.indexOf("D") < 0) {
            s = s + "(D)";
        }
        JMenu menu = new JMenu(s);
        menu.setMnemonic('E');
        Font font1 = menu.getFont();
        Font font = new Font(font1.getName(), 0, 12);
        menu.setFont(font);
        for (int i = 0; i < items.length; ++i) {
            String itemname = items[i][0];
            if (itemname.equals("-")) {
                menu.addSeparator();
                continue;
            }
            Action act = (Action)this.actions.get(itemname);
            String dec = (String)act.getValue("ShortDescription");
            if (items[i][1] != null && dec.indexOf(items[i][1]) < 0) {
                dec = dec + "(" + items[i][1] + ")";
            }
            JMenuItem menuItem = items[i][2] == null ? new JMenuItem(dec) : new JCheckBoxMenuItem(dec);
            menuItem.setName(itemname);
            menu.add(menuItem);
            ImageIcon icon = (ImageIcon)act.getValue("SmallIcon");
            if (icon == null) {
                icon = ImageLoader.load("empty.gif", "");
            }
            menuItem.setIcon(icon);
            menuItem.setHorizontalTextPosition(4);
            menuItem.addActionListener(act);
            if (items[i][1] != null) {
                menuItem.setMnemonic(items[i][1].charAt(0));
            }
            if (items[i][2] != null) {
                menuItem.setSelected(items[i][2].equals("Y"));
            }
            if (items[i][3] != null) {
                try {
                    s = items[i][3];
                    int k = s.indexOf(":");
                    if (k >= 0) {
                        int mask = Integer.parseInt(s.substring(0, k));
                        int keyid = Integer.parseInt(s.substring(k + 1));
                        menuItem.setAccelerator(KeyStroke.getKeyStroke(keyid, mask));
                    } else {
                        int keyid = Integer.parseInt(s);
                        menuItem.setAccelerator(KeyStroke.getKeyStroke(keyid, 0));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            menuItem.setFont(font);
        }
        return menu;
    }

    void cmd_run() {
        block9: {
            try {
                if (this.debugEngine == null || this.documentStatus > 0) {
                    return;
                }
                int status = this.debugEngine.getStatus();
                if (status == 5) {
                    this.debugEngine.continued();
                    break block9;
                }
                if (status == 2) {
                    if (!this.inputMsgPanel.checkReady()) {
                        return;
                    }
                    BizTranCache.init();
                    this.clearMessage();
                    this.outputMsgPanel.resetDocument();
                    this.debugEngine.execute();
                    break block9;
                }
                if (status == 4) {
                    if (!this.inputMsgPanel.checkReady()) {
                        return;
                    }
                    BizTranCache.init();
                    this.clearMessage();
                    this.outputMsgPanel.resetDocument();
                    this.debugEngine.execute();
                    break block9;
                }
                return;
            }
            catch (SAXParseException e) {
                this.scriptEditor.selectLine(e.getLineNumber());
                Debug.println("<" + e.getLineNumber() + "," + e.getColumnNumber() + "> " + e.getMessage());
            }
            catch (Exception e1) {
                Debug.println(e1.toString());
            }
        }
    }

    void markCurrentLine() {
        int s = this.debugEngine.getStatus();
        if (s == 5 || s == 2) {
            this.scriptEditor.moveLineMark(this.debugEngine.getCurrentLine());
        } else {
            this.scriptEditor.moveLineMark(0);
        }
    }

    void clearMarkLine() {
        this.scriptEditor.moveLineMark(0);
    }

    void cmd_stop() {
        try {
            int status = this.debugEngine.getStatus();
            if (status == 3) {
                this.debugEngine.debugstop();
            }
        }
        catch (SAXParseException e) {
            this.scriptEditor.selectLine(e.getLineNumber());
            Debug.println("<" + e.getLineNumber() + ",0> " + e.getMessage());
        }
        catch (Exception e1) {
            Debug.println(e1.getMessage());
        }
    }

    void cmd_terminate() {
        if (this.debugEngine == null) {
            return;
        }
        try {
            int status = this.debugEngine.getStatus();
            if (status == 5 || status == 3) {
                this.debugEngine.debugexit();
            }
        }
        catch (SAXParseException e) {
            this.scriptEditor.selectLine(e.getLineNumber());
            Debug.println("<" + e.getLineNumber() + ",0> " + e.getMessage());
        }
        catch (Exception e1) {
            Debug.println(e1.getMessage());
        }
    }

    void cmd_step() {
        block9: {
            try {
                if (this.debugEngine == null || this.documentStatus > 0) {
                    return;
                }
                int status = this.debugEngine.getStatus();
                if (status == 5) {
                    this.debugEngine.step();
                    break block9;
                }
                if (status == 2) {
                    if (!this.inputMsgPanel.checkReady()) {
                        return;
                    }
                    BizTranCache.init();
                    this.clearMessage();
                    this.outputMsgPanel.resetDocument();
                    this.debugEngine.step();
                    break block9;
                }
                if (status == 4) {
                    if (!this.inputMsgPanel.checkReady()) {
                        return;
                    }
                    BizTranCache.init();
                    this.clearMessage();
                    this.outputMsgPanel.resetDocument();
                    this.debugEngine.step();
                    break block9;
                }
                return;
            }
            catch (SAXParseException e) {
                this.scriptEditor.selectLine(e.getLineNumber());
                Debug.println("<" + e.getLineNumber() + ",0> " + e.getMessage());
            }
            catch (Exception e1) {
                Debug.println(e1.toString());
            }
        }
    }

    void cmd_stepover() {
        block9: {
            try {
                if (this.debugEngine == null || this.documentStatus > 0) {
                    return;
                }
                int status = this.debugEngine.getStatus();
                if (status == 5) {
                    this.debugEngine.stepOver();
                    break block9;
                }
                if (status == 2) {
                    if (!this.inputMsgPanel.checkReady()) {
                        return;
                    }
                    BizTranCache.init();
                    this.clearMessage();
                    this.outputMsgPanel.resetDocument();
                    this.debugEngine.stepOver();
                    break block9;
                }
                if (status == 4) {
                    if (!this.inputMsgPanel.checkReady()) {
                        return;
                    }
                    BizTranCache.init();
                    this.clearMessage();
                    this.outputMsgPanel.resetDocument();
                    this.debugEngine.stepOver();
                    break block9;
                }
                return;
            }
            catch (SAXParseException e) {
                this.scriptEditor.selectLine(e.getLineNumber());
                Debug.println("<" + e.getLineNumber() + ",0> " + e.getMessage());
            }
            catch (Exception e1) {
                Debug.println(e1.toString());
            }
        }
    }

    void cmd_eval() {
        String s = this.scriptEditor.getSelectWord();
        VariableReference ref = this.debugEngine.getVariableReference();
        EvalViewer viewer = null;
        Window window = SwingUtilities.windowForComponent(this);
        if (window instanceof Frame) {
            viewer = new EvalViewer((Frame)window, ref, s);
        } else if (window instanceof Dialog) {
            viewer = new EvalViewer((Dialog)window, ref, s);
        } else {
            window = new JFrame();
            viewer = new EvalViewer((Frame)window, ref, s);
        }
        Point p = window.getLocation();
        p.translate((window.getWidth() - viewer.getWidth()) / 2, (window.getHeight() - viewer.getHeight()) / 2);
        viewer.setLocation(p);
        viewer.setVisible(true);
    }

    void cmd_break() {
        if (this.debugEngine == null) {
            return;
        }
        int line = this.scriptEditor.getSelectLine();
        Object tag = this.scriptEditor.getMarkTag(line);
        if (tag == null) {
            try {
                this.debugEngine.clearBreaker(line);
            }
            catch (Exception e) {
                Debug.println(e.getMessage());
            }
        } else {
            try {
                if (this.debugEngine.addBreaker(line)) {
                    tag = null;
                } else {
                    Debug.println(MappingException.getMessage("ST_CANT_BREAK", String.valueOf(line)));
                }
            }
            catch (Exception e) {
                Debug.println(e.getMessage());
            }
        }
        if (tag != null) {
            this.scriptEditor.removeMark(tag);
        }
    }

    void cmd_exit() {
        this.cmd_terminate();
    }

    void cmd_load() {
        String fn;
        String fileName;
        if (this.documentStatus > 0) {
            return;
        }
        BaseMessage msg = null;
        if (this.focusPanel == 1) {
            msg = this.inputMsgPanel.getSelectedMessage();
        } else if (this.focusPanel == 2) {
            msg = this.outputMsgPanel.getSelectedMessage();
        }
        if (msg == null) {
            return;
        }
        String msgnm = msg.getMsgName();
        FileFilter filter = msg.getDocumentFileFilter();
        FileOrUrlOpenDialog dlg = null;
        if (this.ref != null) {
            dlg = (FileOrUrlOpenDialog)this.ref.get();
        }
        if (dlg == null) {
            Window window = SwingUtilities.windowForComponent(this);
            dlg = window instanceof Frame ? new FileOrUrlOpenDialog((Frame)window) : (window instanceof Dialog ? new FileOrUrlOpenDialog((Dialog)window) : new FileOrUrlOpenDialog(new Frame()));
        }
        dlg.setFileFilter(filter);
        File file = null;
        URL url = msg.getDocumentURL();
        if (url != null && (fileName = FileEx.urlToFile(url)) != null) {
            file = new File(fileName);
        }
        if (file == null && (fn = this.mapDocument.getFileName()) != null && fn.trim().length() > 0) {
            try {
                file = new FileEx(fn);
                fn = file.getParent();
                dlg.setDefaultFile(file);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (msg instanceof XmlMsg) {
            dlg.setXml(true);
        } else {
            dlg.setXml(false);
        }
        dlg.setTitle(MappingEditor.getMessage("CMD_LOADDOC"));
        dlg.setEncoding(msg.getMsgEncoding());
        dlg.setVisible(true);
        this.ref = new SoftReference<FileOrUrlOpenDialog>(dlg);
        String encoding = dlg.getEncoding();
        String urlString = dlg.getURL();
        if (urlString == null) {
            return;
        }
        Object in = null;
        this.clearMessage();
        try {
            if (encoding != null && !encoding.equalsIgnoreCase(msg.getMsgEncoding())) {
                msg.setMsgEncoding(encoding);
                MapDocument.DeclSegment decl = this.mapDocument.getDeclSegment(msgnm);
                decl.setProperties(msg.getProperties());
            }
        }
        catch (SAXException e) {
            Debug.println(e.getMessage());
        }
        catch (Exception e) {
            Debug.println(e.toString());
        }
        DocumentProcessingThread th = new DocumentProcessingThread(1, msg, urlString);
        th.start();
    }

    void cmd_save() {
        String fileName;
        if (this.documentStatus > 0) {
            return;
        }
        BaseMessage msg = this.outputMsgPanel.getSelectedMessage();
        if (msg == null) {
            return;
        }
        FileFilter filter = msg.getDocumentFileFilter();
        File file = null;
        URL url = msg.getDocumentURL();
        if (url != null && (fileName = FileEx.urlToFile(url)) != null) {
            file = new File(fileName);
        }
        if (file == null && (fileName = this.mapDocument.getFileName()) != null && !MappingEditor.NO_NAMING_FILE.equals(fileName)) {
            try {
                file = new FileEx(fileName).getParentFile();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setMultiSelectionEnabled(false);
        fileChooser.setDialogTitle(MappingException.getMessage("DLG_SAVE"));
        fileChooser.addChoosableFileFilter(filter);
        fileChooser.setFileFilter(filter);
        fileChooser.setPreferredSize(new Dimension(500, 260));
        if (file == null) {
            file = this.recentFile != null ? this.recentFile : new File(MappingEditor.SAMPLES_DIR);
        }
        try {
            if (file.isDirectory()) {
                fileChooser.setCurrentDirectory(file);
            } else {
                fileChooser.setSelectedFile(file);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        Window window = SwingUtilities.windowForComponent(this);
        int result = window != null ? fileChooser.showSaveDialog(window) : fileChooser.showSaveDialog(new JFrame());
        if (result != 0) {
            return;
        }
        this.recentFile = file = fileChooser.getSelectedFile();
        if (file == null) {
            return;
        }
        this.clearMessage();
        String urlString = null;
        try {
            urlString = file.toURL().toString();
        }
        catch (MalformedURLException e) {
            Debug.println(e.toString());
            return;
        }
        DocumentProcessingThread th = new DocumentProcessingThread(2, msg, urlString);
        th.start();
    }

    void cmd_submit() {
        if (this.documentStatus > 0) {
            return;
        }
        BaseMessage msg = this.outputMsgPanel.getSelectedMessage();
        if (msg == null) {
            return;
        }
        String urlString = msg.getProperties().getValue("connect");
        this.clearMessage();
        DocumentProcessingThread th = new DocumentProcessingThread(3, msg, urlString);
        th.start();
    }

    @Override
    public void renamed(String oldName, String newName) {
        Object old = this.msgTable.remove(oldName);
        if (old != null) {
            this.msgTable.put(newName, old);
        }
        this.msgStructChanged = true;
    }

    @Override
    public void inserted(String newName, int index) {
        this.msgStructChanged = true;
    }

    @Override
    public void removed(String msgName) {
        this.msgTable.remove(msgName);
        this.msgStructChanged = true;
    }

    private void showToolTipWindow(Component comp, int x, int y, String text) {
        if (text == null || text.trim().length() == 0) {
            return;
        }
        if (this.tipwindow == null) {
            Frame f = this.getFrame();
            if (f == null) {
                return;
            }
            this.tipwindow = new ToolTipWindow(f);
        }
        Point po = comp.getLocationOnScreen();
        this.tipwindow.setLocation((x += 20) + po.x, (y -= 20) + po.y);
        this.tipwindow.showToolTip(text);
    }

    private void hideToolTipWindow() {
        if (this.tipwindow != null) {
            this.tipwindow.setVisible(false);
        }
    }

    private static Point refLacation(Component comp, Component ref, Point point) {
        if (comp != ref) {
            Point point1 = ref.getLocationOnScreen();
            point.translate(point1.x, point1.y);
            Point point2 = comp.getLocationOnScreen();
            point.translate(-point2.x, -point2.y);
        }
        return point;
    }

    private void registActions() {
        Action a = new MyAction(CMD_RUN, MappingEditor.getMessage("CMD_RUN"), (Icon)ImageLoader.load("run.gif", CMD_RUN)){

            @Override
            public void actionPerformed(ActionEvent e) {
                ScriptDebugerPanel.this.cmd_run();
            }
        };
        a.putValue("LongDescription", new Integer(1));
        a.setEnabled(true);
        this.actions.put(CMD_RUN, a);
        a = new MyAction(CMD_STOP, MappingEditor.getMessage("CMD_STOP"), (Icon)ImageLoader.load("stop.gif", CMD_STOP)){

            @Override
            public void actionPerformed(ActionEvent e) {
                ScriptDebugerPanel.this.cmd_stop();
            }
        };
        a.setEnabled(false);
        a.putValue("LongDescription", new Integer(2));
        this.actions.put(CMD_STOP, a);
        a = new MyAction(CMD_TERMINATE, MappingEditor.getMessage("CMD_TERMINATE"), (Icon)ImageLoader.load("terminate.gif", CMD_TERMINATE)){

            @Override
            public void actionPerformed(ActionEvent e) {
                ScriptDebugerPanel.this.cmd_terminate();
            }
        };
        a.setEnabled(true);
        a.putValue("LongDescription", new Integer(4));
        this.actions.put(CMD_TERMINATE, a);
        a = new MyAction(CMD_STEP, MappingEditor.getMessage("CMD_STEP"), (Icon)ImageLoader.load("step.gif", CMD_STEP)){

            @Override
            public void actionPerformed(ActionEvent e) {
                ScriptDebugerPanel.this.cmd_step();
            }
        };
        a.setEnabled(true);
        a.putValue("LongDescription", new Integer(8));
        this.actions.put(CMD_STEP, a);
        a = new MyAction(CMD_STEPOVER, MappingEditor.getMessage("CMD_STEPOVER"), (Icon)ImageLoader.load("stepover.gif", CMD_STEPOVER)){

            @Override
            public void actionPerformed(ActionEvent e) {
                ScriptDebugerPanel.this.cmd_stepover();
            }
        };
        a.setEnabled(true);
        a.putValue("LongDescription", new Integer(16));
        this.actions.put(CMD_STEPOVER, a);
        a = new MyAction(CMD_BREAK, MappingEditor.getMessage("CMD_BREAK"), (Icon)ImageLoader.load("break.gif", CMD_BREAK)){

            @Override
            public void actionPerformed(ActionEvent e) {
                Action a1 = ScriptDebugerPanel.this.scriptEditor.getAction("MARKLINE");
                a1.actionPerformed(e);
                ScriptDebugerPanel.this.cmd_break();
            }
        };
        a.setEnabled(true);
        a.putValue("LongDescription", new Integer(32));
        this.actions.put(CMD_BREAK, a);
        a = new MyAction(CMD_EVAL, MappingEditor.getMessage("CMD_EVAL"), (Icon)ImageLoader.load("eval.gif", CMD_EVAL)){

            @Override
            public void actionPerformed(ActionEvent e) {
                ScriptDebugerPanel.this.cmd_eval();
            }
        };
        a.setEnabled(false);
        a.putValue("LongDescription", new Integer(64));
        this.actions.put(CMD_EVAL, a);
        a = new MyAction(CMD_LOADDOC, MappingEditor.getMessage("CMD_LOADDOC"), (Icon)ImageLoader.load("open.gif", "load")){

            @Override
            public void actionPerformed(ActionEvent e) {
                ScriptDebugerPanel.this.cmd_load();
            }
        };
        a.setEnabled(false);
        a.putValue("LongDescription", new Integer(128));
        this.actions.put(CMD_LOADDOC, a);
        a = new MyAction(CMD_SAVEDOC, MappingEditor.getMessage("CMD_SAVEDOC"), (Icon)ImageLoader.load("save.gif", "save")){

            @Override
            public void actionPerformed(ActionEvent e) {
                ScriptDebugerPanel.this.cmd_save();
            }
        };
        a.setEnabled(false);
        a.putValue("LongDescription", new Integer(256));
        this.actions.put(CMD_SAVEDOC, a);
        a = new MyAction(CMD_SUBMITDOC, MappingEditor.getMessage("CMD_SUBMITDOC"), null){

            @Override
            public void actionPerformed(ActionEvent e) {
                ScriptDebugerPanel.this.cmd_submit();
            }
        };
        a.setEnabled(false);
        a.putValue("LongDescription", new Integer(512));
        this.actions.put(CMD_SUBMITDOC, a);
        a = new MyAction(CMD_EXITDEBUG, MappingEditor.getMessage("CMD_EXITDEBUG"), (Icon)ImageLoader.load("close.gif", "close")){

            @Override
            public void actionPerformed(ActionEvent e) {
                ScriptDebugerPanel.this.cmd_exit();
            }
        };
        a.setEnabled(true);
        a.putValue("LongDescription", new Integer(1024));
        this.actions.put(CMD_EXITDEBUG, a);
        a = this.scriptEditor.getAction("FINDTEXT");
        a.putValue("LongDescription", new Integer(2048));
        this.actions.put("FINDTEXT", a);
        a = this.scriptEditor.getAction("REFINDTEXT");
        a.putValue("LongDescription", new Integer(4096));
        this.actions.put("REFINDTEXT", a);
    }

    void clearMessage() {
    }

    void printMessage(String msg) {
    }

    private String getErrorMessage(Throwable th) {
        String errMsg = "";
        if (th instanceof SAXException) {
            Exception e1;
            int row = 0;
            int col = 0;
            if (th instanceof SAXParseException) {
                row = ((SAXParseException)th).getLineNumber();
                col = ((SAXParseException)th).getColumnNumber();
            }
            errMsg = (e1 = ((SAXException)th).getException()) == null ? th.getMessage() : (e1 instanceof IOException ? MappingException.getMessage("IO_ERR", new String[]{e1.getMessage()}) : e1.toString());
            if (row > 0 || col > 0) {
                errMsg = "<" + row + "," + col + ">" + errMsg;
            }
        } else {
            errMsg = th instanceof IOException ? MappingException.getMessage("IO_ERR", new String[]{th.getMessage()}) : th.toString();
        }
        return errMsg;
    }

    class DocumentProcessingThread
    extends Thread {
        public static final int DOCUMENT_NONE = 0;
        public static final int DOCUMENT_LOADING = 1;
        public static final int DOCUMENT_SAVING = 2;
        public static final int DOCUMENT_SUBMITTING = 3;
        int type;
        BaseMessage msg;
        String urlString;
        PrintWriter pw;
        Throwable lastException = null;
        MessageErrorHandler handler = new MessageErrorHandler();

        public DocumentProcessingThread(int type, BaseMessage msg, String urlString) {
            this.type = type;
            this.msg = msg;
            this.urlString = urlString;
            this.documentProcessStart();
        }

        @Override
        public void run() {
            switch (this.type) {
                case 1: {
                    this.load();
                    break;
                }
                case 2: {
                    this.save();
                    break;
                }
                case 3: {
                    this.submit();
                    break;
                }
            }
            this.docuemntProcessEnd();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void load() {
            try {
                URL url = null;
                try {
                    url = new URL(this.urlString);
                }
                catch (Exception e) {
                    MappingException.error("INVALID_URL", new String[]{this.urlString}, e, null);
                }
                BaseMessage baseMessage = this.msg;
                synchronized (baseMessage) {
                    this.msg.read(url);
                }
            }
            catch (Throwable e) {
                this.lastException = e;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void save() {
            try {
                URL url = null;
                try {
                    url = new URL(this.urlString);
                }
                catch (Exception e) {
                    MappingException.error("INVALID_URL", new String[]{this.urlString}, e, null);
                }
                BaseMessage baseMessage = this.msg;
                synchronized (baseMessage) {
                    this.msg.write(url, false);
                }
            }
            catch (Throwable e) {
                this.lastException = e;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void submit() {
            try {
                BaseMessage baseMessage = this.msg;
                synchronized (baseMessage) {
                    this.msg.submit();
                }
            }
            catch (Throwable e) {
                this.lastException = e;
            }
        }

        private void documentProcessStart() {
            ScriptDebugerPanel.this.documentStatus = this.type;
            this.pw = Debug.getPrintWriter();
            if (this.pw != null) {
                Debug.setPrintWriter(new PrintWriter((Writer)new BufferedWriter(this.pw), false));
            }
            if (ScriptDebugerPanel.this.toolBar != null) {
                ScriptDebugerPanel.this.setToobarStatus();
            }
            if (ScriptDebugerPanel.this.menu != null) {
                ScriptDebugerPanel.this.setMenuStatus();
            }
            Cursor waitCursor = Cursor.getPredefinedCursor(3);
            GuiUtils.setCursorToComponent(ScriptDebugerPanel.this, waitCursor);
            GuiUtils.setCursorToComponent(ScriptDebugerPanel.this.scriptEditor, waitCursor);
            String statusMsg = "";
            switch (this.type) {
                case 1: {
                    statusMsg = MappingException.getMessage("ST_DOC_LOADING", this.msg.getMsgName());
                    break;
                }
                case 2: {
                    statusMsg = MappingException.getMessage("ST_DOC_SAVING", this.msg.getMsgName());
                    break;
                }
                case 3: {
                    statusMsg = MappingException.getMessage("ST_DOC_SUBMITTING", this.msg.getMsgName());
                }
            }
            ScriptDebugerPanel.this.setStatusText(statusMsg);
            this.msg.setErrorHandler(this.handler);
        }

        private void docuemntProcessEnd() {
            ScriptDebugerPanel.this.documentStatus = 0;
            Debug.flush();
            if (this.pw != null) {
                Debug.setPrintWriter(this.pw);
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (ScriptDebugerPanel.this.toolBar != null) {
                        ScriptDebugerPanel.this.setToobarStatus();
                    }
                    if (ScriptDebugerPanel.this.menu != null) {
                        ScriptDebugerPanel.this.setMenuStatus();
                    }
                    Throwable e = DocumentProcessingThread.this.lastException;
                    String statusMsg = "";
                    switch (DocumentProcessingThread.this.type) {
                        case 1: {
                            Window window;
                            statusMsg = e == null ? MappingException.getMessage("ST_DOC_LOADED") : MappingException.getMessage("ST_DOC_LOADFAILED");
                            ScriptDebugerPanel.this.printMessage(statusMsg);
                            if (e != null) {
                                window = SwingUtilities.windowForComponent(ScriptDebugerPanel.this);
                                String title = MappingException.getMessage("DLG_ERR");
                                String errMsg = ScriptDebugerPanel.this.getErrorMessage(e);
                                if (window != null) {
                                    JOptionPane.showMessageDialog(window, errMsg, title, 0);
                                } else {
                                    JOptionPane.showMessageDialog(new JFrame(), errMsg, title, 0);
                                }
                            }
                            ScriptDebugerPanel.this.inputMsgPanel.viewResult();
                            break;
                        }
                        case 2: {
                            statusMsg = e == null ? MappingException.getMessage("ST_DOC_SAVED") : MappingException.getMessage("ST_DOC_SAVEFAILED");
                            ScriptDebugerPanel.this.printMessage(statusMsg);
                            if (e == null) break;
                            Window window = SwingUtilities.windowForComponent(ScriptDebugerPanel.this);
                            String title = MappingException.getMessage("DLG_ERR");
                            String errMsg = ScriptDebugerPanel.this.getErrorMessage(e);
                            if (window != null) {
                                JOptionPane.showMessageDialog(window, errMsg, title, 0);
                                break;
                            }
                            JOptionPane.showMessageDialog(new JFrame(), errMsg, title, 0);
                            break;
                        }
                        case 3: {
                            if (e == null) {
                                statusMsg = MappingException.getMessage("ST_DOC_SUBMITTED");
                                break;
                            }
                            statusMsg = MappingException.getMessage("ST_DOC_SUBMITFAILED");
                            Window window = SwingUtilities.windowForComponent(ScriptDebugerPanel.this);
                            String title = MappingException.getMessage("DLG_ERR");
                            if (e instanceof SAXException) {
                                JOptionPane.showMessageDialog(window, e.getMessage(), title, 0);
                                break;
                            }
                            JOptionPane.showMessageDialog(window, e.toString(), title, 0);
                        }
                    }
                    ScriptDebugerPanel.this.setStatusText(statusMsg);
                    Cursor defaultCursor = Cursor.getPredefinedCursor(0);
                    GuiUtils.setCursorToComponent(ScriptDebugerPanel.this, defaultCursor);
                    GuiUtils.setCursorToComponent(ScriptDebugerPanel.this.scriptEditor, defaultCursor);
                }
            });
            this.handler.reset();
            this.msg.setErrorHandler(null);
        }
    }

    class MessagePanel
    extends JPanel {
        ComboTextFieldEx msgList;
        Vector msgs;
        Hashtable viewTable;

        public MessagePanel() {
            this.setLayout(new BorderLayout());
            this.setBorder(MappingEditor.defaultBorder);
            this.msgList = new ComboTextFieldEx(false){

                @Override
                public boolean valueChanged(Object source, String value) {
                    return MessagePanel.this.selectMessage(this.getSelectedIndex());
                }
            };
            this.msgList.setRequestFocusEnabled(false);
            this.add((Component)this.msgList, "North");
            this.msgs = new Vector();
            this.viewTable = new Hashtable();
        }

        public void load(Vector msgs) {
            this.msgList.setEnabledEvent(false);
            this.msgList.removeAllItems();
            int n = msgs.size();
            for (int i = 0; i < n; ++i) {
                BaseMessage msg = (BaseMessage)msgs.elementAt(i);
                String msgname = msg.getMsgName();
                String msgtype = msg.getMsgType();
                String dir = msg.getDirection();
                String s = msgname + "[" + msgtype + " -- " + dir + "]";
                this.msgList.addItem(s);
            }
            this.msgs = msgs;
            if (this.msgList.getItemCount() > 0) {
                this.selectMessage(0);
            } else if (this.getComponentCount() > 1) {
                Component c = this.getComponent(1);
                c.removeMouseListener(ScriptDebugerPanel.this);
                c.removeFocusListener(ScriptDebugerPanel.this);
                this.remove(1);
            }
            this.msgList.setEnabledEvent(true);
        }

        public BaseMessage getSelectedMessage() {
            int index = this.msgList.getSelectedIndex();
            if (index >= 0 && index < this.msgs.size()) {
                return (BaseMessage)this.msgs.elementAt(index);
            }
            return null;
        }

        public Vector getAllMessages() {
            return this.msgs;
        }

        public void viewResult() {
            BaseMessage msg = this.getSelectedMessage();
            if (msg == null) {
                return;
            }
            String msgname = msg.getMsgName();
            Object doc = msg.getDocument();
            Object obj = this.viewTable.get(msg);
            if (obj instanceof DocumentViewer) {
                DocumentViewer viewer = (DocumentViewer)obj;
                try {
                    viewer.setDocument(doc);
                    this.invalidate();
                    this.repaint();
                }
                catch (Exception e) {
                    Debug.println(e.getMessage());
                }
            } else if (obj instanceof TextEditorPanel) {
                TextEditorPanel te = (TextEditorPanel)obj;
                StringWriter sw = new StringWriter();
                try {
                    msg.write(sw);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                te.setText(sw.toString());
            }
        }

        public boolean checkReady() {
            int n = this.msgs.size();
            for (int i = 0; i < n; ++i) {
                BaseMessage msg = (BaseMessage)this.msgs.elementAt(i);
                String msgName = msg.getMsgName();
                if (msg.isReady()) continue;
                this.msgList.setSelectedIndex(i);
                Window window = SwingUtilities.windowForComponent(ScriptDebugerPanel.this);
                if (window != null) {
                    JOptionPane.showMessageDialog(window, MappingEditor.getMessage("NOLOAD_DOC", msgName));
                } else {
                    JOptionPane.showMessageDialog(new JFrame(), MappingEditor.getMessage("NOLOAD_DOC", msgName));
                }
                return false;
            }
            return true;
        }

        public void resetDocument() {
            int n = this.msgs.size();
            for (int i = 0; i < n; ++i) {
                BaseMessage msg = (BaseMessage)this.msgs.elementAt(i);
                try {
                    msg.clearDocument();
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.viewResult();
        }

        private boolean selectMessage(int index) {
            Component comp;
            if (this.msgs == null || index < 0 || index >= this.msgs.size()) {
                return false;
            }
            BaseMessage msgmod = (BaseMessage)this.msgs.elementAt(index);
            DocumentViewer view = this.createDocumentViewer(msgmod);
            if (view != null) {
                this.viewTable.put(msgmod, view);
                comp = this.createViewerComponent(view);
            } else {
                comp = this.createTextComponent(msgmod);
                this.viewTable.put(msgmod, comp);
            }
            this.selectedMessage(comp);
            return true;
        }

        private DocumentViewer createDocumentViewer(BaseMessage msg) {
            DocumentViewer view = null;
            try {
                VisualMessageFactory f = VisualMessageFactory.getInstance();
                view = f.createDocumentViewer(msg.getMsgType());
            }
            catch (Exception e) {
                view = null;
                System.err.println(e);
            }
            if (view != null) {
                try {
                    Object doc = msg.getDocument();
                    view.setDocument(doc);
                }
                catch (SAXParseException e0) {
                    Debug.println("<" + e0.getLineNumber() + "," + e0.getColumnNumber() + ">" + e0.getMessage());
                    view = null;
                }
                catch (Exception e) {
                    Debug.println(e.toString());
                    view = null;
                }
            }
            return view;
        }

        private Component createViewerComponent(DocumentViewer view) {
            Component comp;
            Component viewer = view.getViewer();
            viewer.addMouseListener(ScriptDebugerPanel.this);
            viewer.addFocusListener(ScriptDebugerPanel.this);
            if (ScriptDebugerPanel.this.mapFileDropListener != null) {
                Serializable viewport;
                if (viewer instanceof JScrollPane) {
                    viewport = ((JScrollPane)viewer).getViewport();
                    DropTarget target = new DropTarget((Component)viewport, ScriptDebugerPanel.this.mapFileDropListener);
                    Component viewcomp = ((JViewport)viewport).getView();
                    if (viewcomp != null) {
                        DropTarget dropTarget = new DropTarget(viewcomp, ScriptDebugerPanel.this.mapFileDropListener);
                    }
                } else {
                    viewport = new DropTarget(viewer, ScriptDebugerPanel.this.mapFileDropListener);
                }
                if (viewer instanceof JTabbedPane) {
                    JTabbedPane tabbedPane = (JTabbedPane)viewer;
                    int count2 = tabbedPane.getComponentCount();
                    for (int i = 0; i < count2; ++i) {
                        Component comp1 = tabbedPane.getComponentAt(i);
                        if (comp1 instanceof JScrollPane) {
                            JViewport viewport2 = ((JScrollPane)comp1).getViewport();
                            DropTarget target = new DropTarget(viewport2, ScriptDebugerPanel.this.mapFileDropListener);
                            Component viewcomp = viewport2.getView();
                            if (viewcomp == null) continue;
                            DropTarget dropTarget = new DropTarget(viewcomp, ScriptDebugerPanel.this.mapFileDropListener);
                            continue;
                        }
                        DropTarget dropTarget = new DropTarget(comp1, ScriptDebugerPanel.this.mapFileDropListener);
                    }
                }
            }
            if (viewer instanceof JScrollPane || viewer instanceof JTabbedPane || viewer instanceof JPanel) {
                viewer.invalidate();
                viewer.repaint();
                comp = viewer;
            } else {
                JScrollPane sp = new JScrollPane();
                if (ScriptDebugerPanel.this.mapFileDropListener != null) {
                    DropTarget dropTarget = new DropTarget(sp.getViewport(), ScriptDebugerPanel.this.mapFileDropListener);
                }
                sp.setBackground(Color.white);
                sp.getViewport().add(viewer);
                sp.addMouseListener(ScriptDebugerPanel.this);
                sp.addFocusListener(ScriptDebugerPanel.this);
                viewer.repaint();
                sp.invalidate();
                sp.repaint();
                comp = sp;
            }
            return comp;
        }

        private Component createTextComponent(BaseMessage msg) {
            TextEditorPanel te = new TextEditorPanel();
            te.setEditable(false);
            Component c = te.getDragComponent();
            c.addMouseListener(ScriptDebugerPanel.this);
            c.addFocusListener(ScriptDebugerPanel.this);
            if (ScriptDebugerPanel.this.mapFileDropListener != null) {
                DropTarget dropTarget = new DropTarget(c, ScriptDebugerPanel.this.mapFileDropListener);
            }
            PlainDocument doc = new PlainDocument();
            try {
                CharArrayWriter writer = new CharArrayWriter();
                msg.write(writer);
                DefaultEditorKit kit = new DefaultEditorKit();
                ((EditorKit)kit).read(new CharArrayReader(writer.toCharArray()), (Document)doc, 0);
            }
            catch (Exception exception) {
                // empty catch block
            }
            te.setDocument(doc);
            te.addMouseListener(ScriptDebugerPanel.this);
            return te;
        }

        private void selectedMessage(Component comp) {
            if (this.getComponentCount() > 1) {
                Component c = this.getComponent(1);
                c.removeMouseListener(ScriptDebugerPanel.this);
                c.removeFocusListener(ScriptDebugerPanel.this);
                this.remove(1);
            }
            this.add(comp, "Center");
            this.setBackground(Color.white);
            this.revalidate();
            this.repaint();
        }
    }

    static class ToolTipWindow
    extends Window
    implements WindowListener {
        JLabel label = new JLabel();

        ToolTipWindow(Frame frame) {
            super(frame);
            this.label.addFocusListener(new FocusAdapter(){

                public void focutLost(FocusEvent e) {
                    this.setVisible(false);
                }
            });
            this.label.setBorder(BorderFactory.createEtchedBorder());
            this.label.setBackground(Color.yellow);
            this.setBackground(Color.yellow);
            this.setLayout(new BorderLayout());
            this.add((Component)this.label, "Center");
        }

        void showToolTip(String text) {
            this.label.setText(text);
            this.pack();
            this.toFront();
            this.setVisible(true);
            this.label.requestFocus();
        }

        @Override
        public void windowOpened(WindowEvent e) {
        }

        @Override
        public void windowClosing(WindowEvent e) {
        }

        @Override
        public void windowClosed(WindowEvent e) {
        }

        @Override
        public void windowIconified(WindowEvent e) {
        }

        @Override
        public void windowDeiconified(WindowEvent e) {
            this.setVisible(false);
        }

        @Override
        public void windowActivated(WindowEvent e) {
        }

        @Override
        public void windowDeactivated(WindowEvent e) {
            this.setVisible(false);
        }
    }

    static class MyAction
    extends AbstractAction {
        MyAction(String name2, String description) {
            super(name2);
            this.putValue("ShortDescription", description);
            this.setEnabled(false);
        }

        MyAction(String name2, String description, Icon icon) {
            super(name2, icon);
            this.putValue("ShortDescription", description);
            this.setEnabled(false);
        }

        MyAction(String name2, String shortdes, Object longdes, Icon icon) {
            super(name2, icon);
            this.putValue("ShortDescription", shortdes);
            this.putValue("LongDescription", longdes);
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
        }
    }
}

