/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.map;

import com.argo21.common.gui.ComboTextFieldEx;
import com.argo21.common.gui.ImageLoader;
import com.argo21.common.gui.StatusChangedListener;
import com.argo21.common.gui.TextEditorPanel;
import com.argo21.map.MapDocument;
import com.argo21.map.MappingEditor;
import com.argo21.map.WorkSpace;
import com.argo21.msg.MessageException;
import com.argo21.msg.SchemaViewer;
import com.argo21.msg.VisualMessageFactory;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Point;
import java.awt.dnd.DragSource;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.EventObject;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.JWindow;
import javax.swing.KeyStroke;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class ScriptEditorPanel
extends JSplitPane
implements MouseMotionListener,
MouseListener,
PopupMenuListener,
FocusListener,
WorkSpace,
MapDocument.MapDocListener {
    public static final String CMD_RUN = "run";
    public static final String CMD_BREAK = "break";
    public static final String CMD_COMPILE = "compile";
    private static Cursor enDropCursor = DragSource.DefaultCopyDrop;
    private static Cursor disDropCursor = DragSource.DefaultCopyNoDrop;
    private static Cursor defaultCursor = Cursor.getPredefinedCursor(0);
    static String[] toolBarNames = new String[]{"UNDO", "REDO", "CUT", "COPY", "PASTE", "DELETE", "FINDTEXT", "-", "run", "break"};
    static String[][] editMenus = new String[][]{{"UNDO", "U", null, "2:90"}, {"REDO", "R", null, "2:89"}, {"-", null, null, null}, {"CUT", "T", null, "2:88"}, {"COPY", "C", null, "2:155"}, {"PASTE", "P", null, "1:155"}, {"-", null, null, null}, {"FINDTEXT", "F", null, "2:70"}, {"REFINDTEXT", "A", null, String.valueOf(114)}, {"-", null, null, null}, {"SELECTALL", "S", null, "2:65"}, {"-", null, null, null}, {"DELETE", "D", null, String.valueOf(127)}, {"-", null, null, null}, {"run", "R", null, String.valueOf(116)}, {"compile", "P", null, String.valueOf(117)}, {"break", "B", null, String.valueOf(120)}};
    private JToolBar toolBar = null;
    private JMenu menu = null;
    private MessagePanel inputMsgPanel = null;
    private MessagePanel outputMsgPanel = null;
    private TextEditorPanel scriptEditor = null;
    private boolean resized = false;
    private Vector myStatusChangedListener = new Vector(1);
    private DropTargetListener mapFileDropListener = null;
    private ToolTipWindow tipwindow = null;
    private boolean activeDrag = false;
    private Component dragSource = null;
    private Component dropTarget = null;
    private String dragText = null;
    private int dragX = -1;
    private int dragY = -1;
    MapDocument mapDocument = null;
    private int focusPanel = 0;
    private long lastModifie = 0L;
    private boolean msgStructChanged = false;

    public String getMessage(String msgID) {
        return MappingEditor.msgCatalog.getMessage(msgID);
    }

    public ScriptEditorPanel(TextEditorPanel scriptEditor, DropTargetListener mapFileDropListener) {
        super(1, false);
        this.setDividerSize(2);
        this.setBorder(MappingEditor.defaultBorder);
        this.mapFileDropListener = mapFileDropListener;
        this.inputMsgPanel = new MessagePanel();
        this.setLeftComponent(this.inputMsgPanel);
        this.outputMsgPanel = new MessagePanel();
        this.setRightComponent(this.outputMsgPanel);
        this.scriptEditor = scriptEditor;
        if (mapFileDropListener != null) {
            DropTarget target1 = new DropTarget(this.inputMsgPanel, mapFileDropListener);
            DropTarget dropTarget = new DropTarget(this.outputMsgPanel, mapFileDropListener);
        }
    }

    void pleaceScriptEditor() {
        this.scriptEditor.requestDefaultFocus();
        this.scriptEditor.addStatusChangedListener(new StatusChangedListener(){

            @Override
            public void statusChanged(int id2, EventObject e) {
                ScriptEditorPanel.this.editorStatusChanged(id2, e);
            }
        });
        Component c = this.scriptEditor.getDragComponent();
        c.addMouseListener(this);
        c.addMouseMotionListener(this);
        c.addFocusListener(this);
        this.scriptEditor.setEditable(true);
    }

    void removeScriptEditor() {
        this.scriptEditor.clearStatusChangedListener();
        Component c = this.scriptEditor.getDragComponent();
        c.removeFocusListener(this);
        c.removeMouseListener(this);
        c.removeMouseMotionListener(this);
    }

    @Override
    public void focusGained(FocusEvent e) {
        for (Component c = e.getComponent(); c != null; c = c.getParent()) {
            if (c == this.scriptEditor) {
                this.focusPanel = 3;
                this.inputMsgPanel.setBorder(MappingEditor.defaultBorder);
                this.outputMsgPanel.setBorder(MappingEditor.defaultBorder);
                this.scriptEditor.setBorder(MappingEditor.selectBorder);
                break;
            }
            if (c == this.inputMsgPanel) {
                this.focusPanel = 1;
                this.inputMsgPanel.setBorder(MappingEditor.selectBorder);
                this.outputMsgPanel.setBorder(MappingEditor.defaultBorder);
                this.scriptEditor.setBorder(MappingEditor.defaultBorder);
                break;
            }
            if (c != this.outputMsgPanel) continue;
            this.focusPanel = 2;
            this.inputMsgPanel.setBorder(MappingEditor.defaultBorder);
            this.outputMsgPanel.setBorder(MappingEditor.selectBorder);
            this.scriptEditor.setBorder(MappingEditor.defaultBorder);
            break;
        }
        if (this.toolBar != null) {
            this.setToolbarStatus();
        }
        if (this.menu != null) {
            this.setMenuStatus();
        }
    }

    @Override
    public void focusLost(FocusEvent e) {
    }

    public void resetDivider(Dimension size) {
        this.setDividerLocation((int)(0.5 * (double)size.height));
        this.validate();
    }

    public void resetDivider() {
        this.setDividerLocation(0.5);
        this.validate();
    }

    private void editorStatusChanged(int id2, EventObject e) {
        this.setToolbarStatus();
        this.setMenuStatus();
        int n = this.myStatusChangedListener.size();
        for (int i = 0; i < n; ++i) {
            StatusChangedListener l = (StatusChangedListener)this.myStatusChangedListener.elementAt(i);
            l.statusChanged(id2, e);
        }
    }

    void setToolbarStatus() {
        block5: {
            if (!this.toolBar.isVisible()) break block5;
            int n = this.toolBar.getComponentCount();
            if (this.focusPanel != 3) {
                for (int i = 0; i < n; ++i) {
                    Component c = this.toolBar.getComponent(i);
                    c.setEnabled(CMD_RUN.equals(c.getName()));
                }
            } else {
                for (int i = 0; i < n; ++i) {
                    Component c = this.toolBar.getComponent(i);
                    Action at = this.scriptEditor.getAction(c.getName());
                    if (at != null) {
                        c.setEnabled(at.isEnabled());
                        continue;
                    }
                    c.setEnabled(true);
                }
            }
        }
    }

    void setMenuStatus() {
        block5: {
            if (!this.menu.isVisible()) break block5;
            int n = this.menu.getMenuComponentCount();
            if (this.focusPanel != 3) {
                for (int i = 0; i < n; ++i) {
                    Component c;
                    c.setEnabled(CMD_RUN.equals((c = this.menu.getMenuComponent(i)).getName()) || CMD_COMPILE.equals(c.getName()));
                }
            } else {
                for (int i = 0; i < n; ++i) {
                    Component c = this.menu.getMenuComponent(i);
                    Action at = this.scriptEditor.getAction(c.getName());
                    if (at != null) {
                        c.setEnabled(at.isEnabled());
                        continue;
                    }
                    c.setEnabled(true);
                }
            }
        }
    }

    @Override
    public void addStatusChangedListener(StatusChangedListener l) {
        this.myStatusChangedListener.addElement(l);
    }

    @Override
    public void removeStatusChangedListener(StatusChangedListener l) {
        this.myStatusChangedListener.removeElement(l);
    }

    @Override
    public boolean isChanged() {
        return this.scriptEditor.isChanged();
    }

    @Override
    public void clearChanged() {
        this.scriptEditor.clearChanged();
    }

    @Override
    public String getWorkSpaceName() {
        return MappingEditor.WKS_SCRIPT;
    }

    @Override
    public void load(MapDocument mapDoc) throws MessageException {
        if (this.mapDocument != null) {
            this.mapDocument.removeMapDocumentListener(this);
        }
        this.mapDocument = mapDoc;
        this.reload();
        this.mapDocument.addMapDocumentListener(this);
    }

    void close() {
        if (this.mapDocument != null) {
            this.mapDocument.removeMapDocumentListener(this);
        }
        this.removeScriptEditor();
        if (this.tipwindow != null) {
            this.tipwindow.dispose();
            this.tipwindow = null;
        }
    }

    private void reload() throws MessageException {
        MapDocument.DeclSegment[] msglist = this.mapDocument.getDeclSegments();
        Vector<MapDocument.DeclSegment> inputMsgs = new Vector<MapDocument.DeclSegment>();
        Vector<MapDocument.DeclSegment> outputMsgs = new Vector<MapDocument.DeclSegment>();
        for (int i = 0; i < msglist.length; ++i) {
            String dir = msglist[i].getDirection();
            if (dir == null) {
                dir = "INPUT";
            }
            if (dir.equals("INPUT")) {
                inputMsgs.addElement(msglist[i]);
                continue;
            }
            outputMsgs.addElement(msglist[i]);
        }
        this.inputMsgPanel.load(inputMsgs);
        this.outputMsgPanel.load(outputMsgs);
        this.msgStructChanged = false;
        this.lastModifie = this.mapDocument.getLastModifie();
    }

    @Override
    public void saveBack() throws MessageException {
    }

    @Override
    public void review() throws MessageException {
        boolean changed;
        if (!this.resized && this.getHeight() > 20) {
            this.resized = true;
            this.resetDivider();
        }
        if (!(changed = this.msgStructChanged)) {
            MapDocument.DeclSegment[] msglist = this.mapDocument.getDeclSegments();
            for (int i = 0; i < msglist.length; ++i) {
                if (msglist[i].getLastModifie() <= this.lastModifie) continue;
                changed = true;
                break;
            }
        }
        if (changed) {
            this.reload();
        }
        this.scriptEditor.requestFocus();
    }

    @Override
    public void messageItemSelected(String id2, int line) {
        if (line > 0) {
            this.scriptEditor.selectLine(line);
        }
    }

    private Frame getFrame() {
        Container parent;
        for (parent = this; parent != null && !(parent instanceof Frame); parent = parent.getParent()) {
        }
        if (parent != null) {
            return (Frame)parent;
        }
        return null;
    }

    private void showToolTipWindow(Component comp, int x, int y, String text) {
        if (text == null || text.trim().length() == 0) {
            return;
        }
        if (this.tipwindow == null) {
            Frame f = this.getFrame();
            if (f == null) {
                return;
            }
            this.tipwindow = new ToolTipWindow(f, text);
            Point po = comp.getLocationOnScreen();
            this.tipwindow.setLocation((x += 20) + po.x, (y -= 20) + po.y);
            this.tipwindow.setVisible(true);
            return;
        }
        Point po = comp.getLocationOnScreen();
        this.tipwindow.setLocation((x += 20) + po.x, (y -= 20) + po.y);
    }

    private void hideToolTipWindow() {
        if (this.tipwindow != null) {
            this.tipwindow.setVisible(false);
        }
    }

    private static Point refLacation(Component comp, Component ref, Point point) {
        if (comp != ref) {
            Point point1 = ref.getLocationOnScreen();
            point.translate(point1.x, point1.y);
            Point point2 = comp.getLocationOnScreen();
            point.translate(-point2.x, -point2.y);
        }
        return point;
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        if (Math.abs(x - this.dragX) < 8 && Math.abs(y - this.dragY) < 4) {
            return;
        }
        this.dragX = x;
        this.dragY = y;
        SchemaViewer inputViewer = this.inputMsgPanel.getViewer();
        SchemaViewer outputViewer = this.outputMsgPanel.getViewer();
        if (this.dragSource != null && this.dropTarget != null) {
            boolean b = false;
            Point po = ScriptEditorPanel.refLacation(this.dropTarget, this.dragSource, e.getPoint());
            if (inputViewer != null && this.dropTarget == inputViewer.getDragComponent()) {
                b = inputViewer.dragOver(this.dragSource, po.x, po.y, this.dragText);
            } else if (outputViewer != null && this.dropTarget == outputViewer.getDragComponent()) {
                b = outputViewer.dragOver(this.dragSource, po.x, po.y, this.dragText);
            } else if (this.dropTarget == this.scriptEditor.getDragComponent()) {
                b = this.scriptEditor.dragOver(this.dragSource, po.x, po.y, this.dragText);
            }
            if (b) {
                if (this.dragSource.getCursor() != enDropCursor) {
                    this.dragSource.setCursor(enDropCursor);
                }
            } else if (this.dragSource.getCursor() != disDropCursor) {
                this.dragSource.setCursor(disDropCursor);
            }
            this.showToolTipWindow(this.dragSource, x, y, this.dragText);
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if ((e.getModifiers() & 0x10) == 0) {
            if (e.getComponent() == this.scriptEditor.getDragComponent()) {
                JPopupMenu popmenu = this.getMenu().getPopupMenu();
                popmenu.addPopupMenuListener(this);
                this.setMenuStatus();
                popmenu.show(e.getComponent(), e.getX(), e.getY());
            } else {
                JPopupMenu popmenu = this.getMenu().getPopupMenu();
                popmenu.addPopupMenuListener(this);
                this.setMenuStatus();
                popmenu.show(e.getComponent(), e.getX(), e.getY());
            }
            this.activeDrag = false;
            return;
        }
        this.activeDrag = false;
        this.dragSource = null;
        this.dropTarget = null;
        SchemaViewer inputViewer = this.inputMsgPanel.getViewer();
        SchemaViewer outputViewer = this.outputMsgPanel.getViewer();
        int x = e.getX();
        int y = e.getY();
        Component c = e.getComponent();
        if (inputViewer != null && c == inputViewer.getDragComponent()) {
            this.dropTarget = this.dragSource = c;
            this.activeDrag = inputViewer.dragStart(this.dragSource, x, y);
            this.dragText = inputViewer.getSelectedText();
        } else if (outputViewer != null && c == outputViewer.getDragComponent()) {
            this.dropTarget = this.dragSource = c;
            this.activeDrag = outputViewer.dragStart(this.dragSource, x, y);
            this.dragText = outputViewer.getSelectedText();
        }
        this.dragY = -1;
        this.dragX = -1;
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        SchemaViewer inputViewer = this.inputMsgPanel.getViewer();
        SchemaViewer outputViewer = this.outputMsgPanel.getViewer();
        if (this.dragSource != null) {
            if (this.dropTarget != null) {
                Point po = ScriptEditorPanel.refLacation(this.dropTarget, this.dragSource, e.getPoint());
                if (inputViewer != null && this.dropTarget == inputViewer.getDragComponent()) {
                    boolean b = inputViewer.drop(this.dragSource, po.x, po.y, this.dragText);
                    if (b) {
                        String s = inputViewer.getSelectedText();
                        s = this.dragText + "\t=\t" + s + ";\n";
                        po = ScriptEditorPanel.refLacation(this.scriptEditor, this.dragSource, e.getPoint());
                        this.scriptEditor.drop(this.dragSource, po.x, po.y, s);
                    }
                } else if (outputViewer != null && this.dropTarget == outputViewer.getDragComponent()) {
                    boolean b = outputViewer.drop(this.dragSource, po.x, po.y, this.dragText);
                    if (b) {
                        String s = outputViewer.getSelectedText();
                        s = s + "\t=\t" + this.dragText + ";\n";
                        po = ScriptEditorPanel.refLacation(this.scriptEditor, this.dragSource, e.getPoint());
                        this.scriptEditor.drop(this.dragSource, po.x, po.y, s);
                    }
                } else if (this.dropTarget == this.scriptEditor.getDragComponent()) {
                    this.scriptEditor.drop(this.dragSource, po.x, po.y, this.dragText);
                }
            }
            if (this.tipwindow != null) {
                this.tipwindow.dispose();
                this.tipwindow = null;
            }
            if (this.dragSource.getCursor() != defaultCursor) {
                this.dragSource.setCursor(defaultCursor);
            }
        }
        this.activeDrag = false;
        this.dropTarget = null;
        this.dragSource = null;
        this.dragY = -1;
        this.dragX = -1;
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        if (this.dragSource != null) {
            this.dropTarget = e.getComponent();
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (this.dragSource != null) {
            this.dragSource.setCursor(defaultCursor);
        }
        this.dropTarget = null;
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
        JPopupMenu popmenu = (JPopupMenu)e.getSource();
        popmenu.setInvoker(this.menu);
        popmenu.removePopupMenuListener(this);
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent e) {
    }

    @Override
    public JToolBar getToolBar() {
        if (this.toolBar == null) {
            this.toolBar = this.createToolbar(toolBarNames);
        }
        return this.toolBar;
    }

    @Override
    public JMenu getMenu() {
        if (this.menu == null) {
            this.menu = this.creatMenu(editMenus);
        }
        return this.menu;
    }

    void cmd_compile() {
    }

    void cmd_run() {
    }

    @Override
    public void renamed(String oldName, String newName) {
        this.msgStructChanged = true;
    }

    @Override
    public void inserted(String newName, int index) {
        this.msgStructChanged = true;
    }

    @Override
    public void removed(String msgName) {
        this.msgStructChanged = true;
    }

    private JToolBar createToolbar(String[] names) {
        JToolBar toolbar = new JToolBar();
        toolbar.setMargin(MappingEditor.toolBarInsets);
        toolbar.setFloatable(false);
        int n = names.length;
        for (int i = 0; i < n; ++i) {
            Action act;
            if (names[i].equals("-")) {
                toolbar.addSeparator();
                continue;
            }
            if (names[i].equals(CMD_BREAK)) {
                act = this.scriptEditor.getAction("MARKLINE");
                act.putValue("Name", CMD_BREAK);
                act.putValue("SmallIcon", ImageLoader.load("break.gif", CMD_BREAK));
                act.putValue("ShortDescription", MappingEditor.getMessage("CMD_BREAK"));
                act.setEnabled(true);
            } else if (names[i].equals(CMD_RUN)) {
                act = new AbstractAction(CMD_RUN){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ScriptEditorPanel.this.cmd_run();
                    }
                };
                act.putValue("SmallIcon", ImageLoader.load("run.gif", CMD_RUN));
                act.putValue("ShortDescription", MappingEditor.getMessage("CMD_RUN"));
                act.setEnabled(true);
            } else {
                act = this.scriptEditor.getAction(names[i]);
            }
            if (act == null) continue;
            ImageIcon icon = (ImageIcon)act.getValue("SmallIcon");
            JButton bt = new JButton((Icon)icon){

                @Override
                public float getAlignmentY() {
                    return 0.5f;
                }
            };
            bt.setRequestFocusEnabled(false);
            bt.setMargin(MappingEditor.toolBarImgButtonInsets);
            bt.setName(names[i]);
            bt.setToolTipText((String)act.getValue("ShortDescription"));
            bt.addActionListener(act);
            toolbar.add(bt);
            bt.setName(names[i]);
        }
        return toolbar;
    }

    private JMenu creatMenu(String[][] items) {
        String s = this.getMessage("MENU_EDIT");
        if (s.indexOf("E") < 0) {
            s = s + "(E)";
        }
        JMenu menu = new JMenu(s);
        menu.setMnemonic('E');
        Font font1 = menu.getFont();
        Font font = new Font(font1.getName(), 0, 12);
        menu.setFont(font);
        for (int i = 0; i < items.length; ++i) {
            Action act;
            String itemname = items[i][0];
            if (itemname.equals("-")) {
                menu.addSeparator();
                continue;
            }
            if (itemname.equals(CMD_BREAK)) {
                act = this.scriptEditor.getAction("MARKLINE");
                act.putValue("Name", CMD_BREAK);
                act.putValue("SmallIcon", ImageLoader.load("break.gif", CMD_BREAK));
                act.putValue("ShortDescription", MappingEditor.getMessage("CMD_BREAK"));
                act.setEnabled(true);
            } else if (itemname.equals(CMD_RUN)) {
                act = new AbstractAction(CMD_RUN){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ScriptEditorPanel.this.cmd_run();
                    }
                };
                act.putValue("SmallIcon", ImageLoader.load("run.gif", CMD_RUN));
                act.putValue("ShortDescription", MappingEditor.getMessage("CMD_RUN"));
                act.setEnabled(true);
            } else if (itemname.equals(CMD_COMPILE)) {
                act = new AbstractAction(CMD_COMPILE){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ScriptEditorPanel.this.cmd_compile();
                    }
                };
                act.putValue("ShortDescription", MappingEditor.getMessage("CMD_COMPILE"));
                act.setEnabled(true);
            } else {
                act = this.scriptEditor.getAction(itemname);
            }
            if (act == null) continue;
            String dec = (String)act.getValue("ShortDescription");
            if (items[i][1] != null && dec.indexOf(items[i][1]) < 0) {
                dec = dec + "(" + items[i][1] + ")";
            }
            JMenuItem menuItem = items[i][2] == null ? new JMenuItem(dec) : new JCheckBoxMenuItem(dec);
            menuItem.setName(itemname);
            menu.add(menuItem);
            ImageIcon icon = (ImageIcon)act.getValue("SmallIcon");
            if (icon == null) {
                icon = ImageLoader.load("empty.gif", "");
            }
            menuItem.setIcon(icon);
            menuItem.setHorizontalTextPosition(4);
            menuItem.addActionListener(act);
            if (items[i][1] != null) {
                menuItem.setMnemonic(items[i][1].charAt(0));
            }
            if (items[i][2] != null) {
                menuItem.setSelected(items[i][2].equals("Y"));
            }
            if (items[i][3] != null) {
                try {
                    s = items[i][3];
                    int k = s.indexOf(":");
                    if (k >= 0) {
                        int mask = Integer.parseInt(s.substring(0, k));
                        int keyid = Integer.parseInt(s.substring(k + 1));
                        menuItem.setAccelerator(KeyStroke.getKeyStroke(keyid, mask));
                    } else {
                        int keyid = Integer.parseInt(s);
                        menuItem.setAccelerator(KeyStroke.getKeyStroke(keyid, 0));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            menuItem.setFont(font);
        }
        return menu;
    }

    static class ToolTipWindow
    extends JWindow
    implements WindowListener {
        JLabel label = new JLabel();
        String text = "";

        ToolTipWindow(Frame frame, String text) {
            super(frame);
            JPanel tp = new JPanel();
            tp.setBorder(BorderFactory.createEtchedBorder());
            tp.setBackground(Color.yellow);
            tp.setLayout(new BorderLayout());
            tp.add((Component)this.label, "Center");
            this.setContentPane(tp);
            this.label.setText(text);
            this.pack();
            this.toFront();
        }

        @Override
        public void windowOpened(WindowEvent e) {
        }

        @Override
        public void windowClosing(WindowEvent e) {
        }

        @Override
        public void windowClosed(WindowEvent e) {
        }

        @Override
        public void windowIconified(WindowEvent e) {
        }

        @Override
        public void windowDeiconified(WindowEvent e) {
            this.setVisible(false);
        }

        @Override
        public void windowActivated(WindowEvent e) {
        }

        @Override
        public void windowDeactivated(WindowEvent e) {
            this.setVisible(false);
        }
    }

    class MessagePanel
    extends JPanel {
        ComboTextFieldEx msgList;
        Vector msgs;
        SchemaViewer view;

        public MessagePanel() {
            this.setBackground(Color.white);
            this.setLayout(new BorderLayout());
            this.setBorder(MappingEditor.defaultBorder);
            this.msgList = new ComboTextFieldEx(false){

                @Override
                public boolean valueChanged(Object source, String value) {
                    MessagePanel.this.selectMessage(this.getSelectedIndex());
                    return true;
                }
            };
            this.add((Component)this.msgList, "North");
        }

        public void load(Vector msgs) {
            this.msgList.setEnabledEvent(false);
            this.msgList.removeAllItems();
            if (this.getComponentCount() > 1) {
                this.remove(1);
            }
            this.view = null;
            int n = msgs.size();
            for (int i = 0; i < n; ++i) {
                MapDocument.DeclSegment msg = (MapDocument.DeclSegment)msgs.elementAt(i);
                String dir = msg.getDirection();
                if (dir == null) {
                    dir = "INPUT";
                }
                String s = msg.getMsgName() + "[" + msg.getMsgType() + " -- " + dir + "]";
                this.msgList.addItem(s);
            }
            this.msgs = msgs;
            if (this.msgList.getItemCount() > 0) {
                this.selectMessage(0);
                this.msgList.setEnabledEvent(true);
            } else {
                this.revalidate();
                this.repaint();
            }
        }

        public SchemaViewer getViewer() {
            return this.view;
        }

        private void selectMessage(int index) {
            if (this.msgs == null || index < 0 || index > this.msgs.size()) {
                return;
            }
            MapDocument.DeclSegment msg = (MapDocument.DeclSegment)this.msgs.elementAt(index);
            this.msgList.setEnabledEvent(false);
            this.view = this.createViewer(msg);
            Component comp = this.view != null ? this.createViewerComponent(this.view) : this.createTextComponent(msg);
            Component comp1 = comp;
            this.selectedMessage(comp1);
        }

        private SchemaViewer createViewer(MapDocument.DeclSegment msg) {
            SchemaViewer view = null;
            try {
                VisualMessageFactory f = VisualMessageFactory.getInstance();
                view = f.createSchemaViewer(msg.getMsgType());
                view.load(msg.getProperties(), msg.getSchemaModel());
            }
            catch (Exception e) {
                view = null;
            }
            return view;
        }

        private Component createViewerComponent(SchemaViewer view) {
            Component comp;
            Component viewer = view.getViewer();
            if (viewer instanceof JScrollPane || viewer instanceof JTabbedPane || viewer instanceof JPanel) {
                comp = viewer;
            } else {
                JScrollPane sp = new JScrollPane();
                sp.getViewport().add(viewer);
                sp.invalidate();
                sp.repaint();
                comp = sp;
            }
            Component c = view.getDragComponent();
            c.addMouseListener(ScriptEditorPanel.this);
            c.addMouseMotionListener(ScriptEditorPanel.this);
            c.addFocusListener(ScriptEditorPanel.this);
            if (ScriptEditorPanel.this.mapFileDropListener != null) {
                DropTarget dropTarget = new DropTarget(c, ScriptEditorPanel.this.mapFileDropListener);
            }
            return comp;
        }

        private Component createTextComponent(MapDocument.DeclSegment msg) {
            TextEditorPanel te = new TextEditorPanel();
            te.setEditable(false);
            Component c = te.getDragComponent();
            c.addMouseListener(ScriptEditorPanel.this);
            c.addFocusListener(ScriptEditorPanel.this);
            if (ScriptEditorPanel.this.mapFileDropListener != null) {
                DropTarget dropTarget = new DropTarget(c, ScriptEditorPanel.this.mapFileDropListener);
            }
            te.setDocument(msg.getSchemaDocument());
            return te;
        }

        private void selectedMessage(Component comp) {
            if (this.getComponentCount() > 1) {
                Component c = this.getComponent(1);
                c.removeMouseListener(ScriptEditorPanel.this);
                c.removeMouseMotionListener(ScriptEditorPanel.this);
                c.removeFocusListener(ScriptEditorPanel.this);
                this.remove(1);
            }
            this.add(comp, "Center");
            this.revalidate();
            this.repaint();
            this.msgList.setEnabledEvent(true);
        }
    }
}

