/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.map.table;

import com.argo21.common.log.AppMessage;
import com.argo21.common.log.BizTranException;
import com.argo21.map.IOFile;
import com.argo21.map.table.BizTranTableFileException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.commons.io.IOUtils;

public class TableFileAnalyzer {
    private Hashtable tableFileHash = null;
    private String mainMsg = null;

    public void analyzeTableFile(String tableFileName) throws BizTranTableFileException, BizTranException {
        this.tableFileHash = new Hashtable();
        FileInputStream fis = null;
        InputStreamReader isr = null;
        BufferedReader br = null;
        try {
            fis = new FileInputStream(tableFileName);
            isr = new InputStreamReader((InputStream)fis, "JISAutoDetect");
            br = new BufferedReader(isr);
            String line = null;
            while ((line = br.readLine()) != null) {
                if (line.trim().length() == 0) continue;
                int comma = line.indexOf(",");
                if (comma == -1) {
                    throw new BizTranTableFileException("\u5909\u63db\u88dc\u52a9\u30d5\u30a1\u30a4\u30eb\u3067\u3001\u30e1\u30c3\u30bb\u30fc\u30b8\u306b\u5bfe\u5fdc\u3059\u308b\u30d5\u30a1\u30a4\u30eb\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
                }
                String msg = line.substring(0, comma).trim();
                String file = line.substring(comma + 1).trim();
                if (file.equals("*")) {
                    this.mainMsg = msg;
                    continue;
                }
                if (file == null || file.length() == 0) {
                    throw new BizTranTableFileException("\u5909\u63db\u88dc\u52a9\u30d5\u30a1\u30a4\u30eb\u3067\u3001\u30e1\u30c3\u30bb\u30fc\u30b8\u306b\u5bfe\u5fdc\u3059\u308b\u30d5\u30a1\u30a4\u30eb\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
                }
                if (!new File(file).exists()) {
                    throw new BizTranTableFileException("\u5909\u63db\u88dc\u52a9\u30d5\u30a1\u30a4\u30eb\u3067\u6307\u5b9a\u3055\u308c\u305f\u30d5\u30a1\u30a4\u30eb\u304c\u5b58\u5728\u3057\u307e\u305b\u3093\u3002");
                }
                this.tableFileHash.put(msg, file);
            }
            if (this.mainMsg == null) {
                throw new BizTranTableFileException("\u5909\u63db\u88dc\u52a9\u30d5\u30a1\u30a4\u30eb\u3067\u3001\u5165\u529b\u30d5\u30a1\u30a4\u30eb\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
            }
        }
        catch (IOException e) {
            try {
                throw new BizTranException(AppMessage.IO_TABLE_INFILE_NOT_FOUND, tableFileName, e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(br);
                IOUtils.closeQuietly(isr);
                IOUtils.closeQuietly((InputStream)fis);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Reader)br);
        IOUtils.closeQuietly((Reader)isr);
        IOUtils.closeQuietly((InputStream)fis);
    }

    public String getMainMsg() {
        return this.mainMsg;
    }

    public int getTableMsgNum() {
        if (this.tableFileHash == null) {
            return 0;
        }
        return this.tableFileHash.size();
    }

    public void getTableFiles(IOFile[] iofiles) {
        if (this.tableFileHash != null) {
            Enumeration keys = this.tableFileHash.keys();
            int num = 2;
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                String file = (String)this.tableFileHash.get(key);
                iofiles[num] = new IOFile(key, file, IOFile.INPUT);
                ++num;
            }
        }
    }
}

