/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.msg;

import com.argo21.common.gui.FileFilterEx;
import com.argo21.common.io.Debug;
import com.argo21.common.io.FileEx;
import com.argo21.common.io.MIME2Java;
import com.argo21.common.io.XReader;
import com.argo21.common.lang.BaseDataViewer;
import com.argo21.common.lang.ExtOperand;
import com.argo21.common.lang.ExtOperandParser;
import com.argo21.common.lang.MessageCatalog;
import com.argo21.common.lang.Operand;
import com.argo21.common.lang.Variable;
import com.argo21.common.lang.VariableReference;
import com.argo21.common.lang.XData;
import com.argo21.common.lang.XDataException;
import com.argo21.common.lang.XDataMultipleException;
import com.argo21.common.lang.XDataViewer;
import com.argo21.common.lang.XNode;
import com.argo21.common.lang.XNodeSet;
import com.argo21.common.lang.XObject;
import com.argo21.common.util.Properties;
import com.argo21.jxp.dtd.DeclNode;
import com.argo21.jxp.dtd.DeclNodeList;
import com.argo21.jxp.dtd.SchemaDecl;
import com.argo21.msg.MessageException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.List;
import javax.swing.filechooser.FileFilter;
import org.apache.commons.lang.time.StopWatch;
import org.w3c.dom.Node;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public abstract class BaseMessage
implements ExtOperandParser,
XDataViewer {
    public static MessageCatalog msgCatalog = MessageException.msgCatalog;
    public static final String INPUT = "INPUT";
    public static final String OUTPUT = "OUTPUT";
    public static final String APPEND = "APPEND";
    public static final String PROPERTY_NAME = "name";
    public static final String PROPERTY_TYPE = "type";
    public static final String PROPERTY_DIRECTION = "direction";
    public static final String PROPERTY_ENCODING = "encoding";
    public static final String PROPERTY_URL = "url";
    public static final String PROPERTY_CONNECT = "connect";
    public static final String PROPERTY_LINESEPARATOR = "lineSeparator";
    public static final long TIMEOUT_VALUE_WRITE = 60000L;
    public static final String EOL_CRLF = "CRLF";
    public static final String EOL_LF = "LF";
    public static final String EOL_AUTO = "AUTO";
    public String eol;
    protected int order = -1;
    protected String name = null;
    protected String direction = null;
    protected String url = null;
    protected String encoding = null;
    protected int firstLine;
    protected int totalLines;
    protected Properties params = null;
    protected String baseUrl = null;
    protected ErrorHandler handler = null;
    protected String lineSeparator = null;

    public void setEol() {
        if (OUTPUT.equals(this.direction)) {
            this.eol = this.getLineSeparatorChar();
        } else {
            String temp;
            try {
                temp = System.getProperty("line.separator", "\n");
            }
            catch (SecurityException e) {
                temp = "\n";
            }
            this.eol = temp;
        }
    }

    private String getLineSeparatorChar() {
        switch (this.lineSeparator) {
            case "CRLF": {
                return "\r\n";
            }
            case "LF": {
                return "\n";
            }
            case "AUTO": {
                try {
                    return System.getProperty("line.separator", "\n");
                }
                catch (SecurityException e) {
                    return "\r\n";
                }
            }
        }
        return "\r\n";
    }

    public int getFirstLine() {
        return this.firstLine;
    }

    public int getTotalLines() {
        return this.totalLines;
    }

    public void setFirstLine(int value) {
        this.firstLine = value;
    }

    public void setTotalLines(int value) {
        this.totalLines = value;
    }

    public String getMsgName() {
        return this.name;
    }

    public String getMsgEncoding() {
        return this.encoding;
    }

    public void setMsgEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public URL getDocumentURL() {
        if (this.url == null) {
            return null;
        }
        URL baseUri = null;
        if (this.baseUrl != null) {
            try {
                baseUri = new URL(this.baseUrl);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        URL uri = null;
        try {
            uri = new URL(this.url);
        }
        catch (MalformedURLException ex) {
            File file = new File(this.url);
            try {
                uri = !file.isAbsolute() && baseUri != null ? new URL(baseUri, file.getPath()) : file.toURL();
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return uri;
    }

    public FileFilter getDocumentFileFilter() {
        return new FileFilterEx(new String[]{"xml"}, "XML Files");
    }

    public String getDirection() {
        return this.direction;
    }

    public boolean isStreamIO() {
        return this.url == null || this.url.trim().length() <= 0;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public Properties getDefaultProperties() {
        Properties ps = new Properties();
        ps.append(PROPERTY_NAME, "New" + this.getMsgType() + "_Msg");
        ps.append(PROPERTY_TYPE, this.getMsgType());
        ps.append(PROPERTY_DIRECTION, INPUT);
        String code = MIME2Java.getDefaultStandardEncoding();
        ps.append(PROPERTY_ENCODING, code);
        return ps;
    }

    public Properties getProperties() {
        Properties ps = new Properties();
        ps.append(PROPERTY_NAME, this.name);
        ps.append(PROPERTY_TYPE, this.getMsgType());
        ps.append(PROPERTY_DIRECTION, this.direction);
        if (this.url != null) {
            ps.append(PROPERTY_URL, this.url);
        }
        if (this.encoding != null) {
            ps.append(PROPERTY_ENCODING, this.encoding);
        }
        return ps;
    }

    public void setProperties(Properties ps) throws MessageException {
        this.name = ps.getValue(PROPERTY_NAME);
        if (this.name == null) {
            MessageException.error("NEED_MSGNAME", new Object[0], null);
        } else if (!BaseMessage.isName(this.name)) {
            MessageException.error("INVALID_MSGNAME", this.name, null);
        }
        String s = ps.getValue(PROPERTY_DIRECTION, INPUT).toUpperCase();
        if (s.equals(INPUT)) {
            this.direction = INPUT;
        } else if (s.equals(OUTPUT)) {
            this.direction = OUTPUT;
        } else if (s.equals(APPEND)) {
            this.direction = APPEND;
        } else {
            MessageException.error("INVALID_PARAM", new Object[]{PROPERTY_DIRECTION, s}, null);
        }
        this.encoding = ps.getValue(PROPERTY_ENCODING, null);
        if (this.encoding != null && MIME2Java.convert(this.encoding) == null) {
            MessageException.error("INVALID_PARAM", new Object[]{PROPERTY_ENCODING, this.encoding}, null);
        }
        this.url = ps.getValue(PROPERTY_URL, null);
        this.lineSeparator = ps.getValue(PROPERTY_LINESEPARATOR, EOL_CRLF).toUpperCase();
    }

    public XData getDocumentData(String xpath, VariableReference variables) throws SAXException {
        int type1;
        int type;
        XReader reader = XReader.createReader(new StringReader(xpath));
        Variable orient = new Variable(this.getMsgName(), new XObject(this));
        ExtOperand opt = this.parseOperand(orient, variables, reader);
        XData data = opt.getData();
        if (data instanceof XNodeSet) {
            if (data.size() == 1) {
                XNodeSet dd = (XNodeSet)data;
                XNode node = new XNode(dd.nodeValue());
                node.setTypeDecl(dd.getTypeDecl());
                data = node;
            } else if (data.size() == 0) {
                data = XData.XNULL;
            }
        }
        if ((type = data.getType()) != (type1 = data.getPrimitiveType())) {
            return data.castToType(type1);
        }
        return data;
    }

    public void setPrameters(Properties params) {
        this.params = params;
    }

    public void setErrorHandler(ErrorHandler handler) {
        this.handler = handler;
    }

    public void warning(String msg, Object[] args) throws SAXException {
        String fmsg = msgCatalog.getMessage(msg, args);
        if (this.handler != null) {
            MessageException e = new MessageException(fmsg, null);
            this.handler.warning(e);
        } else {
            Debug.println(fmsg);
        }
    }

    public void warning(Exception e) throws SAXException {
        String fmsg = e.getMessage();
        if (this.handler != null) {
            MessageException e1;
            if (e instanceof SAXParseException) {
                SAXParseException spe = (SAXParseException)e;
                String publicId = spe.getPublicId();
                String systemId = spe.getSystemId();
                int line = spe.getLineNumber();
                int col = spe.getColumnNumber();
                Exception exception = spe.getException();
                e1 = new MessageException(fmsg, publicId, systemId, line, col, exception);
            } else if (e instanceof SAXException) {
                SAXException se = (SAXException)e;
                Exception exception = se.getException();
                e1 = new MessageException(fmsg, null, exception);
            } else {
                e1 = new MessageException(fmsg, null, e);
            }
            this.handler.warning(e1);
        } else {
            Debug.println(fmsg);
        }
    }

    public void error(String msg, String arg) throws SAXException {
        this.error(msg, new String[]{arg});
    }

    public void error(String msg, Object[] args) throws SAXException {
        String fmsg = msgCatalog.getMessage(msg, args);
        MessageException e = new MessageException(fmsg, null);
        if (this.handler == null) {
            throw e;
        }
        this.handler.error(e);
    }

    public void error(Exception e) throws SAXException {
        String fmsg = e.getMessage();
        MessageException e1 = null;
        SAXException e2 = null;
        if (e instanceof SAXParseException) {
            SAXParseException spe = (SAXParseException)e;
            String publicId = spe.getPublicId();
            String systemId = spe.getSystemId();
            int line = spe.getLineNumber();
            int col = spe.getColumnNumber();
            Exception exception = spe.getException();
            e1 = new MessageException(fmsg, publicId, systemId, line, col, exception);
        } else if (e instanceof SAXException) {
            SAXException se = (SAXException)e;
            Exception exception = se.getException();
            e1 = new MessageException(fmsg, null, exception);
            e2 = se;
        } else {
            e1 = new MessageException(fmsg, null, e);
            e2 = new SAXException(e);
        }
        if (e2 != null) {
            throw e2;
        }
        if (this.handler == null) {
            throw e1;
        }
        this.handler.error(e1);
    }

    public void fatal(XDataException e) throws SAXException {
        if (e instanceof XDataMultipleException) {
            XDataException[] exceptions = ((XDataMultipleException)e).getExceptions();
            int n = exceptions.length;
            for (int i = 0; i < n; ++i) {
                String errMsg = exceptions[i].getMessage();
                boolean throwException = exceptions[i].isThrowException();
                if (throwException) {
                    this.error(e);
                    continue;
                }
                this.warning(e);
            }
        } else {
            String errMsg = e.getMessage();
            boolean throwException = e.isThrowException();
            if (throwException) {
                this.error(e);
            } else {
                this.warning(e);
            }
        }
    }

    public static boolean isName(String value) {
        if (value == null) {
            return false;
        }
        char c = value.charAt(0);
        if (!Character.isLetter(c) && c != '_') {
            return false;
        }
        int n = value.length();
        for (int i = 1; i < n; ++i) {
            c = value.charAt(i);
            if (Character.isLetterOrDigit(c) || c == '_') continue;
            return false;
        }
        return true;
    }

    public abstract String getMsgType();

    public abstract boolean isReady();

    public abstract long getLastModifies();

    public abstract Object getSchema();

    public abstract void setSchema(Object var1) throws MessageException;

    public abstract void readSchema(Reader var1) throws MessageException;

    public abstract void writeSchema(Writer var1) throws MessageException;

    public abstract Object getDocument();

    public abstract void setDocument(Object var1) throws SAXException;

    public abstract void clearDocument();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(URL url) throws SAXException {
        if (url == null) {
            return;
        }
        InputStream in = null;
        try {
            in = url.openStream();
            this.read(in);
        }
        catch (SAXException e) {
            throw e;
        }
        catch (Exception e) {
            this.error(e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public abstract void read(InputStream var1) throws SAXException;

    public abstract void read(Reader var1) throws SAXException;

    public abstract void write(OutputStream var1) throws SAXException;

    public abstract void write(Writer var1) throws SAXException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(URL url, boolean postscriptFlag) throws SAXException {
        if (url == null) {
            return;
        }
        AbstractInterruptibleChannel fc = null;
        FileLock lock = null;
        FileOutputStream out = null;
        try {
            String fileName = FileEx.urlToFile(url);
            if (fileName != null) {
                File file = new File(fileName);
                out = this.direction == APPEND ? new FileOutputStream(file.getPath(), true) : new FileOutputStream(file.getPath(), postscriptFlag);
            } else {
                URLConnection connection = url.openConnection();
                connection.setDoOutput(true);
                out = (FileOutputStream)connection.getOutputStream();
            }
            fc = out.getChannel();
            lock = ((FileChannel)fc).tryLock();
            StopWatch sw = new StopWatch();
            sw.start();
            while (lock == null) {
                if (sw.getTime() >= 60000L) {
                    if (fc != null) {
                        fc.close();
                        fc = null;
                    }
                    throw new IOException();
                }
                Thread.sleep(500L);
                lock = ((FileChannel)fc).tryLock();
            }
            this.write(out);
        }
        catch (SAXException e) {
            throw e;
        }
        catch (Exception e) {
            this.error(e);
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
                if (lock != null) {
                    lock.release();
                }
                if (fc != null) {
                    fc.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public abstract void close() throws SAXException;

    public abstract boolean init() throws SAXException;

    public abstract void submit() throws SAXException;

    @Override
    public abstract ExtOperand parseOperand(Operand var1, VariableReference var2, XReader var3) throws SAXException;

    @Override
    public boolean hasChildenDataViewer() {
        return true;
    }

    @Override
    public XDataViewer[] getChildren() {
        Properties ps = this.getProperties();
        int n = ps.getSize();
        XDataViewer[] res = new XDataViewer[n + 2];
        for (int i = 0; i < n; ++i) {
            res[i] = new BaseDataViewer("String", ps.getName(i), ps.getValue(i));
        }
        Object obj = this.getSchema();
        res[n] = obj instanceof XDataViewer ? new BaseDataViewer("schema", (XDataViewer)obj) : (obj instanceof SchemaDecl ? new BaseDataViewer("schema", new SchemaDeclViewer((SchemaDecl)obj)) : new BaseDataViewer("schema", new XObject(obj)));
        obj = this.getDocument();
        res[n + 1] = obj instanceof XDataViewer ? new BaseDataViewer("document", (XDataViewer)obj) : (obj instanceof Node ? new BaseDataViewer("document", new XNode((Node)obj)) : new BaseDataViewer("document", new XObject(obj)));
        return res;
    }

    @Override
    public String getEvalType() {
        return this.getMsgType();
    }

    @Override
    public String getEvalName() {
        return this.getMsgName();
    }

    @Override
    public Object getEvalValue() {
        return "";
    }

    public boolean validateMessage(String mapPath) {
        return true;
    }

    public List getExceptions() {
        return null;
    }

    public abstract String getExtension();

    public boolean doValidate() {
        return false;
    }

    public boolean isSettingIndent() {
        return false;
    }

    class SchemaDeclViewer
    implements XDataViewer {
        SchemaDecl schema;

        SchemaDeclViewer(SchemaDecl schema) {
            this.schema = schema;
        }

        @Override
        public boolean hasChildenDataViewer() {
            return true;
        }

        @Override
        public XDataViewer[] getChildren() {
            DeclNodeList list = this.schema.getAllDeclNode();
            int n = list.getLength();
            XDataViewer[] res = new XDataViewer[n];
            for (int i = 0; i < n; ++i) {
                DeclNode decl = list.item(i);
                String s = decl.getClass().getName();
                int k = s.lastIndexOf(".");
                if (k > 0) {
                    s = s.substring(k + 1);
                }
                res[i] = new BaseDataViewer(s, decl.getNodeName(), decl.toString());
            }
            return res;
        }

        @Override
        public String getEvalType() {
            return "DeclNode[]";
        }

        @Override
        public String getEvalName() {
            return "schema";
        }

        @Override
        public Object getEvalValue() {
            return "";
        }
    }
}

