/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.msg;

import com.argo21.common.lang.BaseDataViewer;
import com.argo21.common.lang.XBooleanSet;
import com.argo21.common.lang.XData;
import com.argo21.common.lang.XDataException;
import com.argo21.common.lang.XDataMultipleException;
import com.argo21.common.lang.XDataSet;
import com.argo21.common.lang.XDataViewer;
import com.argo21.common.lang.XDateSet;
import com.argo21.common.lang.XDoubleSet;
import com.argo21.common.lang.XFloatSet;
import com.argo21.common.lang.XIntegerSet;
import com.argo21.common.lang.XLongSet;
import com.argo21.common.lang.XNode;
import com.argo21.common.lang.XNodeSet;
import com.argo21.common.lang.XStringSet;
import com.argo21.msg.FieldMataData;
import com.argo21.msg.FieldNode;
import com.argo21.msg.TableDocument;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMConfiguration;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.w3c.dom.UserDataHandler;

public class CacheTable
implements TableDocument,
XDataViewer {
    public static final int BASESIZE = 64;
    protected int rows = 0;
    protected int cols = 0;
    protected XDataSet[] table;
    protected int capacity;
    protected FieldMataData[] fieldMataData;
    protected Document parent = null;
    private NodeList childNodes = new NodeList(){

        @Override
        public Node item(int index) {
            int row = index / CacheTable.this.cols;
            int col = index % CacheTable.this.cols;
            return new FieldNode(CacheTable.this, row, col);
        }

        @Override
        public int getLength() {
            return CacheTable.this.rows * CacheTable.this.cols;
        }
    };

    public CacheTable(FieldMataData[] fieldMataData) {
        this(fieldMataData, 64);
    }

    public CacheTable(FieldMataData[] fieldMataData, int capacity) {
        this(fieldMataData, capacity, null);
    }

    public CacheTable(FieldMataData[] fieldMataData, int capacity, Document parent) {
        this.fieldMataData = fieldMataData;
        this.cols = fieldMataData.length;
        this.capacity = capacity;
        this.parent = parent;
        this.reset();
    }

    @Override
    public FieldMataData[] getFieldMataData() {
        return this.fieldMataData;
    }

    @Override
    public void reset() {
        this.table = new XDataSet[this.cols];
        block8: for (int i = 0; i < this.cols; ++i) {
            switch (this.fieldMataData[i].type) {
                case 5: {
                    this.table[i] = new XBooleanSet(this.capacity);
                    continue block8;
                }
                case 1: {
                    this.table[i] = new XIntegerSet(this.capacity);
                    continue block8;
                }
                case 2: {
                    this.table[i] = new XLongSet(this.capacity);
                    continue block8;
                }
                case 3: {
                    this.table[i] = new XFloatSet(this.capacity);
                    continue block8;
                }
                case 4: {
                    this.table[i] = new XDoubleSet(this.capacity);
                    continue block8;
                }
                case 7: {
                    this.table[i] = new XDateSet(this.capacity);
                    continue block8;
                }
                default: {
                    this.table[i] = new XStringSet(this.capacity);
                }
            }
        }
        this.rows = 0;
    }

    @Override
    public void appendRow(String[] rowData) throws XDataException {
        XDataMultipleException exception = null;
        for (int i = 0; i < this.cols; ++i) {
            String data;
            FieldMataData dt = this.fieldMataData[i];
            String string2 = data = i < rowData.length ? rowData[i] : dt.value;
            if (data == null) {
                data = dt.value;
            }
            try {
                switch (dt.type) {
                    case 1: {
                        this.table[i].setValue(this.rows, dt.intValue(data));
                        break;
                    }
                    case 2: {
                        this.table[i].setValue(this.rows, dt.longValue(data));
                        break;
                    }
                    case 3: {
                        this.table[i].setValue(this.rows, dt.floatValue(data));
                        break;
                    }
                    case 4: {
                        this.table[i].setValue(this.rows, dt.doubleValue(data));
                        break;
                    }
                    case 5: {
                        this.table[i].setValue(this.rows, dt.booleanValue(data));
                        break;
                    }
                    case 7: {
                        this.table[i].setValue(this.rows, dt.dateValue(data));
                        break;
                    }
                    default: {
                        this.table[i].setValue(this.rows, data);
                        break;
                    }
                }
                continue;
            }
            catch (XDataException e) {
                if (dt.isNumber()) {
                    try {
                        this.table[i].setValue(this.rows, dt.doubleValue(data));
                    }
                    catch (XDataException xDataException) {
                        // empty catch block
                    }
                }
                if (exception != null) {
                    exception.addException(e);
                    continue;
                }
                exception = new XDataMultipleException(e);
            }
        }
        ++this.rows;
        if (exception != null) {
            throw exception;
        }
    }

    @Override
    public synchronized void extendRow(int maxRow) throws XDataException {
        XDataMultipleException exception = null;
        block12: for (int i = 0; i < this.cols; ++i) {
            int j;
            FieldMataData dt = this.fieldMataData[i];
            try {
                switch (dt.type) {
                    case 1: {
                        int intValue = dt.intValue();
                        for (int j2 = this.rows; j2 < maxRow; ++j2) {
                            this.table[i].setValue(j2, intValue);
                        }
                        continue block12;
                    }
                    case 2: {
                        long longValue = dt.longValue();
                        for (j = this.rows; j < maxRow; ++j) {
                            this.table[i].setValue(j, longValue);
                        }
                        continue block12;
                    }
                    case 3: {
                        float floatValue = dt.floatValue();
                        for (int j3 = this.rows; j3 < maxRow; ++j3) {
                            this.table[i].setValue(j3, floatValue);
                        }
                        continue block12;
                    }
                    case 4: {
                        double doubleValue = dt.doubleValue();
                        for (int j4 = this.rows; j4 < maxRow; ++j4) {
                            this.table[i].setValue(j4, doubleValue);
                        }
                        continue block12;
                    }
                    case 5: {
                        boolean booleanValue = dt.booleanValue();
                        for (int j5 = this.rows; j5 < maxRow; ++j5) {
                            this.table[i].setValue(j5, booleanValue);
                        }
                        continue block12;
                    }
                    case 7: {
                        Date dateValue = dt.dateValue();
                        for (int j6 = this.rows; j6 < maxRow; ++j6) {
                            this.table[i].setValue(j6, dateValue);
                        }
                        continue block12;
                    }
                    default: {
                        String value = dt.value;
                        for (int j7 = this.rows; j7 < maxRow; ++j7) {
                            this.table[i].setValue(j7, value);
                        }
                        continue block12;
                    }
                }
            }
            catch (XDataException e) {
                if (dt.isNumber()) {
                    try {
                        double doubleValue = dt.doubleValue();
                        for (j = this.rows; j < maxRow; ++j) {
                            this.table[i].setValue(j, doubleValue);
                        }
                    }
                    catch (XDataException xDataException) {
                        // empty catch block
                    }
                }
                if (exception != null) {
                    exception.addException(e);
                    continue;
                }
                exception = new XDataMultipleException(e);
            }
        }
        if (this.rows < maxRow) {
            this.rows = maxRow;
        }
        if (exception != null) {
            throw exception;
        }
    }

    @Override
    public int getCols() {
        return this.cols;
    }

    @Override
    public int getRows() {
        return this.rows;
    }

    @Override
    public int getColIndex(String colName) {
        for (int i = 0; i < this.cols; ++i) {
            String name2 = this.fieldMataData[i].name;
            if (!name2.equals(colName)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public String getColName(int col) {
        return this.fieldMataData[col].name;
    }

    @Override
    public int getColType(int col) {
        return this.fieldMataData[col].type;
    }

    @Override
    public String formatValue(int row, int col) throws XDataException {
        XDataSet colData = this.table[col];
        FieldMataData dt = this.fieldMataData[col];
        return dt.formatValue(colData, row);
    }

    @Override
    public boolean booleanValue(int row, int col) throws XDataException {
        return this.table[col].booleanValue(row);
    }

    @Override
    public int intValue(int row, int col) throws XDataException {
        return this.table[col].intValue(row);
    }

    @Override
    public long longValue(int row, int col) throws XDataException {
        return this.table[col].longValue(row);
    }

    @Override
    public float floatValue(int row, int col) throws XDataException {
        return this.table[col].floatValue(row);
    }

    @Override
    public double doubleValue(int row, int col) throws XDataException {
        return this.table[col].doubleValue(row);
    }

    @Override
    public String stringValue(int row, int col) {
        XDataSet ds = this.table[col];
        return ds.stringValue(row);
    }

    @Override
    public Date dateValue(int row, int col) throws XDataException {
        return this.table[col].dateValue(row);
    }

    @Override
    public Object objectValue(int row, int col) {
        return this.table[col].objectValue(row);
    }

    @Override
    public void setValue(int row, int col, boolean value) throws XDataException {
        if (row < this.rows) {
            this.table[col].setValue(row, value);
        }
    }

    @Override
    public void setValue(int row, int col, int value) throws XDataException {
        if (row < this.rows) {
            this.table[col].setValue(row, value);
        }
    }

    @Override
    public void setValue(int row, int col, long value) throws XDataException {
        if (row < this.rows) {
            this.table[col].setValue(row, value);
        }
    }

    @Override
    public void setValue(int row, int col, float value) throws XDataException {
        if (row < this.rows) {
            this.table[col].setValue(row, value);
        }
    }

    @Override
    public void setValue(int row, int col, double value) throws XDataException {
        if (row < this.rows) {
            this.table[col].setValue(row, value);
        }
    }

    @Override
    public void setValue(int row, int col, String value) throws XDataException {
        if (row < this.rows) {
            this.table[col].setValue(row, value);
        }
    }

    @Override
    public void setValue(int row, int col, Date value) throws XDataException {
        if (row < this.rows) {
            this.table[col].setValue(row, value);
        }
    }

    public void copyFromTableDocument(TableDocument tab) throws SQLException, XDataException {
        XDataMultipleException exception = null;
        int n = tab.getRows();
        int max = this.rows + n;
        int cols1 = tab.getCols();
        for (int col = 0; col < this.cols; ++col) {
            this.table[col].expendsCapacity(max);
        }
        for (int j = 0; j < n; ++j) {
            for (int i = 0; i < this.cols && i < cols1; ++i) {
                try {
                    switch (this.fieldMataData[i].type) {
                        case 1: {
                            this.table[i].setValue(this.rows + j, tab.intValue(j, i));
                            break;
                        }
                        case 2: {
                            this.table[i].setValue(this.rows + j, tab.longValue(j, i));
                            break;
                        }
                        case 3: {
                            this.table[i].setValue(this.rows + j, tab.floatValue(j, i));
                            break;
                        }
                        case 4: {
                            this.table[i].setValue(this.rows + j, tab.doubleValue(j, i));
                            break;
                        }
                        case 5: {
                            this.table[i].setValue(this.rows + j, tab.booleanValue(j, i));
                            break;
                        }
                        case 7: {
                            this.table[i].setValue(this.rows + j, tab.dateValue(j, i));
                            break;
                        }
                        default: {
                            this.table[i].setValue(this.rows + j, tab.stringValue(j, i));
                            break;
                        }
                    }
                    continue;
                }
                catch (XDataException e) {
                    if (this.fieldMataData[i].isNumber()) {
                        try {
                            this.table[i].setValue(this.rows + j, tab.doubleValue(j, i));
                        }
                        catch (XDataException xDataException) {
                            // empty catch block
                        }
                    }
                    if (exception != null) {
                        exception.addException(e);
                        continue;
                    }
                    exception = new XDataMultipleException(e);
                }
            }
        }
        if (this.cols > cols1) {
            block27: for (int i = cols1; i < this.cols; ++i) {
                int j;
                FieldMataData dt = this.fieldMataData[i];
                try {
                    switch (dt.type) {
                        case 1: {
                            int intValue = dt.intValue();
                            for (int j2 = this.rows; j2 < max; ++j2) {
                                this.table[i].setValue(j2, intValue);
                            }
                            continue block27;
                        }
                        case 2: {
                            long longValue = dt.longValue();
                            for (j = this.rows; j < max; ++j) {
                                this.table[i].setValue(j, longValue);
                            }
                            continue block27;
                        }
                        case 3: {
                            float floatValue = dt.floatValue();
                            for (int j3 = this.rows; j3 < max; ++j3) {
                                this.table[i].setValue(j3, floatValue);
                            }
                            continue block27;
                        }
                        case 4: {
                            double doubleValue = dt.doubleValue();
                            for (int j4 = this.rows; j4 < max; ++j4) {
                                this.table[i].setValue(j4, doubleValue);
                            }
                            continue block27;
                        }
                        case 5: {
                            boolean booleanValue = dt.booleanValue();
                            for (int j5 = this.rows; j5 < max; ++j5) {
                                this.table[i].setValue(j5, booleanValue);
                            }
                            continue block27;
                        }
                        case 7: {
                            Date dateValue = dt.dateValue();
                            for (int j6 = this.rows; j6 < max; ++j6) {
                                this.table[i].setValue(j6, dateValue);
                            }
                            continue block27;
                        }
                        default: {
                            String value = dt.value;
                            for (int j7 = this.rows; j7 < max; ++j7) {
                                this.table[i].setValue(j7, value);
                            }
                            continue block27;
                        }
                    }
                }
                catch (XDataException e) {
                    if (dt.isNumber()) {
                        try {
                            double doubleValue = dt.doubleValue();
                            for (j = this.rows; j < max; ++j) {
                                this.table[i].setValue(j, doubleValue);
                            }
                        }
                        catch (XDataException xDataException) {
                            // empty catch block
                        }
                    }
                    if (exception != null) {
                        exception.addException(e);
                        continue;
                    }
                    exception = new XDataMultipleException(e);
                }
            }
        }
        this.rows = max;
        if (exception != null) {
            throw exception;
        }
    }

    public void copyFromResultSet(ResultSet res) throws SQLException, XDataException {
        XDataMultipleException exception = null;
        int cols1 = res.getMetaData().getColumnCount();
        int j = this.rows;
        while (res.next()) {
            for (int col = 0; col < this.cols; ++col) {
                try {
                    if (col >= cols1) continue;
                    switch (this.fieldMataData[col].type) {
                        case 1: {
                            this.table[col].setValue(j, res.getInt(col + 1));
                            break;
                        }
                        case 2: {
                            this.table[col].setValue(j, res.getLong(col + 1));
                            break;
                        }
                        case 3: {
                            this.table[col].setValue(j, res.getFloat(col + 1));
                            break;
                        }
                        case 4: {
                            this.table[col].setValue(j, res.getDouble(col + 1));
                            break;
                        }
                        case 5: {
                            this.table[col].setValue(j, res.getBoolean(col + 1));
                            break;
                        }
                        case 7: {
                            if (this.fieldMataData[col].sqlType == 91) {
                                this.table[col].setValue(j, res.getDate(col + 1));
                                break;
                            }
                            if (this.fieldMataData[col].sqlType == 92) {
                                this.table[col].setValue(j, res.getTime(col + 1));
                                break;
                            }
                            if (this.fieldMataData[col].sqlType == 93) {
                                this.table[col].setValue(j, res.getTimestamp(col + 1));
                                break;
                            }
                            this.table[col].setValue(j, res.getString(col + 1));
                            break;
                        }
                        default: {
                            this.table[col].setValue(j, res.getString(col + 1));
                        }
                    }
                    continue;
                }
                catch (XDataException e) {
                    if (exception != null) {
                        exception.addException(e);
                        continue;
                    }
                    exception = new XDataMultipleException(e);
                }
            }
            ++j;
        }
        int maxRow = j;
        if (this.cols > cols1) {
            block24: for (int i = cols1; i < this.cols; ++i) {
                FieldMataData dt = this.fieldMataData[i];
                try {
                    switch (dt.type) {
                        case 1: {
                            int intValue = dt.intValue();
                            for (j = this.rows; j < maxRow; ++j) {
                                this.table[i].setValue(j, intValue);
                            }
                            continue block24;
                        }
                        case 2: {
                            long longValue = dt.longValue();
                            for (j = this.rows; j < maxRow; ++j) {
                                this.table[i].setValue(j, longValue);
                            }
                            continue block24;
                        }
                        case 3: {
                            float floatValue = dt.floatValue();
                            for (j = this.rows; j < maxRow; ++j) {
                                this.table[i].setValue(j, floatValue);
                            }
                            continue block24;
                        }
                        case 4: {
                            double doubleValue = dt.doubleValue();
                            for (j = this.rows; j < maxRow; ++j) {
                                this.table[i].setValue(j, doubleValue);
                            }
                            continue block24;
                        }
                        case 5: {
                            boolean booleanValue = dt.booleanValue();
                            for (j = this.rows; j < maxRow; ++j) {
                                this.table[i].setValue(j, booleanValue);
                            }
                            continue block24;
                        }
                        case 7: {
                            Date dateValue = dt.dateValue();
                            for (j = this.rows; j < maxRow; ++j) {
                                this.table[i].setValue(j, dateValue);
                            }
                            continue block24;
                        }
                        default: {
                            String value = dt.value;
                            for (j = this.rows; j < maxRow; ++j) {
                                this.table[i].setValue(j, value);
                            }
                            continue block24;
                        }
                    }
                }
                catch (XDataException e) {
                    if (dt.isNumber()) {
                        try {
                            double doubleValue = dt.doubleValue();
                            for (j = this.rows; j < maxRow; ++j) {
                                this.table[i].setValue(j, doubleValue);
                            }
                        }
                        catch (XDataException xDataException) {
                            // empty catch block
                        }
                    }
                    if (exception != null) {
                        exception.addException(e);
                        continue;
                    }
                    exception = new XDataMultipleException(e);
                }
            }
        }
        this.rows = maxRow;
        if (exception != null) {
            throw exception;
        }
    }

    @Override
    public DocumentType getDoctype() {
        return null;
    }

    @Override
    public DOMImplementation getImplementation() {
        return null;
    }

    @Override
    public Element getDocumentElement() {
        return null;
    }

    @Override
    public Element createElement(String tagName) throws DOMException {
        return null;
    }

    @Override
    public DocumentFragment createDocumentFragment() {
        return null;
    }

    @Override
    public Text createTextNode(String data) {
        return null;
    }

    @Override
    public Comment createComment(String data) {
        return null;
    }

    @Override
    public CDATASection createCDATASection(String data) throws DOMException {
        return null;
    }

    @Override
    public ProcessingInstruction createProcessingInstruction(String target, String data) throws DOMException {
        return null;
    }

    @Override
    public Attr createAttribute(String name2) throws DOMException {
        return null;
    }

    @Override
    public EntityReference createEntityReference(String name2) throws DOMException {
        return null;
    }

    @Override
    public NodeList getElementsByTagName(String tagname) {
        return null;
    }

    @Override
    public String getNodeName() {
        return "#table";
    }

    @Override
    public void setNodeValue(String nodeValue) throws DOMException {
    }

    @Override
    public String getNodeValue() throws DOMException {
        return null;
    }

    @Override
    public short getNodeType() {
        return 14;
    }

    @Override
    public Node getParentNode() {
        return this.parent;
    }

    @Override
    public NodeList getChildNodes() {
        return this.childNodes;
    }

    @Override
    public Node getFirstChild() {
        return this.rows > 0 && this.cols > 0 ? new FieldNode(this, 0, 0) : null;
    }

    @Override
    public Node getLastChild() {
        return this.rows > 0 && this.cols > 0 ? new FieldNode(this, this.rows - 1, this.cols - 1) : null;
    }

    @Override
    public Node getPreviousSibling() {
        if (this.parent == null) {
            return null;
        }
        NodeList list = this.parent.getChildNodes();
        int n = list.getLength();
        for (int i = 1; i < n; ++i) {
            if (!this.equals(list.item(i))) continue;
            return list.item(i - 1);
        }
        return null;
    }

    @Override
    public Node getNextSibling() {
        if (this.parent == null) {
            return null;
        }
        NodeList list = this.parent.getChildNodes();
        int n = list.getLength();
        for (int i = 0; i < n - 1; ++i) {
            if (!this.equals(list.item(i))) continue;
            return list.item(i + 1);
        }
        return null;
    }

    @Override
    public NamedNodeMap getAttributes() {
        return null;
    }

    @Override
    public Document getOwnerDocument() {
        return this.parent;
    }

    @Override
    public Node insertBefore(Node newChild, Node refChild) throws DOMException {
        return null;
    }

    @Override
    public Node replaceChild(Node newChild, Node oldChild) throws DOMException {
        return null;
    }

    @Override
    public Node removeChild(Node oldChild) throws DOMException {
        return null;
    }

    @Override
    public Node appendChild(Node newChild) throws DOMException {
        return null;
    }

    @Override
    public boolean hasChildNodes() {
        return this.rows > 0 && this.cols > 0;
    }

    @Override
    public Node cloneNode(boolean deep) {
        return null;
    }

    @Override
    public String getLocalName() {
        return this.getNodeName();
    }

    @Override
    public String getNamespaceURI() {
        return null;
    }

    @Override
    public String getPrefix() {
        return "";
    }

    @Override
    public boolean hasAttributes() {
        return false;
    }

    @Override
    public void normalize() {
    }

    @Override
    public boolean isSupported(String feature, String version) {
        return false;
    }

    @Override
    public void setPrefix(String prefix) throws DOMException {
    }

    @Override
    public Element createElementNS(String namespaceURI, String qualifiedName) throws DOMException {
        return null;
    }

    @Override
    public Attr createAttributeNS(String namespaceURI, String qualifiedName) throws DOMException {
        return null;
    }

    @Override
    public NodeList getElementsByTagNameNS(String namespaceURI, String localName) {
        XNodeSet nd = new XNodeSet(new Node[0]);
        return nd.nodeset();
    }

    @Override
    public Element getElementById(String elementId) {
        return null;
    }

    @Override
    public Node importNode(Node importedNode, boolean deep) throws DOMException {
        return null;
    }

    public void setEncoding(String encoding) {
    }

    @Override
    public Node adoptNode(Node source) {
        return null;
    }

    public void setVersion(String version) {
    }

    public String getVersion() {
        return null;
    }

    public boolean getStandalone() {
        return false;
    }

    public String getEncoding() {
        return null;
    }

    @Override
    public void setStrictErrorChecking(boolean strictErrorChecking) {
    }

    @Override
    public boolean getStrictErrorChecking() {
        return false;
    }

    public void setStandalone(boolean standalone) {
    }

    @Override
    public boolean hasChildenDataViewer() {
        return true;
    }

    @Override
    public XDataViewer[] getChildren() {
        XDataViewer[] res = new XDataViewer[this.rows];
        for (int i = 0; i < this.rows; ++i) {
            res[i] = new ColViewer(i);
        }
        return res;
    }

    @Override
    public String getEvalType() {
        return "row[]";
    }

    @Override
    public String getEvalName() {
        return "table";
    }

    @Override
    public Object getEvalValue() {
        return "";
    }

    @Override
    public String getDocumentURI() {
        return null;
    }

    @Override
    public DOMConfiguration getDomConfig() {
        return null;
    }

    @Override
    public String getInputEncoding() {
        return null;
    }

    @Override
    public String getXmlEncoding() {
        return null;
    }

    @Override
    public boolean getXmlStandalone() {
        return false;
    }

    @Override
    public String getXmlVersion() {
        return null;
    }

    @Override
    public void normalizeDocument() {
    }

    @Override
    public Node renameNode(Node n, String namespaceURI, String qualifiedName) throws DOMException {
        return null;
    }

    @Override
    public void setDocumentURI(String documentURI) {
    }

    @Override
    public void setXmlStandalone(boolean xmlStandalone) throws DOMException {
    }

    @Override
    public void setXmlVersion(String xmlVersion) throws DOMException {
    }

    @Override
    public short compareDocumentPosition(Node other) throws DOMException {
        return 0;
    }

    @Override
    public String getBaseURI() {
        return null;
    }

    @Override
    public Object getFeature(String feature, String version) {
        return null;
    }

    @Override
    public String getTextContent() throws DOMException {
        return null;
    }

    @Override
    public Object getUserData(String key) {
        return null;
    }

    @Override
    public boolean isDefaultNamespace(String namespaceURI) {
        return false;
    }

    @Override
    public boolean isEqualNode(Node arg) {
        return false;
    }

    @Override
    public boolean isSameNode(Node other) {
        return false;
    }

    @Override
    public String lookupNamespaceURI(String prefix) {
        return null;
    }

    @Override
    public String lookupPrefix(String namespaceURI) {
        return null;
    }

    @Override
    public void setTextContent(String textContent) throws DOMException {
    }

    @Override
    public Object setUserData(String key, Object data, UserDataHandler handler) {
        return null;
    }

    static {
        XNode.registNodeType(14, "table");
    }

    class ColViewer
    implements XDataViewer {
        int rownum;

        ColViewer(int rownum) {
            this.rownum = rownum;
        }

        @Override
        public boolean hasChildenDataViewer() {
            return true;
        }

        @Override
        public XDataViewer[] getChildren() {
            XDataViewer[] res = new XDataViewer[CacheTable.this.cols];
            for (int i = 0; i < CacheTable.this.cols; ++i) {
                FieldMataData dt = CacheTable.this.fieldMataData[i];
                res[i] = new BaseDataViewer(XData.getTypeName(dt.type), dt.name, CacheTable.this.stringValue(this.rownum, i));
            }
            return res;
        }

        @Override
        public String getEvalType() {
            return "fields";
        }

        @Override
        public String getEvalName() {
            return "fields";
        }

        @Override
        public Object getEvalValue() {
            return "";
        }
    }
}

