/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.msg;

import com.argo21.common.lang.MessageCatalog;
import java.util.Locale;
import org.xml.sax.Locator;
import org.xml.sax.SAXParseException;

public class MessageException
extends SAXParseException {
    public static MessageCatalog msgCatalog;
    String msgID;

    public static String getMessage(String msgId) {
        return msgCatalog.getMessage(msgId);
    }

    public static String getMessage(String msgId, String param) {
        return msgCatalog.getMessage(msgId, new Object[]{param});
    }

    public static String getMessage(String msgId, Object[] param) {
        return msgCatalog.getMessage(msgId, param);
    }

    public static void error(String msg, String arg, Locator locator) throws MessageException {
        MessageException.error(msg, new Object[]{arg}, null, locator);
    }

    public static void error(String msg, Object[] args, Locator locator) throws MessageException {
        MessageException.error(msg, args, null, locator);
    }

    public static void error(String msg, Object[] args, Exception exception, Locator locator) throws MessageException {
        if (exception != null) {
            if (locator != null) {
                throw new MessageException(null, locator, exception);
            }
            throw new MessageException(null, "", "", 0, 0, exception);
        }
        String fmsg = msgCatalog.getMessage(msg, args);
        MessageException e = locator != null ? new MessageException(fmsg, locator) : new MessageException(fmsg, "", "", 0, 0);
        e.msgID = msg;
        throw e;
    }

    public MessageException(String message, Locator locator) {
        super(message, locator);
    }

    public MessageException(String message, Locator locator, Exception e) {
        super(message, locator, e);
    }

    public MessageException(String message, String publicId, String systemId, int lineNumber, int columnNumber) {
        super(message, publicId, systemId, lineNumber, columnNumber);
    }

    public MessageException(String message, String publicId, String systemId, int lineNumber, int columnNumber, Exception e) {
        super(message, publicId, systemId, lineNumber, columnNumber, e);
    }

    public String getMessageID() {
        return this.msgID;
    }

    @Override
    public String getPublicId() {
        Exception exception = this.getException();
        String s = exception != null && exception instanceof SAXParseException ? ((SAXParseException)exception).getPublicId() : super.getPublicId();
        return s == null ? "" : s;
    }

    @Override
    public String getSystemId() {
        Exception exception = this.getException();
        if (exception != null && exception instanceof SAXParseException) {
            return ((SAXParseException)exception).getSystemId();
        }
        return super.getSystemId();
    }

    @Override
    public int getLineNumber() {
        Exception exception = this.getException();
        if (exception != null && exception instanceof SAXParseException) {
            return ((SAXParseException)exception).getLineNumber();
        }
        return super.getLineNumber();
    }

    @Override
    public int getColumnNumber() {
        Exception exception = this.getException();
        if (exception != null && exception instanceof SAXParseException) {
            return ((SAXParseException)exception).getColumnNumber();
        }
        return super.getColumnNumber();
    }

    static {
        String lang = System.getProperty("user.msg.lang", null);
        if (lang == null) {
            lang = Locale.getDefault().getLanguage();
        }
        String classbase = MessageException.class.getName();
        int k = classbase.lastIndexOf(".");
        classbase = classbase.substring(0, k + 1) + "MessageCatalog_";
        try {
            msgCatalog = (MessageCatalog)Class.forName(classbase + lang).newInstance();
        }
        catch (Exception e) {
            try {
                msgCatalog = (MessageCatalog)Class.forName(classbase + "en").newInstance();
            }
            catch (Exception e1) {
                System.err.println(e1);
                System.exit(1);
            }
        }
    }
}

