/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.msg;

import com.argo21.map.MappingEditor;
import com.argo21.msg.BaseMessage;
import com.argo21.msg.MessageException;
import com.argo21.msg.csv.CsvMsg;
import com.argo21.msg.fix.FixMsg;
import com.argo21.msg.rdb.RdbMsg;
import com.argo21.msg.xml.XmlMsg;
import com.argo21.msg.xsd.XsdMsg;
import java.util.Enumeration;
import java.util.Hashtable;

public class MessageFactory {
    private static final MessageFactory instance = new MessageFactory();
    public static final String XSD_TYPE = "XSD";
    public static final String XML_TYPE = "XML";
    public static final String CSV_TYPE = "CSV";
    public static final String RDB_TYPE = "RDB";
    public static final String FIX_TYPE = "FIX";
    private static Hashtable MESSAGE_CLASSES = new Hashtable(11);
    private static Hashtable MESSAGE_ENABLES = new Hashtable(11);

    public static MessageFactory getInstance() {
        return instance;
    }

    private MessageFactory() {
    }

    public void setEnabled(Object owner, String type, boolean b) {
        if (owner != null && owner instanceof MappingEditor) {
            MESSAGE_ENABLES.put(type, new Boolean(b));
        }
    }

    public boolean isEnabled(String type) {
        Boolean bool = (Boolean)MESSAGE_ENABLES.get(type);
        return bool == null ? false : bool;
    }

    public boolean contains(String type) {
        return MESSAGE_CLASSES.containsKey(type);
    }

    public void registMessage(String type, String classname) throws MessageException {
        if (MESSAGE_CLASSES.containsKey(type)) {
            MessageException.error("DOUBLE_MSG_TYPE", type, null);
        }
        try {
            Class<?> cls = Class.forName(classname);
            boolean b = false;
            for (Class<?> cls1 = cls.getSuperclass(); cls1 != null && !(b = cls1.equals(BaseMessage.class)); cls1 = cls1.getSuperclass()) {
            }
            if (!b) {
                MessageException.error("CANT_CAST_MSG", type, null);
            }
            MESSAGE_CLASSES.put(type.toUpperCase(), cls);
        }
        catch (Exception e) {
            MessageException.error("CANT_REG_MSG", new Object[]{type, e.getMessage()}, null);
        }
    }

    public BaseMessage createMessage(String type) throws MessageException {
        Class cls = (Class)MESSAGE_CLASSES.get(type.toUpperCase());
        if (cls == null) {
            MessageException.error("UNDEFINE_MSG", type, null);
        }
        try {
            return (BaseMessage)cls.newInstance();
        }
        catch (Exception e) {
            MessageException.error(null, null, e, null);
            return null;
        }
    }

    public String[] getMessageTypes() {
        String[] types = new String[MESSAGE_CLASSES.size()];
        Enumeration keys = MESSAGE_CLASSES.keys();
        int k = 0;
        while (keys.hasMoreElements()) {
            types[k++] = (String)keys.nextElement();
        }
        return types;
    }

    public String[] getEnabledMessageTypes() {
        String[] types = new String[MESSAGE_CLASSES.size()];
        Enumeration keys = MESSAGE_CLASSES.keys();
        int k = 0;
        while (keys.hasMoreElements()) {
            String s = (String)keys.nextElement();
            if (!this.isEnabled(s)) continue;
            types[k++] = s;
        }
        if (k < types.length) {
            String[] tmp = new String[k];
            System.arraycopy(types, 0, tmp, 0, k);
            return tmp;
        }
        return types;
    }

    static {
        MESSAGE_CLASSES.put(XSD_TYPE, XsdMsg.class);
        MESSAGE_CLASSES.put(XML_TYPE, XmlMsg.class);
        MESSAGE_CLASSES.put(CSV_TYPE, CsvMsg.class);
        MESSAGE_CLASSES.put(RDB_TYPE, RdbMsg.class);
        MESSAGE_CLASSES.put(FIX_TYPE, FixMsg.class);
        MESSAGE_ENABLES.put(XSD_TYPE, Boolean.TRUE);
        MESSAGE_ENABLES.put(XML_TYPE, Boolean.TRUE);
        MESSAGE_ENABLES.put(CSV_TYPE, Boolean.TRUE);
        MESSAGE_ENABLES.put(RDB_TYPE, Boolean.TRUE);
    }
}

