/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.msg;

import com.argo21.msg.DocumentViewer;
import com.argo21.msg.MessageException;
import com.argo21.msg.SchemaEditor;
import com.argo21.msg.SchemaViewer;
import com.argo21.msg.csv.CsvDocumentViewer;
import com.argo21.msg.csv.CsvSchemaEditor;
import com.argo21.msg.csv.CsvSchemaViewer;
import com.argo21.msg.fix.FixDocumentViewer;
import com.argo21.msg.fix.FixSchemaEditor;
import com.argo21.msg.fix.FixSchemaViewer;
import com.argo21.msg.rdb.RdbDocumentViewer;
import com.argo21.msg.rdb.RdbSchemaEditor;
import com.argo21.msg.rdb.RdbSchemaViewer;
import com.argo21.msg.xml.XmlDocumentViewer;
import com.argo21.msg.xml.XmlDtdEditor;
import com.argo21.msg.xml.XmlDtdViewer;
import com.argo21.msg.xsd.XmlXsdEditor;
import com.argo21.msg.xsd.XmlXsdViewer;
import com.argo21.msg.xsd.XsdDocumentViewer;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.xml.sax.SAXException;

public class VisualMessageFactory {
    private static final VisualMessageFactory instance = new VisualMessageFactory();
    private static Hashtable MESSAGE_CLASSES = new Hashtable(17);

    public static VisualMessageFactory getInstance() {
        return instance;
    }

    private VisualMessageFactory() {
    }

    public void registSchemaEditor(String type, Object cls) {
        MESSAGE_CLASSES.put(type + "[SE]", cls);
    }

    public void registSchemaViewer(String type, Object cls) {
        MESSAGE_CLASSES.put(type + "[SV]", cls);
    }

    public void registDocumentViewer(String type, Object cls) {
        MESSAGE_CLASSES.put(type + "[DV]", cls);
    }

    public String[] getMessageTypes() {
        Vector<String> v = new Vector<String>();
        Enumeration keys = MESSAGE_CLASSES.keys();
        while (keys.hasMoreElements()) {
            String s = (String)keys.nextElement();
            int k = s.indexOf("[");
            if (v.contains(s = s.substring(0, k))) continue;
            v.addElement(s);
        }
        Object[] types = new String[v.size()];
        v.copyInto(types);
        return types;
    }

    public SchemaEditor createSchemaEditor(String type) throws SAXException {
        Object cls = MESSAGE_CLASSES.get(type + "[SE]");
        if (cls == null) {
            return null;
        }
        try {
            if (cls instanceof Class) {
                return (SchemaEditor)((Class)cls).newInstance();
            }
            return (SchemaEditor)Class.forName(cls.toString()).newInstance();
        }
        catch (Exception e) {
            MessageException.error(null, null, e, null);
            return null;
        }
    }

    public SchemaViewer createSchemaViewer(String type) throws SAXException {
        Class cls = (Class)MESSAGE_CLASSES.get(type + "[SV]");
        if (cls == null) {
            return null;
        }
        try {
            if (cls instanceof Class) {
                return (SchemaViewer)cls.newInstance();
            }
            return (SchemaViewer)Class.forName(((Object)cls).toString()).newInstance();
        }
        catch (Exception e) {
            MessageException.error(null, null, e, null);
            return null;
        }
    }

    public DocumentViewer createDocumentViewer(String type) throws SAXException {
        Class cls = (Class)MESSAGE_CLASSES.get(type + "[DV]");
        if (cls == null) {
            MessageException.error("UNDEFINE_MSG", type, null);
        }
        try {
            if (cls instanceof Class) {
                return (DocumentViewer)cls.newInstance();
            }
            return (DocumentViewer)Class.forName(((Object)cls).toString()).newInstance();
        }
        catch (Exception e) {
            MessageException.error(null, null, e, null);
            return null;
        }
    }

    static {
        MESSAGE_CLASSES.put("XML[SE]", XmlDtdEditor.class);
        MESSAGE_CLASSES.put("XML[SV]", XmlDtdViewer.class);
        MESSAGE_CLASSES.put("XML[DV]", XmlDocumentViewer.class);
        MESSAGE_CLASSES.put("CSV[SE]", CsvSchemaEditor.class);
        MESSAGE_CLASSES.put("CSV[SV]", CsvSchemaViewer.class);
        MESSAGE_CLASSES.put("CSV[DV]", CsvDocumentViewer.class);
        MESSAGE_CLASSES.put("RDB[SE]", RdbSchemaEditor.class);
        MESSAGE_CLASSES.put("RDB[SV]", RdbSchemaViewer.class);
        MESSAGE_CLASSES.put("RDB[DV]", RdbDocumentViewer.class);
        MESSAGE_CLASSES.put("FIX[SE]", FixSchemaEditor.class);
        MESSAGE_CLASSES.put("FIX[SV]", FixSchemaViewer.class);
        MESSAGE_CLASSES.put("FIX[DV]", FixDocumentViewer.class);
        MESSAGE_CLASSES.put("XSD[SE]", XmlXsdEditor.class);
        MESSAGE_CLASSES.put("XSD[SV]", XmlXsdViewer.class);
        MESSAGE_CLASSES.put("XSD[DV]", XsdDocumentViewer.class);
    }
}

