/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.msg.csv;

import java.util.NoSuchElementException;

public class CSVTokenizer {
    public static String SPACE = " \t";
    String m_source;
    int m_pos;
    int m_max;
    char[] quote;
    char[] split;

    public CSVTokenizer(String line) {
        this(line, "\"'", ",");
    }

    public CSVTokenizer(String line, String quote, String split) {
        this.m_source = line.trim();
        this.m_pos = 0;
        this.m_max = this.m_source.length();
        this.quote = quote == null ? new char[0] : quote.toCharArray();
        this.split = split == null ? SPACE.toCharArray() : (split.trim().length() == 0 ? SPACE.toCharArray() : split.toCharArray());
    }

    private boolean isQuote(char c) {
        if (this.quote == null) {
            return false;
        }
        for (int i = 0; i < this.quote.length; ++i) {
            if (this.quote[i] != c) continue;
            return true;
        }
        return false;
    }

    private boolean isSplit(char c) {
        if (this.split == null) {
            return false;
        }
        for (int i = 0; i < this.split.length; ++i) {
            if (this.split[i] != c) continue;
            return true;
        }
        return false;
    }

    private int nextComma(int ind) {
        boolean inquote = false;
        char quote = '\"';
        if (ind >= this.m_max) {
            return this.m_max;
        }
        boolean ire = false;
        char c = this.m_source.charAt(ind);
        int c1 = 34;
        if (c == '\"') {
            ire = true;
        }
        while (ind < this.m_max) {
            char ch = this.m_source.charAt(ind);
            if (inquote) {
                if (quote == ch) {
                    inquote = false;
                }
            } else {
                if (this.isSplit(ch)) {
                    if (SPACE.indexOf(ch) < 0) break;
                    while (ind < this.m_max - 1 && SPACE.indexOf(this.m_source.charAt(ind + 1)) >= 0) {
                        ++ind;
                    }
                    break;
                }
                if (this.isQuote(ch)) {
                    quote = ch;
                    inquote = true;
                }
            }
            ++ind;
        }
        return ind;
    }

    public int countTokens() {
        if (this.m_source.length() == 0) {
            return 0;
        }
        int i = 0;
        int ret = 1;
        while ((i = this.nextComma(i)) < this.m_max) {
            ++i;
            ++ret;
        }
        return ret;
    }

    public boolean hasMoreTokens() {
        return this.m_pos <= this.m_max;
    }

    public String nextToken() {
        if (this.m_pos > this.m_max) {
            throw new NoSuchElementException(this.toString() + "#nextToken");
        }
        int st = this.m_pos;
        this.m_pos = this.nextComma(this.m_pos);
        String s = this.m_source.substring(st, this.m_pos).trim();
        ++this.m_pos;
        if (s.length() < 2) {
            return s;
        }
        char ch = s.charAt(0);
        if (this.isQuote(ch) && s.charAt(s.length() - 1) == ch || !this.isQuote(ch) && ch == '\"' && s.charAt(s.length() - 1) == '\"') {
            s = s.substring(1, s.length() - 1);
            StringBuffer str = new StringBuffer();
            boolean quot = false;
            for (int i = 0; i < this.quote.length; ++i) {
                if (this.quote[i] != '\"' && this.quote[i] != '\'') continue;
                quot = true;
            }
            String quo = String.valueOf(this.quote);
            String d_quo = quo + quo;
            if (!quot) {
                quo = "\"";
                d_quo = quo + quo;
            }
            while ((st = s.indexOf(d_quo)) >= 0) {
                String s1 = s.substring(0, st) + quo;
                str.append(s1);
                if (s.length() - 1 > st + 1) {
                    s = s.substring(st + 2);
                    continue;
                }
                s = "";
                break;
            }
            str.append(s);
            s = str.toString();
        }
        return s;
    }

    public String toString() {
        return "CSVTokenizer(\"" + this.m_source + "\")";
    }

    public static String enquote(String item) {
        if (0 > item.indexOf(34) && 0 > item.indexOf(44)) {
            return item;
        }
        StringBuffer sb = new StringBuffer(item.length() + 10);
        sb.append('\"');
        for (int ind = 0; ind < item.length(); ++ind) {
            char ch = item.charAt(ind);
            if ('\"' == ch) {
                sb.append("\"\"");
                continue;
            }
            sb.append(ch);
        }
        sb.append('\"');
        return sb.toString();
    }

    public static String removeQuote(String item, char[] quote) {
        if (quote == null || item.length() < 2) {
            return item;
        }
        int n = item.length() - 1;
        for (int i = 0; i <= n; ++i) {
            if (quote[i] != item.charAt(0) || quote[i] != item.charAt(n)) continue;
            return item.substring(1, n);
        }
        return item;
    }

    public static String removeQuote(String item) {
        return CSVTokenizer.removeQuote(item, new char[]{'\"', '\''});
    }

    public static void main(String[] args) {
        String[] sp = new String[]{",", " "};
        String[] ss = new String[]{" \"sdf \"\"dsfg\"\",dsfh\"  ,BB  , 'CC,    DD,EE' , ggg,    \"     sdf dsfg,dsfh\"", "AA     BB   ' CC,  \"\"DD\"\", EE'  ggg    \"sdf \"\"dsfg\"\",dsfh\""};
        for (int i = 0; i < ss.length; ++i) {
            CSVTokenizer ct = new CSVTokenizer(ss[i], "\"'", sp[i]);
            System.out.print(ct.countTokens());
            while (ct.hasMoreTokens()) {
                System.out.print("|");
                System.out.print(ct.nextToken());
            }
            System.out.println();
        }
    }
}

