/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.msg.csv;

import com.argo21.msg.DocumentViewer;
import com.argo21.msg.MessageException;
import com.argo21.msg.TableDocument;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.SystemColor;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;
import org.xml.sax.SAXException;

public class CsvDocumentViewer
extends JTable
implements DocumentViewer {
    private Font defaultFont = null;
    private Color defaultBackgroundColor = null;
    private TableDocument tableDoc = null;
    private MyTableModel tableModel = null;
    private String msgname = null;
    private FontMetrics fm = null;

    public CsvDocumentViewer() {
        try {
            this.defaultFont = new Font("Dialog", 0, 12);
        }
        catch (Exception e) {
            this.defaultFont = this.getFont();
        }
        this.defaultBackgroundColor = this.getBackground();
        this.fm = this.getFontMetrics(this.defaultFont);
        this.getTableHeader().setReorderingAllowed(false);
    }

    @Override
    public String getMsgType() {
        return "CSV";
    }

    @Override
    public String getMsgName() {
        return this.msgname;
    }

    @Override
    public Component getViewer() {
        return this;
    }

    @Override
    public void setDocument(Object document) throws SAXException {
        if (document == null) {
            this.initializeTable();
            return;
        }
        if (document instanceof TableDocument) {
            if (this.tableDoc == document) {
                this.reView();
                return;
            }
            this.tableDoc = (TableDocument)document;
            this.tableModel = new MyTableModel();
            if (this.tableDoc.getFieldMataData() == null) {
                this.initializeTable();
                return;
            }
            this.setModel(this.tableModel);
            this.setTableCellRenderer();
            this.setAutoResizeMode(0);
        } else {
            this.tableDoc = null;
            MessageException.error("CANT_VIEW_DOC", new Object[]{document.getClass().getName(), this.getMsgType()}, null);
        }
    }

    @Override
    public Object getDocument() {
        return this.tableDoc;
    }

    @Override
    public void reView() {
        this.revalidate();
        this.ajustTableColWidth();
        this.repaint();
    }

    public void reView1() {
        this.tableModel = new MyTableModel();
        if (this.tableDoc.getRows() == 0 || this.tableDoc.getCols() == 0) {
            this.initializeTable();
            return;
        }
        this.setModel(this.tableModel);
        this.setTableCellRenderer();
        this.setAutoResizeMode(0);
    }

    private void initializeTable() {
        this.tableDoc = null;
        this.tableModel = new MyTableModel();
        this.setModel(this.tableModel);
        DefaultTableColumnModel cmodel = (DefaultTableColumnModel)this.getColumnModel();
        TableColumn column = cmodel.getColumn(0);
        column.setCellRenderer(new MyTableCellRenderer());
        this.setAutoResizeMode(4);
    }

    private void setTableCellRenderer() {
        DefaultTableColumnModel cmodel = (DefaultTableColumnModel)this.getColumnModel();
        int columnNum = cmodel.getColumnCount();
        for (int i = 0; i < columnNum; ++i) {
            TableColumn column = cmodel.getColumn(i);
            column.setPreferredWidth(this.calculateColumnWidth(i) + 20);
            this.sizeColumnsToFit(-1);
            column.setCellRenderer(new MyTableCellRenderer());
        }
    }

    private void ajustTableColWidth() {
        DefaultTableColumnModel cmodel = (DefaultTableColumnModel)this.getColumnModel();
        int columnNum = cmodel.getColumnCount();
        for (int i = 0; i < columnNum; ++i) {
            TableColumn column = cmodel.getColumn(i);
            column.setPreferredWidth(this.calculateColumnWidth(i) + 20);
            this.sizeColumnsToFit(-1);
        }
    }

    private int calculateColumnWidth(int indexColumn) {
        int stringWidth;
        int columnWidth = 0;
        String s = this.tableModel.getColumnName(indexColumn);
        columnWidth = stringWidth = this.fm.charsWidth(s.toCharArray(), 0, s.length());
        int rows = this.tableModel.getRowCount();
        if (rows > 2) {
            rows = 2;
        }
        for (int j = 0; j < rows; ++j) {
            s = this.tableModel.getValueAt(j, indexColumn).toString();
            stringWidth = this.fm.charsWidth(s.toCharArray(), 0, s.length());
            if (stringWidth <= columnWidth) continue;
            columnWidth = stringWidth;
        }
        return columnWidth;
    }

    public static void main(String[] args) {
        CsvDocumentViewer csvDocViewer = new CsvDocumentViewer();
        JFrame testFrame = new JFrame();
        testFrame.setSize(new Dimension(400, 400));
        testFrame.getContentPane().setLayout(new BorderLayout());
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.getViewport().add(csvDocViewer);
        testFrame.getContentPane().add("Center", csvDocViewer);
        testFrame.setVisible(true);
        testFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                System.exit(0);
            }
        });
    }

    class MyTableCellRenderer
    extends DefaultTableCellRenderer {
        MyTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasForcus, int row, int column) {
            if (CsvDocumentViewer.this.defaultFont != null) {
                this.setFont(CsvDocumentViewer.this.defaultFont);
            }
            this.setForeground(new Color(102, 102, 153));
            if (isSelected) {
                this.setBackground(SystemColor.scrollbar);
            } else {
                this.setBackground(CsvDocumentViewer.this.defaultBackgroundColor);
            }
            this.setValue(value);
            if (CsvDocumentViewer.this.tableDoc != null) {
                switch (CsvDocumentViewer.this.tableDoc.getColType(column)) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        this.setHorizontalAlignment(4);
                        break;
                    }
                    default: {
                        this.setHorizontalAlignment(2);
                        break;
                    }
                }
            } else {
                this.setHorizontalAlignment(2);
            }
            return this;
        }
    }

    class MyTableModel
    extends AbstractTableModel {
        @Override
        public int getColumnCount() {
            try {
                return CsvDocumentViewer.this.tableDoc.getCols();
            }
            catch (Exception e) {
                return 1;
            }
        }

        @Override
        public int getRowCount() {
            try {
                return CsvDocumentViewer.this.tableDoc.getRows();
            }
            catch (Exception e) {
                return 1;
            }
        }

        @Override
        public Object getValueAt(int row, int col) {
            try {
                return CsvDocumentViewer.this.tableDoc.formatValue(row, col);
            }
            catch (Exception e) {
                return "No Document";
            }
        }

        @Override
        public String getColumnName(int column) {
            try {
                return CsvDocumentViewer.this.tableDoc.getColName(column);
            }
            catch (Exception e) {
                return "";
            }
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return false;
        }
    }
}

