/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.msg.csv;

import com.argo21.common.gui.FileFilterEx;
import com.argo21.common.io.Debug;
import com.argo21.common.io.MIME2Java;
import com.argo21.common.io.XReader;
import com.argo21.common.lang.DataTypeDecl;
import com.argo21.common.lang.ExtOperand;
import com.argo21.common.lang.ObjectDeclaration;
import com.argo21.common.lang.ObjectManager;
import com.argo21.common.lang.Operand;
import com.argo21.common.lang.VariableReference;
import com.argo21.common.lang.XData;
import com.argo21.common.lang.XDataException;
import com.argo21.common.lang.XDataMultipleException;
import com.argo21.common.lang.XDataSet;
import com.argo21.common.lang.XNodeSet;
import com.argo21.common.lang.XObject;
import com.argo21.common.lang.XString;
import com.argo21.common.lang.XStringSet;
import com.argo21.common.util.Properties;
import com.argo21.jxp.xpath.DefaultXPathSurpport;
import com.argo21.jxp.xpath.XPath;
import com.argo21.jxp.xpath.XPathParser;
import com.argo21.jxp.xpath.XPathSurpport;
import com.argo21.msg.BaseMessage;
import com.argo21.msg.CacheTable;
import com.argo21.msg.FieldMataData;
import com.argo21.msg.MessageException;
import com.argo21.msg.TableDocument;
import com.argo21.msg.csv.CSVTokenizer;
import com.argo21.msg.csv.CsvSchema;
import com.argo21.msg.csv.FieldDecl;
import com.argo21.msg.csv.TableColDataSet;
import com.argo21.msg.csv.XPathForCsvParser;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Hashtable;
import javax.swing.filechooser.FileFilter;
import org.xml.sax.SAXException;

public final class CsvMsg
extends BaseMessage {
    public static final String MSGTYPE = "CSV";
    private static final String EXTTYPE = "CSV".toLowerCase();
    public static final String PROPERTY_WITHHEAD = "withhead";
    public static final String PROPERTY_SPLIT = "split";
    public static final String PROPERTY_QUOTE = "quote";
    private boolean isChanged = false;
    protected boolean withhead = false;
    protected String split = ",";
    protected String quote = null;
    protected CsvSchema schema = null;
    protected TableDocument document = null;
    protected XPathParser xpathParser = null;
    protected XPathSurpport xpathSurpport;
    private boolean initialized = false;
    private long lastModifies = 0L;
    private boolean ready = false;
    public static final int METHOD_MAP = 256;
    protected Hashtable mapCode = new Hashtable(10);
    private String keyname = null;

    public static void registObject() {
        Class<CsvMsg> cls = CsvMsg.class;
        if (ObjectManager.isRegisted(cls)) {
            return;
        }
        ObjectDeclaration od = ObjectManager.createObjectDeclaration(cls, "CsvMsg");
        Method md = null;
        try {
            md = cls.getMethod("invoke", String.class, XData[].class);
        }
        catch (Exception e) {
            return;
        }
        od.addMethodDeclaration("map", md, String.valueOf(256), XData.class, 3);
    }

    public XData invoke(String id2, XData[] parameters) throws XDataException, NoSuchMethodException {
        int idd = -1;
        try {
            idd = Integer.parseInt(id2);
        }
        catch (Exception e) {
            throw new NoSuchMethodException();
        }
        switch (idd) {
            case 256: {
                int type1 = parameters[0].getType();
                int type2 = parameters[1].getType();
                int type3 = parameters[2].getType();
                if (type2 == 6 && type3 == 6) {
                    if (type1 == 262 || type1 == 274 || type1 == 6) {
                        String f1 = ((XString)parameters[1]).stringValue();
                        String f2 = ((XString)parameters[2]).stringValue();
                        return this.map(parameters[0], f1, f2);
                    }
                    XData.error("INVALID_PARAMETER", new Object[]{"map", "1"}, true);
                    break;
                }
                if (type2 != 6) {
                    XData.error("INVALID_PARAMETER", new Object[]{"map", "2"}, true);
                    break;
                }
                if (type3 == 6) break;
                XData.error("INVALID_PARAMETER", new Object[]{"map", "3"}, true);
            }
        }
        throw new NoSuchMethodException();
    }

    private XData map(XData src, String field1, String field2) throws XDataException, NoSuchMethodException {
        try {
            XData code;
            int type;
            if (!this.initialized && !this.init()) {
                String s = MessageException.msgCatalog.getMessage("CANT_INIT_MSG", new Object[]{this.name});
                Debug.println(s);
                throw new NoSuchMethodException();
            }
            int index1 = this.document.getColIndex(field1);
            int index2 = this.document.getColIndex(field2);
            if (index1 == -1 || index2 == -1) {
                String errField = null;
                errField = index1 == -1 ? field1 : field2;
                String s = MessageException.msgCatalog.getMessage("INVALID_FIELDNAME", new Object[]{"<" + errField + ">"});
                Debug.println(s);
                throw new NoSuchMethodException();
            }
            int cols = this.document.getCols();
            int rows = this.document.getRows();
            if (!field1.equalsIgnoreCase(this.keyname)) {
                this.mapCode.clear();
                this.keyname = field1;
                for (int i = 0; i < rows; ++i) {
                    String value1 = this.document.stringValue(i, index1);
                    if (this.mapCode.containsKey(value1)) {
                        XData.error("DOUBLE_FIELD", new String[]{field1, value1});
                        continue;
                    }
                    String[] values = new String[cols];
                    for (int j = 0; j < cols; ++j) {
                        values[j] = this.document.stringValue(i, j);
                    }
                    if (value1 != null && values != null) {
                        this.mapCode.put(value1, values);
                    }
                    if (value1 == null || values != null) continue;
                    this.mapCode.put(value1, new String[cols]);
                }
            }
            FieldMataData[] fieldMataData = new FieldMataData[2];
            if (this.schema != null) {
                FieldMataData[] fieldMataData1 = this.document.getFieldMataData();
                DataTypeDecl dtDecl1 = null;
                DataTypeDecl dtDecl2 = null;
                if (fieldMataData1 != null) {
                    int length = fieldMataData1.length;
                    for (int j = 0; j < length; ++j) {
                        FieldMataData fmd2;
                        if (field1.equalsIgnoreCase(fieldMataData1[j].name)) {
                            FieldMataData fmd1;
                            fieldMataData[0] = fmd1 = new FieldMataData(field1, (DataTypeDecl)fieldMataData1[j].clone());
                        }
                        if (!field2.equalsIgnoreCase(fieldMataData1[j].name)) continue;
                        fieldMataData[1] = fmd2 = new FieldMataData(field2, (DataTypeDecl)fieldMataData1[j].clone());
                    }
                } else {
                    FieldDecl decls1 = this.schema.getFieldDecl(field1);
                    FieldDecl decls2 = this.schema.getFieldDecl(field2);
                    if (decls1 != null) {
                        dtDecl1 = decls1.getDataTypeDecl();
                    }
                    if (decls2 != null) {
                        dtDecl2 = decls2.getDataTypeDecl();
                    }
                    if (dtDecl1 == null || decls1 == null) {
                        dtDecl1 = new DataTypeDecl();
                    }
                    if (dtDecl2 == null || decls2 == null) {
                        dtDecl2 = new DataTypeDecl();
                    }
                    FieldMataData metaData1 = new FieldMataData(field1, dtDecl1);
                    FieldMataData metaData2 = new FieldMataData(field2, dtDecl2);
                    fieldMataData[0] = metaData1;
                    fieldMataData[1] = metaData2;
                }
            }
            if ((type = src.getType()) == 274) {
                TableColDataSet dataset;
                TableDocument doc;
                int index3;
                code = (XNodeSet)src;
                String codename = ((XNodeSet)code).getNodeName();
                DataTypeDecl dtDecl = null;
                if (src instanceof TableColDataSet && (index3 = (doc = (dataset = (TableColDataSet)src).getOwnerDocument()).getColIndex(codename)) != -1) {
                    FieldMataData[] mata = doc.getFieldMataData();
                    dtDecl = (DataTypeDecl)mata[index3].clone();
                }
                if (dtDecl != null && dtDecl.type != fieldMataData[0].type) {
                    String s = MessageException.msgCatalog.getMessage("INVALID_DATATYPE", new Object[]{"<" + codename + ">", "<" + field1 + ">"});
                    Debug.println(s);
                    throw new NoSuchMethodException();
                }
                String codeSt = null;
                int size = ((XNodeSet)code).size();
                FieldMataData fmd3 = new FieldMataData(null, (DataTypeDecl)fieldMataData[1].clone());
                FieldMataData[] fms = new FieldMataData[]{fmd3};
                CacheTable tableDocument = new CacheTable(fms, 1);
                for (int i = 0; i < size; ++i) {
                    codeSt = ((XNodeSet)code).stringValue(i);
                    String[] data = new String[1];
                    if (this.mapCode.containsKey(codeSt)) {
                        String[] d = new String[cols];
                        d = (String[])this.mapCode.get(codeSt);
                        data[0] = d[index2];
                        tableDocument.appendRow(data);
                        continue;
                    }
                    data[0] = codeSt;
                    tableDocument.appendRow(data);
                }
                TableColDataSet tableSet = new TableColDataSet(tableDocument, 0);
                XNodeSet nodeset = new XNodeSet(tableSet);
                nodeset.setTypeDecl(fms[0]);
                return nodeset;
            }
            if (type == 262) {
                code = (XStringSet)src;
                String codeSt = null;
                int size = ((XDataSet)code).size();
                XStringSet stringset = new XStringSet(size);
                for (int i = 0; i < size; ++i) {
                    String data = null;
                    codeSt = ((XStringSet)code).stringValue(i);
                    if (this.mapCode.containsKey(codeSt)) {
                        String[] d = new String[cols];
                        d = (String[])this.mapCode.get(codeSt);
                        stringset.append(d[index2]);
                        continue;
                    }
                    data = codeSt;
                    stringset.append(data);
                }
                return stringset;
            }
            if (type == 6) {
                code = (XString)src;
                String data = ((XString)code).stringValue();
                String data1 = null;
                if (this.mapCode.containsKey(data)) {
                    String[] d = new String[cols];
                    d = (String[])this.mapCode.get(code);
                    data1 = d[index2];
                } else {
                    data1 = data;
                }
                XString string2 = new XString(data1);
                return string2;
            }
            throw new NoSuchMethodException();
        }
        catch (Exception e) {
            throw new NoSuchMethodException();
        }
    }

    @Override
    public String getMsgType() {
        return MSGTYPE;
    }

    @Override
    public boolean isReady() {
        return this.ready;
    }

    @Override
    public long getLastModifies() {
        return this.lastModifies;
    }

    @Override
    public FileFilter getDocumentFileFilter() {
        return new FileFilterEx(new String[]{"csv", "text"}, "CSV  Files");
    }

    @Override
    public Properties getProperties() {
        Properties ps = super.getProperties();
        String s = this.withhead ? "YES" : "NO";
        ps.append(PROPERTY_WITHHEAD, s);
        if (this.split.length() > 0 && this.split.trim().length() == 0) {
            ps.append(PROPERTY_SPLIT, "\"" + this.split + "\"");
        } else {
            ps.append(PROPERTY_SPLIT, this.split);
        }
        if (this.quote != null) {
            ps.append(PROPERTY_QUOTE, this.quote);
        }
        return ps;
    }

    @Override
    public void setProperties(Properties properties) throws MessageException {
        super.setProperties(properties);
        String s = properties.getValue(PROPERTY_WITHHEAD, "NO");
        if (s.equalsIgnoreCase("YES")) {
            this.withhead = true;
        } else if (s.equalsIgnoreCase("NO")) {
            this.withhead = false;
        } else {
            MessageException.error("INVALID_PARAM", new Object[]{PROPERTY_WITHHEAD, s}, null);
        }
        s = properties.getValue(PROPERTY_SPLIT, ",");
        if (s.startsWith("\"") && s.endsWith("\"") && s.length() > 1) {
            int len = s.length();
            s = s.substring(1, len - 1);
        }
        if (s.length() == 0) {
            MessageException.error("INVALID_PARAM", new Object[]{PROPERTY_SPLIT, s}, null);
        }
        this.split = s;
        s = properties.getValue(PROPERTY_QUOTE, null);
        if (s == null || s.length() == 0) {
            this.quote = null;
        } else {
            for (int i = 0; i < s.length(); ++i) {
                char c = s.charAt(i);
                if (c == '\"' || c == '\'') continue;
                MessageException.error("INVALID_PARAM", new Object[]{PROPERTY_QUOTE, s}, null);
            }
            this.quote = s;
        }
        this.initialized = false;
    }

    @Override
    public Object getSchema() {
        return this.schema;
    }

    @Override
    public void setSchema(Object schema) throws MessageException {
        if (schema instanceof CsvSchema) {
            this.schema = (CsvSchema)schema;
            this.initialized = false;
        } else {
            this.schema = null;
            MessageException.error("CANT_CAST_SCHEMA", new Object[]{schema.getClass().getName(), this.getMsgType()}, null);
        }
    }

    @Override
    public void readSchema(Reader in) throws MessageException {
        try {
            XReader reader = in instanceof XReader ? (XReader)in : XReader.createReader(in);
            CsvSchema schema = new CsvSchema(this.getMsgName());
            schema.parseSchemaDecl(reader);
            this.schema = schema;
            this.initialized = false;
        }
        catch (Exception e) {
            this.schema = null;
            MessageException.error(null, new Object[0], e, null);
        }
    }

    @Override
    public void writeSchema(Writer out) throws MessageException {
        try {
            this.schema.write(out);
        }
        catch (Exception e) {
            MessageException.error(null, new Object[0], e, null);
        }
    }

    @Override
    public Object getDocument() {
        return this.document;
    }

    @Override
    public void setDocument(Object document) throws SAXException {
        if (document instanceof TableDocument) {
            this.document = (TableDocument)document;
            this.ready = true;
            this.lastModifies = System.currentTimeMillis();
        } else {
            this.document = null;
            this.ready = false;
            this.error("CANT_CAST_DOM", new Object[]{document.getClass().getName(), this.getMsgType()});
        }
    }

    @Override
    public void read(InputStream in) throws SAXException {
        Reader rd = null;
        try {
            String encoding = this.getMsgEncoding();
            if (encoding != null) {
                rd = XReader.createReader(in, encoding);
            } else {
                try {
                    rd = new InputStreamReader(in, "JISAutoDetect");
                }
                catch (UnsupportedEncodingException ex) {
                    rd = new InputStreamReader(in);
                }
            }
        }
        catch (Exception e) {
            if (this.document != null) {
                this.document.reset();
            }
            this.ready = false;
            this.error(e);
        }
        this.read(rd);
    }

    @Override
    public void read(Reader in) throws SAXException {
        boolean headdealed = false;
        XReader reader = null;
        try {
            reader = in instanceof XReader ? (XReader)in : XReader.createReader(in);
            if (this.document == null) {
                FieldDecl[] decls = this.schema.getFieldDecls();
                this.document = new CacheTable(CsvMsg.covertFieldMataData(decls), 32);
            } else {
                this.document.reset();
            }
            this.ready = true;
            this.lastModifies = System.currentTimeMillis();
            int cols = this.document.getCols();
            reader.peekWhitespace();
            String[] buf = new String[cols];
            while (!reader.isEOF()) {
                String lineString = reader.readToEol();
                int k = 0;
                CSVTokenizer sz = new CSVTokenizer(lineString, this.quote, this.split);
                while (k < cols && sz.hasMoreTokens()) {
                    buf[k++] = sz.nextToken();
                }
                if (sz.hasMoreTokens()) {
                    this.warning("NOMATTH_FIELD_NUM", new Object[0]);
                }
                if (k < cols) {
                    this.warning("NOMATTH_FIELD_NUM", new Object[0]);
                    while (k < cols) {
                        int type = this.document.getColType(k);
                        if (XData.isBoolean(type)) {
                            buf[k++] = "false";
                            continue;
                        }
                        if (XData.isNumber(type)) {
                            buf[k++] = "0";
                            continue;
                        }
                        buf[k++] = "";
                    }
                }
                try {
                    if (!headdealed) {
                        if (this.withhead) {
                            this.checkHeader(buf);
                            headdealed = true;
                        } else {
                            this.document.appendRow(buf);
                        }
                        headdealed = true;
                    } else {
                        this.document.appendRow(buf);
                    }
                }
                catch (XDataException e) {
                    this.fatal(e);
                }
                reader.peekWhitespace();
            }
            this.lastModifies = System.currentTimeMillis();
        }
        catch (SAXException e) {
            if (this.document != null) {
                this.document.reset();
            }
            this.ready = false;
            throw e;
        }
        catch (Exception e) {
            if (this.document != null) {
                this.document.reset();
            }
            this.ready = false;
            this.error(e);
        }
    }

    private void checkHeader(String[] fields) throws SAXException {
        int cols = this.document.getCols();
        for (int i = 0; i < cols && i < fields.length; ++i) {
            String name2 = this.document.getColName(i);
            if (name2.equals(fields[i])) continue;
            this.warning("NOMATTH_FIELD", new Object[]{"<" + name2 + ">", "<" + fields[i] + ">"});
        }
    }

    @Override
    public void submit() throws SAXException {
        if (this.direction.equals("INPUT")) {
            return;
        }
        if (!this.isStreamIO()) {
            URL documentURL = this.getDocumentURL();
            this.write(documentURL, false);
        }
    }

    @Override
    public void write(OutputStream out) throws SAXException {
        OutputStreamWriter writer = null;
        if (this.encoding == null) {
            writer = new OutputStreamWriter(out);
            String en = writer.getEncoding();
            this.encoding = MIME2Java.reverse(en);
        } else {
            String s = MIME2Java.convert(this.encoding);
            try {
                writer = new OutputStreamWriter(out, s);
            }
            catch (UnsupportedEncodingException e) {
                this.error("INVALID_ENCODING", this.encoding);
            }
        }
        this.write(writer);
    }

    @Override
    public void write(Writer out) throws SAXException {
        if (this.document == null) {
            return;
        }
        boolean headdealed = false;
        try {
            BufferedWriter bw = new BufferedWriter(out);
            int cols = this.document.getCols();
            int rows = this.document.getRows();
            if (this.withhead) {
                for (int col = 0; col < cols; ++col) {
                    if (this.quote != null) {
                        bw.write(this.quote);
                    }
                    bw.write(this.document.getColName(col));
                    if (this.quote != null) {
                        bw.write(this.quote);
                    }
                    if (col >= cols - 1) continue;
                    bw.write(this.split);
                }
                bw.write(this.eol);
            }
            for (int row = 0; row < rows; ++row) {
                for (int col = 0; col < cols; ++col) {
                    String s;
                    if (this.document.getColType(col) == 6) {
                        s = null;
                        try {
                            s = this.document.formatValue(row, col);
                        }
                        catch (XDataException e) {
                            this.fatal(e);
                        }
                        if (s == null) {
                            bw.write("null");
                        } else if (this.quote != null) {
                            bw.write(this.quote);
                            int st = 0;
                            while ((st = s.indexOf(this.quote)) >= 0) {
                                bw.write(s.substring(0, st));
                                bw.write(this.quote);
                                bw.write(this.quote);
                                if (s.length() > st + 1) {
                                    s = s.substring(st + 1);
                                    continue;
                                }
                                s = "";
                                break;
                            }
                            bw.write(s);
                            bw.write(this.quote);
                        } else {
                            bw.write(s);
                        }
                    } else {
                        s = null;
                        try {
                            s = this.document.formatValue(row, col);
                        }
                        catch (XDataException e) {
                            this.fatal(e);
                        }
                        if (s == null) {
                            bw.write("null");
                        } else {
                            bw.write(s);
                        }
                    }
                    if (col >= cols - 1) continue;
                    bw.write(this.split);
                }
                bw.write(this.eol);
            }
            bw.flush();
        }
        catch (SAXException e) {
            throw e;
        }
        catch (Exception e) {
            this.error(e);
        }
    }

    @Override
    public void close() throws MessageException {
        this.document = null;
        this.ready = false;
    }

    @Override
    public void clearDocument() {
        if (this.direction != "INPUT" && this.document != null) {
            this.document.reset();
            this.lastModifies = System.currentTimeMillis();
        }
    }

    @Override
    public boolean init() throws SAXException {
        if (this.schema == null) {
            MessageException.error("CANT_INIT_MSG", new Object[0], null);
        }
        if (this.direction == "INPUT") {
            FieldDecl[] decls = this.schema.getFieldDecls();
            if (this.document == null) {
                this.document = new CacheTable(CsvMsg.covertFieldMataData(decls), 64);
                this.ready = false;
            } else {
                FieldMataData[] fdt1 = CsvMsg.covertFieldMataData(decls);
                if (!CsvMsg.compareFieldMataData(fdt1, this.document.getFieldMataData())) {
                    this.document = new CacheTable(fdt1, 64);
                    this.ready = false;
                }
            }
            if (!this.isStreamIO()) {
                this.document.reset();
                URL documentURL = this.getDocumentURL();
                this.read(documentURL);
            }
            this.xpathSurpport = new DefaultXPathSurpport();
            this.xpathSurpport.setExtendable(false);
        } else {
            FieldDecl[] decls = this.schema.getFieldDecls();
            this.document = new CacheTable(CsvMsg.covertFieldMataData(decls), 64);
            this.ready = true;
            this.xpathSurpport = new DefaultXPathSurpport();
            this.xpathSurpport.setExtendable(true);
            this.isChanged = true;
            this.lastModifies = System.currentTimeMillis();
        }
        this.initialized = true;
        return true;
    }

    public static FieldMataData[] covertFieldMataData(FieldDecl[] fieldDecls) {
        int cols = fieldDecls.length;
        FieldMataData[] fieldMataData = new FieldMataData[cols];
        for (int i = 0; i < cols; ++i) {
            DataTypeDecl dt = fieldDecls[i].getDataTypeDecl();
            if (dt == null) {
                dt = DataTypeDecl.getDefaultDataTypeDecl();
            }
            fieldMataData[i] = new FieldMataData(fieldDecls[i].getNodeName(), dt);
        }
        return fieldMataData;
    }

    public static boolean compareFieldMataData(FieldMataData[] fieldDecls1, FieldMataData[] fieldDecls2) {
        if (fieldDecls1.length != fieldDecls2.length) {
            return false;
        }
        int cols1 = fieldDecls1.length;
        for (int i = 0; i < cols1; ++i) {
            if (fieldDecls1[i].equals(fieldDecls2[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public ExtOperand parseOperand(Operand orient, VariableReference variables, XReader in) throws SAXException {
        if (!this.initialized && !this.init()) {
            this.error("CANT_INIT_MSG", this.name);
        }
        if (this.xpathSurpport.getVariableReference() != variables) {
            this.xpathSurpport.setVariableReference(variables);
        }
        if (this.xpathParser == null) {
            this.xpathParser = new XPathForCsvParser();
        }
        XPath xpath = this.xpathParser.parse(in);
        XPathOperand op = new XPathOperand(orient, xpath);
        String s = orient.getReference();
        s = s + "/" + xpath.getNodePathString();
        op.setReference(s);
        return op;
    }

    public String toString() {
        Properties ps = this.getProperties();
        return ps.toString(",");
    }

    public static void main(String[] args) {
        try {
            FileReader rd = new FileReader("map2.txt");
            XReader in = XReader.createReader(rd);
            Properties ps = new Properties();
            ps.append("name", "MSG2");
            ps.append("type", MSGTYPE);
            ps.append("direction", "INPUT");
            ps.append("url", "samples\\map\\book-order-csv\\document.csv");
            ps.append(PROPERTY_WITHHEAD, "YES");
            ps.append(PROPERTY_QUOTE, "\"");
            ps.append("encoding", "SHIFT_JIS");
            CsvMsg msg = new CsvMsg();
            msg.setProperties(ps);
            msg.readSchema(in);
            msg.read(msg.getDocumentURL());
            OutputStreamWriter wr = new OutputStreamWriter(System.out);
            msg.write(wr);
            boolean b = false;
            ((Writer)wr).flush();
            rd.close();
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    @Override
    public String getExtension() {
        return EXTTYPE;
    }

    class XPathOperand
    extends ExtOperand {
        XPathOperand(Operand orient, Object expression) {
            super(orient, expression);
        }

        @Override
        public String getEncoding() {
            return CsvMsg.this.encoding;
        }

        private XData selectData(XData ref) throws XDataException {
            XPath xpath = (XPath)this.expression;
            try {
                if (ref instanceof TableColDataSet) {
                    return xpath.eval(ref, CsvMsg.this.xpathSurpport);
                }
                if (ref.isObject()) {
                    Object obj = ref.objectValue();
                    if (obj instanceof CsvMsg) {
                        TableDocument doc = ((CsvMsg)obj).document;
                        return xpath.eval(new XObject(doc), CsvMsg.this.xpathSurpport);
                    }
                    if (obj instanceof XData) {
                        Object[] param = new Object[]{((XData)obj).getPrimitiveTypeName(), TableDocument.class.getName()};
                        XData.error("CANT_TO_TYPE", param, true);
                    } else {
                        Object[] param = new Object[]{obj.getClass().getName(), TableDocument.class.getName()};
                        XData.error("CANT_TO_TYPE", param, true);
                    }
                } else {
                    Object[] param = new Object[]{ref.getPrimitiveTypeName(), TableDocument.class.getName()};
                    XData.error("CANT_TO_TYPE", param, true);
                }
            }
            catch (XDataException e) {
                throw e;
            }
            catch (Exception e) {
                XData.error(e, true);
            }
            return null;
        }

        @Override
        protected XData getData(XData ref) throws XDataException {
            CsvMsg.this.xpathSurpport.setExtendable(false);
            return this.selectData(ref);
        }

        @Override
        protected void setData(XData ref, XData data) throws XDataException {
            int maxrow = Math.max(CsvMsg.this.document.getRows(), data.size());
            CsvMsg.this.xpathSurpport.setDefaultNumber(maxrow);
            CsvMsg.this.xpathSurpport.setExtendable(CsvMsg.this.getDirection() != "INPUT");
            XData target = this.selectData(ref);
            int type = data.getPrimitiveType();
            int n = target.size();
            XDataMultipleException exception = null;
            switch (type) {
                case 1: {
                    for (int i = 0; i < n; ++i) {
                        try {
                            target.setValue(i, data.intValue(i));
                            continue;
                        }
                        catch (XDataException e) {
                            if (exception != null) {
                                exception.addException(e);
                                continue;
                            }
                            exception = new XDataMultipleException(e);
                        }
                    }
                    break;
                }
                case 2: {
                    for (int i = 0; i < n; ++i) {
                        try {
                            target.setValue(i, data.longValue(i));
                            continue;
                        }
                        catch (XDataException e) {
                            if (exception != null) {
                                exception.addException(e);
                                continue;
                            }
                            exception = new XDataMultipleException(e);
                        }
                    }
                    break;
                }
                case 3: {
                    for (int i = 0; i < n; ++i) {
                        try {
                            target.setValue(i, data.floatValue(i));
                            continue;
                        }
                        catch (XDataException e) {
                            if (exception != null) {
                                exception.addException(e);
                                continue;
                            }
                            exception = new XDataMultipleException(e);
                        }
                    }
                    break;
                }
                case 4: {
                    for (int i = 0; i < n; ++i) {
                        try {
                            target.setValue(i, data.doubleValue(i));
                            continue;
                        }
                        catch (XDataException e) {
                            if (exception != null) {
                                exception.addException(e);
                                continue;
                            }
                            exception = new XDataMultipleException(e);
                        }
                    }
                    break;
                }
                case 5: {
                    for (int i = 0; i < n; ++i) {
                        try {
                            target.setValue(i, data.booleanValue(i));
                            continue;
                        }
                        catch (XDataException e) {
                            if (exception != null) {
                                exception.addException(e);
                                continue;
                            }
                            exception = new XDataMultipleException(e);
                        }
                    }
                    break;
                }
                case 7: {
                    for (int i = 0; i < n; ++i) {
                        try {
                            target.setValue(i, data.dateValue(i));
                            continue;
                        }
                        catch (XDataException e) {
                            if (exception != null) {
                                exception.addException(e);
                                continue;
                            }
                            exception = new XDataMultipleException(e);
                        }
                    }
                    break;
                }
                default: {
                    for (int i = 0; i < n; ++i) {
                        try {
                            target.setValue(i, data.stringValue(i));
                            continue;
                        }
                        catch (XDataException e) {
                            if (exception != null) {
                                exception.addException(e);
                                continue;
                            }
                            exception = new XDataMultipleException(e);
                        }
                    }
                }
            }
            CsvMsg.this.lastModifies = System.currentTimeMillis();
            if (exception != null) {
                throw exception;
            }
        }
    }
}

