/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.msg.csv;

import com.argo21.common.io.XReader;
import com.argo21.common.lang.DataTypeDecl;
import com.argo21.common.util.Properties;
import com.argo21.jxp.dtd.CommentDeclNode;
import com.argo21.jxp.dtd.DeclNode;
import com.argo21.jxp.dtd.DeclNodeList;
import com.argo21.jxp.dtd.DeclNodeListImpl;
import com.argo21.jxp.dtd.SchemaDecl;
import com.argo21.msg.MessageException;
import com.argo21.msg.csv.FieldDecl;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Hashtable;
import org.xml.sax.Locator;

public class CsvSchema
implements DeclNode,
SchemaDecl {
    public static final int CSV_DECL = 42;
    public static final int FIELD_DECL = 43;
    public static final String FIELD_STRING = "field";
    protected static String eol;
    protected DeclNodeListImpl nodes = new DeclNodeListImpl(20);
    protected Hashtable fieldDecls = new Hashtable(11);
    protected String name;

    public CsvSchema() {
        this(null);
    }

    public CsvSchema(String name2) {
        this.name = name2;
    }

    @Override
    public int getNodeType() {
        return 42;
    }

    @Override
    public String getNodeName() {
        return this.name;
    }

    @Override
    public DataTypeDecl getDataTypeDecl() {
        return null;
    }

    @Override
    public DeclNode getParentDecl() {
        return null;
    }

    @Override
    public DeclNode getOwner() {
        return null;
    }

    @Override
    public DeclNodeList getAllDeclNode() {
        return this.nodes;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean parseSchemaDecl(XReader in) throws MessageException {
        try {
            do {
                in.peekWhitespace();
                if (in.isEOF()) return true;
            } while (this.parseComment(in) || this.parseFieldDecl(in) || this.parseDataDecl(in));
            if (!in.isChar(']')) return true;
            return true;
        }
        catch (IOException e) {
            throw new MessageException(null, in, e);
        }
    }

    protected boolean parseComment(XReader in) throws IOException, MessageException {
        if (!in.peek("<!--")) {
            return false;
        }
        String s1 = in.readStringTo("-->", false);
        if (s1 != null) {
            CommentDeclNode decl = new CommentDeclNode(this, s1);
            this.nodes.addElement(decl);
        } else {
            MessageException.error("NEED_CHAR", "-->", (Locator)in);
        }
        return true;
    }

    protected boolean parseFieldDecl(XReader in) throws IOException, MessageException {
        String s;
        if (!in.peek("<!FIELD")) {
            return false;
        }
        if (!in.peekWhitespace()) {
            MessageException.error("INVAILD_CHAR", String.valueOf(in.getc()), (Locator)in);
        }
        FieldDecl decl = new FieldDecl((DeclNode)this, in);
        in.peekWhitespace();
        if (!in.peekc('>')) {
            MessageException.error("NEED_CHAR", ">", (Locator)in);
        }
        if (this.fieldDecls.containsKey(s = decl.getNodeName())) {
            MessageException.error("DOUBLE_NAME", s, (Locator)in);
        }
        this.fieldDecls.put(s, decl);
        this.nodes.addElement(decl);
        return true;
    }

    public void appendChild(DeclNode newChild) {
        int type = newChild.getNodeType();
        if (type == 43) {
            this.fieldDecls.put(newChild.getNodeName(), newChild);
            this.nodes.addElement(newChild);
        } else {
            this.nodes.addElement(newChild);
        }
    }

    protected boolean parseDataDecl(XReader in) throws MessageException {
        Properties properties = new Properties();
        if (!in.peek("<DATA")) {
            return false;
        }
        if (!in.peekWhitespace()) {
            MessageException.error("INVAILD_CHAR", String.valueOf(in.getc()), (Locator)in);
        }
        boolean hasEnded = false;
        while (!in.isEOF()) {
            if (in.isChar('\\')) {
                in.getc();
                if (in.isChar('>')) {
                    in.getc();
                    hasEnded = true;
                    break;
                }
                MessageException.error("NEED_CHAR", ">", (Locator)in);
            }
            if (in.isChar('>')) {
                in.getc();
                break;
            }
            String propertyname = in.peekName();
            if (propertyname == null) {
                MessageException.error("INVAILD_CHAR", String.valueOf(in.getc()), (Locator)in);
            }
            in.peekWhitespace();
            if (!in.peekc('=')) {
                MessageException.error("NEED_CHAR", "=", (Locator)in);
            }
            in.peekWhitespace();
            String propertyvalue = in.peekQuotedString();
            if (propertyvalue == null) {
                MessageException.error("INVALID_PARAM", propertyname, (Locator)in);
            }
            properties.append(propertyname, propertyvalue);
            in.peekWhitespace();
        }
        if (!hasEnded) {
            in.peekWhitespace();
            String s = in.readStringTo("</DATA>", false);
            properties.append("value", Properties.parseSpecialChar(s));
        }
        DataTypeDecl dtDecl = new DataTypeDecl(properties);
        String element = properties.getValue(FIELD_STRING);
        if (element != null) {
            FieldDecl fielddecl = this.getFieldDecl(element);
            if (fielddecl != null) {
                fielddecl.setDataTypeDecl(dtDecl);
            } else {
                MessageException.error("INVALID_PARAM", new Object[]{FIELD_STRING, element}, (Locator)in);
            }
        } else {
            MessageException.error("INVALID_PARAM", new Object[]{FIELD_STRING, ""}, (Locator)in);
        }
        return true;
    }

    public FieldDecl[] getFieldDecls() {
        int n = this.nodes.size();
        FieldDecl[] res = new FieldDecl[n];
        int k = 0;
        for (int i = 0; i < n; ++i) {
            DeclNode obj = this.nodes.elementAt(i);
            if (!(obj instanceof FieldDecl)) continue;
            res[k++] = (FieldDecl)obj;
        }
        if (k < n) {
            FieldDecl[] res1 = new FieldDecl[k];
            System.arraycopy(res, 0, res1, 0, k);
            return res1;
        }
        return res;
    }

    public FieldDecl getFieldDecl(String name2) {
        Object decl = this.fieldDecls.get(name2);
        if (decl != null) {
            return (FieldDecl)decl;
        }
        return null;
    }

    public void write(Writer out) throws IOException {
        DeclNode node;
        int i;
        int n = this.nodes.size();
        for (i = 0; i < n; ++i) {
            node = this.nodes.elementAt(i);
            out.write(node.toString());
            out.write(eol);
        }
        out.write(eol);
        for (i = 0; i < n; ++i) {
            DataTypeDecl dt;
            node = this.nodes.elementAt(i);
            int type = node.getNodeType();
            if (type != 43 || (dt = node.getDataTypeDecl()) == null) continue;
            FieldDecl element = (FieldDecl)node;
            String attr = "field=\"" + element.getNodeName() + "\"";
            String s = dt.getXML(attr);
            if (s == null) continue;
            out.write(dt.getXML(attr));
            out.write(eol);
        }
    }

    public static void main(String[] args) {
        try {
            FileReader rd = new FileReader("map2.txt");
            XReader in = XReader.createReader(rd);
            CsvSchema cs = new CsvSchema("WWW");
            cs.parseSchemaDecl(in);
            StringWriter sw = new StringWriter();
            cs.write(sw);
            System.out.println(sw.toString());
            boolean bl = false;
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    @Override
    public String getNodeTypeName() {
        return "CsvSchema";
    }

    static {
        String temp;
        try {
            temp = System.getProperty("line.separator", "\n");
        }
        catch (SecurityException e) {
            temp = "\n";
        }
        eol = temp;
    }
}

