/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.msg.csv;

import com.argo21.common.gui.ComboTextFieldEx;
import com.argo21.common.gui.ImageLoader;
import com.argo21.common.gui.TextFieldEx;
import com.argo21.common.io.MIME2Java;
import com.argo21.common.lang.DataTypeDecl;
import com.argo21.common.lang.XData;
import com.argo21.common.util.Properties;
import com.argo21.jxp.dtd.CommentDecl;
import com.argo21.jxp.dtd.CommentDeclNode;
import com.argo21.jxp.dtd.DTDException;
import com.argo21.jxp.dtd.DeclNode;
import com.argo21.jxp.dtd.DeclNodeList;
import com.argo21.jxp.vdtd.ContentsEditPanel;
import com.argo21.jxp.vdtd.DTDEditorPanel;
import com.argo21.jxp.vdtd.DeclNodeData;
import com.argo21.jxp.vdtd.ResultPanel;
import com.argo21.msg.MessageException;
import com.argo21.msg.SchemaEditor;
import com.argo21.msg.csv.CsvSchema;
import com.argo21.msg.csv.FieldDecl;
import com.argo21.msg.csv.ImportCSVDialog;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;

public class CsvSchemaEditor
extends DTDEditorPanel
implements SchemaEditor {
    public static final String CMD_NEW_FIELD = "FIELD";
    public static final int CAN_NEW_FIELD = 256;
    static final String CMD_IMPORT_SCHEMA = "CMD_IMPORT";
    static String[] toolBarNames = new String[]{"FIELD", "COMMENT", "-", "NODECOPY", "REMOVE", "TOUP", "TODOWN"};
    static String[][] editMenus = new String[][]{{"FIELD", "F", null, null}, {"COMMENT", "M", null, null}, {"-", null, null, null}, {"NODECOPY", "C", null, "2:155"}, {"REMOVE", "D", null, String.valueOf(127)}, {"-", null, null, null}, {"FINDNODE", "F", null, "2:70"}, {"REFINDNODE", "R", null, String.valueOf(114)}, {"-", null, null, null}, {"TOUP", "U", null, null}, {"TODOWN", "W", null, null}, {"-", null, null, null}, {"CMD_IMPORT", null, null, null}};
    private JToolBar toolBar = null;
    private JMenu menu = null;
    private Properties ps;
    private CsvSchema csvSchema;
    private SchemaEditor.NameChangedListener nameChangedListener = null;
    private SchemaEditor.ExceptionListener exceptionListener = null;
    private String defaultFilePath = null;

    public CsvSchemaEditor() {
        super(null, true, false);
        this.registActionEx();
    }

    @Override
    public String getMsgType() {
        return "CSV";
    }

    @Override
    public String getMsgName() {
        return this.ps.getValue("name");
    }

    @Override
    public void close() {
        this.nameChangedListener = null;
        this.exceptionListener = null;
    }

    @Override
    protected void registContentsEditorPanel() {
        ContentsEditPanel panel = new CsvDeclPanel();
        panel.init(this);
        this.setContentsEditPanel(42, panel);
        panel = new FieldDeclPanel();
        panel.init(this);
        this.setContentsEditPanel(43, panel);
        String s = CsvSchemaEditor.getPackageName(DTDEditorPanel.class) + ".";
        this.setContentsEditPanel(8, s + "CommentDeclPanel");
        this.setContentsEditPanel(32, s + "DataTypeDeclPanel");
    }

    @Override
    protected void resetEditStatus() {
        DefaultMutableTreeNode selNode;
        if (this.status != 0) {
            this.status = 0;
            this.hasSetActionStatus = false;
        }
        if ((selNode = this.getSelectedTreeNode()) == null) {
            return;
        }
        if (!this.getContentsViewVisible()) {
            return;
        }
        DeclNodeData select = (DeclNodeData)selNode.getUserObject();
        if (select == null) {
            return;
        }
        DefaultMutableTreeNode parent = (DefaultMutableTreeNode)selNode.getParent();
        this.status = 288;
        if (select.getNodeType() != 42) {
            this.status = this.status | 0x400 | 0x800;
        }
        if (parent != null) {
            if (parent.getFirstChild() != selNode) {
                this.status |= 0x1000;
            }
            if (parent.getLastChild() != selNode) {
                this.status |= 0x2000;
            }
        }
        this.status |= 0x4000;
        this.status = !this.searchText.equals("") ? (this.status |= 0x8000) : (this.status ^= 0x8000);
        ((Action)this.actions.get(CMD_NEW_FIELD)).setEnabled((this.status & 0x100) != 0);
        ((Action)this.actions.get("COMMENT")).setEnabled((this.status & 0x20) != 0);
        ((Action)this.actions.get("NODECOPY")).setEnabled((this.status & 0x400) != 0);
        ((Action)this.actions.get("REMOVE")).setEnabled((this.status & 0x800) != 0);
        ((Action)this.actions.get("TOUP")).setEnabled((this.status & 0x1000) != 0);
        ((Action)this.actions.get("TODOWN")).setEnabled((this.status & 0x2000) != 0);
        ((Action)this.actions.get("FINDNODE")).setEnabled((this.status & 0x4000) != 0);
        ((Action)this.actions.get("REFINDNODE")).setEnabled((this.status & 0x8000) != 0);
        this.hasSetActionStatus = true;
        if (this.toolBar != null) {
            this.setToolbarStatus();
        }
        if (this.menu != null) {
            this.setMenuStatus();
        }
    }

    void setToolbarStatus() {
        int n = this.toolBar.getComponentCount();
        for (int i = 0; i < n; ++i) {
            Action a;
            Component c = this.toolBar.getComponent(i);
            String name2 = c.getName();
            if (name2 == null || (a = (Action)this.actions.get(name2)) == null) continue;
            c.setEnabled(a.isEnabled());
        }
    }

    void setMenuStatus() {
        int n = this.menu.getMenuComponentCount();
        for (int i = 0; i < n; ++i) {
            Action a;
            Component c = this.menu.getMenuComponent(i);
            String name2 = c.getName();
            if (name2 == null || (a = (Action)this.actions.get(name2)) == null) continue;
            c.setEnabled(a.isEnabled());
        }
    }

    @Override
    public void setNameChangedListener(SchemaEditor.NameChangedListener listener) {
        this.nameChangedListener = listener;
    }

    @Override
    public void setExceptionListener(SchemaEditor.ExceptionListener listener) {
        this.exceptionListener = listener;
    }

    @Override
    public void setDefaultFilePath(String path) {
        this.defaultFilePath = path;
    }

    void importSchema() {
        Properties ps;
        Frame f = this.getOwnerFrame();
        if (f == null) {
            return;
        }
        ImportCSVDialog in = new ImportCSVDialog(f, MessageException.getMessage(CMD_IMPORT_SCHEMA), this.defaultFilePath);
        Point p = f.getLocation();
        p.translate((f.getWidth() - in.getWidth()) / 2, (f.getHeight() - in.getHeight()) / 2);
        in.setLocation(p);
        try {
            ps = this.getProperties();
        }
        catch (Exception e) {
            ps = this.ps;
        }
        in.setEncoding(ps.getValue("encoding"));
        in.setVisible(true);
        String errMsg = null;
        try {
            CsvSchema schema = in.getCsvSchema();
            if (schema == null) {
                return;
            }
            String encoding = in.getEncoding();
            if (encoding != null) {
                ps.repleace("encoding", encoding);
            }
            this.load(null, ps, schema);
        }
        catch (DTDException e) {
            String systemId = e.getSystemId();
            errMsg = systemId != null ? systemId + "<" + e.getLineNumber() + "," + e.getColumnNumber() + "> :" + e.getMessage() : "<" + e.getLineNumber() + "," + e.getColumnNumber() + "> :" + e.getMessage();
        }
        catch (Exception e) {
            errMsg = e.getMessage();
        }
        this.changeContents();
        if (errMsg != null) {
            JOptionPane.showMessageDialog(this, errMsg);
        }
    }

    protected Frame getOwnerFrame() {
        Container parent;
        for (parent = this; parent != null && !(parent instanceof Frame); parent = parent.getParent()) {
        }
        if (parent != null) {
            return (Frame)parent;
        }
        return null;
    }

    public void addNewFieldDeclNode() {
        DefaultMutableTreeNode selNode = this.getSelectedTreeNode();
        if (selNode == null) {
            return;
        }
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.treeModel.getRoot();
        DeclNodeData select = (DeclNodeData)selNode.getUserObject();
        if (select == null) {
            return;
        }
        String name2 = this.getNewDefaultNodeName("New_Field_");
        int type = select.getNodeType();
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(new FieldDeclNodeData(name2));
        this.addToDefaultNode(node);
        if (type == 42) {
            root.add(node);
            this.treeModel.nodeStructureChanged(root);
        } else {
            if (selNode.getParent() != root) {
                return;
            }
            int pos = this.treeModel.getIndexOfChild(root, selNode);
            this.treeModel.insertNodeInto(node, root, pos + 1);
        }
        this.setSelectedTreeNode(node);
        this.changeContents();
    }

    @Override
    protected String getNewDefaultNodeName(int type) {
        if (type == 43) {
            String basename = "New_Field_";
            return this.getNewDefaultNodeName(basename);
        }
        return super.getNewDefaultNodeName(type);
    }

    protected void registActionEx() {
        AbstractAction a = new AbstractAction(CMD_NEW_FIELD, ImageLoader.load("field.gif", CMD_NEW_FIELD)){

            @Override
            public void actionPerformed(ActionEvent e) {
                CsvSchemaEditor.this.addNewFieldDeclNode();
            }
        };
        String s = MessageException.getMessage("CMD_NEW_FIELD");
        a.putValue("ShortDescription", s);
        this.actions.put(CMD_NEW_FIELD, a);
        s = MessageException.getMessage(CMD_IMPORT_SCHEMA);
        a = new AbstractAction(CMD_IMPORT_SCHEMA){

            @Override
            public void actionPerformed(ActionEvent e) {
                CsvSchemaEditor.this.importSchema();
            }
        };
        a.setEnabled(true);
        a.putValue("ShortDescription", s);
        this.actions.put(CMD_IMPORT_SCHEMA, a);
    }

    @Override
    public Component getEditorPanel() {
        return this;
    }

    @Override
    public JToolBar getToolBar() {
        if (this.toolBar == null) {
            this.toolBar = this.createToolbar(toolBarNames);
            this.setToolbarStatus();
        }
        return this.toolBar;
    }

    @Override
    public JMenu getMenu() {
        if (this.menu == null) {
            this.menu = this.creatMenu(editMenus);
            this.menu.addMenuListener(new MenuListener(){

                @Override
                public void menuSelected(MenuEvent e) {
                    CsvSchemaEditor.this.setMenuStatus();
                }

                @Override
                public void menuDeselected(MenuEvent e) {
                }

                @Override
                public void menuCanceled(MenuEvent e) {
                }
            });
            this.setMenuStatus();
        }
        return this.menu;
    }

    @Override
    public Component getPopMenuComponent() {
        return this.tree;
    }

    @Override
    public Properties getProperties() throws MessageException {
        try {
            DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.tree.getModel().getRoot();
            CsvDeclNodeData rootdata = (CsvDeclNodeData)root.getUserObject();
            return rootdata.getProperties();
        }
        catch (Exception e) {
            throw new MessageException(null, this.getMsgName(), this.getMsgName(), 0, 0, e);
        }
    }

    @Override
    public void load(Properties params, Properties ps, Object schema) throws MessageException {
        this.ps = ps.cloneProperties();
        this.csvSchema = (CsvSchema)schema;
        CsvDeclNodeData rootdata = new CsvDeclNodeData(this.ps);
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(rootdata);
        this.treeModel = new DefaultTreeModel(root);
        this.defaultNodes.removeAllElements();
        if (this.csvSchema == null) {
            this.treeModel.nodeStructureChanged(root);
            this.tree.expandRow(0);
            this.tree.setSelectionRow(0);
            this.dtdChanged = false;
            return;
        }
        DeclNodeList nodes = this.csvSchema.getAllDeclNode();
        int n = nodes.size();
        for (int i = 0; i < n; ++i) {
            DeclNode node = nodes.elementAt(i);
            int nodetype = node.getNodeType();
            DefaultMutableTreeNode treeNode = null;
            switch (nodetype) {
                case 43: {
                    DeclNodeData userdata = new FieldDeclNodeData((FieldDecl)node);
                    ((DeclNodeData)userdata).setDataTypeDecl(node.getDataTypeDecl());
                    treeNode = new DefaultMutableTreeNode(userdata);
                    break;
                }
                case 8: {
                    String s = ((CommentDecl)node).getComment();
                    if (s == null) {
                        s = "";
                    }
                    DeclNodeData userdata = new DeclNodeData(8, "COMMENT", s);
                    treeNode = new DefaultMutableTreeNode(userdata);
                }
            }
            if (treeNode == null) continue;
            root.add(treeNode);
        }
        this.tree.setModel(this.treeModel);
        this.tree.expandRow(0);
        this.tree.setSelectionRow(0);
        this.setStructViewVisible(true);
        this.setContentsViewVisible(true);
        this.dtdChanged = false;
        this.resetEditStatus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getSchema() throws MessageException {
        if (this.csvSchema != null && !this.isChanged()) {
            return this.csvSchema;
        }
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.tree.getModel().getRoot();
        CsvDeclNodeData rootdata = (CsvDeclNodeData)root.getUserObject();
        this.csvSchema = new CsvSchema();
        DefaultMutableTreeNode currentNode = null;
        try {
            currentNode = (DefaultMutableTreeNode)root.getFirstChild();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            while (currentNode != null) {
                DeclNodeData userobj = (DeclNodeData)currentNode.getUserObject();
                int nodetype = userobj.getNodeType();
                DeclNode declnode = null;
                switch (nodetype) {
                    case 43: {
                        declnode = new FieldDecl((DeclNode)this.csvSchema, userobj.getNodeName());
                        declnode.setDataTypeDecl(userobj.getDataTypeDecl());
                        break;
                    }
                    case 8: {
                        declnode = new CommentDeclNode(this.csvSchema, (String)userobj.getNodeValue());
                    }
                }
                if (declnode != null) {
                    this.csvSchema.appendChild(declnode);
                } else {
                    MessageException.error("INVALID_DECL", new Object[]{userobj.getNodeTypeNameDes(), userobj.getNodeName()}, null);
                }
                currentNode = currentNode.getNextSibling();
            }
        }
        finally {
            this.lastErrorNode = currentNode;
        }
        return this.csvSchema;
    }

    boolean msgNameChanged(String oldName, String newName) {
        if (this.nameChangedListener != null) {
            return this.nameChangedListener.nameChanged(oldName, newName);
        }
        return true;
    }

    private JToolBar createToolbar(String[] names) {
        JToolBar toolbar = new JToolBar();
        toolbar.setMargin(new Insets(0, 0, 0, 0));
        toolbar.setFloatable(false);
        int n = names.length;
        for (int i = 0; i < n; ++i) {
            if (names[i].equals("-")) {
                toolbar.addSeparator();
                continue;
            }
            Action act = (Action)this.actions.get(names[i]);
            if (act == null) continue;
            ImageIcon icon = (ImageIcon)act.getValue("SmallIcon");
            JButton bt = new JButton((Icon)icon){

                @Override
                public float getAlignmentY() {
                    return 0.5f;
                }
            };
            bt.setRequestFocusEnabled(false);
            bt.setMargin(new Insets(1, 1, 1, 1));
            bt.setName(names[i]);
            bt.setToolTipText((String)act.getValue("ShortDescription"));
            bt.addActionListener(act);
            toolbar.add(bt);
        }
        return toolbar;
    }

    private JMenu creatMenu(String[][] items) {
        String s = MessageException.msgCatalog.getMessage("MENU_EDIT");
        if (s.indexOf("E") < 0) {
            s = s + "(E)";
        }
        JMenu menu = new JMenu(s);
        menu.setMnemonic('E');
        Font font1 = menu.getFont();
        Font font = new Font(font1.getName(), 0, 12);
        menu.setFont(font);
        for (int i = 0; i < items.length; ++i) {
            String itemname = items[i][0];
            if (itemname.equals("-")) {
                menu.addSeparator();
                continue;
            }
            Action act = (Action)this.actions.get(itemname);
            String dec = (String)act.getValue("ShortDescription");
            if (items[i][1] != null && dec.indexOf(items[i][1]) < 0) {
                dec = dec + "(" + items[i][1] + ")";
            }
            JMenuItem menuItem = items[i][2] == null ? new JMenuItem(dec) : new JCheckBoxMenuItem(dec);
            menuItem.setName(itemname);
            menu.add(menuItem);
            ImageIcon icon = (ImageIcon)act.getValue("SmallIcon");
            if (icon != null) {
                menuItem.setIcon(icon);
                menuItem.setHorizontalTextPosition(4);
            }
            menuItem.addActionListener(act);
            if (items[i][1] != null) {
                menuItem.setMnemonic(items[i][1].charAt(0));
            }
            if (items[i][2] != null) {
                menuItem.setSelected(items[i][2].equals("Y"));
            }
            menuItem.setFont(font);
            if (items[i][3] == null) continue;
            try {
                String sk = items[i][3];
                int k = sk.indexOf(":");
                if (k >= 0) {
                    int mask = Integer.parseInt(sk.substring(0, k));
                    int keyid = Integer.parseInt(sk.substring(k + 1));
                    menuItem.setAccelerator(KeyStroke.getKeyStroke(keyid, mask));
                    continue;
                }
                int keyid = Integer.parseInt(sk);
                menuItem.setAccelerator(KeyStroke.getKeyStroke(keyid, 0));
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return menu;
    }

    public static class FieldDeclPanel
    extends ContentsEditPanel {
        protected TextFieldEx nameField;
        protected ResultPanel result;
        protected ComboTextFieldEx typeOption;
        protected TextFieldEx sizeField;
        protected TextFieldEx fillField;
        protected TextFieldEx formatField;
        protected TextFieldEx valueField;
        protected DataTypeDecl dtDecl;

        @Override
        public void init(DTDEditorPanel parentPanel) {
            super.init(parentPanel);
            GridBagConstraints gc = new GridBagConstraints();
            gc.gridy = 0;
            gc.gridx = 0;
            gc.fill = 1;
            gc.weightx = 1.0;
            gc.insets = new Insets(2, 2, 2, 2);
            this.setLayout(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.gridy = 0;
            c.gridx = 0;
            c.gridheight = 1;
            c.gridwidth = 1;
            c.insets = new Insets(2, 2, 2, 2);
            c.fill = 1;
            JPanel tp = new JPanel();
            tp.setLayout(new GridBagLayout());
            tp.setOpaque(true);
            tp.setBorder(BorderFactory.createTitledBorder(MessageException.getMessage("FIELD_DECL")));
            JLabel label = new JLabel(ContentsEditPanel.getMessage("LAB_NAME"));
            tp.add((Component)label, c);
            ++c.gridx;
            c.weightx = 1.0;
            this.nameField = new TextFieldEx(10){

                @Override
                public boolean valueChanged(Object source, String value) {
                    this.nameChanged(value.trim());
                    return true;
                }
            };
            tp.add((Component)this.nameField, c);
            this.add((Component)tp, gc);
            ++gc.gridy;
            tp = this.createDataTypePanel();
            this.add((Component)tp, gc);
            ++gc.gridy;
            gc.gridwidth = 0;
            gc.gridheight = 0;
            gc.weighty = 1.0;
            gc.weightx = 1.0;
            this.result = new ResultPanel(parentPanel);
            this.add((Component)this.result, gc);
        }

        JPanel createDataTypePanel() {
            JPanel tp = new JPanel();
            GridBagConstraints c = new GridBagConstraints();
            c.gridy = 0;
            c.gridx = 0;
            c.gridheight = 1;
            c.gridwidth = 1;
            c.insets = new Insets(2, 2, 2, 2);
            c.fill = 1;
            tp.setLayout(new GridBagLayout());
            tp.setOpaque(true);
            tp.setBorder(BorderFactory.createTitledBorder(FieldDeclPanel.getMessage("TL_DATATYPE")));
            JLabel label = new JLabel(FieldDeclPanel.getMessage("LAB_DATATYPE"));
            tp.add((Component)label, c);
            ++c.gridx;
            c.weightx = 1.0;
            String[] typenames = new String[]{XData.getTypeName(1), XData.getTypeName(2), XData.getTypeName(3), XData.getTypeName(4), XData.getTypeName(5), XData.getTypeName(6), XData.getTypeName(7)};
            this.typeOption = new ComboTextFieldEx(false){

                @Override
                public boolean valueChanged(Object source, String value) {
                    this.typeOptionChanged();
                    return true;
                }
            };
            this.typeOption.setEnabledEvent(false);
            this.typeOption.setList(typenames);
            this.typeOption.setEnabledEvent(true);
            tp.add((Component)this.typeOption, c);
            c.gridx = 0;
            ++c.gridy;
            c.weightx = 0.0;
            label = new JLabel(FieldDeclPanel.getMessage("LAB_DATASIZE"));
            tp.add((Component)label, c);
            ++c.gridx;
            c.weightx = 1.0;
            this.sizeField = new TextFieldEx(10){

                @Override
                public boolean valueChanged(Object source, String value) {
                    this.sizeChanged(value.trim());
                    return true;
                }
            };
            tp.add((Component)this.sizeField, c);
            c.gridx = 0;
            ++c.gridy;
            c.weightx = 0.0;
            label = new JLabel(FieldDeclPanel.getMessage("LAB_DATAFILL"));
            tp.add((Component)label, c);
            ++c.gridx;
            c.weightx = 1.0;
            this.fillField = new TextFieldEx(10){

                @Override
                public boolean valueChanged(Object source, String value) {
                    this.fillChanged(value.trim());
                    return true;
                }
            };
            tp.add((Component)this.fillField, c);
            c.gridx = 0;
            ++c.gridy;
            c.weightx = 0.0;
            label = new JLabel(FieldDeclPanel.getMessage("LAB_DATAFORMAT"));
            tp.add((Component)label, c);
            ++c.gridx;
            c.weightx = 1.0;
            this.formatField = new TextFieldEx(10){

                @Override
                public boolean valueChanged(Object source, String value) {
                    this.formatChanged(value.trim());
                    return true;
                }
            };
            tp.add((Component)this.formatField, c);
            c.gridx = 0;
            ++c.gridy;
            c.weightx = 0.0;
            label = new JLabel(FieldDeclPanel.getMessage("LAB_DATAVALUE"));
            tp.add((Component)label, c);
            ++c.gridx;
            c.weightx = 1.0;
            this.valueField = new TextFieldEx(10){

                @Override
                public boolean valueChanged(Object source, String value) {
                    this.defaultChanged(value.trim());
                    return true;
                }
            };
            tp.add((Component)this.valueField, c);
            return tp;
        }

        void typeOptionChanged() {
            this.dtDecl.type = this.typeOption.getSelectedIndex() + 1;
            this.setDataTypeDecl();
        }

        void sizeChanged(String value) {
            int size = -1;
            if (value.length() == 0) {
                size = 0;
            } else {
                try {
                    size = Integer.parseInt(value);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (size == -1) {
                JOptionPane.showMessageDialog(this.parentPanel, FieldDeclPanel.getMessage("INVALID_SIZE"));
                this.sizeField.setText(String.valueOf(this.dtDecl.size));
                return;
            }
            if (size != this.dtDecl.size) {
                this.dtDecl.size = size;
                this.setDataTypeDecl();
            }
        }

        void fillChanged(String value) {
            char fill;
            if (value.length() == 0) {
                fill = '\u0000';
            } else {
                value = Properties.parseSpecialChar(value);
                fill = value.charAt(0);
            }
            if (fill != this.dtDecl.fillchar) {
                this.dtDecl.fillchar = fill;
                this.setDataTypeDecl();
            }
        }

        void formatChanged(String value) {
            if (value != null && ((value = Properties.parseSpecialChar(value)).length() == 0 || value.equals("null"))) {
                value = null;
            }
            if (value != this.dtDecl.format) {
                this.dtDecl.format = value;
                this.setDataTypeDecl();
            }
        }

        void defaultChanged(String value) {
            if (value != null) {
                value = Properties.parseSpecialChar(value);
            }
            if (value != this.dtDecl.value) {
                this.dtDecl.value = value;
                this.setDataTypeDecl();
            }
        }

        void setDataTypeDecl() {
            DeclNodeData data = (DeclNodeData)this.node.getUserObject();
            data.setDataTypeDecl(this.dtDecl);
            this.contentsChanged();
            this.viewResult();
        }

        void nameChanged(String value) {
            FieldDeclNodeData data = (FieldDeclNodeData)this.node.getUserObject();
            String s = data.getNodeName();
            if (!s.equals(value)) {
                if (!FieldDeclPanel.isName(value)) {
                    JOptionPane.showMessageDialog(this.parentPanel, FieldDeclPanel.getMessage("INVALID_NAME", value));
                    this.nameField.setText(s);
                    return;
                }
                if (this.parentPanel.hasNameWithoutSelect(value)) {
                    JOptionPane.showMessageDialog(this.parentPanel, ContentsEditPanel.getMessage("DOUBLE_NAME", new Object[]{value}));
                    this.nameField.setText(s);
                    return;
                }
                this.nameChangedTo(value);
                this.viewResult();
            }
        }

        void viewResult() {
            String rs1;
            FieldDeclNodeData data = (FieldDeclNodeData)this.node.getUserObject();
            FieldDecl declnode = new FieldDecl(null, data.getNodeName());
            String rs = declnode == null ? "" : declnode.toString();
            String att = "field=\"" + data.getNodeName() + "\"";
            String string2 = rs1 = this.dtDecl == null ? "" : this.dtDecl.getXML(att);
            if (rs1 != null) {
                rs = rs + "\n---------\n" + rs1;
            }
            this.result.setText(rs);
        }

        @Override
        public void setTreeNode(DefaultMutableTreeNode node) {
            this.node = node;
            FieldDeclNodeData data = (FieldDeclNodeData)node.getUserObject();
            this.nameField.setText(data.getNodeName());
            this.dtDecl = data.getDataTypeDecl();
            if (this.dtDecl == null) {
                this.dtDecl = new DataTypeDecl();
            }
            this.typeOption.setEnabledEvent(false);
            this.typeOption.setSelectedIndex(this.dtDecl.type - 1);
            this.typeOption.setEnabledEvent(true);
            this.sizeField.setText(String.valueOf(this.dtDecl.size));
            if (this.dtDecl.fillchar == '\u0000') {
                this.fillField.setText("");
            } else {
                String value = String.valueOf(this.dtDecl.fillchar);
                this.fillField.setText(Properties.makeSpecialChar(value));
            }
            if (this.dtDecl.format == null) {
                this.formatField.setText("");
            } else {
                this.formatField.setText(Properties.makeSpecialChar(this.dtDecl.format));
            }
            if (this.dtDecl.value == null) {
                this.valueField.setText("");
            } else {
                this.valueField.setText(Properties.makeSpecialChar(this.dtDecl.value));
            }
            this.viewResult();
        }

        static boolean isName(String s) {
            if (s == null) {
                return false;
            }
            int n = s.length();
            if (n < 1) {
                return false;
            }
            char c = s.charAt(0);
            if (!Character.isLetter(c)) {
                return false;
            }
            for (int i = 1; i < n; ++i) {
                c = s.charAt(i);
                if (Character.isLetterOrDigit(c) || c == '_') continue;
                return false;
            }
            return true;
        }
    }

    public static class CsvDeclPanel
    extends ContentsEditPanel {
        ComboTextFieldEx dirField;
        JCheckBox withdtd;
        TextFieldEx urlField;
        ComboTextFieldEx splitField;
        ComboTextFieldEx quoteField;
        protected TextFieldEx nameField;
        protected ComboTextFieldEx encodingField;
        protected ResultPanel result;
        protected JPanel propertyPanel;
        static String NON = DTDEditorPanel.msgCatalog.getMessage("UNDEF_MARK");
        static String[] ENCODINGS;
        String[] SPLITS = new String[]{NON, "Space&Tab", ";", ":", ",", "|"};
        String[] QUOTES = new String[]{NON, "\"", "'"};

        @Override
        public void init(DTDEditorPanel parentPanel) {
            this.parentPanel = parentPanel;
            GridBagConstraints gc = new GridBagConstraints();
            gc.gridy = 0;
            gc.gridx = 0;
            gc.fill = 1;
            gc.weightx = 1.0;
            gc.insets = new Insets(2, 2, 2, 2);
            this.setLayout(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.gridy = 0;
            c.gridx = 0;
            c.gridheight = 1;
            c.gridwidth = 1;
            c.insets = new Insets(2, 2, 2, 2);
            c.fill = 1;
            JPanel tp = new JPanel();
            tp.setLayout(new GridBagLayout());
            tp.setOpaque(true);
            tp.setBorder(BorderFactory.createTitledBorder(MessageException.getMessage("CSV_DECL")));
            JLabel label = new JLabel(MessageException.getMessage("LAB_NAME"));
            tp.add((Component)label, c);
            ++c.gridx;
            c.weightx = 1.0;
            this.nameField = new TextFieldEx(10){

                @Override
                public boolean valueChanged(Object source, String value) {
                    this.nameChanged(value.trim());
                    return true;
                }
            };
            tp.add((Component)this.nameField, c);
            this.add((Component)tp, gc);
            ++gc.gridy;
            this.propertyPanel = new JPanel();
            this.propertyPanel.setLayout(new GridBagLayout());
            this.propertyPanel.setOpaque(true);
            this.propertyPanel.setBorder(BorderFactory.createTitledBorder(ContentsEditPanel.getMessage("TL_PROPERTY")));
            c.gridy = 0;
            c.gridx = 0;
            c.weightx = 0.0;
            label = new JLabel(CsvDeclPanel.getMessage("LAB_ENCODING"));
            this.propertyPanel.add((Component)label, c);
            ++c.gridx;
            c.weightx = 1.0;
            this.encodingField = new ComboTextFieldEx(false){

                @Override
                public boolean valueChanged(Object source, String value) {
                    this.propertyChanged("encoding", value);
                    return true;
                }
            };
            this.encodingField.setEnabledEvent(false);
            this.encodingField.setList(ENCODINGS);
            this.encodingField.setEnabledEvent(true);
            this.propertyPanel.add((Component)this.encodingField, c);
            c.gridx = 0;
            ++c.gridy;
            c.weightx = 0.0;
            label = new JLabel(MessageException.getMessage("LAB_DIRECTION"));
            this.propertyPanel.add((Component)label, c);
            ++c.gridx;
            c.weightx = 1.0;
            this.dirField = new ComboTextFieldEx(false){

                @Override
                public boolean valueChanged(Object source, String value) {
                    this.propertyChanged("direction", value);
                    return true;
                }
            };
            this.dirField.addItem("INPUT");
            this.dirField.addItem("OUTPUT");
            this.dirField.addItem("APPEND");
            this.propertyPanel.add((Component)this.dirField, c);
            c.gridx = 0;
            ++c.gridy;
            c.weightx = 0.0;
            label = new JLabel(MessageException.getMessage("LAB_DOC_URL"));
            this.propertyPanel.add((Component)label, c);
            ++c.gridx;
            c.weightx = 1.0;
            this.urlField = new TextFieldEx(){

                @Override
                public boolean valueChanged(Object Source2, String value) {
                    this.propertyChanged("url", value);
                    return true;
                }
            };
            this.propertyPanel.add((Component)this.urlField, c);
            c.gridx = 1;
            ++c.gridy;
            c.weightx = 1.0;
            this.withdtd = new JCheckBox(MessageException.getMessage("LAB_WITHHEAD"));
            this.withdtd.setFont(this.getDefaultFont());
            this.withdtd.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String value = withdtd.isSelected() ? "YES" : "NO";
                    this.propertyChanged("withhead", value);
                }
            });
            this.propertyPanel.add((Component)this.withdtd, c);
            this.add((Component)this.propertyPanel, gc);
            ++gc.gridy;
            c.gridx = 0;
            ++c.gridy;
            c.weightx = 0.0;
            label = new JLabel(MessageException.getMessage("LAB_SPLIT"));
            this.propertyPanel.add((Component)label, c);
            ++c.gridx;
            c.weightx = 1.0;
            this.splitField = new ComboTextFieldEx(false){

                @Override
                public boolean valueChanged(Object source, String value) {
                    if (value.equals("Space&Tab")) {
                        value = "\" \"";
                    }
                    this.propertyChanged("split", value);
                    return true;
                }
            };
            this.splitField.setEnabledEvent(false);
            this.splitField.setList(this.SPLITS);
            this.splitField.setEnabledEvent(true);
            this.propertyPanel.add((Component)this.splitField, c);
            c.gridx = 0;
            ++c.gridy;
            c.weightx = 0.0;
            label = new JLabel(MessageException.getMessage("LAB_QUOTE"));
            this.propertyPanel.add((Component)label, c);
            ++c.gridx;
            c.weightx = 1.0;
            this.quoteField = new ComboTextFieldEx(false){

                @Override
                public boolean valueChanged(Object source, String value) {
                    this.propertyChanged("quote", value);
                    return true;
                }
            };
            this.quoteField.setEnabledEvent(false);
            this.quoteField.setList(this.QUOTES);
            this.quoteField.setEnabledEvent(true);
            this.propertyPanel.add((Component)this.quoteField, c);
            gc.gridwidth = 0;
            gc.gridheight = 0;
            gc.weighty = 1.0;
            gc.weightx = 1.0;
            this.result = new ResultPanel(parentPanel);
            this.add((Component)this.result, gc);
        }

        protected void nameChanged(String value) {
            CsvDeclNodeData data = (CsvDeclNodeData)this.node.getUserObject();
            String s = data.getNodeName();
            if (s.equals(value)) {
                return;
            }
            boolean b = this.isName(value);
            if (!b || ((CsvSchemaEditor)this.parentPanel).msgNameChanged(s, value)) {
                if (!b) {
                    JOptionPane.showMessageDialog(this.parentPanel, CsvDeclPanel.getMessage("INVALID_NAME", value));
                    this.nameField.setText(s);
                    return;
                }
                data.setNodeName(value);
                Properties ps = data.getProperties();
                ps.repleace("name", value);
                JTree tree = this.parentPanel.getStructTree();
                DefaultTreeModel treeModel = (DefaultTreeModel)tree.getModel();
                this.nodeStructureChanged();
                tree.setSelectionRow(0);
                this.contentsChanged();
            }
        }

        protected void propertyChanged(String field, String value) {
            CsvDeclNodeData data = (CsvDeclNodeData)this.node.getUserObject();
            Properties ps = data.getProperties();
            if (value != null && value.length() == 0) {
                value = null;
            } else if (NON.equals(value)) {
                value = null;
            }
            ps.repleace(field, value);
            this.result.setText(ps.toString("\n", false));
            this.contentsChanged();
        }

        @Override
        public void setTreeNode(DefaultMutableTreeNode node) {
            super.setTreeNode(node);
            Object obj = node.getUserObject();
            CsvDeclNodeData data = (CsvDeclNodeData)obj;
            this.nameField.setText(data.getNodeName());
            Properties ps = data.getProperties();
            if (ps == null) {
                return;
            }
            String value = ps.getValue("encoding");
            this.encodingField.setEnabledEvent(false);
            if (value == null || value.length() == 0) {
                this.encodingField.setSelectedIndex(0);
            } else {
                int selectedIndex = -1;
                int n = ENCODINGS.length;
                for (int i = 0; i < n; ++i) {
                    if (!value.equalsIgnoreCase(ENCODINGS[i])) continue;
                    this.encodingField.setSelectedIndex(i);
                    selectedIndex = i;
                    break;
                }
                if (selectedIndex < 0) {
                    this.encodingField.setSelectedItem(value);
                }
            }
            this.encodingField.setEnabledEvent(true);
            value = ps.getValue("direction");
            this.dirField.setEnabledEvent(false);
            if (value == null || value.length() == 0) {
                this.dirField.setSelectedIndex(0);
            } else {
                this.dirField.setSelectedItem(value);
            }
            this.dirField.setEnabledEvent(true);
            value = ps.getValue("url");
            if (value == null) {
                this.urlField.setText("");
            } else {
                this.urlField.setText(value);
            }
            value = ps.getValue("withhead");
            if (value == null) {
                this.withdtd.setSelected(false);
            } else {
                this.withdtd.setSelected(value.equalsIgnoreCase("YES"));
            }
            value = ps.getValue("split");
            this.splitField.setEnabledEvent(false);
            if (value == null || value.length() == 0) {
                this.splitField.setSelectedIndex(0);
            } else {
                if (value.startsWith("\"") && value.endsWith("\"") && value.length() > 1) {
                    int len = value.length();
                    value = value.substring(1, len - 1);
                }
                if (value.equals(" ")) {
                    this.splitField.setSelectedIndex(1);
                } else {
                    int k = 0;
                    for (int i = 2; i < this.SPLITS.length; ++i) {
                        if (!value.equals(this.SPLITS[i])) continue;
                        k = i;
                        break;
                    }
                    this.splitField.setSelectedIndex(k);
                }
            }
            this.splitField.setEnabledEvent(true);
            value = ps.getValue("quote");
            this.quoteField.setEnabledEvent(false);
            if (value == null || value.length() == 0) {
                this.quoteField.setSelectedIndex(0);
            } else {
                switch (value.charAt(0)) {
                    case '\"': {
                        this.quoteField.setSelectedIndex(1);
                        break;
                    }
                    case '\'': {
                        this.quoteField.setSelectedIndex(2);
                        break;
                    }
                    default: {
                        this.quoteField.setSelectedIndex(0);
                    }
                }
            }
            this.quoteField.setEnabledEvent(true);
            this.result.setText(ps.toString("\n", false));
        }

        boolean isName(String s) {
            if (s == null) {
                return false;
            }
            int n = s.length();
            if (n < 1) {
                return false;
            }
            char c = s.charAt(0);
            if (!Character.isLetter(c)) {
                return false;
            }
            for (int i = 1; i < n; ++i) {
                c = s.charAt(i);
                if (Character.isLetterOrDigit(c) || c == '_') continue;
                return false;
            }
            return true;
        }

        static {
            String[] codes = MIME2Java.getAllStandardEncoding();
            ENCODINGS = new String[codes.length + 1];
            CsvDeclPanel.ENCODINGS[0] = NON;
            System.arraycopy(codes, 0, ENCODINGS, 1, codes.length);
        }
    }

    public static class FieldDeclNodeData
    extends DeclNodeData {
        public FieldDeclNodeData(String name2) {
            super(43, name2);
        }

        public FieldDeclNodeData(String name2, DataTypeDecl dt) {
            super(43, name2);
            this.nodevalue = dt;
        }

        public FieldDeclNodeData(FieldDecl decl) {
            super(43, decl.getNodeName());
            this.nodevalue = decl.getDataTypeDecl();
        }

        public FieldDecl getDeclMode(DeclNode owner) {
            FieldDecl fd = new FieldDecl(owner, this.getNodeName());
            DataTypeDecl dt = (DataTypeDecl)this.nodevalue;
            if (dt != null && dt.isDefalut()) {
                dt = null;
            }
            fd.setDataTypeDecl(dt);
            return fd;
        }

        @Override
        protected Object clone() {
            FieldDeclNodeData data = new FieldDeclNodeData(this.nodename);
            if (this.nodevalue != null) {
                data.nodevalue = ((DataTypeDecl)this.nodevalue).clone();
            }
            return data;
        }

        @Override
        public String getNodeTypeNameDes() {
            return MessageException.getMessage("FIELD_DECL");
        }

        @Override
        public String getNodeTypeName() {
            return "Field";
        }

        @Override
        public DataTypeDecl getDataTypeDecl() {
            return (DataTypeDecl)this.nodevalue;
        }

        @Override
        public void setDataTypeDecl(DataTypeDecl dtDecl) {
            this.nodevalue = dtDecl;
        }

        @Override
        public ImageIcon getImageIcon() {
            return ImageLoader.load("field.gif", "Field");
        }
    }

    public static class CsvDeclNodeData
    extends DeclNodeData {
        CsvDeclNodeData(Properties ps) {
            super(42, ps.getValue("name"), ps);
        }

        Properties getProperties() {
            return (Properties)this.getNodeValue();
        }
    }
}

