/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.msg.csv;

import com.argo21.common.gui.GuiUtils;
import com.argo21.common.gui.ImageLoader;
import com.argo21.common.io.XReader;
import com.argo21.common.util.Properties;
import com.argo21.msg.MessageException;
import com.argo21.msg.SchemaViewer;
import com.argo21.msg.csv.CsvSchema;
import com.argo21.msg.csv.FieldDecl;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.Icon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import org.xml.sax.SAXException;

public class CsvSchemaViewer
extends JTree
implements SchemaViewer {
    public static Color SelectedBackgroundColor = UIManager.getColor("Tree.selectionBackground");
    private Font defaultFont;
    private CsvSchema schema = null;
    private DefaultTreeModel treeModel = null;
    private String msgname;

    public CsvSchemaViewer(CsvSchema schema) {
        this();
        this.setSchema(schema);
    }

    public CsvSchemaViewer() {
        try {
            this.defaultFont = new Font("Dialog", 0, 12);
        }
        catch (Exception exception) {
            // empty catch block
        }
        DefaultMutableTreeNode root = new DefaultMutableTreeNode("");
        this.treeModel = new DefaultTreeModel(root);
        this.setModel(this.treeModel);
        this.setCellRenderer(new MyTreeCellRenderer());
        this.getSelectionModel().setSelectionMode(1);
        GuiUtils.setLookAndFeel(GuiUtils.lookAndFeelClassName, this);
    }

    @Override
    public Component getDragComponent() {
        return this;
    }

    @Override
    public String getSelectedText() {
        return this.getAbsolutePathOfSelect();
    }

    @Override
    public boolean dragStart(Component source, int x, int y) {
        TreePath path = this.getClosestPathForLocation(x, y);
        if (path == null) {
            return false;
        }
        this.setSelectionPath(path);
        return this.canDragAndDrop(path);
    }

    @Override
    public boolean dragOver(Component source, int x, int y, String dragText) {
        if (source == this) {
            return false;
        }
        TreePath path = this.getClosestPathForLocation(x, y);
        if (path == null) {
            return false;
        }
        this.setSelectionPath(path);
        return this.canDragAndDrop(path);
    }

    @Override
    public boolean drop(Component source, int x, int y, String dragText) {
        if (source == this) {
            return false;
        }
        TreePath path = this.getClosestPathForLocation(x, y);
        if (path == null) {
            return false;
        }
        this.setSelectionPath(path);
        return this.canDragAndDrop(path);
    }

    private boolean canDragAndDrop(TreePath path) {
        DefaultMutableTreeNode currentNode = (DefaultMutableTreeNode)path.getLastPathComponent();
        if (this.schema == null) {
            return false;
        }
        return this.schema.getFieldDecl(currentNode.getUserObject().toString()) != null;
    }

    private String getAbsolutePathOfSelect() {
        if (this.schema == null) {
            return null;
        }
        TreePath sel = this.getSelectionPath();
        if (sel == null) {
            return null;
        }
        DefaultMutableTreeNode selectedNode = (DefaultMutableTreeNode)sel.getLastPathComponent();
        if (this.schema.getFieldDecl(selectedNode.getUserObject().toString()) == null) {
            return null;
        }
        return this.msgname + "/" + selectedNode.getUserObject() + "[*]";
    }

    @Override
    public String getMsgName() {
        return this.msgname;
    }

    @Override
    public String getMsgType() {
        return "CSV";
    }

    @Override
    public Component getViewer() {
        return this;
    }

    @Override
    public void load(Properties ps, Object schema) throws SAXException {
        this.msgname = ps.getValue("name");
        this.setSchema((CsvSchema)schema);
    }

    public void setSchema(CsvSchema schema) {
        this.schema = schema;
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.getModel().getRoot();
        Object rootName = null;
        root.removeAllChildren();
        if (schema != null) {
            FieldDecl[] field = schema.getFieldDecls();
            int fieldNum = field.length;
            for (int i = 0; i < fieldNum; ++i) {
                DefaultMutableTreeNode fieldNode = new DefaultMutableTreeNode(field[i].getNodeName());
                root.add(fieldNode);
            }
        } else {
            this.treeModel.nodeStructureChanged(root);
            this.setSelectionRow(0);
            return;
        }
        this.treeModel.nodeStructureChanged(root);
    }

    public static void main(String[] args) {
        String contents = "<!FIELD \u767a\u6ce8\u62c5\u5f53>\r\n<!FIELD \u767a\u6ce8\u756a\u53f7>\r\n<!FIELD \u5546\u54c1\u30b3\u30fc\u30c9>\r\n<!FIELD \u5546\u54c1\u540d>\r\n<!FIELD \u5358\u4fa1>\r\n<!FIELD \u6570\u91cf>\r\n<!FIELD \u65e5\u4ed8>\r\n\r\n<DATA field=\"\u5546\u54c1\u30b3\u30fc\u30c9\" type=\"int\">0</DATA>\r\n<DATA field=\"\u6570\u91cf\" type=\"int\">0</DATA>\r\n<DATA field=\"\u5358\u4fa1\" type=\"int\">0</DATA>\r\n<DATA field=\"\u65e5\u4ed8\" type=\"Date\" format=\"yyyy/MM/dd HH:mm:ss\"></DATA>\r\n";
        XReader xreader = XReader.createReader(new String(contents).toCharArray(), null);
        CsvSchema testSchema = new CsvSchema();
        try {
            testSchema.parseSchemaDecl(xreader);
            CsvSchemaViewer csvViewer = new CsvSchemaViewer(testSchema);
            JFrame testFrame = new JFrame();
            testFrame.setSize(new Dimension(400, 400));
            testFrame.getContentPane().setLayout(new BorderLayout());
            JScrollPane scPane = new JScrollPane();
            scPane.getViewport().add(csvViewer);
            testFrame.getContentPane().add("Center", scPane);
            testFrame.setVisible(true);
            testFrame.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent event) {
                    System.exit(0);
                }
            });
        }
        catch (MessageException e) {
            System.out.println(e);
        }
    }

    class MyTreeCellRenderer
    extends JLabel
    implements TreeCellRenderer {
        protected boolean selected;

        MyTreeCellRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            String stringValue = tree.convertValueToText(value, selected, expanded, leaf, row, hasFocus);
            this.setText(stringValue);
            this.setToolTipText(stringValue);
            if (CsvSchemaViewer.this.schema != null && CsvSchemaViewer.this.schema.getFieldDecl(stringValue) != null) {
                this.setIcon(ImageLoader.load("field.gif", ""));
            } else {
                this.setIcon(ImageLoader.load("folder.gif", ""));
            }
            this.setFont(CsvSchemaViewer.this.defaultFont);
            this.selected = selected;
            return this;
        }

        @Override
        public void paint(Graphics g) {
            Icon currentI = this.getIcon();
            Color bColor = this.selected ? SelectedBackgroundColor : (this.getParent() != null ? this.getParent().getBackground() : this.getBackground());
            g.setColor(bColor);
            if (currentI != null && this.getText() != null) {
                int offset = currentI.getIconWidth() + this.getIconTextGap();
                g.fillRect(offset, 0, this.getWidth() - 1 - offset, this.getHeight() - 1);
            } else {
                g.fillRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
            }
            super.paint(g);
        }
    }
}

