/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.msg.csv;

import com.argo21.common.gui.CheckBoxList;
import com.argo21.common.gui.ComboTextFieldEx;
import com.argo21.common.gui.FileFilterEx;
import com.argo21.common.gui.FileOrUrlOpenDialog;
import com.argo21.common.gui.ImageLoader;
import com.argo21.common.io.Debug;
import com.argo21.common.io.MIME2Java;
import com.argo21.common.io.XReader;
import com.argo21.common.lang.XData;
import com.argo21.jxp.dtd.AttDef;
import com.argo21.jxp.dtd.CommentDecl;
import com.argo21.jxp.dtd.CommentDeclNode;
import com.argo21.jxp.dtd.DTDDocument;
import com.argo21.jxp.dtd.DTDException;
import com.argo21.jxp.dtd.DeclNode;
import com.argo21.jxp.dtd.DeclNodeList;
import com.argo21.jxp.dtd.ElementDecl;
import com.argo21.map.MappingException;
import com.argo21.msg.FieldMataData;
import com.argo21.msg.MessageException;
import com.argo21.msg.csv.CsvSchema;
import com.argo21.msg.csv.FieldDecl;
import com.argo21.msg.rdb.RdbConnector;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.ResultSet;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ImportCSVDialog
extends JDialog
implements ActionListener,
PropertyChangeListener {
    public static final String[] TYPES = new String[]{"CSV", "DTD", "XML", "RDB"};
    public static String DLG_FREESEL = FileOrUrlOpenDialog.DLG_FREESEL;
    protected static final int LINES = 20;
    protected static final int COLUMNS = 40;
    protected Hashtable fieldTable = new Hashtable(31);
    private int import_type = 0;
    protected boolean is_OK = false;
    protected RdbConnector connect = null;
    protected JTabbedPane tabPanel;
    private CardLayout cardLayout;
    protected JFileChooser chooser;
    protected JTextArea textArea;
    protected JTextField urlField = new JTextField("");
    protected JCheckBox urlEnabled = new JCheckBox("URL:");
    protected JPanel urlPanel;
    protected JComboBox encodingField;
    protected JTextField rdbField;
    protected JButton connectButton;
    protected JTextField uidField;
    protected JTextField pwdField;
    protected JPanel rdbPanel;
    protected ComboTextFieldEx tabField;
    protected CheckBoxList fieldsList;
    protected JList fdsList;
    protected JButton addButton;
    protected JButton delButton;
    protected JButton rdbOkButton;
    protected JButton rdbCancelButton;
    private Vector tables;
    private File selectedFile = null;
    private String defencoding = null;

    public static String getDefaultStandardEncoding() {
        String s = System.getProperty("file.encoding");
        return MIME2Java.reverse(s);
    }

    public ImportCSVDialog(Frame frame, String title) {
        this(frame, title, (File)null);
    }

    public ImportCSVDialog(Frame frame, String title, String dir) {
        this(frame, title, (File)null);
        if (dir != null) {
            this.chooser.setCurrentDirectory(new File(dir));
        }
    }

    public ImportCSVDialog(Frame frame, String title, File dirFile) {
        super(frame, title, true);
        this.urlEnabled.setRequestFocusEnabled(false);
        this.urlPanel = new JPanel();
        this.urlPanel.setBorder(BorderFactory.createTitledBorder(""));
        this.cardLayout = new CardLayout();
        this.urlPanel.setLayout(this.cardLayout);
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridy = 0;
        c.gridx = 0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.insets = new Insets(1, 1, 1, 1);
        c.fill = 2;
        panel.add((Component)this.urlEnabled, c);
        ++c.gridx;
        c.weightx = 1.0;
        panel.add((Component)this.urlField, c);
        this.urlPanel.add((Component)panel, "DEFAULT");
        panel = new JPanel(new GridBagLayout());
        c = new GridBagConstraints();
        c.gridy = 0;
        c.gridx = 0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.insets = new Insets(1, 1, 1, 1);
        c.fill = 2;
        panel.add((Component)new JLabel("RDB:"), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.rdbField = new JTextField("");
        panel.add((Component)this.rdbField, c);
        ++c.gridx;
        c.weightx = 0.0;
        panel.add((Component)new JLabel("UID:"), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.uidField = new JTextField("");
        panel.add((Component)this.uidField, c);
        ++c.gridx;
        c.weightx = 0.0;
        panel.add((Component)new JLabel("PWD:"), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.pwdField = new JPasswordField("");
        panel.add((Component)this.pwdField, c);
        ++c.gridx;
        c.weightx = 0.0;
        this.connectButton = new JButton(MappingException.getMessage("CMD_CONNECT"));
        panel.add((Component)this.connectButton, c);
        this.connectButton.addActionListener(this);
        this.urlPanel.add((Component)panel, "RDB");
        this.chooser = new JFileChooser(dirFile);
        this.chooser.setMultiSelectionEnabled(false);
        this.textArea = new JTextArea();
        this.textArea.setEditable(false);
        this.textArea.setFont(new Font("Dialog", 0, 12));
        JPanel textPanel = new JPanel();
        textPanel.setLayout(new BorderLayout());
        String[] rs = MIME2Java.getAllStandardEncoding();
        String[] rs1 = new String[rs.length + 1];
        rs1[0] = DLG_FREESEL;
        System.arraycopy(rs, 0, rs1, 1, rs.length);
        this.encodingField = new JComboBox<String>(rs1);
        this.encodingField.addActionListener(this);
        textPanel.add((Component)this.encodingField, "North");
        textPanel.add((Component)new JScrollPane(this.textArea), "Center");
        textPanel.setBorder(BorderFactory.createCompoundBorder());
        textPanel.setPreferredSize(new Dimension(300, 80));
        this.chooser.setAccessory(textPanel);
        this.tabPanel = new JTabbedPane();
        for (int i = 0; i < TYPES.length; ++i) {
            JPanel tp = new JPanel(new BorderLayout());
            this.tabPanel.addTab(TYPES[i], tp);
            tp.setBorder(BorderFactory.createTitledBorder(""));
        }
        this.selectType(0);
        this.getContentPane().add((Component)this.tabPanel, "Center");
        this.rdbPanel = this.createRdbPanel();
        this.pack();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                ImportCSVDialog.this.setVisible(false);
            }
        });
        this.chooser.addActionListener(this);
        this.urlEnabled.addActionListener(this);
        this.urlField.addActionListener(this);
        this.uidField.addActionListener(this);
        this.pwdField.addActionListener(this);
        this.chooser.addPropertyChangeListener(this);
        this.tabPanel.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ImportCSVDialog.this.selectType(ImportCSVDialog.this.tabPanel.getSelectedIndex());
            }
        });
    }

    void selectType(int type) {
        boolean b;
        if (type == 0) {
            this.chooser.resetChoosableFileFilters();
            this.chooser.setFileFilter(new FileFilterEx(new String[]{"csv"}, "CSV Files"));
            if (this.defencoding == null) {
                this.encodingField.setSelectedItem(ImportCSVDialog.getDefaultStandardEncoding());
            } else {
                this.encodingField.setSelectedItem(this.defencoding);
            }
        } else if (type == 1) {
            this.chooser.resetChoosableFileFilters();
            this.chooser.setFileFilter(new FileFilterEx(new String[]{"dtd"}, "DTD Files"));
            if (this.defencoding == null) {
                this.encodingField.setSelectedIndex(0);
            } else {
                this.encodingField.setSelectedItem(this.defencoding);
            }
        } else if (type == 2) {
            this.chooser.resetChoosableFileFilters();
            this.chooser.setFileFilter(new FileFilterEx(new String[]{"xml"}, "XML Files"));
            if (this.defencoding == null) {
                this.encodingField.setSelectedIndex(0);
            } else {
                this.encodingField.setSelectedItem(this.defencoding);
            }
        }
        JPanel tp = (JPanel)this.tabPanel.getComponentAt(type);
        tp.add((Component)this.urlPanel, "North");
        boolean bl = b = type < 3;
        if (b) {
            tp.add((Component)this.chooser, "Center");
        } else {
            tp.add((Component)this.rdbPanel, "Center");
        }
        this.urlField.setText("");
        this.urlField.setEnabled(!b);
        this.urlEnabled.setSelected(!b);
        this.chooser.setEnabled(b);
        this.urlEnabled.setEnabled(b);
        if (b) {
            this.cardLayout.first(this.urlPanel);
        } else {
            this.cardLayout.last(this.urlPanel);
        }
        this.urlPanel.invalidate();
        this.urlPanel.repaint();
        this.import_type = type;
    }

    public String getImportType() {
        int sel = this.tabPanel.getSelectedIndex();
        return sel >= 0 ? TYPES[sel] : null;
    }

    public String getEncoding() {
        String encoding = (String)this.encodingField.getSelectedItem();
        if (DLG_FREESEL.equals(encoding)) {
            encoding = null;
        }
        return encoding;
    }

    public void setEncoding(String encoding) {
        this.defencoding = encoding;
    }

    public CsvSchema getCsvSchema() throws MessageException, DTDException, IOException {
        if (!this.is_OK) {
            return null;
        }
        String encoding = (String)this.encodingField.getSelectedItem();
        if (DLG_FREESEL.equals(encoding)) {
            encoding = null;
        }
        if (this.import_type == 0) {
            String urlString = this.getURL();
            if (urlString != null) {
                String contents;
                XReader in;
                URL url = new URL(urlString);
                if (url == null) {
                    return null;
                }
                if (encoding == null) {
                    try {
                        in = XReader.createReader(url.openStream(), "JISAutoDetect");
                    }
                    catch (UnsupportedEncodingException e) {
                        in = XReader.createReader(new InputStreamReader(url.openStream()));
                    }
                } else {
                    in = XReader.createReader(url.openStream(), encoding);
                }
                if ((contents = this.csvHeadToSchema(in)) == null || contents.length() == 0) {
                    return null;
                }
                CsvSchema shema = new CsvSchema();
                shema.parseSchemaDecl(XReader.createReader(contents.toCharArray(), null));
                try {
                    in.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return shema;
            }
        } else {
            if (this.import_type == 1) {
                String url;
                DTDDocument dtd = new DTDDocument();
                if (encoding != null) {
                    dtd.getProperties().repleace("encoding", encoding);
                }
                if ((url = this.getURL()) == null) {
                    return null;
                }
                dtd.load(url);
                return this.dtdToCsvSchema(dtd);
            }
            if (this.import_type == 2) {
                String url;
                DTDDocument dtd = new DTDDocument();
                if (encoding != null) {
                    dtd.getProperties().repleace("encoding", encoding);
                }
                if ((url = this.getURL()) != null) {
                    dtd.loadByXML(url);
                }
                return this.dtdToCsvSchema(dtd);
            }
            if (this.import_type == 3) {
                String contents = this.rdbFieldToSchema();
                if (contents == null || contents.length() == 0) {
                    return null;
                }
                CsvSchema shema = new CsvSchema();
                shema.parseSchemaDecl(XReader.createReader(contents.toCharArray(), null));
                return shema;
            }
        }
        return null;
    }

    private CsvSchema dtdToCsvSchema(DTDDocument dtd) {
        if (dtd != null) {
            CsvSchema shema = new CsvSchema();
            DeclNodeList nl = dtd.getAllDeclNode();
            int n = nl.getLength();
            for (int i = 0; i < n; ++i) {
                DeclNode decl = nl.elementAt(i);
                int type = decl.getNodeType();
                if (type == 20) {
                    if (((ElementDecl)decl).getType() != 2) continue;
                    shema.appendChild(new FieldDecl((DeclNode)shema, decl.getNodeName()));
                    continue;
                }
                if (type == 22) {
                    String s = ((AttDef)decl).getElementName() + "_" + decl.getNodeName();
                    shema.appendChild(new FieldDecl((DeclNode)shema, s));
                    continue;
                }
                if (type != 8) continue;
                shema.appendChild(new CommentDeclNode(shema, ((CommentDecl)decl).getComment()));
            }
            return shema;
        }
        return null;
    }

    private String csvHeadToSchema(XReader in) throws DTDException {
        char c;
        Vector<String> fds = new Vector<String>();
        in.peekWhitespace();
        while ((c = in.getc()) > '\u0000') {
            String s;
            if (c == '\"' || c == '\"') {
                s = in.peekName();
                if (s != null) {
                    fds.addElement(s);
                }
                in.peekc(c);
            } else {
                if (c == '\n' || c == '\r') break;
                if (Character.isLetter(c)) {
                    in.ungetc();
                    s = in.peekName();
                    if (s != null) {
                        fds.addElement(s);
                    }
                }
            }
            in.peekSpace();
        }
        StringBuffer sb = new StringBuffer();
        int n = fds.size();
        for (int i = 0; i < n; ++i) {
            sb.append("<!FIELD ");
            sb.append((String)fds.elementAt(i));
            sb.append(">\n");
        }
        return sb.toString();
    }

    private String rdbFieldToSchema() {
        FieldMataData fm;
        String s;
        int i;
        DefaultListModel dlm = (DefaultListModel)this.fdsList.getModel();
        int n = dlm.getSize();
        boolean muti = false;
        if (n == 0) {
            return null;
        }
        String tbname = (String)dlm.elementAt(0);
        int k = tbname.indexOf("/");
        if (k > 0) {
            tbname = tbname.substring(0, k);
        }
        for (int i2 = 1; i2 < n; ++i2) {
            String s2 = (String)dlm.elementAt(i2);
            k = s2.indexOf("/");
            s2 = k > 0 ? s2.substring(0, k) : "";
            if (s2.equals(tbname)) continue;
            muti = true;
            break;
        }
        StringBuffer sb = new StringBuffer();
        for (i = 0; i < n; ++i) {
            s = (String)dlm.elementAt(i);
            fm = (FieldMataData)this.fieldTable.get(s);
            if (fm == null) continue;
            sb.append("<!FIELD ");
            if (!muti) {
                sb.append(fm.name);
            } else {
                k = s.indexOf(46);
                if (k != -1) {
                    s = s.substring(k + 1);
                }
                sb.append(s.replace('/', '_'));
            }
            sb.append(">\n");
        }
        for (i = 0; i < n; ++i) {
            s = (String)dlm.elementAt(i);
            fm = (FieldMataData)this.fieldTable.get(s);
            if (fm == null || fm.type == 6) continue;
            if (!muti) {
                s = "field=\"" + fm.name + "\"";
            } else {
                k = s.indexOf(46);
                if (k != -1) {
                    s = s.substring(k + 1);
                }
                sb.append(s.replace('/', '_'));
            }
            sb.append(fm.getXML(s));
            sb.append("\n");
        }
        return sb.toString();
    }

    public String getURL() {
        if (this.is_OK && this.tabPanel.getSelectedIndex() < 3) {
            if (this.urlEnabled.isSelected()) {
                return this.urlField.getText();
            }
            File f = this.chooser.getSelectedFile();
            if (f != null) {
                try {
                    return f.toURL().toString();
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    private void refrashDataBase() {
        ResultSet res = null;
        try {
            this.closeRdbConnection();
            this.fieldTable.clear();
            this.fieldsList.removeAllItems();
            this.tabField.setEnabled(false);
            this.tabField.setEnabledEvent(false);
            this.tabField.removeAllItems();
            RdbConnector con = this.getRdbConnector();
            if (con == null) {
                return;
            }
            this.tabField.setEnabled(true);
            try {
                res = con.getDatabaseTables(new String[]{"TABLE", "VIEW"});
            }
            catch (Exception e) {
                res = con.getDatabaseTables(new String[]{"TABLE"});
            }
            this.tables = new Vector();
            int n = res.getMetaData().getColumnCount();
            while (res.next()) {
                String schema = res.getString(2);
                String table = res.getString(3);
                String type = res.getString(4);
                StringBuffer sb = new StringBuffer();
                if (schema != null && schema.length() > 0) {
                    sb.append(schema);
                    sb.append('.');
                }
                sb.append(table);
                if (type != null && type.length() > 0) {
                    sb.append(' ');
                    sb.append('(');
                    sb.append(type);
                    sb.append(')');
                }
                this.tabField.addItem(sb.toString());
                String[] ss = new String[]{schema, table};
                this.tables.addElement(ss);
            }
            this.tabField.setSelectedIndex(-1);
            this.tabField.setEnabledEvent(true);
        }
        catch (Exception e) {
            Debug.println(e);
            this.tabField.setEnabledEvent(true);
        }
        try {
            if (res != null) {
                res.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        Object obj = evt.getSource();
        if (obj == this.urlEnabled) {
            boolean b = this.urlEnabled.isSelected();
            this.urlField.setEnabled(b);
            this.chooser.setEnabled(!b);
            if (b) {
                this.urlField.requestFocus();
            }
        } else if (obj == this.urlField) {
            int sel = this.tabPanel.getSelectedIndex();
            if (sel < 0) {
                return;
            }
            String us = this.urlField.getText().trim();
            if (us.length() == 0) {
                return;
            }
            try {
                if (sel < 3) {
                    this.preview();
                }
            }
            catch (Exception e) {
                Debug.println(e);
            }
        } else if (obj == this.encodingField) {
            this.preview();
        } else if (obj == this.connectButton) {
            this.refrashDataBase();
        } else {
            this.selectedFile = this.chooser.getSelectedFile();
            String cmd = evt.getActionCommand();
            if ("ApproveSelection".equals(cmd)) {
                if (this.urlEnabled.isSelected()) {
                    if (this.urlField.getText().trim().length() == 0) {
                        return;
                    }
                    this.is_OK = true;
                    this.setVisible(false);
                } else {
                    if (this.selectedFile == null) {
                        return;
                    }
                    this.is_OK = true;
                    this.setVisible(false);
                }
            } else {
                this.is_OK = false;
                this.setVisible(false);
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("SelectedFileChangedProperty")) {
            this.selectedFile = (File)evt.getNewValue();
            if (this.selectedFile != null && this.selectedFile.isFile() && this.selectedFile.canRead()) {
                int sel = this.tabPanel.getSelectedIndex();
                if (sel < 0) {
                    return;
                }
                try {
                    if (sel < 3) {
                        this.preview();
                    }
                }
                catch (Exception exception) {}
            } else {
                this.textArea.setText("");
            }
        }
    }

    protected void preview() {
        String encoding = (String)this.encodingField.getSelectedItem();
        if (DLG_FREESEL.equals(encoding)) {
            encoding = null;
        }
        if (this.urlEnabled.isSelected()) {
            String us = this.urlField.getText().trim();
            if (us.length() == 0) {
                return;
            }
            try {
                XReader in;
                URL url = new URL(us);
                if (encoding == null) {
                    if (this.import_type == 0) {
                        try {
                            in = XReader.createReader(url.openStream(), "JISAutoDetect");
                        }
                        catch (UnsupportedEncodingException e1) {
                            in = XReader.createReader(new InputStreamReader(url.openStream()));
                        }
                    } else {
                        in = XReader.createReader(url, false);
                    }
                } else {
                    in = XReader.createReader(url.openStream(), encoding);
                }
                this.preview(in);
                try {
                    in.close();
                }
                catch (Exception exception) {
                }
            }
            catch (IOException e) {
                this.textArea.setText("");
                String s = MappingException.getMessage("INVALID_URL", us) + "\n" + e.getMessage();
                JOptionPane.showMessageDialog(this, s);
            }
            catch (Exception e) {
                this.textArea.setText("");
                JOptionPane.showMessageDialog(this, e.toString());
            }
        } else if (this.selectedFile != null && this.selectedFile.isFile() && this.selectedFile.canRead()) {
            try {
                XReader in;
                if (encoding == null) {
                    if (this.import_type == 0) {
                        try {
                            in = XReader.createReader(new FileInputStream(this.selectedFile), "JISAutoDetect");
                        }
                        catch (UnsupportedEncodingException e1) {
                            in = XReader.createReader(new FileReader(this.selectedFile));
                        }
                    } else {
                        in = XReader.createReader(this.selectedFile);
                    }
                } else {
                    in = XReader.createReader(new FileInputStream(this.selectedFile), encoding);
                }
                this.preview(in);
                try {
                    in.close();
                }
                catch (Exception exception) {
                }
            }
            catch (Exception e) {
                this.textArea.setText("");
                JOptionPane.showMessageDialog(this, e.getMessage());
            }
        } else {
            this.textArea.setText("");
        }
    }

    protected void preview(XReader in) {
        this.textArea.setText("");
        try {
            String s;
            for (int i = 0; i < 20 && !in.isEOF() && (s = in.readLine()) != null; ++i) {
                this.textArea.append(s);
                this.textArea.append("\n");
            }
        }
        catch (Throwable t) {
            this.textArea.setText("");
        }
        try {
            this.textArea.setSelectionStart(0);
            this.textArea.setSelectionEnd(0);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void setVisible(boolean b) {
        if (!b && this.connect != null) {
            try {
                this.connect.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.connect = null;
        }
        super.setVisible(b);
    }

    RdbConnector getRdbConnector() {
        if (this.connect == null) {
            try {
                String pwd;
                String us = this.rdbField.getText().trim();
                if (us.length() == 0) {
                    return null;
                }
                String uid = this.uidField.getText().trim();
                if (uid.length() == 0) {
                    uid = null;
                }
                if ((pwd = this.pwdField.getText().trim()).length() == 0) {
                    pwd = null;
                }
                this.connect = new RdbConnector(us, uid, pwd);
                if (this.connect != null) {
                    Debug.println(MessageException.getMessage("CONN_RDB_OK", us));
                }
            }
            catch (MessageException e) {
                this.closeRdbConnection();
                Debug.println(e.getMessage());
            }
            catch (Exception e) {
                this.closeRdbConnection();
                Debug.println(e);
            }
        }
        return this.connect;
    }

    private void closeRdbConnection() {
        if (this.connect != null) {
            try {
                this.connect.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.connect = null;
        }
    }

    private JPanel createRdbPanel() {
        JPanel tp = new JPanel();
        tp.setLayout(new GridBagLayout());
        tp.setOpaque(true);
        tp.setBorder(BorderFactory.createTitledBorder(""));
        GridBagConstraints c = new GridBagConstraints();
        c.gridy = 0;
        c.gridx = 0;
        c.gridheight = 1;
        c.gridwidth = 2;
        c.weightx = 1.0;
        c.insets = new Insets(1, 1, 1, 1);
        c.fill = 1;
        JLabel label = new JLabel(MessageException.getMessage("LAB_SEL_TAB"));
        tp.add((Component)label, c);
        ++c.gridy;
        this.tabField = new ComboTextFieldEx(false){

            @Override
            public boolean valueChanged(Object source, String value) {
                ImportCSVDialog.this.tableChanged(value);
                return true;
            }
        };
        this.tabField.setEnabled(false);
        tp.add((Component)this.tabField, c);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 2;
        label = new JLabel(MessageException.getMessage("LAB_SEL_FLD"));
        tp.add((Component)label, c);
        c.gridx = 0;
        ++c.gridy;
        this.fieldsList = new CheckBoxList();
        JScrollPane sp = new JScrollPane(this.fieldsList);
        sp.setPreferredSize(new Dimension(60, 80));
        sp.setBorder(BorderFactory.createEtchedBorder());
        tp.add((Component)sp, c);
        c.fill = 0;
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 1;
        this.addButton = new JButton(ImageLoader.load("todown.gif", "ADD"));
        this.addButton.setMargin(new Insets(0, 0, 0, 0));
        this.addButton.setBorder(null);
        tp.add((Component)this.addButton, c);
        ++c.gridx;
        this.delButton = new JButton(ImageLoader.load("toup.gif", "DEL"));
        this.delButton.setMargin(new Insets(0, 0, 0, 0));
        this.delButton.setBorder(null);
        tp.add((Component)this.delButton, c);
        ActionListener al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImportCSVDialog.this.rdbButtonAction(e.getSource());
            }
        };
        this.addButton.addActionListener(al);
        this.delButton.addActionListener(al);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 2;
        c.fill = 1;
        c.gridwidth = 0;
        c.gridheight = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        this.fdsList = new JList(new DefaultListModel());
        sp = new JScrollPane(this.fdsList);
        sp.setPreferredSize(new Dimension(60, 60));
        sp.setBorder(BorderFactory.createEtchedBorder());
        tp.add((Component)sp, c);
        JPanel tp1 = new JPanel();
        tp1.setLayout(new BorderLayout());
        tp1.add((Component)tp, "Center");
        JPanel tp2 = new JPanel();
        tp2.setLayout(new FlowLayout(1));
        this.rdbOkButton = new JButton(MessageException.getMessage("BUTTON_OK"));
        tp2.add(this.rdbOkButton);
        this.rdbCancelButton = new JButton(MessageException.getMessage("BUTTON_CANCEL"));
        tp2.add(this.rdbCancelButton);
        this.rdbOkButton.addActionListener(al);
        this.rdbCancelButton.addActionListener(al);
        tp1.add((Component)tp2, "South");
        return tp1;
    }

    void tableChanged(String value) {
        RdbConnector con = this.getRdbConnector();
        if (con == null) {
            return;
        }
        this.fieldsList.removeAllItems();
        ResultSet res = null;
        try {
            String table;
            int index = this.tabField.getSelectedIndex();
            if (index < 0 || this.tables == null || index >= this.tables.size()) {
                return;
            }
            String[] ss = (String[])this.tables.elementAt(index);
            String schema = ss[0];
            res = con.getDatabaseTableColumns(schema, table = ss[1]);
            if (res == null) {
                return;
            }
            this.fieldsList.addItem("*");
            int n = res.getMetaData().getColumnCount();
            while (res.next()) {
                int type;
                String fdName = res.getString(4);
                int fdType = res.getInt(5);
                int fdSize = res.getInt(7);
                boolean nullAble = res.getInt(11) == 1;
                String fdValue = null;
                if (n >= 13) {
                    fdValue = res.getString(13);
                }
                if (XData.isNumber(type = FieldMataData.SqlType2XDataType(fdType))) {
                    fdSize = 0;
                }
                String fn = table + "/" + fdName;
                this.fieldsList.addItem(fdName);
                this.fieldTable.put(fn, new FieldMataData(fdName, type, fdType, fdSize, nullAble, fdValue));
            }
        }
        catch (Exception e) {
            Debug.println(e);
        }
        if (res != null) {
            try {
                res.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    void rdbButtonAction(Object source) {
        block8: {
            DefaultListModel dlm;
            block7: {
                if (source == this.rdbOkButton) {
                    this.is_OK = true;
                    this.setVisible(false);
                    return;
                }
                if (source == this.rdbCancelButton) {
                    this.is_OK = false;
                    this.setVisible(false);
                    return;
                }
                dlm = (DefaultListModel)this.fdsList.getModel();
                if (source != this.addButton) break block7;
                int index = this.tabField.getSelectedIndex();
                if (index < 0 || this.tables == null || index >= this.tables.size()) {
                    return;
                }
                String[] ss = (String[])this.tables.elementAt(index);
                String table = ss[1];
                Object[] selects = this.fieldsList.getSelectedValues();
                for (int i = 0; i < selects.length; ++i) {
                    if ("*".equals(selects[i])) {
                        ListModel model = this.fieldsList.getModel();
                        for (int j = 1; j < model.getSize(); ++j) {
                            String fn = table + "/" + model.getElementAt(j);
                            if (dlm.contains(fn)) continue;
                            dlm.addElement(fn);
                        }
                        continue;
                    }
                    String fn = table + "/" + selects[i];
                    if (dlm.contains(fn)) continue;
                    dlm.addElement(fn);
                }
                break block8;
            }
            if (source != this.delButton) break block8;
            Object[] selects = this.fdsList.getSelectedValues();
            for (int i = 0; i < selects.length; ++i) {
                dlm.removeElement(selects[i]);
            }
        }
    }

    public static void main(String[] args) {
        String dir = null;
        if (args.length > 0) {
            dir = args[0];
        }
        Debug.enDebug = true;
        String DEFAULT_JDBC_DRIVER = "sun.jdbc.odbc.JdbcOdbcDriver";
        try {
            Class.forName(DEFAULT_JDBC_DRIVER).newInstance();
        }
        catch (Exception exception) {
            // empty catch block
        }
        JFrame f = new JFrame();
        ImportCSVDialog d = new ImportCSVDialog((Frame)f, "File Preview", dir);
        d.show();
        d.dispose();
        System.exit(0);
    }
}

