/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.msg.csv;

import com.argo21.common.lang.XData;
import com.argo21.common.lang.XObject;
import com.argo21.jxp.xpath.IndexExpr;
import com.argo21.jxp.xpath.StepExpr;
import com.argo21.jxp.xpath.XPathException;
import com.argo21.jxp.xpath.XPathSurpport;
import com.argo21.msg.TableDocument;
import com.argo21.msg.csv.TableColDataList;
import com.argo21.msg.csv.TableColDataSet;
import org.xml.sax.SAXException;

public class StepExprForTable
extends StepExpr {
    protected String field;

    public StepExprForTable(String fieldName) {
        super(0, null);
        this.field = fieldName;
    }

    @Override
    public int getType() {
        return 27;
    }

    @Override
    public XData eval(XData context, XPathSurpport surpport) throws SAXException {
        Object context1 = context.objectValue();
        if (context1 instanceof TableDocument) {
            this.resultName = this.field;
            TableColDataSet da = this.selectRows(context, (TableDocument)context1, surpport);
            if (da != null) {
                return da;
            }
        } else if (context1 instanceof TableRow) {
            TableRow tr = (TableRow)context1;
            TableDocument tb = tr.tb;
            int col = tb.getColIndex(this.field);
            if (col >= 0) {
                return new TableColDataList(tb, col, tr.row);
            }
        }
        XPathException.fatal("INVALID_NODE", this.field, null);
        return null;
    }

    TableColDataSet selectRows(XData context, TableDocument tb, XPathSurpport surpport) throws SAXException {
        int i;
        int col = tb.getColIndex(this.field);
        if (col < 0) {
            return null;
        }
        if (this.predicaties == null || this.predicaties.length == 0) {
            if (tb.getRows() < 1 && surpport.isExtendable()) {
                tb.extendRow(1);
            }
            return new TableColDataList(tb, col, 0);
        }
        int rows = tb.getRows();
        if (this.predicaties[0] instanceof IndexExpr) {
            IndexExpr expr = (IndexExpr)this.predicaties[0];
            int n = expr.getSize();
            if (n == 0) {
                int rows1 = surpport.getDefaultNumber();
                if (surpport.isExtendable() && rows1 > rows) {
                    if (rows1 >= 10000000) {
                        rows1 = rows;
                    }
                    tb.extendRow(rows1);
                }
                return new TableColDataSet(tb, col);
            }
            TableColDataList results = new TableColDataList(tb, col);
            for (int i2 = 0; i2 < n; ++i2) {
                int first = expr.getFirst(i2, context, surpport);
                int last2 = expr.getLast(i2, context, surpport);
                if (last2 < 0) {
                    last2 = first;
                } else if (last2 < first) {
                    int tmp = first;
                    first = last2;
                    last2 = tmp;
                }
                this.extendAndSelectRow(tb, results, first, last2, surpport);
            }
            return results;
        }
        TableColDataList results = new TableColDataList(tb, col);
        if (rows == 0) {
            return results;
        }
        for (i = 0; i < rows; ++i) {
            TableRow tr = new TableRow(tb, i);
            XData value = this.predicaties[0].eval(new XObject(tr), surpport);
            if (!value.booleanValue()) continue;
            results.appendRow(i);
        }
        for (i = 1; i < this.predicaties.length; ++i) {
            TableColDataList source = results;
            results = new TableColDataList(tb, col);
            int n = source.getLength();
            for (int j = 0; j < n; ++j) {
                int r = source.getRow(j);
                TableRow tr = new TableRow(tb, r);
                XData value = this.predicaties[i].eval(new XObject(tr), surpport);
                if (!value.booleanValue()) continue;
                results.appendRow(i);
            }
        }
        return results;
    }

    void extendAndSelectRow(TableDocument tb, TableColDataList results, int first, int last2, XPathSurpport surpport) throws SAXException {
        if (tb.getRows() <= last2 && surpport.isExtendable()) {
            tb.extendRow(last2 + 1);
        }
        results.appendRow(first, last2);
    }

    @Override
    public String getShortPath() {
        return this.field;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("field");
        sb.append("::");
        sb.append(this.field);
        if (this.predicaties != null) {
            for (int i = 0; i < this.predicaties.length; ++i) {
                sb.append('[');
                sb.append(this.predicaties[i].toString());
                sb.append(']');
            }
        }
        return sb.toString();
    }

    static class TableRow {
        TableDocument tb;
        int row;

        TableRow(TableDocument tb, int row) {
            this.tb = tb;
            this.row = row;
        }
    }
}

