/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.msg.csv;

import com.argo21.common.lang.XDataException;
import com.argo21.common.lang.XDataSet;
import com.argo21.msg.FieldNode;
import com.argo21.msg.TableDocument;
import com.argo21.msg.csv.TableColDataSet;
import java.util.Date;
import org.w3c.dom.Node;

public class TableColDataList
extends TableColDataSet {
    int[] rows;
    static int BASESIZE = 8;

    public TableColDataList(TableDocument document, int col, int row) {
        super(document, col);
        this.rows = new int[1];
        this.rows[0] = row;
        this.count = 1;
    }

    public TableColDataList(TableDocument document, int col) {
        super(document, col);
        this.rows = new int[BASESIZE];
        this.col = col;
        this.count = 0;
    }

    public void appendRow(int row) {
        if (row >= this.document.getRows()) {
            return;
        }
        if (this.count >= this.rows.length) {
            int[] tmp = this.rows;
            this.rows = new int[this.count + BASESIZE];
            System.arraycopy(tmp, 0, this.rows, 0, this.count);
        }
        this.rows[this.count++] = row;
    }

    public void appendRow(int row1, int row2) {
        if (row2 >= this.document.getRows()) {
            return;
        }
        int n = row2 - row1 + 1;
        int newsize = this.count + n;
        if (newsize >= this.rows.length) {
            int[] tmp = this.rows;
            this.rows = new int[newsize + BASESIZE];
            System.arraycopy(tmp, 0, this.rows, 0, this.count);
        }
        int i = row1;
        while (i <= row2) {
            this.rows[this.count++] = i++;
        }
    }

    @Override
    public TableDocument getOwnerDocument() {
        return this.document;
    }

    @Override
    public int size() {
        return this.count;
    }

    @Override
    public int getRow(int index) {
        return this.rows[index];
    }

    @Override
    public void expendsCapacity(int minCapacity) {
    }

    @Override
    public XDataSet extendDataSet(int length) {
        return null;
    }

    @Override
    public int getPrimitiveType() {
        return this.document.getColType(this.col);
    }

    @Override
    public boolean booleanValue(int index) throws XDataException {
        return this.count <= index ? false : this.document.booleanValue(this.rows[index], this.col);
    }

    @Override
    public int intValue(int index) throws XDataException {
        return this.count <= index ? 0 : this.document.intValue(this.rows[index], this.col);
    }

    @Override
    public long longValue(int index) throws XDataException {
        return this.count <= index ? 0L : this.document.longValue(this.rows[index], this.col);
    }

    @Override
    public float floatValue(int index) throws XDataException {
        return this.count <= index ? 0.0f : (float)this.document.intValue(this.rows[index], this.col);
    }

    @Override
    public double doubleValue(int index) throws XDataException {
        return this.count <= index ? 0.0 : this.document.doubleValue(this.rows[index], this.col);
    }

    @Override
    public String stringValue(int index) {
        return this.count <= index ? "" : this.document.stringValue(this.rows[index], this.col);
    }

    @Override
    public Date dateValue(int index) throws XDataException {
        return this.count <= index ? null : this.document.dateValue(this.rows[index], this.col);
    }

    @Override
    public Node nodeValue(int index) {
        return this.count <= index ? null : new FieldNode(this.document, this.rows[index], this.col);
    }

    @Override
    public Object objectValue(int index) {
        return this.count <= index ? null : this.document.objectValue(this.rows[index], this.col);
    }

    @Override
    public boolean[] booleanValues() throws XDataException {
        boolean[] result = new boolean[this.count];
        for (int i = 0; i < this.count; ++i) {
            result[i] = this.document.booleanValue(this.rows[i], this.col);
        }
        return result;
    }

    @Override
    public int[] intValues() throws XDataException {
        int[] result = new int[this.count];
        for (int i = 0; i < this.count; ++i) {
            result[i] = this.document.intValue(this.rows[i], this.col);
        }
        return result;
    }

    @Override
    public long[] longValues() throws XDataException {
        long[] result = new long[this.count];
        for (int i = 0; i < this.count; ++i) {
            result[i] = this.document.longValue(this.rows[i], this.col);
        }
        return result;
    }

    @Override
    public float[] floatValues() throws XDataException {
        float[] result = new float[this.count];
        for (int i = 0; i < this.count; ++i) {
            result[i] = this.document.floatValue(this.rows[i], this.col);
        }
        return result;
    }

    @Override
    public double[] doubleValues() throws XDataException {
        double[] result = new double[this.count];
        for (int i = 0; i < this.count; ++i) {
            result[i] = this.document.doubleValue(this.rows[i], this.col);
        }
        return result;
    }

    @Override
    public String[] stringValues() throws XDataException {
        String[] result = new String[this.count];
        for (int i = 0; i < this.count; ++i) {
            result[i] = this.document.stringValue(this.rows[i], this.col);
        }
        return result;
    }

    @Override
    public Date[] dateValues() throws XDataException {
        Date[] result = new Date[this.count];
        for (int i = 0; i < this.count; ++i) {
            result[i] = this.document.dateValue(this.rows[i], this.col);
        }
        return result;
    }

    @Override
    public void setValue(int index, int value) throws XDataException {
        if (index < this.count) {
            this.document.setValue(this.rows[index], this.col, value);
        }
    }

    @Override
    public void setValue(int index, long value) throws XDataException {
        if (index < this.count) {
            this.document.setValue(this.rows[index], this.col, value);
        }
    }

    @Override
    public void setValue(int index, float value) throws XDataException {
        if (index < this.count) {
            this.document.setValue(this.rows[index], this.col, value);
        }
    }

    @Override
    public void setValue(int index, double value) throws XDataException {
        if (index < this.count) {
            this.document.setValue(this.rows[index], this.col, value);
        }
    }

    @Override
    public void setValue(int index, String value) throws XDataException {
        if (index < this.count) {
            this.document.setValue(this.rows[index], this.col, value);
        }
    }

    @Override
    public void setValue(int index, boolean value) throws XDataException {
        if (index < this.count) {
            this.document.setValue(this.rows[index], this.col, value);
        }
    }

    @Override
    public void setValue(int index, Date value) throws XDataException {
        if (index < this.count) {
            this.document.setValue(this.rows[index], this.col, value);
        }
    }

    @Override
    public Node item(int index) {
        return new FieldNode(this.document, this.rows[index], this.col);
    }

    @Override
    public int getLength() {
        return this.size();
    }
}

