/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.msg.division;

import com.argo21.common.log.AppMessage;
import com.argo21.common.log.BizTranException;
import com.argo21.common.util.MappingInfo;
import com.argo21.msg.division.DivisionPropertiesValidator;
import com.argo21.msg.division.input.CsvDivisionProperties;
import com.argo21.msg.division.input.FixFlatDivisionProperties;
import com.argo21.msg.division.input.FixTagDivisionProperties;
import com.argo21.msg.division.input.XmlDivisionProperties;
import com.argo21.msg.division.output.FixTagUnionProperties;
import com.argo21.msg.division.output.XmlUnionProperties;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import jp.co.argo21.nts.commons.properties.PropertyParseException;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;

public class DivisionProperties {
    public static final int TMP_FILE_SIZE = 0x500000;
    public static final String DIVISION_TOP = "top";
    public static final String DIVISION_MSGTYPE_XML = "XML";
    public static final String DIVISION_MSGTYPE_FIXFLAT = "FIX_FLAT";
    public static final String DIVISION_MSGTYPE_FIXTAG = "FIX_TAG";
    public static final String DIVISION_MSGTYPE_CSV = "CSV";
    public static final String DIVISION_COMMON_INPUT_FILESIZE = "input.filesize";
    public static final String DIVISION_COMMON_INPUT_MSGTYPE = "input.msgtype";
    public static final String DIVISION_COMMON_INPUT_ENCODING = "input.encoding";
    public static final String DIVISION_COMMON_OUTPUT_MSGTYPE = "output.msgtype";
    public static final String DIVISION_COMMON_OUTPUT_ENCODING = "output.encoding";
    public static final String DIVISION_INPUT_CHILDKEY = "input.child.key.";
    public static final String DIVISION_XML_INPUT_TAGNAME = "input.xml.tag.name.";
    public static final String DIVISION_XML_INPUT_TAGNAME_PARENT = "input.xml.tag.parent.name.";
    public static final String DIVISION_XML_OUTPUT_TAGNAME = "output.xml.tag.name.";
    public static final String DIVISION_XML_OUTPUT_TAGNAME_PARENT = "output.xml.tag.parent.name.";
    public static final String DIVISION_FIXFLAT_INPUT_RECORD_LENGTH = "input.fixflat.record.length";
    public static final String DIVISION_FIXFLAT_INPUT_KEY_INDEX = "input.fixflat.key.index.";
    public static final String DIVISION_FIXFLAT_INPUT_KEY_LENGTH = "input.fixflat.key.length.";
    public static final String DIVISION_FIXTAG_INPUT_KEY_INDEX = "input.fixtag.key.index";
    public static final String DIVISION_FIXTAG_INPUT_KEY_LENGTH = "input.fixtag.key.length";
    public static final String DIVISION_FIXTAG_INPUT_RECORD_LENGTH = "input.fixtag.record.length";
    public static final String DIVISION_FIXTAG_INPUT_KEY_BODY_START = "input.fixtag.key.bodystart.";
    public static final String DIVISION_FIXTAG_INPUT_KEY_FOOTER_START = "input.fixtag.key.footerstart.";
    public static final String DIVISION_FIXTAG_OUTPUT_KEY_INDEX = "output.fixtag.key.index";
    public static final String DIVISION_FIXTAG_OUTPUT_KEY_LENGTH = "output.fixtag.key.length";
    public static final String DIVISION_FIXTAG_OUTPUT_RECORD_LENGTH = "output.fixtag.record.length";
    public static final String DIVISION_FIXTAG_OUTPUT_KEY_BODY_START = "output.fixtag.key.bodystart.";
    public static final String DIVISION_FIXTAG_OUTPUT_KEY_FOOTER_START = "output.fixtag.key.footerstart.";
    public static final String DIVISION_CSV_INPUT_KEY_INDEX = "input.csv.key.index.";
    private PropertiesConfiguration propConf = new PropertiesConfiguration();
    private long fileSize;
    private String inputMsgType = null;
    private String inputEncoding = null;
    private String outputMsgType = null;
    private String outputEncoding = null;

    public DivisionProperties(MappingInfo mapinfo) throws BizTranException {
        try {
            FileInputStream inputstream = new FileInputStream(mapinfo.getDividePropFilePath());
            this.propConf.load((InputStream)inputstream);
            inputstream.close();
        }
        catch (ConfigurationException e) {
            throw new BizTranException(AppMessage.IO_DIVIDEPROP_ABNORMAL, e.getMessage());
        }
        catch (IOException e) {
            throw new BizTranException(AppMessage.IO_DIVIDEPROP_NOT_FOUND, e.getMessage());
        }
        try {
            new DivisionPropertiesValidator().validate((Configuration)this.propConf);
            this.analysisFileSize(this.propConf.getString(DIVISION_COMMON_INPUT_FILESIZE), mapinfo);
            this.inputMsgType = this.propConf.getString(DIVISION_COMMON_INPUT_MSGTYPE);
            this.inputEncoding = this.propConf.getString(DIVISION_COMMON_INPUT_ENCODING);
            this.outputMsgType = this.propConf.getString(DIVISION_COMMON_OUTPUT_MSGTYPE);
            this.outputEncoding = this.propConf.getString(DIVISION_COMMON_OUTPUT_ENCODING);
        }
        catch (PropertyParseException e) {
            throw new BizTranException(AppMessage.IO_DIVIDEPROP_ABNORMAL, e.getMessage());
        }
    }

    private void analysisFileSize(String fs, MappingInfo mapinfo) {
        fs = fs.toLowerCase();
        try {
            if (fs.endsWith("m")) {
                double fileSizeM = Double.parseDouble(fs.substring(0, fs.length() - 1));
                this.fileSize = (long)Math.ceil(fileSizeM * 1024.0 * 1024.0);
            } else if (fs.endsWith("k")) {
                double fileSizeK = Double.parseDouble(fs.substring(0, fs.length() - 1));
                this.fileSize = (long)Math.ceil(fileSizeK * 1024.0);
            } else {
                this.fileSize = Long.parseLong(fs);
            }
        }
        catch (NumberFormatException e) {
            mapinfo.setDoDivide(false);
        }
    }

    public long getFileSize() {
        return this.fileSize;
    }

    public String getInputMsgType() {
        return this.inputMsgType;
    }

    public String getInputEncoding() {
        return this.inputEncoding;
    }

    public String getOutputMsgType() {
        return this.outputMsgType;
    }

    public String getOutputEncoding() {
        return this.outputEncoding;
    }

    public XmlDivisionProperties getXmlDivisionProperties() {
        return new XmlDivisionProperties(this.propConf, this.fileSize);
    }

    public XmlUnionProperties getXmlUnionProperties() {
        return new XmlUnionProperties(this.propConf);
    }

    public FixFlatDivisionProperties getFixFlatDivisionProperties(String[] divKeys) {
        return new FixFlatDivisionProperties(this.propConf, divKeys, this.fileSize);
    }

    public FixTagDivisionProperties getFixTagDivisionProperties(String[] divKeys) {
        return new FixTagDivisionProperties(this.propConf, divKeys, this.fileSize);
    }

    public FixTagUnionProperties getFixTagUnionProperties(String[] divKeys) {
        return new FixTagUnionProperties(this.propConf, divKeys);
    }

    public CsvDivisionProperties getCsvDivisionProperties(String[] divKeys) {
        return new CsvDivisionProperties(this.propConf, divKeys, this.fileSize);
    }

    public String[] getChildKeys(String key) {
        return this.propConf.getStringArray(DIVISION_INPUT_CHILDKEY + key);
    }
}

