/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.msg.division;

import com.argo21.msg.division.EncodingValidator;
import com.argo21.msg.division.IsFileSizeValidator;
import com.argo21.msg.division.MessageTypeValidator;
import java.util.ArrayList;
import java.util.List;
import jp.co.argo21.nts.commons.properties.ArrayCountValidator;
import jp.co.argo21.nts.commons.properties.Condition;
import jp.co.argo21.nts.commons.properties.ConditionJudgment;
import jp.co.argo21.nts.commons.properties.ConditionJudgmentLeaf;
import jp.co.argo21.nts.commons.properties.ConditionValidator;
import jp.co.argo21.nts.commons.properties.ExistCondition;
import jp.co.argo21.nts.commons.properties.IsDigitValidator;
import jp.co.argo21.nts.commons.properties.IsNotEmptyOrNotNullValidator;
import jp.co.argo21.nts.commons.properties.PropertiesValidator;
import jp.co.argo21.nts.commons.properties.PropertyParseException;
import jp.co.argo21.nts.commons.properties.SimpleValidator;
import jp.co.argo21.nts.commons.properties.Validatable;
import jp.co.argo21.nts.commons.properties.Validator;
import org.apache.commons.configuration.Configuration;

public class DivisionPropertiesValidator {
    public void validate(Configuration config) throws PropertyParseException {
        PropertiesValidator pv = new PropertiesValidator(config);
        pv.addValueValidator((Validator)new SimpleValidator("input.filesize", (Validatable)new IsNotEmptyOrNotNullValidator()));
        pv.addValueValidator((Validator)new SimpleValidator("input.filesize", (Validatable)new IsFileSizeValidator()));
        pv.addValueValidator((Validator)new SimpleValidator("input.msgtype", (Validatable)new IsNotEmptyOrNotNullValidator()));
        pv.addValueValidator((Validator)new SimpleValidator("input.msgtype", (Validatable)new MessageTypeValidator()));
        pv.addValueValidator((Validator)new SimpleValidator("input.encoding", (Validatable)new EncodingValidator()));
        pv.addValueValidator((Validator)new SimpleValidator("output.msgtype", (Validatable)new IsNotEmptyOrNotNullValidator()));
        pv.addValueValidator((Validator)new SimpleValidator("output.msgtype", (Validatable)new MessageTypeValidator()));
        pv.addValueValidator((Validator)new SimpleValidator("output.encoding", (Validatable)new EncodingValidator()));
        String inputMsgType = config.getString("input.msgtype");
        String outputMsgType = config.getString("output.msgtype");
        List<String> keyList = "XML".equals(inputMsgType) ? this.validateInputXML(pv, config, "top") : ("FIX_FLAT".equals(inputMsgType) ? this.validateInputFIXFLAT(pv, config, "top") : ("FIX_TAG".equals(inputMsgType) ? this.validateInputFIXTAG(pv, config, "top") : ("CSV".equals(inputMsgType) ? this.validateInputCSV(pv, config, "top") : new ArrayList<String>())));
        if ("XML".equals(outputMsgType)) {
            this.validateOutputXML(pv, config, keyList);
        } else if ("FIX_TAG".equals(outputMsgType)) {
            this.validateOutputFIXTAG(pv, config, keyList);
        }
        pv.validate();
    }

    private List<String> validateInputXML(PropertiesValidator pv, Configuration config, String divKey) {
        ArrayList<String> keyList = new ArrayList<String>();
        keyList.add(divKey);
        pv.addValueValidator((Validator)new SimpleValidator("input.xml.tag.name." + divKey, (Validatable)new IsNotEmptyOrNotNullValidator()));
        pv.addValueValidator((Validator)new SimpleValidator("input.xml.tag.parent.name." + divKey, (Validatable)new IsNotEmptyOrNotNullValidator()));
        String[] divKeys = config.getStringArray("input.child.key." + divKey);
        if (divKeys != null && divKeys.length > 0) {
            for (String childDivKey : divKeys) {
                keyList.addAll(this.validateInputXML(pv, config, childDivKey));
            }
        }
        return keyList;
    }

    private List<String> validateInputFIXFLAT(PropertiesValidator pv, Configuration config, String divKey) {
        pv.addValueValidator((Validator)new SimpleValidator("input.fixflat.record.length", (Validatable)new IsDigitValidator()));
        return this.validateInputFIXFLATChild(pv, config, divKey);
    }

    private List<String> validateInputFIXFLATChild(PropertiesValidator pv, Configuration config, String divKey) {
        ArrayList<String> keyList = new ArrayList<String>();
        keyList.add(divKey);
        pv.addValueValidator((Validator)new SimpleValidator("input.fixflat.key.index." + divKey, (Validatable)new IsDigitValidator()));
        pv.addValueValidator((Validator)new ArrayCountValidator("input.fixflat.key.index." + divKey, new String[]{"input.fixflat.key.length." + divKey}));
        pv.addValueValidator((Validator)new SimpleValidator("input.fixflat.key.length." + divKey, (Validatable)new IsDigitValidator()));
        pv.addValueValidator((Validator)new ArrayCountValidator("input.fixflat.key.length." + divKey, new String[]{"input.fixflat.key.index." + divKey}));
        String[] divKeys = config.getStringArray("input.child.key." + divKey);
        if (divKeys != null && divKeys.length > 0) {
            for (String childDivKey : divKeys) {
                keyList.addAll(this.validateInputFIXFLATChild(pv, config, childDivKey));
            }
        }
        return keyList;
    }

    private List<String> validateInputFIXTAG(PropertiesValidator pv, Configuration config, String divKey) {
        pv.addValueValidator((Validator)new SimpleValidator("input.fixtag.key.index", (Validatable)new IsDigitValidator()));
        pv.addValueValidator((Validator)new ArrayCountValidator("input.fixtag.key.index", new String[]{"input.fixtag.key.length", "input.fixtag.key.bodystart." + divKey}));
        pv.addValueValidator((Validator)new SimpleValidator("input.fixtag.key.length", (Validatable)new IsDigitValidator()));
        pv.addValueValidator((Validator)new ArrayCountValidator("input.fixtag.key.length", new String[]{"input.fixtag.key.index", "input.fixtag.key.bodystart." + divKey}));
        return this.validateInputFIXTAGChild(pv, config, divKey);
    }

    private List<String> validateInputFIXTAGChild(PropertiesValidator pv, Configuration config, String divKey) {
        ArrayList<String> keyList = new ArrayList<String>();
        keyList.add(divKey);
        pv.addValueValidator((Validator)new SimpleValidator("input.fixtag.key.bodystart." + divKey, (Validatable)new IsNotEmptyOrNotNullValidator()));
        pv.addValueValidator((Validator)new ArrayCountValidator("input.fixtag.key.bodystart." + divKey, new String[]{"input.fixtag.key.index", "input.fixtag.key.length"}));
        ConditionJudgmentLeaf footerStartExistJudg = new ConditionJudgmentLeaf("input.fixtag.key.footerstart." + divKey);
        footerStartExistJudg.addCondition((Condition)new ExistCondition());
        ConditionValidator footerStartValidator = new ConditionValidator((ConditionJudgment)footerStartExistJudg, (Validator)new SimpleValidator("input.fixtag.key.footerstart." + divKey, (Validatable)new IsNotEmptyOrNotNullValidator()));
        footerStartValidator.addValidator((Validator)new ArrayCountValidator("input.fixtag.key.footerstart." + divKey, new String[]{"input.fixtag.key.index", "input.fixtag.key.length", "input.fixtag.key.bodystart." + divKey}));
        pv.addValueValidator((Validator)footerStartValidator);
        String[] divKeys = config.getStringArray("input.child.key." + divKey);
        if (divKeys != null && divKeys.length > 0) {
            for (String childDivKey : divKeys) {
                keyList.addAll(this.validateInputFIXTAGChild(pv, config, childDivKey));
            }
        }
        return keyList;
    }

    private List<String> validateInputCSV(PropertiesValidator pv, Configuration config, String divKey) {
        ArrayList<String> keyList = new ArrayList<String>();
        keyList.add(divKey);
        pv.addValueValidator((Validator)new SimpleValidator("input.csv.key.index." + divKey, (Validatable)new IsDigitValidator()));
        String[] divKeys = config.getStringArray("input.child.key." + divKey);
        if (divKeys != null && divKeys.length > 0) {
            for (String childDivKey : divKeys) {
                keyList.addAll(this.validateInputCSV(pv, config, childDivKey));
            }
        }
        return keyList;
    }

    private void validateOutputXML(PropertiesValidator pv, Configuration config, List<String> keyList) {
        for (String divKey : keyList) {
            pv.addValueValidator((Validator)new SimpleValidator("output.xml.tag.name." + divKey, (Validatable)new IsNotEmptyOrNotNullValidator()));
            pv.addValueValidator((Validator)new SimpleValidator("output.xml.tag.parent.name." + divKey, (Validatable)new IsNotEmptyOrNotNullValidator()));
        }
    }

    private void validateOutputFIXTAG(PropertiesValidator pv, Configuration config, List<String> keyList) {
        pv.addValueValidator((Validator)new SimpleValidator("output.fixtag.key.index", (Validatable)new IsDigitValidator()));
        pv.addValueValidator((Validator)new ArrayCountValidator("output.fixtag.key.index", new String[]{"output.fixtag.key.length"}));
        pv.addValueValidator((Validator)new SimpleValidator("output.fixtag.key.length", (Validatable)new IsDigitValidator()));
        pv.addValueValidator((Validator)new ArrayCountValidator("output.fixtag.key.length", new String[]{"output.fixtag.key.index"}));
        for (String divKey : keyList) {
            pv.addValueValidator((Validator)new SimpleValidator("output.fixtag.key.bodystart." + divKey, (Validatable)new IsNotEmptyOrNotNullValidator()));
            pv.addValueValidator((Validator)new ArrayCountValidator("output.fixtag.key.bodystart." + divKey, new String[]{"output.fixtag.key.index", "output.fixtag.key.length"}));
            ConditionJudgmentLeaf footerStartExistJudg = new ConditionJudgmentLeaf("output.fixtag.key.footerstart." + divKey);
            footerStartExistJudg.addCondition((Condition)new ExistCondition());
            ConditionValidator footerStartValidator = new ConditionValidator((ConditionJudgment)footerStartExistJudg, (Validator)new SimpleValidator("output.fixtag.key.footerstart." + divKey, (Validatable)new IsNotEmptyOrNotNullValidator()));
            footerStartValidator.addValidator((Validator)new ArrayCountValidator("output.fixtag.key.footerstart." + divKey, new String[]{"output.fixtag.key.index", "output.fixtag.key.length", "output.fixtag.key.bodystart." + divKey}));
            pv.addValueValidator((Validator)footerStartValidator);
        }
    }
}

