/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.msg.division;

import com.argo21.common.log.AppMessage;
import com.argo21.common.log.BizTranException;
import com.argo21.msg.division.FileOutputStreamGetter;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;

public class TempFileWriter {
    private String encoding = null;
    private String tmpFileName;

    public TempFileWriter(String outputFolderName, String tmpName, String encoding) {
        this.encoding = encoding;
        this.tmpFileName = outputFolderName.concat(File.separator).concat(tmpName);
    }

    public void write(String body) throws BizTranException {
        BufferedWriter bw = null;
        FileOutputStream fos = null;
        OutputStreamWriter osw = null;
        try {
            fos = FileOutputStreamGetter.getFileOutputStream(this.tmpFileName, true);
            osw = this.encoding == null ? new OutputStreamWriter(fos) : new OutputStreamWriter((OutputStream)fos, this.encoding);
            bw = new BufferedWriter(osw);
            osw.write(body);
        }
        catch (Exception e) {
            throw new BizTranException(AppMessage.IO_DIVIDEPROP_DIVIDE_FAIL, (Throwable)e);
        }
        finally {
            try {
                if (bw != null) {
                    bw.close();
                }
                if (osw != null) {
                    osw.close();
                }
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public String getTmpFileName() {
        return this.tmpFileName;
    }

    public long getTmpSize() {
        return new File(this.tmpFileName).length();
    }

    public void deleteTmpFile() throws BizTranException {
        if (new File(this.tmpFileName).exists() && !new File(this.tmpFileName).delete()) {
            throw new BizTranException(AppMessage.IO_DIVIDEPROP_DIVIDE_FAIL, "\u4e00\u6642\u30d5\u30a1\u30a4\u30eb\u306e\u524a\u9664\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002\uff1a" + this.tmpFileName);
        }
    }
}

