/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.msg.division.input;

import com.argo21.common.log.AppMessage;
import com.argo21.common.log.BizTranException;
import com.argo21.msg.csv.CSVTokenizer;
import com.argo21.msg.division.TempFileWriter;
import com.argo21.msg.division.input.CSVDivisionKey;
import com.argo21.msg.division.input.CsvDivisionProperties;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class CSVDivisionReader {
    private BufferedReader br;
    private CsvDivisionProperties csvDivProp;
    private String line;
    private CSVDivisionKey beforeKey;
    private TempFileWriter tmpWriter = null;

    public CSVDivisionReader(CsvDivisionProperties csvDivProp, BufferedReader br, TempFileWriter tmpWriter) {
        this.csvDivProp = csvDivProp;
        this.br = br;
        this.beforeKey = null;
        this.line = null;
        this.tmpWriter = tmpWriter;
    }

    public String getNextLoop(String[] divKeys) throws IOException, BizTranException {
        try {
            StringBuffer lineBuffer = new StringBuffer();
            while ((this.line = this.readLine()) != null) {
                CSVTokenizer csvTokenizer = new CSVTokenizer(this.line);
                ArrayList<String> lineList = new ArrayList<String>();
                while (csvTokenizer.hasMoreTokens()) {
                    lineList.add(csvTokenizer.nextToken());
                }
                CSVDivisionKey thisKey = this.getDivKey(lineList, divKeys);
                if (lineBuffer.length() == 0 && this.tmpWriter.getTmpSize() == 0L || this.beforeKey == null || thisKey.equals(this.beforeKey)) {
                    lineBuffer.append(this.line);
                    if (lineBuffer.length() >= 0x500000) {
                        this.tmpWriter.write(lineBuffer.toString());
                        lineBuffer = new StringBuffer();
                    }
                    this.beforeKey = new CSVDivisionKey(thisKey.getDivKey(), thisKey.getKeyList());
                    this.line = null;
                    continue;
                }
                this.tmpWriter.write(lineBuffer.toString());
                lineBuffer = new StringBuffer();
                return this.tmpWriter.getTmpFileName();
            }
            this.tmpWriter.write(lineBuffer.toString());
            lineBuffer = new StringBuffer();
            return this.tmpWriter.getTmpFileName();
        }
        catch (Exception e) {
            throw new BizTranException(AppMessage.IO_DIVIDEPROP_DIVIDE_FAIL, (Throwable)e);
        }
    }

    private String readLine() throws IOException {
        if (this.line == null) {
            this.line = this.br.readLine();
            if (this.line != null) {
                this.line = this.line.concat("\r\n");
            }
        }
        return this.line;
    }

    public String getDivisonKey() {
        return this.beforeKey.getDivKey();
    }

    private CSVDivisionKey getDivKey(List<String> lineList, String[] divKeys) {
        for (String divKey : divKeys) {
            int[] keyIndex = this.csvDivProp.getKeyIndex(divKey);
            boolean isKey = false;
            ArrayList<String> thisKey = new ArrayList<String>();
            for (int i = 0; i < keyIndex.length; ++i) {
                String value = lineList.get(keyIndex[i] - 1);
                thisKey.add(value);
                if (value == null || value.length() <= 0) continue;
                isKey = true;
            }
            if (!isKey) continue;
            return new CSVDivisionKey(divKey, thisKey);
        }
        return new CSVDivisionKey(divKeys[0], new ArrayList<String>());
    }
}

