/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.msg.division.input;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.configuration.PropertiesConfiguration;

public class CsvDivisionProperties {
    private PropertiesConfiguration propConf = null;
    private long fileSize;
    private Map<String, int[]> keyIndexMap;

    public CsvDivisionProperties(PropertiesConfiguration propConf, String[] divKeys, long fileSize) {
        this.propConf = propConf;
        this.fileSize = fileSize;
        this.keyIndexMap = new HashMap<String, int[]>();
        for (String divKey : divKeys) {
            this.keyIndexMap.put(divKey, this.getIntArray(divKey));
        }
    }

    private int[] getIntArray(String key) {
        String[] values = this.propConf.getStringArray("input.csv.key.index." + key);
        int[] result = new int[values.length];
        for (int i = 0; i < values.length; ++i) {
            result[i] = Integer.parseInt(values[i]);
        }
        return result;
    }

    public int[] getKeyIndex(String divKey) {
        return this.keyIndexMap.get(divKey);
    }

    public long getFileSize() {
        return this.fileSize;
    }
}

