/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.msg.division.input;

import com.argo21.common.io.MIME2Java;
import com.argo21.common.log.AppMessage;
import com.argo21.common.log.BizTranException;
import com.argo21.msg.division.TempFileWriter;
import com.argo21.msg.division.input.CSVDivisionReader;
import com.argo21.msg.division.input.CsvDivisionProperties;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.DecimalFormat;

public class CsvDivisioner {
    private CsvDivisionProperties csvDivProp = null;
    private String[] divKeys = null;
    private String encoding = null;
    private int fileCounter;

    public CsvDivisioner(CsvDivisionProperties csvDivProp, String[] divKeys, String encoding) {
        this.csvDivProp = csvDivProp;
        this.divKeys = divKeys;
        this.encoding = MIME2Java.convert(encoding);
        this.fileCounter = 1;
    }

    public void divide(String inputFileName, String outputFolderName) throws BizTranException {
        File outputFolder = new File(outputFolderName);
        if (!outputFolder.exists()) {
            if (!outputFolder.mkdirs()) {
                throw new BizTranException(AppMessage.IO_DIVIDEPROP_DIVIDE_FAIL, "\u4e00\u6642\u51fa\u529b\u30d5\u30a9\u30eb\u30c0\u306e\u4f5c\u6210\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
            }
        } else if (!outputFolder.isDirectory()) {
            throw new BizTranException(AppMessage.IO_DIVIDEPROP_DIVIDE_FAIL, "\u4e00\u6642\u51fa\u529b\u30d5\u30a9\u30eb\u30c0\u304c\u30d5\u30a9\u30eb\u30c0\u3067\u3042\u308a\u307e\u305b\u3093\u3002");
        }
        FileInputStream fis = null;
        InputStreamReader isr = null;
        BufferedReader br = null;
        try {
            File inputFile = new File(inputFileName);
            fis = new FileInputStream(inputFile);
            if (this.encoding == null) {
                isr = new InputStreamReader(fis);
                this.encoding = System.getProperty("file.encoding");
            } else {
                isr = new InputStreamReader((InputStream)fis, this.encoding);
            }
            br = new BufferedReader(isr);
            TempFileWriter tmpWriter = new TempFileWriter(outputFolderName, "tmpBody", this.encoding);
            CSVDivisionReader reader = new CSVDivisionReader(this.csvDivProp, br, tmpWriter);
            while (true) {
                String tmpFileName = reader.getNextLoop(this.divKeys);
                String divKey = reader.getDivisonKey();
                long beforeSize = this.getBeforeSize(outputFolderName);
                long thisSize = new File(tmpFileName).length();
                if (thisSize == 0L) {
                    tmpWriter.deleteTmpFile();
                    break;
                }
                if (beforeSize + thisSize < this.csvDivProp.getFileSize()) {
                    this.writeCSV(outputFolderName, tmpFileName);
                } else if (beforeSize > 0L) {
                    ++this.fileCounter;
                    this.writeCSV(outputFolderName, tmpFileName);
                    if (thisSize >= this.csvDivProp.getFileSize()) {
                        this.addDivkey(outputFolderName, divKey);
                        ++this.fileCounter;
                    }
                } else {
                    this.writeCSV(outputFolderName, tmpFileName);
                    this.addDivkey(outputFolderName, divKey);
                    ++this.fileCounter;
                }
                tmpWriter.deleteTmpFile();
            }
        }
        catch (IOException e) {
            throw new BizTranException(AppMessage.IO_DIVIDEPROP_DIVIDE_FAIL, e.getMessage());
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
                if (isr != null) {
                    isr.close();
                }
                if (br != null) {
                    br.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private void writeCSV(String outputFolderName, String tmpFileName) throws BizTranException {
        DecimalFormat df = new DecimalFormat("000000000");
        String outputFileName = outputFolderName.concat(File.separator).concat(df.format(this.fileCounter));
        FileInputStream fis = null;
        BufferedInputStream bis = null;
        FileOutputStream fos = null;
        FilterOutputStream bos = null;
        try {
            int length;
            fis = new FileInputStream(tmpFileName);
            bis = new BufferedInputStream(fis);
            fos = new FileOutputStream(outputFileName, true);
            bos = new BufferedOutputStream(fos);
            byte[] fbytes = new byte[102400];
            while ((length = bis.read(fbytes)) >= 0) {
                ((BufferedOutputStream)bos).write(fbytes, 0, length);
            }
        }
        catch (IOException e) {
            throw new BizTranException(AppMessage.IO_DIVIDEPROP_DIVIDE_FAIL, e.getMessage());
        }
        finally {
            try {
                if (bos != null) {
                    bos.close();
                }
                if (fos != null) {
                    fos.close();
                }
                if (bis != null) {
                    bis.close();
                }
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private long getBeforeSize(String outputFolderName) {
        DecimalFormat df = new DecimalFormat("000000000");
        String outputFileName = outputFolderName.concat(File.separator).concat(df.format(this.fileCounter));
        return new File(outputFileName).length();
    }

    private void addDivkey(String outputFolderName, String divKey) throws BizTranException {
        String outputFileNameWithDivkey;
        DecimalFormat df = new DecimalFormat("000000000");
        String outputFileName = outputFolderName.concat(File.separator).concat(df.format(this.fileCounter));
        boolean result = new File(outputFileName).renameTo(new File(outputFileNameWithDivkey = outputFileName.concat("_").concat(divKey)));
        if (!result) {
            throw new BizTranException(AppMessage.IO_DIVIDEPROP_DIVIDE_FAIL, "\u5206\u5272\u5f8c\u30d5\u30a1\u30a4\u30eb\u3078\u306e\u5206\u5272\u8a2d\u5b9a\u30ad\u30fc\u3092\u4ed8\u4e0e\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002\uff1a" + outputFileName);
        }
    }
}

