/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.msg.division.input;

import com.argo21.msg.division.input.FixFlatDivisionKeyIndex;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.configuration.PropertiesConfiguration;

public class FixFlatDivisionProperties {
    private PropertiesConfiguration propConf = null;
    private long fileSize;
    private Map<String, List<FixFlatDivisionKeyIndex>> keyMap;

    public FixFlatDivisionProperties(PropertiesConfiguration propConf, String[] divKeys, long fileSize) {
        this.propConf = propConf;
        this.fileSize = fileSize;
        this.keyMap = new HashMap<String, List<FixFlatDivisionKeyIndex>>();
        for (String divKey : divKeys) {
            this.keyMap.put(divKey, this.getFixFlatDivisionKey(divKey));
        }
    }

    private List<FixFlatDivisionKeyIndex> getFixFlatDivisionKey(String key) {
        String[] index = this.propConf.getStringArray("input.fixflat.key.index." + key);
        String[] length = this.propConf.getStringArray("input.fixflat.key.length." + key);
        ArrayList<FixFlatDivisionKeyIndex> keyList = new ArrayList<FixFlatDivisionKeyIndex>();
        for (int i = 0; i < index.length; ++i) {
            keyList.add(new FixFlatDivisionKeyIndex(Integer.parseInt(index[i]), Integer.parseInt(length[i])));
        }
        return keyList;
    }

    public List<FixFlatDivisionKeyIndex> getKeyIndex(String divKey) {
        return this.keyMap.get(divKey);
    }

    public long getFileSize() {
        return this.fileSize;
    }

    public int getRecordLength() {
        return this.propConf.getInt("input.fixflat.record.length");
    }
}

