/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.msg.division.input;

import com.argo21.common.log.AppMessage;
import com.argo21.common.log.BizTranException;
import com.argo21.msg.division.TempFileWriter;
import com.argo21.msg.division.input.FixFlatDivisionKey;
import com.argo21.msg.division.input.FixFlatDivisionKeyIndex;
import com.argo21.msg.division.input.FixFlatDivisionProperties;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class FixFlatDivisionReader {
    private BufferedInputStream bis;
    private FixFlatDivisionProperties divProp;
    private String encoding;
    private byte[] record;
    private FixFlatDivisionKey beforeKey;
    private TempFileWriter tmpWriter = null;

    public FixFlatDivisionReader(FixFlatDivisionProperties divProp, BufferedInputStream bis, String encoding, TempFileWriter tmpWriter) {
        this.divProp = divProp;
        this.bis = bis;
        this.encoding = encoding;
        this.beforeKey = null;
        this.record = null;
        this.tmpWriter = tmpWriter;
    }

    public String getNextLoop(String[] divKeys) throws BizTranException {
        StringBuffer loopBuffer = new StringBuffer();
        try {
            while (this.readRecord() != -1) {
                FixFlatDivisionKey thisKey = this.getDivKey(this.record, divKeys);
                if (loopBuffer.length() == 0 && this.tmpWriter.getTmpSize() == 0L || this.beforeKey == null || thisKey.equals(this.beforeKey)) {
                    loopBuffer.append(new String(this.record, this.encoding));
                    if (loopBuffer.length() >= 0x500000) {
                        this.tmpWriter.write(loopBuffer.toString());
                        loopBuffer = new StringBuffer();
                    }
                    this.beforeKey = new FixFlatDivisionKey(thisKey.getDivKey(), thisKey.getKeyList());
                    this.record = null;
                    continue;
                }
                this.tmpWriter.write(loopBuffer.toString());
                loopBuffer = new StringBuffer();
                return this.tmpWriter.getTmpFileName();
            }
        }
        catch (IOException e) {
            throw new BizTranException(AppMessage.IO_DIVIDEPROP_DIVIDE_FAIL, (Throwable)e);
        }
        this.record = null;
        this.tmpWriter.write(loopBuffer.toString());
        loopBuffer = new StringBuffer();
        return this.tmpWriter.getTmpFileName();
    }

    private int readRecord() throws IOException {
        if (this.record == null) {
            this.record = new byte[this.divProp.getRecordLength()];
            return this.bis.read(this.record);
        }
        return this.record.length;
    }

    public String getDivisonKey() {
        return this.beforeKey.getDivKey();
    }

    private FixFlatDivisionKey getDivKey(byte[] record, String[] divKeys) throws IOException {
        for (String divKey : divKeys) {
            List<FixFlatDivisionKeyIndex> keyIndexList = this.divProp.getKeyIndex(divKey);
            boolean isKey = false;
            ArrayList<String> thisKey = new ArrayList<String>();
            for (FixFlatDivisionKeyIndex keyIndex : keyIndexList) {
                byte[] key = new byte[keyIndex.getLength()];
                System.arraycopy(record, keyIndex.getIndex() - 1, key, 0, keyIndex.getLength());
                String keyString = new String(key, this.encoding);
                thisKey.add(keyString);
                if (keyString == null || keyString.trim().length() <= 0) continue;
                isKey = true;
            }
            if (!isKey) continue;
            return new FixFlatDivisionKey(divKey, thisKey);
        }
        return new FixFlatDivisionKey(divKeys[0], new ArrayList<String>());
    }
}

