/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.msg.division.input;

import com.argo21.common.log.AppMessage;
import com.argo21.common.log.BizTranException;
import com.argo21.msg.division.FileOutputStreamGetter;
import com.argo21.msg.division.input.FixTagDivisionKeyBodyFooter;
import com.argo21.msg.division.input.FixTagDivisionProperties;
import com.argo21.msg.division.input.FixTagDivisionReader;
import com.argo21.msg.division.input.FixTagDivisionRecord;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class FixTagDivisionBodyLoopReader {
    private FixTagDivisionProperties divProp;
    private String[] divKeys;
    private String thisKey;
    FixTagDivisionRecord record;
    FixTagDivisionReader reader;

    public FixTagDivisionBodyLoopReader(FileInputStream fis, FixTagDivisionProperties divProp, String encoding, String[] divKeys) throws BizTranException {
        this.divProp = divProp;
        this.divKeys = divKeys;
        this.reader = new FixTagDivisionReader(fis, divProp, encoding);
        this.record = new FixTagDivisionRecord();
        while (this.reader.getNextRecord(this.record) != -1) {
            this.thisKey = this.getBodyStartKey(this.record);
            if (this.thisKey == null) continue;
            break;
        }
    }

    public String getNextBodyLoop(File bodyFile) throws BizTranException {
        ArrayList<Object> bodyBytesList;
        String divKey;
        block4: {
            divKey = null;
            if (this.record == null) {
                return null;
            }
            bodyBytesList = new ArrayList<byte[]>();
            long byteCount = 0L;
            bodyBytesList.add(this.record.getRecord());
            byteCount += (long)this.record.getRecord().length;
            divKey = this.thisKey;
            while (this.reader.getNextRecord(this.record) != -1) {
                if (this.isFooterStart(this.record)) {
                    this.record = null;
                    break block4;
                }
                String nextKey = this.getBodyStartKey(this.record);
                if (nextKey != null) {
                    this.thisKey = nextKey;
                    break block4;
                }
                bodyBytesList.add(this.record.getRecord());
                if ((byteCount += (long)this.record.getRecord().length) < 0x500000L) continue;
                this.writeTmpFile(bodyFile, bodyBytesList);
                bodyBytesList = new ArrayList();
                byteCount = 0L;
            }
            this.record = null;
        }
        this.writeTmpFile(bodyFile, bodyBytesList);
        return divKey;
    }

    private void writeTmpFile(File tmpFile, List<byte[]> bodyBytesList) throws BizTranException {
        FilterOutputStream bos = null;
        FileOutputStream fos = null;
        try {
            fos = FileOutputStreamGetter.getFileOutputStream(tmpFile, true);
            bos = new BufferedOutputStream(fos);
            for (byte[] bodyBytes : bodyBytesList) {
                bos.write(bodyBytes);
            }
        }
        catch (Exception e) {
            throw new BizTranException(AppMessage.IO_DIVIDEPROP_DIVIDE_FAIL, e.getMessage());
        }
        finally {
            try {
                if (bos != null) {
                    bos.close();
                }
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private String getBodyStartKey(FixTagDivisionRecord target) {
        for (String divKey : this.divKeys) {
            FixTagDivisionKeyBodyFooter keys = this.divProp.getKeyBodyFooter(divKey);
            if (!Arrays.equals(target.getKey(), keys.getKeyBodyStart())) continue;
            return divKey;
        }
        return null;
    }

    private boolean isFooterStart(FixTagDivisionRecord target) {
        for (String divKey : this.divKeys) {
            FixTagDivisionKeyBodyFooter keys = this.divProp.getKeyBodyFooter(divKey);
            if (!Arrays.equals(target.getKey(), keys.getKeyFooterStart())) continue;
            return true;
        }
        return false;
    }
}

