/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.msg.division.input;

import com.argo21.common.log.AppMessage;
import com.argo21.common.log.BizTranException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.List;

public class FixTagDivisionFileWriter {
    private List<byte[]> headerBytesList;
    private String outputFolderName;
    private int fileCounter;
    private long bodySize;

    public FixTagDivisionFileWriter(List<byte[]> headerBytesList, String outputFolderName) throws BizTranException {
        this.headerBytesList = headerBytesList;
        this.outputFolderName = outputFolderName;
        this.fileCounter = 1;
        this.bodySize = 0L;
        File outputFolder = new File(outputFolderName);
        if (!outputFolder.exists()) {
            if (!outputFolder.mkdirs()) {
                throw new BizTranException(AppMessage.IO_DIVIDEPROP_DIVIDE_FAIL, "\u4e00\u6642\u51fa\u529b\u30d5\u30a9\u30eb\u30c0\u306e\u4f5c\u6210\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
            }
        } else if (!outputFolder.isDirectory()) {
            throw new BizTranException(AppMessage.IO_DIVIDEPROP_DIVIDE_FAIL, "\u4e00\u6642\u51fa\u529b\u30d5\u30a9\u30eb\u30c0\u304c\u30d5\u30a9\u30eb\u30c0\u3067\u3042\u308a\u307e\u305b\u3093\u3002");
        }
    }

    public void writeBody(File tmpFile) throws BizTranException {
        DecimalFormat df = new DecimalFormat("000000000");
        String outputFileName = this.outputFolderName.concat(File.separator).concat(df.format(this.fileCounter));
        if (!new File(outputFileName).exists()) {
            FilterOutputStream bos = null;
            FileOutputStream fos = null;
            try {
                fos = new FileOutputStream(outputFileName, false);
                bos = new BufferedOutputStream(fos);
                for (byte[] headerBytes : this.headerBytesList) {
                    bos.write(headerBytes);
                }
            }
            catch (Exception e) {
                throw new BizTranException(AppMessage.IO_DIVIDEPROP_DIVIDE_FAIL, e.getMessage());
            }
            finally {
                try {
                    if (bos != null) {
                        bos.close();
                    }
                    if (fos != null) {
                        fos.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        if (tmpFile != null) {
            FileInputStream fis = null;
            BufferedInputStream bis = null;
            FileOutputStream fos = null;
            FilterOutputStream bos = null;
            try {
                int length;
                fis = new FileInputStream(tmpFile);
                bis = new BufferedInputStream(fis);
                fos = new FileOutputStream(outputFileName, true);
                bos = new BufferedOutputStream(fos);
                byte[] fbytes = new byte[102400];
                while ((length = bis.read(fbytes)) >= 0) {
                    ((BufferedOutputStream)bos).write(fbytes, 0, length);
                }
                this.bodySize += tmpFile.length();
            }
            catch (IOException e) {
                throw new BizTranException(AppMessage.IO_DIVIDEPROP_DIVIDE_FAIL, (Throwable)e);
            }
            finally {
                try {
                    if (bos != null) {
                        bos.close();
                    }
                    if (fos != null) {
                        fos.close();
                    }
                    if (bis != null) {
                        bis.close();
                    }
                    if (fis != null) {
                        fis.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void writeFooter(List<byte[]> footerBytesList) throws BizTranException {
        File outputFolder = new File(this.outputFolderName);
        File[] files = outputFolder.listFiles();
        for (int i = 0; i < files.length; ++i) {
            FileOutputStream fos = null;
            try {
                fos = new FileOutputStream(files[i], true);
                for (byte[] footerBytes : footerBytesList) {
                    fos.write(footerBytes);
                }
                continue;
            }
            catch (Exception e) {
                throw new BizTranException(AppMessage.IO_DIVIDEPROP_DIVIDE_FAIL, e.getMessage());
            }
            finally {
                try {
                    if (fos != null) {
                        fos.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
    }

    public long getBodySize() {
        return this.bodySize;
    }

    public void setDivKey(String divKey) throws BizTranException {
        String outputFileNameWithDivkey;
        DecimalFormat df = new DecimalFormat("000000000");
        String outputFileName = this.outputFolderName.concat(File.separator).concat(df.format(this.fileCounter));
        boolean result = new File(outputFileName).renameTo(new File(outputFileNameWithDivkey = outputFileName.concat("_").concat(divKey)));
        if (!result) {
            throw new BizTranException(AppMessage.IO_DIVIDEPROP_DIVIDE_FAIL, "\u5206\u5272\u8a2d\u5b9a\u30ad\u30fc\u4ed8\u4e0e\u5931\u6557 " + outputFileName);
        }
    }

    public void nextFile() {
        ++this.fileCounter;
        this.bodySize = 0L;
    }
}

