/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.msg.division.input;

import com.argo21.msg.division.input.FixTagDivisionKeyBodyFooter;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.configuration.PropertiesConfiguration;

public class FixTagDivisionProperties {
    private PropertiesConfiguration propConf = null;
    private long fileSize;
    private int[] keyIndex = null;
    private int[] keyLength = null;
    private Map<String, FixTagDivisionKeyBodyFooter> keyMap;
    private int minLength;

    public FixTagDivisionProperties(PropertiesConfiguration propConf, String[] divKeys, long fileSize) {
        this.propConf = propConf;
        this.fileSize = fileSize;
        this.keyIndex = this.getIntArray(propConf, "input.fixtag.key.index");
        this.keyLength = this.getIntArray(propConf, "input.fixtag.key.length");
        this.keyMap = new HashMap<String, FixTagDivisionKeyBodyFooter>();
        for (String divKey : divKeys) {
            this.keyMap.put(divKey, new FixTagDivisionKeyBodyFooter(propConf.getStringArray("input.fixtag.key.bodystart." + divKey), propConf.getStringArray("input.fixtag.key.footerstart." + divKey)));
        }
        this.minLength = 0;
        for (int i = 0; i < this.keyIndex.length; ++i) {
            int tmpLength = this.keyIndex[i] + this.keyLength[i] - 1;
            if (this.minLength >= tmpLength) continue;
            this.minLength = tmpLength;
        }
    }

    private int[] getIntArray(PropertiesConfiguration propConf, String key) {
        String[] values = propConf.getStringArray(key);
        int[] result = new int[values.length];
        for (int i = 0; i < values.length; ++i) {
            result[i] = Integer.parseInt(values[i]);
        }
        return result;
    }

    public int[] getKeyIndex() {
        return this.keyIndex;
    }

    public int[] getKeyLength() {
        return this.keyLength;
    }

    public FixTagDivisionKeyBodyFooter getKeyBodyFooter(String divKey) {
        return this.keyMap.get(divKey);
    }

    public long getFileSize() {
        return this.fileSize;
    }

    public int getMinLength() {
        return this.minLength;
    }

    public int getRecordLength(String[] keys) {
        StringBuffer sb = new StringBuffer();
        for (String key : keys) {
            sb.append(".");
            sb.append(key);
        }
        return this.propConf.getInt("input.fixtag.record.length" + sb.toString());
    }
}

