/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.msg.division.input;

import com.argo21.common.log.AppMessage;
import com.argo21.common.log.BizTranException;
import com.argo21.msg.division.input.FixTagDivisionProperties;
import com.argo21.msg.division.input.FixTagDivisionRecord;
import java.io.FileInputStream;

public class FixTagDivisionReader {
    private FileInputStream fis;
    private FixTagDivisionProperties divProp;
    private String encoding;

    public FixTagDivisionReader(FileInputStream fis, FixTagDivisionProperties divProp, String encoding) {
        this.fis = fis;
        this.divProp = divProp;
        this.encoding = encoding;
    }

    public int getNextRecord(FixTagDivisionRecord result) throws BizTranException {
        try {
            int remainLength;
            byte[] remainRecord;
            int remainRecordLength;
            byte[] keyRecord = new byte[this.divProp.getMinLength()];
            int keyRecordLength = this.fis.read(keyRecord);
            if (keyRecordLength == -1) {
                return -1;
            }
            int[] keyIndex = this.divProp.getKeyIndex();
            int[] keyLength = this.divProp.getKeyLength();
            String[] thisKey = new String[keyIndex.length];
            for (int j = 0; j < keyIndex.length; ++j) {
                byte[] key = new byte[keyLength[j]];
                System.arraycopy(keyRecord, keyIndex[j] - 1, key, 0, keyLength[j]);
                thisKey[j] = new String(key, this.encoding);
            }
            int recordLength = this.divProp.getRecordLength(thisKey);
            if (recordLength != keyRecordLength + (remainRecordLength = this.fis.read(remainRecord = new byte[remainLength = recordLength - this.divProp.getMinLength()]))) {
                String message = "\u30ec\u30b3\u30fc\u30c9\u9577\u304c\u4e0d\u6b63\u3067\u3059\u3000\u5206\u5272\u30ad\u30fc\uff1a";
                for (String key : thisKey) {
                    message = message + key + " ";
                }
                throw new BizTranException(AppMessage.IO_DIVIDEPROP_DIVIDE_FAIL, message);
            }
            byte[] allRecord = new byte[recordLength];
            System.arraycopy(keyRecord, 0, allRecord, 0, keyRecord.length);
            System.arraycopy(remainRecord, 0, allRecord, keyRecord.length, remainRecord.length);
            result.setKey(thisKey);
            result.setRecord(allRecord);
            return recordLength;
        }
        catch (Exception e) {
            throw new BizTranException(AppMessage.IO_DIVIDEPROP_DIVIDE_FAIL, (Throwable)e);
        }
    }
}

