/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.msg.division.input;

import com.argo21.common.log.AppMessage;
import com.argo21.common.log.BizTranException;
import com.argo21.msg.division.input.FixTagDivisionBodyLoopReader;
import com.argo21.msg.division.input.FixTagDivisionFileWriter;
import com.argo21.msg.division.input.FixTagDivisionKeyBodyFooter;
import com.argo21.msg.division.input.FixTagDivisionProperties;
import com.argo21.msg.division.input.FixTagDivisionReader;
import com.argo21.msg.division.input.FixTagDivisionRecord;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;

public class FixTagDivisioner {
    private FixTagDivisionProperties fixTagDivProp;
    private String encoding = null;
    private String[] divKeys = null;
    private FixTagDivisionFileWriter writer = null;

    public FixTagDivisioner(FixTagDivisionProperties fixTagDivProp, String[] divKeys, String encoding) {
        this.fixTagDivProp = fixTagDivProp;
        this.divKeys = divKeys;
        this.encoding = encoding == null ? System.getProperty("file.encoding") : encoding;
    }

    public void divide(String inputFileName, String outputFolderName) throws BizTranException {
        ArrayList<byte[]> headerBytesList = new ArrayList<byte[]>();
        ArrayList<byte[]> footerBytesList = new ArrayList<byte[]>();
        int headerFooterSize = 0;
        FileInputStream fis = null;
        try {
            boolean isHeader = true;
            boolean isFooter = false;
            File inputFile = new File(inputFileName);
            fis = new FileInputStream(inputFile);
            FixTagDivisionReader reader = new FixTagDivisionReader(fis, this.fixTagDivProp, this.encoding);
            FixTagDivisionRecord record = new FixTagDivisionRecord();
            while (reader.getNextRecord(record) != -1) {
                Object[] thisKey = record.getKey();
                for (String divKey : this.divKeys) {
                    FixTagDivisionKeyBodyFooter bodyFooterKey = this.fixTagDivProp.getKeyBodyFooter(divKey);
                    if (Arrays.equals(bodyFooterKey.getKeyBodyStart(), thisKey)) {
                        isHeader = false;
                        break;
                    }
                    if (!Arrays.equals(bodyFooterKey.getKeyFooterStart(), thisKey)) continue;
                    isFooter = true;
                    break;
                }
                if (isHeader) {
                    headerBytesList.add(record.getRecord());
                    headerFooterSize += record.getRecord().length;
                }
                if (isFooter) {
                    footerBytesList.add(record.getRecord());
                    headerFooterSize += record.getRecord().length;
                }
                record = new FixTagDivisionRecord();
            }
        }
        catch (IOException e) {
            throw new BizTranException(AppMessage.IO_DIVIDEPROP_DIVIDE_FAIL, e.getMessage());
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException iOException) {}
        }
        try {
            File inputFile = new File(inputFileName);
            fis = new FileInputStream(inputFile);
            FixTagDivisionBodyLoopReader reader = new FixTagDivisionBodyLoopReader(fis, this.fixTagDivProp, this.encoding, this.divKeys);
            this.writer = new FixTagDivisionFileWriter(headerBytesList, outputFolderName);
            File tmpBodyFile = new File(outputFolderName.concat(File.separator).concat("tmpBodyFile"));
            String divKey = null;
            boolean noBodyFlag = true;
            while ((divKey = reader.getNextBodyLoop(tmpBodyFile)) != null) {
                long tmpBodySize;
                noBodyFlag = false;
                long bodySize = this.writer.getBodySize();
                if ((long)headerFooterSize + bodySize + (tmpBodySize = tmpBodyFile.length()) < this.fixTagDivProp.getFileSize()) {
                    this.writer.writeBody(tmpBodyFile);
                } else if (bodySize > 0L) {
                    this.writer.nextFile();
                    this.writer.writeBody(tmpBodyFile);
                    if ((long)headerFooterSize + tmpBodySize >= this.fixTagDivProp.getFileSize()) {
                        this.writer.setDivKey(divKey);
                        this.writer.nextFile();
                    }
                } else {
                    this.writer.writeBody(tmpBodyFile);
                    this.writer.setDivKey(divKey);
                    this.writer.nextFile();
                }
                if (!tmpBodyFile.exists() || tmpBodyFile.delete()) continue;
                throw new BizTranException(AppMessage.IO_DIVIDEPROP_DIVIDE_FAIL, "\u4e00\u6642\u30d5\u30a1\u30a4\u30eb\u306e\u524a\u9664\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002\uff1a" + tmpBodyFile);
            }
            if (noBodyFlag) {
                this.writer.writeBody(null);
                if (tmpBodyFile.exists() && !tmpBodyFile.delete()) {
                    throw new BizTranException(AppMessage.IO_DIVIDEPROP_DIVIDE_FAIL, "\u4e00\u6642\u30d5\u30a1\u30a4\u30eb\u306e\u524a\u9664\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002\uff1a" + tmpBodyFile);
                }
            }
            this.writer.writeFooter(footerBytesList);
        }
        catch (IOException e) {
            throw new BizTranException(AppMessage.IO_DIVIDEPROP_DIVIDE_FAIL, e.getMessage());
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException iOException) {}
        }
    }
}

