/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.msg.division.input;

import com.argo21.common.log.BizTranException;
import com.argo21.msg.division.DivisionProperties;
import com.argo21.msg.division.input.CsvDivisioner;
import com.argo21.msg.division.input.FixFlatDivisioner;
import com.argo21.msg.division.input.FixTagDivisioner;
import com.argo21.msg.division.input.XmlDivisioner;

public class InputMessageDivisioner {
    private DivisionProperties divProp = null;
    private String[] divKeys = null;

    public InputMessageDivisioner(DivisionProperties divProp, String[] divKeys) {
        this.divProp = divProp;
        this.divKeys = divKeys;
    }

    public void divide(String inputFileName, String outputFolderName) throws BizTranException {
        String inputMsgType = this.divProp.getInputMsgType();
        if ("XML".equalsIgnoreCase(inputMsgType)) {
            XmlDivisioner xmlDiv = new XmlDivisioner(this.divProp.getXmlDivisionProperties(), this.divKeys, this.divProp.getInputEncoding());
            xmlDiv.divide(inputFileName, outputFolderName);
        } else if ("FIX_FLAT".equalsIgnoreCase(inputMsgType)) {
            FixFlatDivisioner fixFlatDiv = new FixFlatDivisioner(this.divProp.getFixFlatDivisionProperties(this.divKeys), this.divKeys, this.divProp.getInputEncoding());
            fixFlatDiv.divide(inputFileName, outputFolderName);
        } else if ("FIX_TAG".equalsIgnoreCase(inputMsgType)) {
            FixTagDivisioner fixTagDiv = new FixTagDivisioner(this.divProp.getFixTagDivisionProperties(this.divKeys), this.divKeys, this.divProp.getInputEncoding());
            fixTagDiv.divide(inputFileName, outputFolderName);
        } else if ("CSV".equalsIgnoreCase(inputMsgType)) {
            CsvDivisioner csvDiv = new CsvDivisioner(this.divProp.getCsvDivisionProperties(this.divKeys), this.divKeys, this.divProp.getInputEncoding());
            csvDiv.divide(inputFileName, outputFolderName);
        }
    }
}

