/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.msg.division.input;

import com.argo21.msg.division.BizTranSAXException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.DecimalFormat;

public class XmlDivisionFileWriter {
    private String hederString;
    private String outputFolderName;
    private String encoding = null;
    private int fileCounter;
    private long bodySize;

    public XmlDivisionFileWriter(String hederString, String outputFolderName, String encoding) throws BizTranSAXException {
        this.hederString = hederString;
        this.outputFolderName = outputFolderName;
        this.encoding = encoding;
        this.fileCounter = 1;
        this.bodySize = 0L;
        File outputFolder = new File(outputFolderName);
        if (!outputFolder.exists()) {
            if (!outputFolder.mkdirs()) {
                throw new BizTranSAXException("\u4e00\u6642\u51fa\u529b\u30d5\u30a9\u30eb\u30c0\u4f5c\u6210\u5931\u6557");
            }
        } else if (!outputFolder.isDirectory()) {
            throw new BizTranSAXException("\u4e00\u6642\u51fa\u529b\u30d5\u30a9\u30eb\u30c0\u304c\u30d5\u30a9\u30eb\u30c0\u3067\u306a\u3044");
        }
    }

    public void writeBody(String tmpFileName) throws BizTranSAXException {
        DecimalFormat df = new DecimalFormat("000000000");
        String outputFileName = this.outputFolderName.concat(File.separator).concat(df.format(this.fileCounter));
        if (!new File(outputFileName).exists()) {
            BufferedWriter bw = null;
            FileOutputStream fos = null;
            OutputStreamWriter osw = null;
            try {
                fos = new FileOutputStream(outputFileName, false);
                osw = this.encoding == null ? new OutputStreamWriter(fos) : new OutputStreamWriter((OutputStream)fos, this.encoding);
                bw = new BufferedWriter(osw);
                bw.write(this.hederString);
            }
            catch (Exception e) {
                throw new BizTranSAXException("\u5206\u5272\u30d5\u30a1\u30a4\u30eb\u4f5c\u6210\u306b\u5931\u6557\u3057\u307e\u3057\u305f", e);
            }
            finally {
                try {
                    if (bw != null) {
                        bw.close();
                    }
                    if (osw != null) {
                        osw.close();
                    }
                    if (fos != null) {
                        fos.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        if (tmpFileName != null) {
            FileInputStream fis = null;
            BufferedInputStream bis = null;
            FileOutputStream fos = null;
            FilterOutputStream bos = null;
            try {
                int length;
                fis = new FileInputStream(tmpFileName);
                bis = new BufferedInputStream(fis);
                fos = new FileOutputStream(outputFileName, true);
                bos = new BufferedOutputStream(fos);
                byte[] fbytes = new byte[102400];
                while ((length = bis.read(fbytes)) >= 0) {
                    ((BufferedOutputStream)bos).write(fbytes, 0, length);
                }
                this.bodySize += new File(tmpFileName).length();
            }
            catch (IOException e) {
                throw new BizTranSAXException("\u5206\u5272\u30d5\u30a1\u30a4\u30eb\u51fa\u529b\u306b\u5931\u6557\u3057\u307e\u3057\u305f", e);
            }
            finally {
                try {
                    if (bos != null) {
                        bos.close();
                    }
                    if (fos != null) {
                        fos.close();
                    }
                    if (bis != null) {
                        bis.close();
                    }
                    if (fis != null) {
                        fis.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void writeFooter(String footerString) throws BizTranSAXException {
        File outputFolder = new File(this.outputFolderName);
        File[] files = outputFolder.listFiles();
        for (int i = 0; i < files.length; ++i) {
            FileOutputStream fos = null;
            OutputStreamWriter osw = null;
            try {
                fos = new FileOutputStream(files[i], true);
                osw = this.encoding == null ? new OutputStreamWriter(fos) : new OutputStreamWriter((OutputStream)fos, this.encoding);
                osw.write(footerString);
                continue;
            }
            catch (Exception e) {
                throw new BizTranSAXException("\u30d5\u30a1\u30a4\u30eb\u51fa\u529b\u306b\u5931\u6557\u3057\u307e\u3057\u305f", e);
            }
            finally {
                try {
                    if (osw != null) {
                        osw.close();
                    }
                    if (fos != null) {
                        fos.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
    }

    public long getBodySize() {
        return this.bodySize;
    }

    public void setDivKey(String divKey) throws BizTranSAXException {
        String outputFileNameWithDivkey;
        DecimalFormat df = new DecimalFormat("000000000");
        String outputFileName = this.outputFolderName.concat(File.separator).concat(df.format(this.fileCounter));
        boolean result = new File(outputFileName).renameTo(new File(outputFileNameWithDivkey = outputFileName.concat("_").concat(divKey)));
        if (!result) {
            throw new BizTranSAXException("\u30d5\u30a1\u30a4\u30eb\u51fa\u529b\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002\u3000\uff1a\u3000\u5206\u5272\u8a2d\u5b9a\u30ad\u30fc\u4ed8\u4e0e\u5931\u6557 " + outputFileName);
        }
    }

    public void nextFile() {
        ++this.fileCounter;
        this.bodySize = 0L;
    }
}

