/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.msg.division.input;

import com.argo21.msg.division.XPathCreateor;
import com.argo21.msg.division.input.XmlDivisionProperties;
import java.io.UnsupportedEncodingException;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XmlDivisionGetSizeSAXHandler
extends DefaultHandler {
    private XmlDivisionProperties propConf = null;
    private String[] divKeys;
    private String encoding = null;
    private XPathCreateor xPath;
    private StringBuffer sb;
    private boolean isBody;

    public XmlDivisionGetSizeSAXHandler(XmlDivisionProperties propConf, String[] divKeys, String encoding) {
        this.propConf = propConf;
        this.divKeys = divKeys;
        this.encoding = encoding;
    }

    @Override
    public void startDocument() throws SAXException {
        this.xPath = new XPathCreateor();
        if (this.encoding == null) {
            this.encoding = System.getProperty("file.encoding");
        }
        this.sb = new StringBuffer("<?xml version=\"1.0\" encoding=\"" + this.encoding + "\"?>");
        this.isBody = false;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (this.propConf.getTargetDivisonKey(this.divKeys, qName, this.xPath.toString()) != null) {
            this.isBody = true;
        }
        if (!this.isBody) {
            this.writeStartTag(this.sb, qName, attributes);
        }
        this.xPath.addLeaf(qName);
    }

    @Override
    public void characters(char[] ch, int offset, int length) {
        String value = new String(ch, offset, length);
        if ("&".equals(value)) {
            value = "&amp;";
        } else if ("<".equals(value)) {
            value = "&lt;";
        } else if (">".equals(value)) {
            value = "&gt;";
        } else if ("\"".equals(value)) {
            value = "&quot;";
        } else if ("'".equals(value)) {
            value = "&apos;";
        }
        if (!this.isBody) {
            this.sb.append(value);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (!this.isBody) {
            this.writeEndTag(this.sb, qName);
        }
        this.xPath.removeLeaf();
        if (this.propConf.getTargetDivisonKey(this.divKeys, qName, this.xPath.toString()) != null) {
            this.isBody = false;
        }
    }

    @Override
    public void endDocument() throws SAXException {
    }

    private void writeStartTag(StringBuffer buf, String tagName, Attributes attributes) {
        buf.append("<");
        buf.append(tagName);
        if (attributes != null && attributes.getLength() > 0) {
            for (int i = 0; i < attributes.getLength(); ++i) {
                buf.append(" ");
                buf.append(attributes.getQName(i));
                buf.append("=\"");
                buf.append(attributes.getValue(i));
                buf.append("\"");
            }
        }
        buf.append(">");
    }

    private void writeEndTag(StringBuffer buf, String tagName) {
        buf.append("</");
        buf.append(tagName);
        buf.append(">");
    }

    public int getSize() throws SAXException {
        try {
            return this.sb.toString().getBytes(this.encoding).length;
        }
        catch (UnsupportedEncodingException e) {
            throw new SAXException(e);
        }
    }
}

