/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.msg.division.input;

import com.argo21.common.log.BizTranException;
import com.argo21.msg.division.BizTranSAXException;
import com.argo21.msg.division.TempFileWriter;
import com.argo21.msg.division.XPathCreateor;
import com.argo21.msg.division.input.XmlDivisionFileWriter;
import com.argo21.msg.division.input.XmlDivisionProperties;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XmlDivisionSAXHandler
extends DefaultHandler {
    private final int STATE_BEFORE_BODY = 1;
    private final int STATE_IN_BODY = 2;
    private final int STATE_AFTER_BODY = 3;
    private String outputFolderName;
    private XmlDivisionProperties propConf = null;
    private String[] divKeys;
    private String encoding = null;
    private long headerfooterSize;
    private StringBuffer headerBuffer;
    private StringBuffer bodyBufferTmp;
    private StringBuffer footerBuffer;
    private int state;
    private boolean noBodyFlag;
    private XPathCreateor xPath;
    private XmlDivisionFileWriter writer = null;
    private TempFileWriter tmpWriter = null;

    public XmlDivisionSAXHandler(String outputFolderName, XmlDivisionProperties propConf, String[] divKeys, String encoding, int headerfooterSize) {
        this.outputFolderName = outputFolderName;
        this.propConf = propConf;
        this.divKeys = divKeys;
        this.encoding = encoding;
        this.headerfooterSize = headerfooterSize;
        this.xPath = new XPathCreateor();
        this.noBodyFlag = true;
        this.tmpWriter = new TempFileWriter(outputFolderName, "tmp", encoding);
    }

    @Override
    public void startDocument() throws SAXException {
        String enc = this.encoding != null ? this.encoding : System.getProperty("file.encoding");
        this.headerBuffer = new StringBuffer("<?xml version=\"1.0\" encoding=\"" + enc + "\"?>");
        this.footerBuffer = new StringBuffer();
        this.state = 1;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        String divKey = this.propConf.getTargetDivisonKey(this.divKeys, qName, this.xPath.toString());
        if (divKey != null) {
            this.state = 2;
            this.noBodyFlag = false;
            if (this.writer == null) {
                this.writer = new XmlDivisionFileWriter(this.headerBuffer.toString(), this.outputFolderName, this.encoding);
            }
            this.bodyBufferTmp = new StringBuffer();
        }
        switch (this.state) {
            case 1: {
                this.writeStartTag(this.headerBuffer, qName, attributes);
                break;
            }
            case 2: {
                this.writeStartTag(this.bodyBufferTmp, qName, attributes);
                break;
            }
            case 3: {
                this.writeStartTag(this.footerBuffer, qName, attributes);
            }
        }
        this.xPath.addLeaf(qName);
    }

    @Override
    public void characters(char[] ch, int offset, int length) {
        String value = new String(ch, offset, length);
        if ("&".equals(value)) {
            value = "&amp;";
        } else if ("<".equals(value)) {
            value = "&lt;";
        } else if (">".equals(value)) {
            value = "&gt;";
        } else if ("\"".equals(value)) {
            value = "&quot;";
        } else if ("'".equals(value)) {
            value = "&apos;";
        }
        switch (this.state) {
            case 1: {
                this.headerBuffer.append(value);
                break;
            }
            case 2: {
                this.bodyBufferTmp.append(value);
                break;
            }
            case 3: {
                this.footerBuffer.append(value);
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        try {
            switch (this.state) {
                case 1: {
                    this.writeEndTag(this.headerBuffer, qName);
                    break;
                }
                case 2: {
                    this.writeEndTag(this.bodyBufferTmp, qName);
                    if (this.bodyBufferTmp.length() < 0x500000) break;
                    this.tmpWriter.write(this.bodyBufferTmp.toString());
                    this.bodyBufferTmp = new StringBuffer();
                    break;
                }
                case 3: {
                    this.writeEndTag(this.footerBuffer, qName);
                }
            }
            this.xPath.removeLeaf();
            String divKey = this.propConf.getTargetDivisonKey(this.divKeys, qName, this.xPath.toString());
            if (divKey != null) {
                this.state = 3;
                this.tmpWriter.write(this.bodyBufferTmp.toString());
                this.bodyBufferTmp = new StringBuffer();
                long bodySize = this.writer.getBodySize();
                long tmpBodySize = this.tmpWriter.getTmpSize();
                if (this.headerfooterSize + bodySize + tmpBodySize < this.propConf.getFileSize()) {
                    this.writer.writeBody(this.tmpWriter.getTmpFileName());
                } else if (bodySize > 0L) {
                    this.writer.nextFile();
                    this.writer.writeBody(this.tmpWriter.getTmpFileName());
                    if (this.headerfooterSize + tmpBodySize >= this.propConf.getFileSize()) {
                        this.writer.setDivKey(divKey);
                        this.writer.nextFile();
                    }
                } else {
                    this.writer.writeBody(this.tmpWriter.getTmpFileName());
                    this.writer.setDivKey(divKey);
                    this.writer.nextFile();
                }
                this.tmpWriter.deleteTmpFile();
            }
        }
        catch (BizTranException e) {
            throw new BizTranSAXException("\u5165\u529b\u30d5\u30a1\u30a4\u30eb\u306e\u5206\u5272\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", e);
        }
    }

    @Override
    public void endDocument() throws SAXException {
        if (this.noBodyFlag) {
            this.writer = new XmlDivisionFileWriter(this.headerBuffer.toString(), this.outputFolderName, this.encoding);
            this.writer.writeBody(null);
        }
        this.writer.writeFooter(this.footerBuffer.toString());
    }

    private void writeStartTag(StringBuffer buf, String tagName, Attributes attributes) {
        buf.append("<");
        buf.append(tagName);
        if (attributes != null && attributes.getLength() > 0) {
            for (int i = 0; i < attributes.getLength(); ++i) {
                buf.append(" ");
                buf.append(attributes.getQName(i));
                buf.append("=\"");
                buf.append(attributes.getValue(i));
                buf.append("\"");
            }
        }
        buf.append(">");
    }

    private void writeEndTag(StringBuffer buf, String tagName) {
        buf.append("</");
        buf.append(tagName);
        buf.append(">");
    }
}

