/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.msg.division.output;

import com.argo21.common.log.AppMessage;
import com.argo21.common.log.BizTranException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.Arrays;
import org.apache.commons.lang.time.StopWatch;

public class CsvUnioner {
    public static final long TIMEOUT_VALUE_WRITE = 300000L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void union(String outputFileName, File inputFolder, boolean postscriptFlag) throws BizTranException {
        AbstractInterruptibleChannel fc = null;
        FileLock lock = null;
        try {
            FileOutputStream fos = new FileOutputStream(outputFileName, postscriptFlag);
            BufferedOutputStream bos = new BufferedOutputStream(fos);
            fc = fos.getChannel();
            lock = ((FileChannel)fc).tryLock();
            StopWatch sw = new StopWatch();
            sw.start();
            while (lock == null) {
                if (sw.getTime() >= 300000L) {
                    if (fc != null) {
                        fc.close();
                        fc = null;
                    }
                    if (bos != null) {
                        bos.close();
                    }
                    if (fos != null) {
                        fos.close();
                    }
                    throw new IOException();
                }
                Thread.sleep(500L);
                lock = ((FileChannel)fc).tryLock();
            }
            Object[] divOutputFiles = inputFolder.listFiles();
            Arrays.sort(divOutputFiles);
            for (int j = 0; j < divOutputFiles.length; ++j) {
                int readLength;
                FileInputStream fis = new FileInputStream((File)divOutputFiles[j]);
                BufferedInputStream bis = new BufferedInputStream(fis);
                byte[] byteArray = new byte[102400];
                while ((readLength = bis.read(byteArray)) != -1) {
                    bos.write(byteArray, 0, readLength);
                }
                bis.close();
                fis.close();
            }
            bos.close();
            fos.close();
        }
        catch (IOException e) {
            throw new BizTranException(AppMessage.IO_DIVIDEPROP_UNION_FAIL, e.getMessage());
        }
        catch (Exception exception) {
        }
        finally {
            try {
                if (lock != null) {
                    lock.release();
                }
                if (fc != null) {
                    fc.close();
                }
            }
            catch (Exception exception) {}
        }
    }
}

